'From VisualWorks(R), Release 2.5 of September 26, 1995 on March 26, 1997 at 3:42:23 pm'!

Model subclass: #UIBBrowserContext
	instanceVariableNames: 'category className protocol selector '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserContext methodsFor: 'accessing'!

category

	^category!

category: aValue

	category := aValue.
	self changed: #category!

className

	^className!

className: aValue

	className := aValue.
	self changed: #className!

protocol

	^protocol!

protocol: aValue

	protocol := aValue.
	self changed: #protocol!

selector

	^selector!

selector: aValue

	selector := aValue.
	self changed: #selector! !

!UIBBrowserContext methodsFor: 'initialize-release'!

initialize

	category := className := protocol := selector := nil! !

!UIBBrowserContext methodsFor: 'printing'!

printOn: aStream

	aStream
		nextPutAll: self class name;
		crtab;
		nextPutAll: self category printString;
		crtab;
		nextPutAll: self className printString;
		crtab;
		nextPutAll: self protocol printString;
		crtab;
		nextPutAll: self selector printString! !

UIBCompositeComponentSpec subclass: #UIBBrowserCodeViewSpec
	instanceVariableNames: 'contextHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserCodeViewSpec methodsFor: 'accessing'!

contextHolder

	^contextHolder == nil
		ifTrue:[contextHolder := (UIBPropertyFieldModel basicNew name: #contextHolder; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'UIBBrowserContext new asValue'; yourself)]
		ifFalse:[contextHolder]!

setContextHolder: aValue

	contextHolder := aValue! !

!UIBBrowserCodeViewSpec methodsFor: 'decoding'!

contextHolder: aValue

	self contextHolder property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserCodeViewSpec class
	instanceVariableNames: ''!


!UIBBrowserCodeViewSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#UIBBrowserCodeView!

defaultMinorKey

	^#windowSpec! !

!UIBBrowserCodeViewSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).
	env at: #contextHolder put: (self adapt: inst forAspect: #property accessPath: #(#contextHolder) channel: aChannel).!

componentName

	^'Browser Code View'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #UIBBrowserCodeView #specSelector: #windowSpec))!

placementExtent

	^50 @ 50!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Details #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!UIBBrowserCodeViewSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Code View-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Browser Code View' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 75 0 269 0 -13 1 289 0 ) 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #contextHolder 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'UIBBrowserContext new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 270 ) 
					#label: 'Aspect:' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Code View-Details' 
			#bounds: #(#Rectangle 193 144 458 468 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#label: 'Component Name' ) ) ) )! !

!UIBBrowserCodeViewSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@,@@@@@@=@@B2*"***#4@@KJBBB**OP@@,(HHH@(=@@B2*****#4@@KJ*****OP@@,(B@H@(=@@B2*****#4@@KJ*****OP@@,(@@@@(=@@B2*****#4@@KJ*****OP@@,(@@@*(=@@B2*****#4@@KJ***(*OP@@,(@ *@(=@@B2*****#4@@KJ*****OP@@,@@@@@@=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

UIBApplicationModel subclass: #UIBTestBrowser
	instanceVariableNames: 'context '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBTestBrowser methodsFor: 'aspects'!

context
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^context isNil
		ifTrue:
			[context := (UIBBrowserContext new category: #'UIB-Test-Browser') asValue]
		ifFalse:
			[context]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBTestBrowser class
	instanceVariableNames: ''!


!UIBTestBrowser class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Test Browser' 
			#bounds: #(#Rectangle 175 213 752 507 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBBrowserSelectorSpec 
					#layout: #(#Rectangle 8 9 126 114 ) 
					#flags: 0 
					#contextHolder: 
					#(#UIBAspectProperty 
						#name: #context ) ) 
				#(#UIBBrowserSelectorSpec 
					#layout: #(#Rectangle 147 12 274 114 ) 
					#flags: 0 
					#majorKey: #UIBBrowserClassSelector 
					#contextHolder: 
					#(#UIBAspectProperty 
						#name: #context ) ) 
				#(#UIBBrowserSelectorSpec 
					#layout: #(#Rectangle 292 15 395 112 ) 
					#flags: 0 
					#majorKey: #UIBBrowserProtocolSelector 
					#contextHolder: 
					#(#UIBAspectProperty 
						#name: #context ) ) 
				#(#UIBBrowserSelectorSpec 
					#layout: #(#Rectangle 421 12 539 113 ) 
					#flags: 0 
					#majorKey: #UIBBrowserSelectorSelector 
					#contextHolder: 
					#(#UIBAspectProperty 
						#name: #context ) ) 
				#(#UIBBrowserCodeViewSpec 
					#layout: #(#Rectangle 18 143 544 274 ) 
					#flags: 0 
					#contextHolder: 
					#(#UIBAspectProperty 
						#name: #context ) ) ) ) )! !

UIBCompositeComponentSpec subclass: #UIBBrowserSelectorSpec
	instanceVariableNames: 'contextHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserSelectorSpec methodsFor: 'accessing'!

contextHolder

	^contextHolder == nil
		ifTrue:[contextHolder := (UIBPropertyFieldModel basicNew name: #contextHolder; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'UIBBrowserContext new asValue'; yourself)]
		ifFalse:[contextHolder]!

setContextHolder: aValue

	contextHolder := aValue! !

!UIBBrowserSelectorSpec methodsFor: 'decoding'!

contextHolder: aValue

	self contextHolder property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserSelectorSpec class
	instanceVariableNames: ''!


!UIBBrowserSelectorSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#UIBBrowserCategorySelector!

defaultMinorKey

	^#listSpec! !

!UIBBrowserSelectorSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #contextHolder put: (self adapt: inst forAspect: #property accessPath: #(#contextHolder) channel: aChannel).
	env at: #majorKey put: (self adapt: inst forAspect: #majorKey channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Browser Selector'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #UIBBrowserCategorySelector #specSelector: #listSpec) #(#UIBComponentLookAndFeel #specHolderClass: #UIBBrowserClassSelector #specSelector: #listSpec) #(#UIBComponentLookAndFeel #specHolderClass: #UIBBrowserProtocolSelector #specSelector: #listSpec) #(#UIBComponentLookAndFeel #specHolderClass: #UIBBrowserSelectorSelector #specSelector: #listSpec))!

placementExtent

	^50 @ 50!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Details #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!UIBBrowserSelectorSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Selector-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Browser Selector' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 23 120 ) 
					#model: #majorKey 
					#label: 'Category' 
					#select: #UIBBrowserCategorySelector ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 23 151 ) 
					#model: #majorKey 
					#label: 'Class' 
					#select: #UIBBrowserClassSelector ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 23 183 ) 
					#model: #majorKey 
					#label: 'Protocol' 
					#select: #UIBBrowserProtocolSelector ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 23 216 ) 
					#model: #majorKey 
					#label: 'Selector' 
					#select: #UIBBrowserSelectorSelector ) 
				#(#GroupBoxSpec 
					#layout: #(#Rectangle 8 93 120 249 ) 
					#label: 'Selector Type' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 75 0 269 0 -13 1 289 0 ) 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #contextHolder 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'UIBBrowserContext new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 270 ) 
					#label: 'Aspect:' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Selector-Details' 
			#bounds: #(#Rectangle 193 144 458 468 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#label: 'Component Name' ) ) ) )! !

!UIBBrowserSelectorSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K@@@@@@CP@@,??????M@@B3?????<4@@KO?????3P@@,??????M@@B3?????<4@@KO?????3P@@,??????M@@B3?????<4@@KO?????3P@@,??????M@@B3?????<4@@KO?????3P@@,??????M@@B3?????<4@@KO?????3P@@,??????M@@B3?????<4@@KO?????3P@@,@@@@@@M@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

UIBPalette subclass: #UIBBrowserPalette
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserPalette class
	instanceVariableNames: ''!


!UIBBrowserPalette class methodsFor: 'accessing-specs'!

activeSpecsList

	^#(#UIBBrowserSelectorSpec #UIBBrowserCodeViewSpec)! !

!UIBBrowserPalette class methodsFor: 'accessing'!

numberOfColumns

	^5!

paletteName

	^'Browser'! !

UIBApplicationModel subclass: #UIBBrowserComponent
	instanceVariableNames: 'contextHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserComponent methodsFor: 'accessing'!

browserSourceAspect

	^self subclassResponsibility!

context

	^contextHolder value!

context: aValue

	contextHolder value: aValue!

contextHolder

	^contextHolder! !

!UIBBrowserComponent methodsFor: 'initialize-release'!

contextHolder: aContextHolder

	contextHolder isNil ifFalse:[contextHolder value retractInterestIn: self browserSourceAspect for: self].
	contextHolder := aContextHolder.
	aContextHolder value expressInterestIn: self browserSourceAspect for: self sendBack: #sourceChanged! !

!UIBBrowserComponent methodsFor: 'private'!

sourceChanged

	self subclassResponsibility! !

UIBBrowserComponent subclass: #UIBBrowserSelector
	instanceVariableNames: 'choices selector '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserSelector methodsFor: 'initialize-release'!

initialize

	super initialize.
	self contextHolder: UIBBrowserContext new asValue.
	self choices: self defaultChoices.
	self selector selectionHolder
		compute:[:newSelection|
				self context
					perform: (self browserAspect , (String with: $:)) asSymbol
					with: newSelection]! !

!UIBBrowserSelector methodsFor: 'private'!

choicesFromNonNilSource

	^self subclassResponsibility!

choicesFromSource

	^(self context perform: self browserSourceAspect) isNil
		ifTrue: [List new]
		ifFalse: [self choicesFromNonNilSource asSortedCollection asList]!

defaultChoices
	"Default implementation."
	
	^List new!

setupSelector

	self selector list: self choices!

sourceChanged

	self choices: self choicesFromSource! !

!UIBBrowserSelector methodsFor: 'accessing'!

browserAspect

	^self subclassResponsibility!

choices

	^choices!

choices: listOfChoices

	choices := listOfChoices.
	self setupSelector! !

!UIBBrowserSelector methodsFor: 'aspects'!

selector
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^selector isNil
		ifTrue:
			[selector := SelectionInList new]
		ifFalse:
			[selector]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserSelector class
	instanceVariableNames: ''!


!UIBBrowserSelector class methodsFor: 'interface specs'!

listSpec
	"UIBPainter new openOnClass: self andSelector: #listSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Selector-#listSpec' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #selector 
					#model: #selector ) ) ) )! !

UIBBrowserSelector subclass: #UIBBrowserSelectorSelector
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserSelectorSelector methodsFor: 'accessing'!

browserAspect

	^#selector!

browserSourceAspect

	^#protocol! !

!UIBBrowserSelectorSelector methodsFor: 'private'!

choicesFromNonNilSource

	^(Smalltalk at: self context className) organization listAtCategoryNamed: self context protocol! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserSelectorSelector class
	instanceVariableNames: ''!


!UIBBrowserSelectorSelector class methodsFor: 'interface specs'!

listSpec
	"UIBPainter new openOnClass: self andSelector: #listSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Selector-#listSpec' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #selector 
					#model: #selector ) ) ) )! !

UIBBrowserSelector subclass: #UIBBrowserCategorySelector
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserCategorySelector methodsFor: 'accessing'!

browserAspect

	^#category!

browserSourceAspect

	^#source	"dummy"! !

!UIBBrowserCategorySelector methodsFor: 'private'!

defaultChoices

	^Smalltalk organization categories asSortedCollection asList! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserCategorySelector class
	instanceVariableNames: ''!


!UIBBrowserCategorySelector class methodsFor: 'interface specs'!

listSpec
	"UIBPainter new openOnClass: self andSelector: #listSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Selector-#listSpec' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #selector 
					#model: #selector ) ) ) )! !

UIBBrowserSelector subclass: #UIBBrowserClassSelector
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserClassSelector methodsFor: 'private'!

choicesFromNonNilSource

	^Smalltalk organization listAtCategoryNamed: self context category! !

!UIBBrowserClassSelector methodsFor: 'accessing'!

browserAspect

	^#className!

browserSourceAspect

	^#category! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserClassSelector class
	instanceVariableNames: ''!


!UIBBrowserClassSelector class methodsFor: 'interface specs'!

listSpec
	"UIBPainter new openOnClass: self andSelector: #listSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Selector-#listSpec' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #selector 
					#model: #selector ) ) ) )! !

UIBBrowserSelector subclass: #UIBBrowserProtocolSelector
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserProtocolSelector methodsFor: 'accessing'!

browserAspect

	^#protocol!

browserSourceAspect

	^#className! !

!UIBBrowserProtocolSelector methodsFor: 'private'!

choicesFromNonNilSource

	^(Smalltalk at: self context className) organization categories! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserProtocolSelector class
	instanceVariableNames: ''!


!UIBBrowserProtocolSelector class methodsFor: 'interface specs'!

listSpec
	"UIBPainter new openOnClass: self andSelector: #listSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Selector-#listSpec' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #selector 
					#model: #selector ) ) ) )! !

UIBBrowserComponent subclass: #UIBBrowserCodeView
	instanceVariableNames: 'code '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Browser'!


!UIBBrowserCodeView methodsFor: 'aspects'!

code
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^code isNil
		ifTrue:
			[code := Text new asValue]
		ifFalse:
			[code]! !

!UIBBrowserCodeView methodsFor: 'accessing'!

browserSourceAspect

	^#selector! !

!UIBBrowserCodeView methodsFor: 'private'!

sourceChanged

	self code value:
		(self context selector isNil
			ifTrue:[Text new]
			ifFalse:[((Smalltalk at: self context className) sourceCodeAt: self context selector) asText
						makeSelectorBoldIn: (Smalltalk at: self context className)])! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBBrowserCodeView class
	instanceVariableNames: ''!


!UIBBrowserCodeView class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Browser Code View-#windowSpec' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #code 
					#model: #code ) ) ) )! !





UIFinderVW2 computeSpecBearingClasses!
