'From VisualWorks(R), Release 2.5 of September 26, 1995 on March 26, 1997 at 3:41:31 pm'!

UIPainterView subclass: #UIBPluggablePainterView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!
UIBPluggablePainterView comment:
'I represent a view in which can be painted by UIBPainters.'!


!UIBPluggablePainterView methodsFor: 'accessing'!

label

	^self model windowSpec label! !

CompositePart subclass: #UIBCompositePart
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Composites'!
UIBCompositePart comment:
'I am the abstract superclass of all classes representing special groupings.
Subclasses are typically used to autolayout the widgets they contain.'!


Model subclass: #UIBResourceLocation
	instanceVariableNames: 'specSelector specHolderClass '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources'!
UIBResourceLocation comment:
'I represent the location of a resource, such as canvas resources (see the subclasses).

Instance variables:
	specSelector		<Symbol|nil>	The message that can be sent to the specHolderClass to fetch the resource.
	specHolderClass	<Symbol|nil>	The name of the class that holds onto the resource.'!


!UIBResourceLocation methodsFor: 'testing'!

exists
	"Answer a Boolean indicating existance of the resource the receiver refers to."

	^(self specHolderClass notNil and:[Smalltalk includesKey: self specHolderClass]) 
	and:[self specSelector notNil and:[(Smalltalk at: self specHolderClass) class canUnderstand: self specSelector]]!

sameLocationAs: aUIBResourceLocationOrNil

	^aUIBResourceLocationOrNil notNil
	and:[self specHolderClass == aUIBResourceLocationOrNil specHolderClass
	and: [self specSelector == aUIBResourceLocationOrNil specSelector]]! !

!UIBResourceLocation methodsFor: 'private'!

setSpecHolderClass: aSymbol

	specHolderClass := aSymbol!

setSpecSelector: aSymbol

	specSelector := aSymbol! !

!UIBResourceLocation methodsFor: 'accessing'!

resourceLocation

	^UIBResourceLocation new specHolderClass: self specHolderClass; specSelector: self specSelector!

specHolderClass

	^specHolderClass!

specHolderClass: aSymbol

	self setSpecHolderClass: aSymbol.
	self changed: #specHolderClass!

specSelector

	^specSelector!

specSelector: aSymbol

	self setSpecSelector: aSymbol.
	self changed: #specSelector! !

!UIBResourceLocation methodsFor: 'printing'!

printOn: aStream

	aStream store: self class; space; store: self specHolderClass; space; store: self specSelector! !

!UIBResourceLocation methodsFor: 'initialize-release'!

initialize

	self initializeSpecInfo!

initializeSpecInfo

	self
		specHolderClass: #UntitledClass;
		specSelector: UIBCompositeComponentSpec defaultMinorKey! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBResourceLocation class
	instanceVariableNames: ''!


!UIBResourceLocation class methodsFor: 'instance creation'!

holderClass: classSymbol selector: selectorSymbol

	^self basicNew
		specHolderClass: classSymbol;
		specSelector: selectorSymbol!

new

	^super new initialize! !

SelectionView subclass: #TabBarViewOOP
	instanceVariableNames: 'visualBlock leftSpine tabScrollPosition tabScrollPositionKnown localEnabled hasFocus '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!


!TabBarViewOOP methodsFor: 'constants'!

gapBetweenTabs

	^0

	"<<BIKI on top of a mountain: 1 January 1996,4:29:53 pm, version: 1>>"!

numberOfVisiblePages

	^6!

tabScrollButtonMargin

	"Answer the extent in pixels that the tab scrolling buttons take up when present."

	^8! !

!TabBarViewOOP methodsFor: 'private'!

initialSelectionIndex

	^1!

levelOfElement: index 
	index < selectionIndex ifTrue: [^1].
	^  ( self numberOfVisiblePages - index + selectionIndex  ) max: 1

	"<<BIKI at the bottom of a mountain: 2 January 1996,12:54:32 pm, version: 3>>"!

makeVisible: anIndex
	"Force the tab identified by the argument to be visible within the receiver's display bounds."

	| old |
	old := tabScrollPosition.
	self computeTabScrollPositionFor: anIndex.
	old = tabScrollPosition ifFalse: [self invalidate]!

normalStringTab

	"Set the visualBlock (see visualBlock:) so that it will display the string returned by the view when sent displayStringAt:"


	self visualBlock: 
		[:view :index | |displayObject text icon|  
		displayObject := (view displayStringAt: index).
		( displayObject isKindOf: StringAndIcon )
			ifTrue: [text := displayObject string.
					icon := displayObject icon]
			ifFalse: [text := displayObject].
		BoundedWrapper on: ((UIBLabelAndIcon
								with: text  
								attributes: view textStyle offset: 6@2)  icon:  icon)]

	"<<BIKI 'please dont remove this button': 21 January 1996,7:03:27 pm, version: 6>>"!

useSelectionIndex: anIndex

	self makeVisible: anIndex.
	self selectionChannel value: anIndex.
	self targetIndex: anIndex!

visualComponentForElementIndex: anIndex  
	| vc |
	vc := visualBlock value: self value: anIndex.  
	^vc

	"<<BIKI 'please dont remove this button': 21 January 1996,7:03:29 pm, version: 8>>"!

visualComponentForElementIndex: anIndex inBounds: box

	| vc |
	vc := self visualComponentForElementIndex: anIndex.
	vc bounds: box.
	^vc

	"<<BIKI 'please dont remove this button': 21 January 1996,7:03:30 pm, version: 2>>"! !

!TabBarViewOOP methodsFor: 'visual properties'!

borderColor
	"Answer the receiver's border color (around flat regions)."
	
	^ColorValue gray!

scrollButtonColor

	"Answer the color to display the tab scrolling buttons."

	^SymbolicPaint scrollerButtonForeground!

tabColor

	"Answer the color to display the inside of each tab.  This should be the same as the background color of the Notebook pages."

	^self backgroundColor! !

!TabBarViewOOP methodsFor: 'accessing'!

localEnabled: aBoolean

	localEnabled == aBoolean ifTrue: [^self].
	localEnabled := aBoolean.
	self redisplayForEnabledChange!

selectionIndex: elementIndex
	"Set the index of the selected item.
	If elementIndex is not zeroIndex then move the target index to
	correspond to the new selection index.  If the elementIndex is
	the zeroIndex then leave the target index where it was."

	((selectionIndex = elementIndex) or: [sequence == nil]) ifTrue: [^self].
	selectionIndex := elementIndex max: 1.
	self invalidate!

sequence: aSequence
	"Set the receiver's sequence to be aSequence."

	tabScrollPositionKnown := false.
	super sequence: aSequence!

targetIndex: anInteger

	self setValidTargetIndex: anInteger! !

!TabBarViewOOP methodsFor: 'bounds accessing'!

bounds: newBounds
	"The receiver's bounds are being changed to newBounds."

	super bounds: newBounds.
	tabScrollPositionKnown := false! !

!TabBarViewOOP methodsFor: 'controller accessing'!

defaultControllerClass

	^TabBarController! !

!TabBarViewOOP methodsFor: 'focus accessing'!

hasFocus

	^hasFocus!

hasFocus: aBoolean

	hasFocus == aBoolean ifTrue: [^self].
	hasFocus := aBoolean.
	(aBoolean and: [targetIndex = self zeroIndex]) ifTrue: [self setValidTargetIndex: 1].
	self invalidateRectangle: (self boundsOfElementIndex: targetIndex inBounds: self bounds)! !

!TabBarViewOOP methodsFor: 'initialize-release'!

initialize
	"Initialize the receiver."

	super initialize.
	self initializeVisuals.
	leftSpine := false.
	tabScrollPosition := 0.
	tabScrollPositionKnown := false.
	localEnabled := true.
	hasFocus := false!

initializeGrid

	grid := [self textStyle lineGrid + 7]!

initializeVisuals
	"Assume that the visuals will be simple CharacterArrays."

	self normalStringTab!

leftSpine: aBoolean

	leftSpine := aBoolean.!

visualBlock: aBlock

	"Set the BlockClosure that accepts two arguments, self and the index of the tab item label to display.  The BlockClosure should answer a VisualComponent appropriate for displaying this tab item label."

	visualBlock := aBlock! !

!TabBarViewOOP methodsFor: 'protected-tab scrolling'!

computeTabScrollPositionFor: anIndex

	"Compute the proper value for the tab scroll position."
	"The current tabScrollPosition may indicate the last valid tab scroll position."

	self subclassResponsibility!

decrementTabButtonBox
	"Answer the rectangle bounds of the tab scrolling button that decrements the tabScrollingPosition."

	^self subclassResponsibility!

incrementTabButtonBox
	"Answer the rectangle bounds of the tab scrolling button that increments the tabScrollingPosition."

	^self subclassResponsibility!

invalidateTabsForScrolling
	"Invalidate the area where the tabs are displayed because they are being scrolled."

	self subclassResponsibility!

isScrollingTabs

	"Answer whether the tabs are currently capable of being scrolled via tab scrolling buttons."

	self validateScrollPosition.
	^tabScrollPosition ~= 0!

tabScrollPositionDecrement
	"The tab scroll button to decrement the tabScrollButton has been pressed.  Take the appropriate action."

	tabScrollPosition = 1 ifTrue: [^self].
	tabScrollPosition := tabScrollPosition - 1.
	self invalidateTabsForScrolling!

tabScrollPositionIncrement
	"The tab scroll button to increment the tabScrollButton has been pressed.  Take the appropriate action."

	"Need a more sophisticated test here."
	tabScrollPosition = self numberOfElements ifTrue: [^self].
	tabScrollPosition := tabScrollPosition + 1.
	self invalidateTabsForScrolling!

validateScrollPosition

	"Validate the value of the tab scroll position."

	tabScrollPositionKnown ifFalse: [
		self computeTabScrollPositionFor: selectionIndex.
		tabScrollPositionKnown := true]! !

!TabBarViewOOP methodsFor: 'testing'!

isEnabled

	^state isEnabled and: [localEnabled]! !

CompositeSpec subclass: #UIBCompositeSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Composites'!
UIBCompositeSpec comment:
'I am a subclass of CompositeSpec that can be asked for its favorite associated user interface component.
I am the superclass of all specification classes that correspond with UIBCompositeSpecs.

Subclasses should override #compositeSpecCollectionClass and #preferredCompositeClass.'!


!UIBCompositeSpec methodsFor: 'private'!

compositeSpecCollectionClass

	^self class compositeSpecCollectionClass!

newComposite

	^self class newComposite!

preferredCompositeClass

	^self class preferredCompositeClass! !

!UIBCompositeSpec methodsFor: 'accessing'!

extractedSpecFor: aComposite

	"Overridden here in order not to use the hardcoded CompositeSpecCollection class."

	| csc |
	csc := self compositeSpecCollectionClass new.
	csc compositeSpec: self.
	csc extractFromCollection: aComposite components.
	^csc!

savableSpecFor: aComposite

	"Overridden here in order not to use the hardcoded CompositeSpecCollection class."

	| csc |
	csc := self compositeSpecCollectionClass new.
	csc compositeSpec: self copy.
	csc fromCollection: aComposite components.
	^csc! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBCompositeSpec class
	instanceVariableNames: ''!


!UIBCompositeSpec class methodsFor: 'applicability'!

canBeGrouped: wrapperCollection
	"Answer whether the components in wrapperCollection can be grouped by instances of the receiver."

	^true! !

!UIBCompositeSpec class methodsFor: 'class accessing'!

compositeSpecCollectionClass

	^UIBCompositeSpecCollection!

newComposite

	^self preferredCompositeClass new!

preferredCompositeClass

	^UIBCompositePart! !

Model subclass: #UIBLabelAndVisualRepository
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Basics'!


!UIBLabelAndVisualRepository methodsFor: 'private'!

buildImage: imageSelector mask: maskSelector bw: bwSelector

	"savedScreenDepth < 4 |" imageSelector isNil ifTrue: [^self class perform: bwSelector].
	maskSelector isNil ifTrue: [^self class perform: imageSelector].
	^OpaqueImage figure: (self wrap: (self class perform: imageSelector))
		shape:(self wrap: (self class perform: maskSelector))!

buildImageWithMask: aMask bw: aBW andImage: anImage 

	"savedScreenDepth < 4 |" anImage isNil ifTrue: [^self class perform: aBW].
	aMask isNil ifTrue: [^self class perform: anImage].
	^OpaqueImage figure: (self wrap: (self class perform: anImage))
		shape:(self wrap: (self class perform: aMask))!

label: aStringOrText andIcon: iconSelector

	^(LabelAndIcon with: aStringOrText) icon: (self visualAt: iconSelector); yourself!

wrap: anImage

	^anImage class == CachedImage
		ifTrue: [anImage]
		ifFalse: [CachedImage on: anImage]! !

!UIBLabelAndVisualRepository methodsFor: 'accessing'!

visualAt: aKey

	^self visualAt: aKey ifAbsent: [self error: 'Visual not found!!']!

visualAt: aKey ifAbsent: aBlock

	^self messageNotUnderstoodSignal
		handle: [:ex | aBlock value]
		do: [self class perform: aKey]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBLabelAndVisualRepository class
	instanceVariableNames: ''!


!UIBLabelAndVisualRepository class methodsFor: 'resources'!

acceptImage
	"UIMaskEditor new openOnClass: self andSelector: #acceptImage"

	<resource: #image>
	^(Image extent: 15@12 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: (ColorValue scaledRed: 0 scaledGreen: 3276 scaledBlue: 0); at: 2 put: (ColorValue scaledRed: 0 scaledGreen: 6007 scaledBlue: 0); at: 3 put: (ColorValue scaledRed: 0 scaledGreen: 7645 scaledBlue: 0); at: 4 put: ColorValue white; at: 5 put: (ColorValue scaledRed: 7645 scaledGreen: 7645 scaledBlue: 7645); yourself)) usingBits: #[51 51 51 51 51 51 51 0 51 51 51 51 51 51 16 48 51 51 51 51 51 49 4 48 51 51 51 51 51 16 67 48 51 51 51 51 49 4 51 48 49 36 51 51 16 67 51 48 1 18 67 51 17 51 51 48 48 17 36 49 4 51 51 48 51 1 18 16 67 51 51 48 51 48 17 4 51 51 51 48 51 51 1 36 51 51 51 48 51 51 48 67 51 51 51 48])!

acceptMask
	"UIMaskEditor new openOnClass: self andSelector: #acceptMask"

	<resource: #image>
	^(Image extent: 15@12 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 2 0 0 0 12 0 0 0 28 0 0 0 56 0 0 0 112 0 0 112 224 0 0 248 192 0 0 125 192 0 0 63 128 0 0 31 0 0 0 15 0 0 0 6 0 0 0])!

applFLabLogoImage
	"UIMaskEditor new openOnClass: self andSelector: #applFLabLogoImage"

	<resource: #image>
	^CachedImage on: (Image extent: 240@75 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: ColorValue white; at: 2 put: ColorValue red; yourself)) usingBits: (ByteArray fromPackedString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

applFLabLogoMask
	"UIMaskEditor new openOnClass: self andSelector: #applFLabLogoMask"

	<resource: #image>
	^CachedImage on: (Image extent: 240@75 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: (ByteArray fromPackedString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

cancelImage
	"UIMaskEditor new openOnClass: self andSelector: #cancelImage"

	<resource: #image>
	^(Image extent: 14@13 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 3) at: 1 put: (ColorValue scaledRed: 7645 scaledGreen: 0 scaledBlue: 0); at: 2 put: (ColorValue scaledRed: 7645 scaledGreen: 7645 scaledBlue: 7645); at: 3 put: ColorValue white; yourself)) usingBits: #[6 170 168 16 0 106 160 96 128 26 129 160 168 6 26 160 170 0 26 160 170 128 106 160 170 0 26 160 168 6 6 160 160 26 129 160 128 106 161 160 128 106 168 96 161 170 170 160 170 170 170 16])!

cancelMask
	"UIMaskEditor new openOnClass: self andSelector: #cancelMask"

	<resource: #image>
	^(Image extent: 14@13 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[224 28 0 0 248 56 0 0 124 112 0 0 30 192 0 0 15 192 0 0 7 128 0 0 15 192 0 0 30 224 0 0 60 112 0 0 120 48 0 0 120 24 0 0 48 0 0 0 0 12 0 0])!

classCommentImage
	"UIMaskEditor new openOnClass: self andSelector: #classCommentImage"

	<resource: #image>
	^(Image extent: 16@16 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue yellow; at: 4 put: ColorValue white; yourself)) usingBits: #[240 0 15 255 241 85 67 255 241 85 68 255 241 85 64 63 241 169 85 63 241 85 85 63 241 85 85 63 241 169 169 63 241 85 85 63 241 85 85 63 241 166 105 63 241 85 85 63 241 85 85 63 241 170 153 63 241 85 85 63 240 0 0 63])!

classCommentMask
	"UIMaskEditor new openOnClass: self andSelector: #classCommentMask"

	<resource: #image>
	^(Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[63 192 0 0 63 224 0 0 63 240 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0 63 248 0 0])!

classDefinitionImage
	"UIMaskEditor new openOnClass: self andSelector: #classDefinitionImage"

	<resource: #image>
	^(Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: ColorValue white; at: 2 put: ColorValue blue; yourself)) usingBits: #[0 0 0 0 0 0 0 0 1 128 0 0 3 192 0 0 3 192 0 0 1 128 0 0 0 0 0 0 3 192 0 0 7 192 0 0 3 192 0 0 3 192 0 0 3 192 0 0 3 192 0 0 7 224 0 0 0 0 0 0 0 0 0 0])!

classDefinitionMask
	"UIMaskEditor new openOnClass: self andSelector: #classDefinitionMask"

	<resource: #image>
	^(Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 1 128 0 0 3 192 0 0 3 192 0 0 1 128 0 0 0 0 0 0 3 192 0 0 7 192 0 0 3 192 0 0 3 192 0 0 3 192 0 0 3 192 0 0 7 224 0 0 0 0 0 0 0 0 0 0])!

classHierarchyImage
	"UIMaskEditor new openOnClass: self andSelector: #classHierarchyImage"

	<resource: #image>
	^(Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: ColorValue white; at: 2 put: ColorValue blue; yourself)) usingBits: #[3 128 0 0 3 128 0 0 3 128 0 0 1 0 0 0 15 224 0 0 8 32 0 0 28 112 0 0 28 112 0 0 28 112 0 0 0 32 0 0 1 252 0 0 1 4 0 0 3 142 0 0 3 142 0 0 3 142 0 0 0 0 0 0])!

classHierarchyMask
	"UIMaskEditor new openOnClass: self andSelector: #classHierarchyMask"

	<resource: #image>
	^(Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[3 128 0 0 3 128 0 0 3 128 0 0 1 0 0 0 15 224 0 0 8 32 0 0 28 112 0 0 28 112 0 0 28 112 0 0 0 32 0 0 1 252 0 0 1 4 0 0 3 142 0 0 3 142 0 0 3 142 0 0 0 0 0 0])!

fileOutImage
	"UIMaskEditor new openOnClass: self andSelector: #fileOutImage"

	<resource: #image>
	^(Image extent: 14@13 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 4112 scaledGreen: 4112 scaledBlue: 4112); at: 3 put: ColorValue white; at: 4 put: ColorValue yellow; yourself)) usingBits: #[170 128 2 160 170 133 80 160 170 197 81 32 170 245 80 0 170 253 85 64 255 255 85 64 255 255 213 64 255 255 85 64 170 253 85 64 170 245 85 64 170 197 85 64 170 133 85 64 170 128 0 0])!

fileOutMask
	"UIMaskEditor new openOnClass: self andSelector: #fileOutMask"

	<resource: #image>
	^(Image extent: 14@13 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[7 224 0 0 4 48 0 0 12 40 0 0 12 60 0 0 14 4 0 0 255 4 0 0 255 132 0 0 255 4 0 0 14 4 0 0 12 4 0 0 12 4 0 0 4 4 0 0 7 252 0 0])!

infoImage
	"UIMaskEditor new openOnClass: self andSelector: #infoImage"

	<resource: #image>
	^(Image extent: 15@12 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: ColorValue white; at: 2 put: ColorValue blue; yourself)) usingBits: #[1 128 0 0 3 192 0 0 3 192 0 0 1 128 0 0 0 0 0 0 3 192 0 0 7 192 0 0 3 192 0 0 3 192 0 0 3 192 0 0 3 192 0 0 7 224 0 0])!

infoMask
	"UIMaskEditor new openOnClass: self andSelector: #infoMask"

	<resource: #image>
	^(Image extent: 15@12 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[1 128 0 0 3 192 0 0 3 192 0 0 1 128 0 0 0 0 0 0 3 192 0 0 7 192 0 0 3 192 0 0 3 192 0 0 3 192 0 0 3 192 0 0 7 224 0 0])!

pencilImage
	"UIMaskEditor new openOnClass: self andSelector: #pencilImage"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 8191 scaledGreen: 3276 scaledBlue: 1638); at: 3 put: ColorValue yellow; at: 4 put: ColorValue white; yourself)) usingBits: #[255 255 255 255 255 255 255 255 255 255 252 15 255 255 241 83 255 255 240 83 255 255 202 3 255 255 202 143 255 255 42 143 255 255 42 63 255 252 170 63 255 252 168 255 255 252 3 255 255 252 15 255 255 252 63 255 195 0 255 255 255 255 255 255])!

pencilMask
	"UIMaskEditor new openOnClass: self andSelector: #pencilMask"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 28 0 0 0 62 0 0 0 62 0 0 0 126 0 0 0 124 0 0 0 252 0 0 0 248 0 0 1 248 0 0 1 240 0 0 1 224 0 0 1 192 0 0 1 128 0 0 111 0 0 0 0 0 0 0])! !

!UIBLabelAndVisualRepository class methodsFor: 'composite image creation'!

cancelButtonLabel

	^self new label: 'Cancel' andIcon: #cancelIcon!

okButtonLabel

	^self new label: 'OK' andIcon: #acceptIcon! !

!UIBLabelAndVisualRepository class methodsFor: 'image creation'!

acceptIcon

	^self new buildImage: #acceptImage mask: #acceptMask bw: nil!

applFLabLogoIcon

	^self new buildImage: #applFLabLogoImage mask: #applFLabLogoMask bw: nil!

cancelIcon

	^self new buildImage: #cancelImage mask: #cancelMask bw: nil!

classCommentIcon

	^self new buildImage: #classCommentImage mask: #classCommentMask bw: nil!

classDefinitionIcon

	^self new buildImage: #classDefinitionImage mask: #classDefinitionMask bw: nil!

classHierarchyIcon

	^self new buildImage: #classHierarchyImage mask: #classHierarchyMask bw: nil!

classMethodsIcon

	^self pencilIcon!

fileOutIcon

	^self new buildImage: #fileOutImage mask: #fileOutMask bw: nil!

hierarchyIcon

	^self new buildImage: #hierarchyImage mask: #hierarchyMask bw: nil!

infoIcon

	^self new buildImage: #infoImage mask: #infoMask bw: nil!

pencilIcon

	^self new buildImage: #pencilImage mask: #pencilMask bw: nil! !

ApplicationModel subclass: #UIBApplicationModel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Basics'!
UIBApplicationModel comment:
'I am an enhanced version of my superclass.
I extend it with
	- use of another builder class (UIBBuilder)
	- behavior for easy access to components in my user interface
	- binding non-unary action methods

Instance variables:
	none'!


!UIBApplicationModel methodsFor: 'binding'!

actionFor: aKey 
	"Depending on the arity of aKey, return a block that will be sent the message #value or #valueWithArguments:.
	This method is the generalization of the one in the superclass. It can now be used for binding arbitrary callback actions."

	aKey isKeyword
		ifTrue:[^[:args| self perform: aKey withArguments: (args copyFrom: 1 to: aKey numArgs)]]
		ifFalse:[^super actionFor: aKey]! !

!UIBApplicationModel methodsFor: 'components-visibility'!

hideComponent: anIDsymbol

	self show: false component: anIDsymbol!

hideComponents: idList

	self show: false components: idList!

show: aBoolean component: anIDsymbol

	(self component: anIDsymbol) isVisible: aBoolean!

show: aBoolean components: idList

	idList do: [:id | self show: aBoolean component: id]!

showComponent: anIDsymbol

	self show: true component: anIDsymbol!

showComponents: idList

	self show: true components: idList! !

!UIBApplicationModel methodsFor: 'testing'!

built

	^self builder notNil! !

!UIBApplicationModel methodsFor: 'components-access'!

component: anIDsymbol

	^self builder componentAt: anIDsymbol!

widget: anIDsymbol
	"Answer the widget corresponding to the given ID.
	For custom components,
		answer the custom component object rather than the subcanvas widget.
		Use '(self component: anIDsymbol) widget' to fetch its subcanvas widget."

	| component |
	^(component := self builder customComponentAt: anIDsymbol) isNil
		ifTrue:[(self component: anIDsymbol) widget]
		ifFalse:[component]! !

!UIBApplicationModel methodsFor: 'components-enabling'!

able: aBoolean component: anIDsymbol

	(self component: anIDsymbol) isEnabled: aBoolean!

able: aBoolean components: idList

	idList do: [:id | self able: aBoolean component: id]!

disableComponent: anIDsymbol

	self able: false component: anIDsymbol!

disableComponents: idList

	self able: false components: idList!

enableComponent: anIDsymbol

	self able: true component: anIDsymbol!

enableComponents: idList

	self able: true components: idList! !

!UIBApplicationModel methodsFor: 'component setup'!

minorKey: aSpecSymbol
	"This method is sent when the minorKey for a custom component differs
	from the default minorKey, as laid down in the component's specification class."

	"Koen, June 7, 1996: This is probably obsolete."

	"No-op."! !

!UIBApplicationModel methodsFor: 'initialize-release'!

release
	"Release the receiver's dependency relationships."

	self releaseDependencyRelationShips.
	super release!

releaseDependencyRelationShips

	^self! !

!UIBApplicationModel methodsFor: 'private'!

builderClass
	"Answer the builder class to use for the receiver."

	"It is probably a good idea to override #defaultSource in your subclass of UIBBuilder when you override this method."

	^UIBBuilder!

labelAndVisualRepository

	^self class labelAndVisualRepository! !

!UIBApplicationModel methodsFor: 'events'!

noticeOfWindowClose: aWindow 
	"aWindow is being closed. Take appropriate action."
	"This class supposes that its instances are opened in 1 window only."

	self release! !

!UIBApplicationModel methodsFor: 'actions'!

beep

	Screen default ringBell! !

!UIBApplicationModel methodsFor: 'changing'!

retractInterest: aSymbol from: anObject while: aBlock

	anObject retractInterestsFor: self.
	aBlock value.
	anObject onChangeSend: aSymbol to: self! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBApplicationModel class
	instanceVariableNames: ''!


!UIBApplicationModel class methodsFor: 'resource accessing'!

visualAt: key 
	"Retrieve the indicated visual from the receiver's label and visual repository."

	^self visualAt: key ifAbsent: [self error: 'Visual not found!!']!

visualAt: key ifAbsent: aBlock 
	"Retrieve the indicated visual from the receiver's label and visual repository.
	If not found, try the super's default visuals registry."

	^self labelAndVisualRepository visualAt: key ifAbsent: [super visualAt: key ifAbsent: aBlock]! !

!UIBApplicationModel class methodsFor: 'class accessing'!

labelAndVisualRepository
	"Answer the object that holds the receiver's labels ans visuals."

	^UIBLabelAndVisualRepository new! !

UIBApplicationModel subclass: #UIBComponentEditor
	instanceVariableNames: 'specSettings component specSlices placementWidth placementHeight sliceEditor subBuilder paletteIcon paletteMonoIcon iconEditor iconKind painter looks paletteEditor installer quietAccept customSize slice sliceMenu specSlicesSelectionIndexHolder updateAfterInstall '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Editor'!
UIBComponentEditor comment:
'I am ApplFlab''s meta-tool for creation of user-defined components.
My user interface is a notebook with two tabbars. The major tabbar (at the bottom) contains icons that represent all the steps to be taken in order to define a new component. The minor tab (on the right) is used to select a canvas when painting a user interface for the component or the user interface of a slice for its properties tool. The minor tabbar is replaced by a pop-up menu when the user prefers menu page style tools (see the Settings under the launcher''s File menu).

The steps that need to taken are:
	1. Supplying general information, such as the name of the component.
	2. Painting the component''s user interfaces.
	3. Editing the slices of the component''s properties tool.
	4. Painting the user interfaces of the component''s properties tool slices.
	5. Supplying the default width and height of the component when dragged off a palette and the icon representing it on a palette.
	6. Installation of the specification class.
	7. Installation of the component on a palette.

Generation of Smalltalk code is not done by the receiver, but by a UIBComponentGenerator. The receiver only edits a UIBComponent.

Instance variables:
	specSettings		<SelectionInList>	The aspect of the major tabbar of the notebook.
	component		<UIBComponent>	The target user-defined component for the receiver.
	specSlices		<SelectionInList>	The aspect of the minor tabbar of the notebook.
									This aspect is changed when the slices change.
									The slice menu (see below) is changed automatically.
	placementWidth	<AspectAdaptor>	The aspect of the ''width'' input field.
	placementHeight	<AspectAdaptor>	The aspect of the ''height'' input field.
	sliceEditor		<UIBOrderableList>	The client for the editor on the ''slices'' page.
	subBuilder		<UIBBuilder>	The builder of the current SubCanvas in the notebook.
	paletteIcon		<PluggableAdaptor>	The aspect of the icon editor for the component''s colour icon.
	paletteMonoIcon	<PluggableAdaptor>	The aspect of the icon editor for the component''s black and white icon.
	iconEditor		<UIBIconEditor>	The client for the icon editor.
	iconKind			<PluggableAdaptor>	The aspect of the icon editor for icon selection.
	painter			<UIBPropertiesPainter|UIBPluggablePainter>	The client for the canvas pages.
	looks			<UIBComponentLookAndFeelEditor2>	
	paletteEditor		<UIBPaletteEditor>	The client for the palette page.
	quietAccept		<Boolean>	
	customSize		<Point>	The custom extent of the receiver.
	slice				<ValueHolder>	The aspect of the slice pop-up menu when the menu page style is preferred.
								It is equal to the selection index holder of the ''specSlices'' SelectionInList.
	sliceMenu		<PluggableAdaptor>		The actual menu of the  slice pop-up menu.

Class variables:
	none'!


!UIBComponentEditor methodsFor: 'components'!

ableSlices: aBoolean

	self noteBookWidget rightTabBar localEnabled: aBoolean!

commentLineWidget

	^(self builder componentAt: #commentLine) widget!

loadAllButton

	^subBuilder componentAt: #loadAllButton!

loadButton

	^subBuilder componentAt: #loadButton!

noteBookWidget

	^self widget: #pageHolder!

paletteIconRadioButton

	^subBuilder componentAt: #paletteIcon!

paletteMonoIconRadioButton

	^subBuilder componentAt: #paletteMonoIcon!

removeButton

	^subBuilder componentAt: #removeSliceButton!

setCommentLine: aString

	self commentLineWidget labelString: aString! !

!UIBComponentEditor methodsFor: 'accept'!

accept

	self perform: (self specSettings selection value at: 2)!

acceptComponent

	self specSlices list isEmpty ifTrue:[^self].
	" Koen: als het volgende uitgevoerd wordt, wordt een UI niet geregistreerd na een install dmv de pluggable painter."
	"painter canvasHasChanged
		ifTrue:[(self specSlices list at: self specSlices selectionIndex) fullSpec: painter makeFullSpec]."
	"Dit is dus goed in alle gevallen. Nadeel is nu dat een UI 2 keer geinstalleerd wordt: bij de install dmv de painter en bij de install van de spec class."
	(self specSlices list at: self specSlices selectionIndex) fullSpec: painter makeFullSpec.
	quietAccept ifFalse:[self painterCloses]!

acceptGeneral

	self forceAcceptOfComponent: #componentName!

acceptInstall

	"Do nothing."!

acceptPainting

	self
		forceAcceptOfComponent: #placementWidth;
		forceAcceptOfComponent: #placementHeight.
	self iconEditor doAccept!

acceptPalette

	"Do nothing."!

acceptProperties

	self specSlices list isEmpty ifTrue:[^self].
	painter canvasHasChanged
		ifTrue:[(self specSlices list at: self specSlices selectionIndex) fullSpec: painter makeFullSpec].
	sliceEditor orderableList selectionIndexHolder retractInterestsFor: self.
	quietAccept ifFalse:[self painterCloses]!

acceptSlices

	self sliceEditor orderableList selection isNil
		ifFalse:[self
				forceAcceptOfComponent: #specSliceLabel;
				forceAcceptOfComponent: #specSelector;
				forceAcceptOfComponent: #specHolderClass;
				forceAcceptOfComponent: #subSpecID]!

quietAccept

	quietAccept := true.
	self accept.
	quietAccept := false! !

!UIBComponentEditor methodsFor: 'testing'!

editingStandardWidget

	^false!

editingSubclassOfStandardWidget

	^false! !

!UIBComponentEditor methodsFor: 'changes'!

changedComponentName
	
	| tx |
	self builder window label:
		(((tx := self componentName value) isNil or: [tx isEmpty])
			ifTrue: ['Component Editor']
			ifFalse: ['Component Editor on: ' , tx]).
	self painter isNil ifFalse:[self painter windowSpec label: tx]!

componentSettings

	self noteBookWidget client: self spec:  #componentSettingsSpec!

generalSettings

	self noteBookWidget client: self spec:  #generalSettingsSpec!

installSettings

	self noteBookWidget client: self spec:  #installSettingsSpec!

loadButtonModifiedState

	self loadButton isEnabled: (self sliceEditor orderableList selection notNil
							and:[self sliceEditor orderableList selection isInconsistent])!

paintingSettings

	self noteBookWidget client: self spec:  #paintingSettingsSpec.
	self paletteIconRadioButton widget label: self paletteIcon value.
	self paletteMonoIconRadioButton widget label: self paletteMonoIcon value.
	self iconKind value isNil ifTrue:[self iconKind value: #paletteIcon]!

paletteSettings

	self noteBookWidget client: self spec:  #paletteSettingsSpec!

propertiesSettings

	self specSlices list isEmpty
		ifTrue:[	self noteBookWidget client: nil]
		ifFalse:[	self specSlices selectionIndex = 0 ifTrue:[self specSlices selectionIndex: 1].
				self noteBookWidget client: self spec: #propertiesSpec.
				painter makeActivePainter.
				self updateCommentLine]!

sliceSelectionChanged

	self removeButton isEnabled: self sliceEditor orderableList selection notNil.
	self loadButtonModifiedState!

sliceSettings

	self noteBookWidget client: self spec:  #sliceSettingsSpec.
	sliceEditor orderableList selectionIndexHolder onChangeSend: #sliceSelectionChanged to: self.
	self sliceSelectionChanged! !

!UIBComponentEditor methodsFor: 'private-accessing'!

targetComponent

	^component!

targetComponent: aUIBComponent

	component := aUIBComponent! !

!UIBComponentEditor methodsFor: 'component class accessing'!

preferredComponentClass

	^self subclassResponsibility! !

!UIBComponentEditor methodsFor: 'private'!

changeRequest

	"NOT YET IMPLEMENTED."

	"^(Dialog confirm: 'The specification has been altered but not installed.\Do you wish to discard the changes ?' withCRs)"

	self quietAccept.
	^(self builder window sensor shiftDown or: [self hasChanged not])
		or: [Dialog
			choose: 'This feature is not yet implemeted.\Be sure to install before closing this window.' withCRs
			labels: #('Close it' 'Do NOT close it')
			values: #(true false)
			default: true]!

clearCommentLine

	self setCommentLine: ''!

currentSettingIsForPainting

	|setting|
	^(setting := (self specSettings selection value at: 1)) == #propertiesSettings
		or: [setting == #componentSettings]!

forceAcceptOfComponent: aSymbol

	(subBuilder componentAt: aSymbol) widget controller checkForAcceptWithValidation
	"Koen: deze expressie geeft false terug bij een validation failure. Moeten we daar niets mee doen? -> op dit moment wordt er niets gevalideerd."!

hasChanged

	^self targetComponent specHasChanged!

painterCloses

	painter makeInactivePainter.
	painter := nil.
	self clearCommentLine!

painterIsOpen

	^painter notNil!

sliceMenu

	^sliceMenu!

subBuilder

	^subBuilder!

updateCommentLine

	(self specSettings selection value at: 1 ) == #propertiesSettings ifFalse:[^self].
	self setCommentLine: 
		((self targetComponent isOurOwnSlice: self specSlices selection)
			ifTrue:['']
			ifFalse:['This slice is not editable. Use a conventional Painter to edit it.'])! !

!UIBComponentEditor methodsFor: 'accessing'!

iconEditor
	
	^iconEditor!

installer

	^installer isNil
		ifTrue:
			[installer := UIBClassInstaller new]
		ifFalse:
			[installer]!

looks

	^looks!

paletteEditor
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^paletteEditor isNil
		ifTrue:
			[paletteEditor := UIBPaletteEditor new]
		ifFalse:
			[paletteEditor]!

paletteIcon
	
	^paletteIcon!

paletteMonoIcon
	
	^paletteMonoIcon!

sliceEditor

	^sliceEditor! !

!UIBComponentEditor methodsFor: 'initialize-release'!

initializeComponentAspects

	"Default is to do nothing."!

initializeComponentForClass: aSpecClass

	self targetComponent: 
		(aSpecClass isNil
			ifFalse:[self preferredComponentClass forClass: aSpecClass]
			ifTrue:[self preferredComponentClass new])
	"self targetComponent: (aSpecClass isNil ifTrue:[UIBCompositeComponent new] ifFalse:[
		((UIBFinder isStandardSpecClass: aSpecClass)
			ifTrue:[UIBStandardComponent]
			ifFalse:[(UIBFinder isCompositeComponentSpecClass: aSpecClass)
					ifTrue:[UIBCompositeComponent]
					ifFalse:[UIBExtendedStandardComponent]]) forClass: aSpecClass])"!

initializeFor: aSpecClass

	self initialize. "In case the superclass needs initialization (we use #basicNew for instance creation)."
	"The order is important !!"
	self
		initializeComponentForClass: aSpecClass;
		initializeNoteBookAspects;
		initializeComponentAspects;
		initializeSlicesAspects;
		initializeGeneralAspects;
		initializePaintingAspects;
		initializeInstallerAspects!

initializeGeneralAspects

	"Default is tot do nothing."!

initializeInstallerAspects

	installer := UIBClassInstaller new.
	installer targetClassNameHolder: 
		((AspectAdaptor forAspect: #targetClassName)
			subject: self targetComponent;
			subjectSendsUpdates: false).
	installer targetClassNameHolder onChangeSend: #install to: self!

initializeNoteBookAspects

	quietAccept := false.
	specSettings := SelectionInList with: self majorTabsList.
	specSettings selectionIndexHolder:
		((PluggableAdaptor on: 0 asValue)
			getBlock:[:m| m value]
			putBlock:[:m :newValue||selector|
					m value > 0 ifTrue:[self accept].
					m value: newValue.
					specSlices list:
						((newValue = 0 or:[(selector := self specSettings selection value at: 3) isNil])
							ifTrue:[List new]
							ifFalse:[self targetComponent perform: selector]).
					Cursor execute showWhile:[self perform: (self specSettings selection value at: 1). "change page"]]
			updateBlock:[:m :aspect :parameter| false]).
	specSlices := SelectionInList new.
	updateAfterInstall := false.
	specSlices selectionIndexHolder:
		((PluggableAdaptor on: (specSlicesSelectionIndexHolder := 0 asValue))
			getBlock:[:m| m value]
			putBlock:[:m :newValue| |interestingPut|
					updateAfterInstall
					ifFalse:[interestingPut := self painterIsOpen and:[m value > 0 and: [self currentSettingIsForPainting]].
					interestingPut ifTrue:[self perform: (self specSettings selection value at: 2)]. "accept"].
					m value: newValue.
					updateAfterInstall
					ifFalse:[interestingPut
						ifTrue:[Cursor execute showWhile:[self noteBookWidget client: self spec: (self specSettings selection value at: 4)."change page"].
								self updateCommentLine.
								painter makeActivePainter]]]
			updateBlock:[:m :aspect :parameter| false]).
	"These aspects are needed for the menu page style variant of the receiver:"
	self class isItNotebook ifFalse:[
		sliceMenu := (PluggableAdaptor on: specSlices listHolder)
					getBlock:[:m| Menu labelArray: (m value collect:[:lookAndFeel| self looks displayStringFor: lookAndFeel]) asArray]
					putBlock:[:m :v| self error: 'This menu may not changed.']
					updateBlock:[:m :aspect :parameter| true].
		slice := specSlices selectionIndexHolder]!

initializePaintingAspects

	iconKind := (PluggableAdaptor on: (ValueHolder with: nil)) "iconKind is initialized in 'paintingSettings'"
		getBlock:[:m| m value]
		putBlock:[:m :newValue|
					m value isNil ifFalse:[self iconEditor doAccept].
					m value: newValue.
					self iconEditor icon: (self perform: newValue) inColor: newValue == #paletteIcon.]
		updateBlock:[:m :aspect :parameter|  false].
	
	paletteIcon := (PluggableAdaptor on: ((AspectAdaptor forAspect: #paletteIcon) subject: self targetComponent))
		getBlock:[:m| m value]
		putBlock:[:m :newValue| self paletteIconRadioButton widget label: newValue. m value: newValue]
		updateBlock:[:m :aspect :parameter| false].
	paletteMonoIcon := (PluggableAdaptor on: ((AspectAdaptor forAspect: #paletteMonoIcon) subject: self targetComponent))
		getBlock:[:m| m value]
		putBlock:[:m :newValue| self paletteMonoIconRadioButton widget label: newValue. m value: newValue]
		updateBlock:[:m :aspect :parameter| false].

	iconEditor := UIBIconEditor new!

initializeSlicesAspects

	sliceEditor := UIBOrderableList new.
	sliceEditor orderableList listHolder: ((AspectAdaptor forAspect: #slices) subject: self targetComponent; subjectSendsUpdates: false)!

majorTabsList
	"Answer a List of Associations between icons and Arrays.
	The latter contain Symbols or nil to configure the receiver's behaviour.
	The first Symbol is the message selector to be sent when the icon is clicked (for page set up).
	The second Symbol is the message selector to be sent when another page is selected (for acceptance).
	The third Symbol is the message selector to be sent to the target component to set up the minor tabs list.
	The fourth Symbol is the spec selector for the page to be displayed when a minor tab is clicked."

	^(List new:10)
		add: (Association key: (self visualFor: #generalIcon) value: #(#generalSettings #acceptGeneral nil nil));
		add: (Association key:  (self visualFor: #componentIcon) value: #(#componentSettings #acceptComponent #lookAndFeels #componentSettingsSpec));
		add: (Association key: (self visualFor: #slicesIcon) value: #(#sliceSettings #acceptSlices nil nil));
		add: (Association key: (self visualFor: #propertiesIcon) value: #(#propertiesSettings #acceptProperties #slices #propertiesSpec));
		add: (Association key: (self visualFor: #paintingIcon) value: #(#paintingSettings #acceptPainting nil nil));
		add: (Association key: (self visualFor: #installIcon) value: #(#installSettings #acceptInstall nil nil));
		add: (Association key: (self visualFor: #paletteEditorIcon) value: #(#paletteSettings #acceptPalette nil nil));
		yourself! !

!UIBComponentEditor methodsFor: 'aspects'!

componentName

	^((AspectAdaptor forAspect: #componentName) subject: self targetComponent)
		onChangeSend: #changedComponentName to: self!

iconKind
	
	^iconKind!

lookAndFeelCommentForStandardUIC

	^'This is a standard widget.
Its look and feel is determined by the implementation of a widget-dependent method in the LookPolicy classes.

Since this is a standard widget, some of its characteristics cannot be changed.' asValue!

painter

	^painter!

placementHeight

	^(AspectAdaptor forAspect: #y accessPath: #(#placementExtent)) subject: self targetComponent!

placementWidth

	^(AspectAdaptor forAspect: #x accessPath: #(#placementExtent)) subject: self targetComponent!

slice
	"Answer the aspect of the slice menu."

	^slice!

specHolderClass

	^(PluggableAdaptor on: sliceEditor orderableList selectionIndexHolder)
		getBlock:[:indexHolder|
				indexHolder value = 0
					ifTrue:[nil]
					ifFalse:[sliceEditor orderableList selection specHolderClass]]
		putBlock:[:indexHolder :newSelector|
				sliceEditor orderableList selection specHolderClass: newSelector copy.
				sliceEditor orderableList list changed: #at: with: indexHolder value.
				self loadButtonModifiedState]
		updateBlock:[:indexHolder :aspect :parameter| true]!

specSelector

	^(PluggableAdaptor on: sliceEditor orderableList selectionIndexHolder)
		getBlock:[:indexHolder|
				indexHolder value = 0
					ifTrue:[nil]
					ifFalse:[sliceEditor orderableList selection specSelector]]
		putBlock:[:indexHolder :newSelector|
				sliceEditor orderableList selection specSelector: newSelector copy.
				sliceEditor orderableList list changed: #at: with: indexHolder value.
				self loadButtonModifiedState]
		updateBlock:[:indexHolder :aspect :parameter| true]!

specSettings

	^specSettings!

specSliceLabel

	^(PluggableAdaptor on: sliceEditor orderableList selectionIndexHolder)
		getBlock:[:indexHolder|
				indexHolder value = 0
					ifTrue:['']
					ifFalse:[sliceEditor orderableList selection sliceLabel]]
		putBlock:[:indexHolder :newLabel|
				"Koen: Zouden de volgende lijnen niet in UIBSpecGenerator moeten staan ?"
				sliceEditor orderableList selection sliceLabel: newLabel copy.
				sliceEditor orderableList list changed: #at: with: indexHolder value]
		updateBlock:[:indexHolder :aspect :parameter| true]!

specSlices
	"Answer the aspect of the vertical tabbar."

	^specSlices!

subSpecID

	^(PluggableAdaptor on: sliceEditor orderableList selectionIndexHolder)
		getBlock:[:indexHolder|
				indexHolder value = 0
					ifTrue:[nil]
					ifFalse:[sliceEditor orderableList selection subSpecID]]
		putBlock:[:indexHolder :newSelector|
				sliceEditor orderableList selection subSpecID: newSelector copy.
				sliceEditor orderableList list changed: #at: with: indexHolder value.
				self loadButtonModifiedState]
		updateBlock:[:indexHolder :aspect :parameter| true]!

targetClassName
self halt: 'wordt dit nog gebruikt?'.
	^(AspectAdaptor forAspect: #targetClassName) subject: self targetComponent! !

!UIBComponentEditor methodsFor: 'interface opening'!

buildInSubCanvas: spec withBuilder: aBuilder 
	"This message is sent by the builder when it begins work on a SubCanvas."

	super buildInSubCanvas: spec withBuilder: aBuilder.
	subBuilder := aBuilder!

postBuildWith: aBuilder

	"This method is also invoked with every page change. -> MERDE !!"

	"Koen: dit is niet meer nodig wanneer de slices niet continu te zien zijn:"
	"self ableSlices: ((self specSettings selection notNil
					and:[self currentSettingIsForPainting])
					and:[self specSlices list isEmpty not])."
	self class isItNotebook
		ifFalse:[self sliceMenu compute:[self able: self sliceMenu value menuItems isEmpty not component: #sliceMenu]].
	subBuilder isNil ifTrue:[
		self noteBookWidget bottomTabBar
			lineGrid: 26;
			setTabWidth: 30;
			visualBlock:[:tabBar :index| BoundedWrapper on: (tabBar model value at: index) key]]!

postOpenWith: aBuilder

	self specSettings selectionIndex: 1.
	self changedComponentName.
	self able: self targetComponent targetTrouble not component: #installButton! !

!UIBComponentEditor methodsFor: 'actions'!

customSize
	"Make the receiver's notebook as high and wide as the last size given by the user."

	self builder window displayBox: (self builder window displayBox origin extent: customSize).
	self disableComponent: #customSizeButton!

install

	| generator|
	self quietAccept.
	generator := self targetComponent class preferredComponentGeneratorClass forComponent: self targetComponent.
	generator isValidForInstall ifFalse:[^self].
	generator generate.
	UIBFinder installed: (Array with: self targetComponent targetClassName with: #notUsed).
	self enableComponent: #installButton!

load

	self sliceEditor orderableList selection loadFromSystem.
	self loadButton disable!

loadAll

	self sliceEditor orderableList list do:[:slice| slice loadFromSystem].
	self loadAllButton disable!

newSlice
	"Add a new slice to the property sheets after the selected slice
	or in front of all slices when no selection is made."

	| addIndex newSheet sheetList |
	sheetList := self sliceEditor orderableList list.
	newSheet := self targetComponent defaultEditSlice.
	(addIndex := self sliceEditor orderableList selectionIndex) = 0
		ifTrue:[sheetList addFirst:newSheet]
		ifFalse:[sheetList add: newSheet beforeIndex: addIndex + 1].
	sheetList changed: #insert: with: addIndex + 1.
	self sliceEditor orderableList selectionIndex: addIndex + 1!

normalSize
	"Make the receiver's notebook as high and wide as the one in the PropertiesTool."

	| box |
	(box := self builder window displayBox) extent = (408@394) ifTrue:[^self].
	customSize := box extent.
	self builder window displayBox: (box origin extent: 408@394).
	self enableComponent: #customSizeButton!

removeSlice
	"Remove the slice selection from the property sheets."

	| removeIndex |
	removeIndex := self sliceEditor orderableList selectionIndex.
	self sliceEditor orderableList list removeAtIndex: removeIndex.
	self sliceEditor orderableList list changed: #remove: with: removeIndex.
	removeIndex < self specSlices selectionIndex
		ifTrue:[self specSlices selectionIndex: (1 max: self specSlices selectionIndex - 1)]! !

!UIBComponentEditor methodsFor: 'updating'!

update: anAspectSymbol with: aParameter from: aSender

	| oldIndex |
	(self painter notNil and:[aSender == self painter canvas and:[anAspectSymbol == #specSelector]])
		ifTrue:[	"Turn off any unwanted updates (the selection index holder is also used 
				to register notebook page changes and this update is not a result of a
				page change):"
				updateAfterInstall := true.
				"A SelectionInList sets the selection index to zero when the list changes,
				so keep it for later use:"
				oldIndex := self specSlices selectionIndex.
				"Delegate the canvas change to the list that contains it:"
				self specSlices listHolder changed: #value.
				"Restore the old selection index."
				"This also solves this problem: When the menu changes, the menu 
				button view does not update its label (current selection)."
				self specSlices selectionIndex: oldIndex.
				updateAfterInstall := false]
		ifFalse:[super update: anAspectSymbol with: aParameter from: aSender]! !

!UIBComponentEditor methodsFor: 'binding'!

clientFor: aKey

	aKey == #propertiesPainter
		ifTrue:[^(painter := UIBPropertiesPainter new)
					forComponent: self targetComponent;
					forCanvas: self specSlices selection].
	aKey == #componentPainter
		ifTrue:[painter isNil ifFalse:[painter canvas removeDependent: self].
				painter := UIBPluggablePainter forCanvas: self specSlices selection.
				painter canvas addDependent: self.
				^painter]
		ifFalse:[^super clientFor: aKey].! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBComponentEditor class
	instanceVariableNames: ''!


!UIBComponentEditor class methodsFor: 'accessing preferences'!

isItNotebook
	^(UISettings preferenceFor: #notebookStyle)
		== #notebook!

windowSpec
	^self isItNotebook
		ifTrue: [self windowNotebookSpec]
		ifFalse: [self windowMenuSpec]! !

!UIBComponentEditor class methodsFor: 'interface specs'!

componentSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #componentSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Component Settings' 
			#bounds: #(#Rectangle 65 107 330 431 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )!

generalSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #generalSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'General Settings' 
			#bounds: #(#Rectangle 101 246 366 570 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 5 25 ) 
					#label: 'Component Name:' 
					#style: #default ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 50 0 -5 1 75 0 ) 
					#name: #componentName 
					#model: #componentName 
					#style: #default ) 
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 10 0 100 0 -10 1 -10 1 ) 
					#name: #looks 
					#flags: 0 
					#majorKey: #UIBComponentLookAndFeelEditor 
					#minorKey: #windowSpec 
					#clientKey: #looks ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 5 0 78 0 -5 1 -5 1 ) 
					#label: 'Look and Feels' 
					#style: #default ) ) ) )!

installSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #installSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Install Settings' 
			#bounds: #(#Rectangle 76 88 341 412 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#flags: 0 
					#majorKey: #UIBClassInstaller 
					#minorKey: #classCreationSpec 
					#clientKey: #installer ) ) ) )!

noPropertiesSpec
	"UIBPainter new openOnClass: self andSelector: #noPropertiesSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'No Properties' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )!

paintingSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #paintingSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Painting Settings' 
			#bounds: #(#Rectangle 326 209 591 533 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#GroupBoxSpec 
					#layout: #(#Rectangle 5 0 262 45 ) 
					#label: 'Placement' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 88 66 ) 
					#name: #paletteMonoIcon 
					#model: #iconKind 
					#tabable: false 
					#label: #defaultPaletteMonoIcon 
					#hasCharacterOrientedLabel: false 
					#style: #default 
					#select: #paletteMonoIcon ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 21 66 ) 
					#name: #paletteIcon 
					#model: #iconKind 
					#tabable: false 
					#label: #defaultPaletteIcon 
					#hasCharacterOrientedLabel: false 
					#style: #default 
					#select: #paletteIcon ) 
				#(#SubCanvasSpec 
					#layout: #(#Rectangle 7 90 265 322 ) 
					#name: #iconEditor 
					#flags: 0 
					#majorKey: #UIBIconEditor 
					#minorKey: #windowSpec 
					#clientKey: #iconEditor ) 
				#(#GroupBoxSpec 
					#layout: #(#Rectangle 3 44 262 324 ) 
					#label: 'Palette Icon' 
					#style: #default ) 
				#(#LabelSpec 
					#layout: #(#Point 50 15 ) 
					#label: 'Width:' 
					#style: #default ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 101 15 141 40 ) 
					#name: #placementWidth 
					#model: #placementWidth 
					#style: #default 
					#type: #number ) 
				#(#LabelSpec 
					#layout: #(#Point 148 15 ) 
					#label: 'Height:' 
					#style: #default ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 203 15 243 40 ) 
					#name: #placementHeight 
					#model: #placementHeight 
					#style: #default 
					#type: #number ) ) ) )!

paletteSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #paletteSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Palette Settings' 
			#bounds: #(#Rectangle 372 240 637 564 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#flags: 0 
					#majorKey: #UIBPaletteEditor 
					#minorKey: #windowSpec 
					#clientKey: #paletteEditor ) ) ) )!

propertiesSpec
	"UIBPainter new openOnClass: self andSelector: #propertiesSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Properties Settings' 
			#bounds: #(#Rectangle 238 226 503 550 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #propertiesPainter 
					#flags: 0 
					#majorKey: #UIBPropertiesPainter 
					#minorKey: #windowSpec 
					#clientKey: #propertiesPainter ) ) ) )!

sliceSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #sliceSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Slice Settings' 
			#bounds: #(#Rectangle 327 267 592 591 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 12 0 25 0 -80 1 -200 1 ) 
					#name: #sliceEditor 
					#flags: 0 
					#majorKey: #UIBOrderableList 
					#minorKey: #noButtonSpec 
					#clientKey: #sliceEditor ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 5 0 3 0 -5 1 -5 1 ) 
					#label: 'Property Slices' 
					#style: #default ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -72 1 25 0 -12 1 50 0 ) 
					#name: #newSliceButton 
					#model: #newSlice 
					#label: 'Add' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -72 1 55 0 -12 1 80 0 ) 
					#name: #removeSliceButton 
					#model: #removeSlice 
					#label: 'Remove' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -72 1 -225 1 -12 1 -200 1 ) 
					#name: #loadButton 
					#flags: 40 
					#model: #load 
					#label: 'Load' 
					#style: #default 
					#defaultable: true ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#InputFieldSpec 
							#layout: #(#LayoutFrame 6 0 23 0 0 0.975104 48 0 ) 
							#name: #specSliceLabel 
							#model: #specSliceLabel 
							#style: #default ) 
						#(#LabelSpec 
							#layout: #(#Point 6 0 ) 
							#label: 'Label:' 
							#style: #default ) 
						#(#LabelSpec 
							#layout: #(#Point 6 45 ) 
							#label: 'Spec Selector:' 
							#style: #default ) 
						#(#LabelSpec 
							#layout: #(#Point 6 89 ) 
							#label: 'Holder Class:' 
							#style: #default ) 
						#(#LabelSpec 
							#layout: #(#Point 6 132 ) 
							#flags: 32 
							#label: 'Subspec ID:' 
							#style: #default ) 
						#(#InputFieldSpec 
							#layout: #(#LayoutFrame 6 0 68 0 0 0.975104 93 0 ) 
							#name: #specSelector 
							#model: #specSelector 
							#style: #default 
							#type: #symbol ) 
						#(#InputFieldSpec 
							#layout: #(#LayoutFrame 6 0 111 0 0 0.975104 136 0 ) 
							#name: #specHolderClass 
							#model: #specHolderClass 
							#style: #default 
							#type: #symbol ) 
						#(#InputFieldSpec 
							#layout: #(#LayoutFrame 6 0 153 0 0 0.975104 178 0 ) 
							#name: #subSpecID 
							#flags: 40 
							#model: #subSpecID 
							#style: #default 
							#type: #symbol ) 
						#(#GroupBoxSpec 
							#layout: #(#LayoutFrame 0 0.0 0 0.00549451 0 1.0 0 1.0 ) ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame 12 0 -195 1 -12 1 -12 1 ) ) ) ) ) )!

windowMenuSpec
	"UIBPainter new openOnClass: self andSelector: #windowMenuSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Component Editor' 
			#bounds: #(#Rectangle 96 173 405 593 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#NoteBookSpec 
					#layout: #(#LayoutFrame 4 0 35 0 -4 1 -20 1 ) 
					#name: #pageHolder 
					#model: #specSettings 
					#majorTabsOnRight: false 
					#rightInset: 0 ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -74 1 4 0 -19 1 29 0 ) 
					#name: #installButton 
					#model: #install 
					#label: 'Install' 
					#style: #default 
					#defaultable: true ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 1 0 -19 1 -1 1 -18 1 ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutFrame 5 0 -17 1 -5 1 0 1 ) 
					#name: #commentLine 
					#style: #default ) 
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 4 0 4 0 -80 1 29 0 ) 
					#name: #sliceMenu 
					#model: #slice 
					#menu: #sliceMenu ) ) ) )!

windowNotebookSpec
	"UIBPainter new openOnClass: self andSelector: #windowNotebookSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Component Editor' 
			#bounds: #(#Rectangle 63 185 472 579 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#NoteBookSpec 
					#layout: #(#LayoutFrame 4 0 4 0 -5 1 -20 1 ) 
					#name: #pageHolder 
					#model: #specSettings 
					#secondModel: #specSlices 
					#majorTabsOnRight: false 
					#rightInset: 95 ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -75 1 -70 1 -25 1 -45 1 ) 
					#name: #installButton 
					#model: #install 
					#label: 'Install' 
					#style: #default 
					#defaultable: true ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 1 0 -19 1 -1 1 -18 1 ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutFrame 5 0 -17 1 -5 1 0 1 ) 
					#name: #commentLine 
					#style: #default ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -92 1 -115 1 -7 1 -90 1 ) 
					#name: #customSizeButton 
					#flags: 40 
					#model: #customSize 
					#label: 'Custom Size' 
					#style: #default 
					#defaultable: true ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame -95 1 -80 1 -5 1 -78 1 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -92 1 -150 1 -7 1 -125 1 ) 
					#name: #normalSizeButton 
					#model: #normalSize 
					#label: 'Normal Size' 
					#style: #default 
					#defaultable: true ) ) ) )! !

!UIBComponentEditor class methodsFor: 'generated resources'!

addIcon

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwPlusIcon24]
		ifFalse: [^UIBImage cgPlusIcon24]!

defaultPaletteIcon

	^UIBComponent defaultPaletteIcon!

defaultPaletteMonoIcon

	^UIBComponent defaultPaletteMonoIcon!

dummyPaletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #dummyPaletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@K0@@@@@OP@@/J****(=@@B<*"J**#4@@K2 @J**OP@@/J"J*((=@@B< @J*@#4@@K2"J***OP@@/J****(=@@B<@@@@@C4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a'))!

removeIcon

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwMinusIcon24]
		ifFalse: [^UIBImage cgMinusIcon24]! !

!UIBComponentEditor class methodsFor: 'instance creation'!

forClass: aSpecClass

	^self basicNew initializeFor: aSpecClass!

new

	^self forClass: nil! !

!UIBComponentEditor class methodsFor: 'interface opening'!

openOnClass: aSpecClass

	(aSpecClass isNil or: [UIBFinder isEditableSpecClass: aSpecClass])
		ifFalse:[^self error: aSpecClass name , ' is not an editable specification class.'].
	^self openOn: (self forClass: aSpecClass)! !

!UIBComponentEditor class methodsFor: 'class accessing'!

labelAndVisualRepository
	"Answer the object that holds the receiver's labels ans visuals."

	^UIBImage new! !

UIBApplicationModel subclass: #UIBApplFLabInstaller
	instanceVariableNames: 'installerOptions introductionText fileout uninstallText installText '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Installer'!


!UIBApplFLabInstaller methodsFor: 'aspects'!

installerOptions

	^installerOptions!

installText

	^installText!

introductionText

	^introductionText!

uninstallText

	^uninstallText! !

!UIBApplFLabInstaller methodsFor: 'change messages'!

tabSelectionChanged

	(self widget: #notebook) client: self spec: (self installerOptions selection at: 3)! !

!UIBApplFLabInstaller methodsFor: 'private-uninstall'!

closeAllApplFLabToolWindows
	"Answer a Boolean indicating whether closing the windows succeeded."

	"| applflabTools | ApplicationStandardSystemController allInstances
	applflabTools := #(#UIBPropertiesTool #UIBCanvasTool #UIBFinder) asSet.
	ApplicationWindow allInstances
		do: [:window|
			(window application notNil and: [(window application class in: applflabTools) or: [window application isKindOf: UIBApplicationModel]])
				ifTrue: [window application closeRequest]]"

	^(Dialog
		choose: 'Be sure to close all ApplFLab tools \and all open windows that have ApplFLab application models' withCRs
		labels: (Array with: 'Continue' with: 'I''ll close the windows first')
		values: #(true false)
		default: false)!

originalSystemMethodsInFileOutFormat
	"Answer a String containing the system methods changed by ApplFLab in file-out format."

	"Make sure to double all single quotes before accepting this method."

	^'
!!Object methodsFor: ''user interface''!!

basicInspect
	"Create and schedule an Inspector in which the user can examine the
	receiver''s variables.  This method should not be overwritten."

	Inspector openOn: self!! !!
	

!!Parser methodsFor: ''initialize-release''!!

initScanner
	super initScanner.
	typeTable := TypeTable.
	"Default language choice:"
	oldLanguage := true.
	newLanguage := true.
	extendedLanguage := false!! !!
	

!!Browser methodsFor: ''private-protocol functions''!!

addProtocol
	| aString newProtocol |
	self changeRequest ifFalse: [^self].
	aString := self
			prompt: ''Enter new category name''
			initially: (LastProtocol == nil ifTrue: [''protocol name''] ifFalse: [LastProtocol]).
	aString isEmpty ifTrue: [^ self].
	newProtocol := aString asSymbol.
	self classForSelectedProtocol organization addCategory: newProtocol before: protocol.
	self logProtocolChange: (''<1p> organization addCategory: <2p> before: <3p>''
					expandMacrosWith: self classForSelectedProtocol
					with: newProtocol
					with: protocol).
	self classForSelectedProtocol reorganize.
	self newProtocolList: newProtocol!! !!
'!

removeCategory: category

	| classes |
	classes := Smalltalk organization superclassOrder: category.
	classes isEmpty ifFalse: [classes reverseDo: [:cls | cls removeFromSystem]].
	Smalltalk organization removeCategory: category.
	ChangeSet current reorganizeSystem.!

undoApplFLabSystemAdditions

	self applFLabSystemAdditions
		do: [:assoc| 
			((Smalltalk at: assoc value) includesSelector: assoc key)
				ifTrue: [(Smalltalk at: assoc value) removeSelector: assoc key]]!

undoApplFLabSystemChanges

	| originalString |
	originalString := self originalSystemMethodsInFileOutFormat.
	originalString isEmpty ifFalse: [originalString readStream fileIn]!

uninstallApplFlab

	Transcript cr; cr; show: 'Uninstalling ApplFLab ...'.
	self closeRequest. "This only queues a close request. It does not actually close the window."
	[Transcript crtab; show: 'undoing system changes...'.
	self undoApplFLabSystemChanges.
	self undoApplFLabSystemAdditions.
	Transcript crtab; show: 'removing ApplFlab categories...'.
	self uninstallApplFLabCategories.
	Transcript cr; show: 'done.'; cr] fork "Fork this block to make sure that the window is closed before deleting the classes."!

uninstallApplFLabCategories

	self applFLabCategoriesInSystem do: [:category| self removeCategory: category]!

uninstallIntroduction

^
('ApplFLab Uninstallation

' asText emphasizeAllWith: #(#bold #large))
, 'ApplFLab classes are organized in the ApplFlab categories. By convention, all ApplFLab category names start with "UIB-".

Uninstalling ApplFLab means that all ApplFLab categories (and thus all ApplFLab classes) are  removed from the image, and that all changes to the system classes are undone.

' asText
, 'Important: ' asText allBold
, 'if you have created subclasses of ApplFlab classes (typically of UIBApplicationModel, UIBPalette, and UIBCompositeComponentSpec), you should file them out before pressing the uninstall button!! You can use the file out tool on the next page of this notebook for that purpose.

' asText
, 'Note: ' asText allBold
, 'This window will be closed automatically when you press the uninstall button.'! !

!UIBApplFLabInstaller methodsFor: 'private-install'!

installApplFLabFromFile: aFilename

	Transcript cr; cr; show: 'Installing ApplFLab ...'.
	aFilename fileIn.
	Transcript cr; show: 'done.'; cr.!

installIntroduction

^
('ApplFLab Installation

' asText emphasizeAllWith: #(#bold #large))
, 'By the time you read this, all required ApplFLab classes and system changes are already in the image. If you want to undo the changes, use the notebook''s next page to bring the image in its original state.

You can perform additional installations by pressing the install button below.

After pressing the install button, you will be asked to select an installation file (i.e. any Smalltalk file). Extra installation files for ApplFLab are located in the "Additional_Installations" directory.

The ApplFLab tools look best when the UI look is set to "default" in the Settings Tool.

' asText
, 'Note: ' asText allBold
, 'ApplFLab requires that the drag&drop extension of VisualWorks (file "tooldd.st") is in the image. Using ApplFLab (in casu the Properties Tool) without drag&drop extensions would result in an exception.

' asText
, 'Note: ' asText allBold
, 'It is a good idea to close the standard VisualWorks launcher and user interface tools, since they do not mix well with the ApplFLab tools.' asText! !

!UIBApplFLabInstaller methodsFor: 'private'!

applFLabCategoriesInSystem

	^Smalltalk organization categories asSortedCollection 
		select:[:symbol| 'UIB-*' match: symbol]!

introduction

	^'This version of ApplFLab is intended for VisualWorks version 2.5, including 2.5.1 and 2.5.2. ' asText
, '
Do not continue if you are not running the correct version!!

' asText allBold

, 'ApplFLab, or Application Framework Laboratory, is an extension of VisualWorks. It enables you to put new components on a palette and associate properties with them.

This version features: 
	* an enhanced Painter
		- pick a palette when opening a new canvas from the Launcher
		- extended widget handles for resizing in one direction
		- "Define All..." command to define all aspects
	* an enhanced Properties Tool
		- Models and Aspects slices to configure the aspects
		- "Full Size" button in Position Tool
		- "Window" button to display properties of the canvas
	* an extended Resource Finder
		- view specification classes
		- opening Component Editors on specification classes
	* a Component Editor
		- creation of new user interface components
	* multiple Palettes
	* a Palette Editor
		- configuration of the multiple palettes
	* an extended ApplicationModel class called UIBApplicationModel
		- other builder: UIBBuilder
		- convenience methods for component manipulation
		- binding of non-unary action methods
		- release of dependents when window closes

This version also includes some experimental features, typically found in the operate menu of a Painter via the "ApplFLab" menu item. These features are to be used with caution, because they are not yet well-integrated with the other tools (so you better not use them at all!!).
'asText

,'
Information about ApplFLab is also available on the web. Check out http://progwww.vub.ac.be/prog/pools/applflab/applflab.html.

ApplFLab is continuously under development. If you have comments on this version or if you have useful suggestions for future versions, please do not hesitate send them to Koen De Hondt.
Email:		kdehondt@vnet3.vub.ac.be.
Address:	Programming Technology Lab
			Computer Science Department (PROG/DINF/WE)
			Vrije Universiteit Brussel
			Pleinlaan 2
			1050 Brussel
			Belgium

Enjoy ApplFLab !!

(c) Copyright 1996 Programming Technology Lab, Vrije Universiteit Brussel' asText! !

!UIBApplFLabInstaller methodsFor: 'initialize-release'!

initialize

	super initialize.
	fileout := UIBFileOut new.
	introductionText := self introduction asValue.
	installText :=  self installIntroduction asValue.
	uninstallText := self uninstallIntroduction asValue.
	installerOptions := SelectionInList with:
		(List
			with: #('Introduction' #infoIcon #introductionSpec)
			with: #('Install' #acceptIcon #installSpec)
			with: #('Uninstall' #cancelIcon #uninstallSpec)
			with: #('File Out' #fileOutIcon #fileoutSpec)).
	installerOptions selectionIndex: 1.
	installerOptions selectionHolder onChangeSend: #tabSelectionChanged to: self! !

!UIBApplFLabInstaller methodsFor: 'accessing'!

fileout

	^fileout! !

!UIBApplFLabInstaller methodsFor: 'actions'!

createApplFLabInstallerFiles

	| dir |
	(dir := FileDialog getDirectory: 'Select a directory for the ApplFLab installer files:') isNil
		ifFalse: [self generateApplFLabInstallerFiles: dir]!

install

	| filename |
	(filename := FileDialog
					getFileFiltered: [:file| '*.st' match: file first tail]
					prompt: 'Select an installation file:') isNil
		ifFalse: [self installApplFLabFromFile: filename]!

uninstall

	((Dialog confirm: 'Are you certain that you want to \remove all ApplFLab categories from the image?' withCRs)
		and: [self closeAllApplFLabToolWindows])
		ifTrue: [self uninstallApplFlab]! !

!UIBApplFLabInstaller methodsFor: 'interface opening'!

buildInSubCanvas: spec withBuilder: aBuilder 
	"Overridden here in order not to invoke the postBuildWith: method for subcanvasses in my user interface."

	aBuilder source: self.
	aBuilder add: spec.
	^aBuilder!

postBuildWith: aBuilder

	(aBuilder componentAt: #notebook) widget bottomTabBar
		visualBlock:[:tabBar :index| |tabItem|
			tabItem := tabBar model value at: index.
			BoundedWrapper on: ((UIBLabelAndIcon with: (tabItem at: 1))
									icon: (self labelAndVisualRepository visualAt: (tabItem at: 2));
									offset: 5@4)].
	self tabSelectionChanged! !

!UIBApplFLabInstaller methodsFor: 'private-installer files'!

applFLabBasicInstallationCategories
	"Answer all required ApplFLab categories."

	"(Smalltalk organization categories select: [:cat| 'UIB-*' match: cat]) asSortedCollection asArray"

	^   #(#'UIB-Aspect Editors' #'UIB-Basics' #'UIB-Builder/Definer' #'UIB-Components' #'UIB-Components-Editor' #'UIB-Components-Generation' #'UIB-Components-Preconfigured' #'UIB-Components-Resources' #'UIB-Components-Resources-UI' #'UIB-Composites' #'UIB-Demo-File selection (New)' #'UIB-Installer' #'UIB-Misc' #'UIB-Painter' #'UIB-Painter-Support' #'UIB-Painter-Tools' #'UIB-Palette' #'UIB-Properties' #'UIB-Property Fields' #'UIB-Support' #'UIB-Development Extras')!

applFLabBrowserInstallationCategories
	"Answer all ApplFLab browser categories."

	^#(#'UIB-Browser' #'UIB-Browser-Class Editor' #'UIB-Browser-Class Selector' #'UIB-Browser-Items' #'UIB-Browser-Method Editor')!

applFLabDevelopmentInstallationCategories
	"Answer all additional ApplFLab categories."

	"(Smalltalk organization categories select: [:cat| 'UIB-*' match: cat]) asSortedCollection asArray"

	^ ((Smalltalk organization categories select: [:cat| 'UIB-*' match: cat]) asOrderedCollection
		removeAll: self applFLabBasicInstallationCategories;
		addAll: self applFLabTutorialInstallationCategories;
		addAll: self applFLabBrowserInstallationCategories;
		yourself) asSortedCollection asArray!

applFLabSystemAdditions
	"Answer a collection of associations between selectors and their class.
	These associations describe the methods added to system classes by ApplFLab.
	These methods can simply be removed when ApplFLab is uninstalled."

	^(OrderedCollection new: 15)
		add: #applflabCompositeComponent:into: -> #UILookPolicy;
		add: #oopNoteBook:into: -> #UILookPolicy;
		add: #dragHandlesFor:subject:view:isPrimary: -> #ComponentSpec;
		add: #handlesFor:subject:view:isPrimary:in: -> #ComponentSpec;
		add: #attachControlModesForWrapper:toHandles: -> #ComponentSpec;
		add: #painterDragHandles:inView: -> #SpecWrapper;
		add: #dragHandlesFor:subject:view:isPrimary: -> #DividerSpec;
		add: #handlesFor:subject:view:isPrimary:in: -> #DividerSpec;
		add: #attachControlModesForWrapper:toHandles: -> #DividerSpec;
		add: #dragHandlesFor:subject:view:isPrimary: -> #SliderSpec;
		add: #handlesFor:subject:view:isPrimary:in: -> #SliderSpec;
		add: #attachControlModesForWrapper:toHandles: -> #SliderSpec;
		yourself!

applFLabSystemChanges
	"Answer a collection of associations between selectors and their class.
	These association describe the system methods changed by ApplFLab."

	^(OrderedCollection new: 10)
		add: #initScanner -> #Parser;
		add: #basicInspect -> #Object;
		add: #addProtocol -> #Browser;
		yourself!

applFLabTutorialInstallationCategories
	"Answer all ApplFLab tutorial categories."

	^#(#'UIB-Tutorial-ESUG96')!

generateApplFLabInstallerFiles: targetDirectory
	"Generate all ApplFLab distribution files in the directory passed as an argument."

	| installerDirectory |
	installerDirectory := targetDirectory.
	self fileout
		fileOutCategories: self applFLabBasicInstallationCategories
		with: [:fileManager|
				self applFLabSystemAdditions , self applFLabSystemChanges
					do: [:assoc| fileManager fileOutMessages: (Array with: assoc key) for: (Smalltalk at: assoc value)].
				fileManager store: '\\UIFinderVW2 computeSpecBearingClasses' withCRs.
				fileManager store: '\\UIBVisualLauncher open' withCRs.
				fileManager store: '\\UIBApplFLabInstaller open' withCRs]
		in: (installerDirectory construct: 'ApplFLabInstaller.st').
	installerDirectory := installerDirectory construct: 'Additional_Installations'.
	installerDirectory exists ifFalse: [installerDirectory makeDirectory].
	self fileout
		fileOutCategories: self applFLabDevelopmentInstallationCategories
		with: [:fileManager| fileManager store: '\\UIFinderVW2 computeSpecBearingClasses' withCRs]
		in: (installerDirectory construct: 'Development.st').
	self fileout
		fileOutCategories: self applFLabTutorialInstallationCategories
		with: [:fileManager| fileManager store: '\\UIFinderVW2 computeSpecBearingClasses' withCRs]
		in: (installerDirectory construct: 'ESUG96Tutorial.st').
	self fileout
		fileOutCategories: #(#'UIB-Demo-Browser')
		with: [:fileManager| fileManager store: '\\UIFinderVW2 computeSpecBearingClasses' withCRs]
		in: (installerDirectory construct: 'Demo-Browser.st').
	self fileout
		fileOutCategories: #(#'UIB-Demo-Metro' #'UIB-Demo-Metro UICs')
		with: [:fileManager| fileManager store: '\\UIFinderVW2 computeSpecBearingClasses' withCRs]
		in: (installerDirectory construct: 'Demo-Metro.st').
	self fileout
		fileOutCategories: #(#'UIB-Demo-From the Net' )
		with: [:fileManager| 
				fileManager fileOutMessages: #progress:into: for: UILookPolicy.
				fileManager store: '\\UIFinderVW2 computeSpecBearingClasses' withCRs]
		in: (installerDirectory construct: 'Demo-FromTheNet.st').
	self fileout
		fileOutCategories: self applFLabBrowserInstallationCategories
		with: [:fileManager| fileManager store: '\\UIFinderVW2 computeSpecBearingClasses' withCRs]
		in: (installerDirectory construct: 'Browser.st').! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBApplFLabInstaller class
	instanceVariableNames: ''!


!UIBApplFLabInstaller class methodsFor: 'interface specs'!

fileoutSpec
	"UIBPainter new openOnClass: self andSelector: #fileoutSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'ApplFLab Installer File Out' 
			#bounds: #(#Rectangle 68 160 566 520 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 5 0 5 0 -5 1 -5 1 ) 
					#name: #fileout 
					#flags: 0 
					#majorKey: #UIBFileOut 
					#minorKey: #windowSpec 
					#clientKey: #fileout ) ) ) )!

installSpec
	"UIBPainter new openOnClass: self andSelector: #installSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'ApplFLab Installer Install' 
			#bounds: #(#Rectangle 9 186 532 546 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 5 0 10 0 -5 1 -70 1 ) 
					#name: #installTest 
					#model: #installText 
					#isReadOnly: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -90 0.5 -50 1 90 0.5 -20 1 ) 
					#name: #installButton 
					#model: #install 
					#label: 'Additional Installations...' 
					#defaultable: true ) ) ) )!

introductionSpec
	"UIBPainter new openOnClass: self andSelector: #introductionSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'ApplFLab Installer Introduction' 
			#bounds: #(#Rectangle 69 208 567 568 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 3 0 120 0 -3 1 -3 1 ) 
					#name: #introductionText 
					#model: #introductionText 
					#isReadOnly: true ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 20 0 0.5 0 ) 
					#label: #applFLabLogoIcon 
					#hasCharacterOrientedLabel: false ) ) ) )!

uninstallSpec
	"UIBPainter new openOnClass: self andSelector: #uninstallSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'ApplFLab Installer Uninstall' 
			#bounds: #(#Rectangle 52 148 550 508 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -75 0.5 -50 1 75 0.5 -20 1 ) 
					#name: #uninstallButton 
					#model: #uninstall 
					#label: 'Uninstall ApplFLab ' 
					#defaultable: true ) 
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 5 0 10 0 -5 1 -70 1 ) 
					#name: #uninstallTest 
					#model: #uninstallText 
					#isReadOnly: true ) ) ) )!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'ApplFLab Installer/Uninstaller' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 99 150 635 574 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#OOPNoteBookSpec 
					#layout: #(#LayoutFrame 5 0 5 0 -5 1 -5 1 ) 
					#name: #notebook 
					#model: #installerOptions 
					#binderWidth: 0 
					#majorTabsOnRight: false 
					#rightInset: 0 ) ) ) )! !

UIBComponentEditor subclass: #UIBCompositeComponentEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Editor'!


!UIBCompositeComponentEditor methodsFor: 'component class accessing'!

preferredComponentClass

	^UIBCompositeComponent! !

!UIBCompositeComponentEditor methodsFor: 'changes'!

componentSettings

	self specSlices list isEmpty
		ifTrue:[	self noteBookWidget client: nil]
		ifFalse:[	self specSlices selectionIndex = 0 ifTrue:[self specSlices selectionIndex: 1].
				self noteBookWidget client: self spec:  #componentSettingsSpec.
				self painter makeActivePainter.
				self updateCommentLine]! !

!UIBCompositeComponentEditor methodsFor: 'accept'!

acceptGeneral

	super acceptGeneral.
	self targetComponent makeLookAndFeelsConsistent! !

!UIBCompositeComponentEditor methodsFor: 'initialize-release'!

initializeGeneralAspects

	looks := UIBComponentLookAndFeelEditor new.
	looks
		listHolder: ((AspectAdaptor forAspect: #lookAndFeels) subject: self targetComponent; subjectSendsUpdates: false)
		defaultHolder: ((AspectAdaptor forAspect: #defaultLookAndFeel) subject: self targetComponent; subjectSendsUpdates: false)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBCompositeComponentEditor class
	instanceVariableNames: ''!


!UIBCompositeComponentEditor class methodsFor: 'interface specs'!

componentSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #componentSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Component Settings' 
			#bounds: #(#Rectangle 65 107 330 431 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #componentPainter 
					#flags: 0 
					#majorKey: #UIBPluggablePainter 
					#minorKey: #windowSpec 
					#clientKey: #componentPainter ) ) ) )!

generalSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #generalSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'General Settings' 
			#bounds: #(#Rectangle 284 223 549 547 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 10 0 100 0 -10 1 -10 1 ) 
					#name: #looks 
					#flags: 0 
					#majorKey: #UIBComponentLookAndFeelEditor 
					#minorKey: #windowSpec 
					#clientKey: #looks ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 5 0 78 0 -5 1 -5 1 ) 
					#label: 'Look and Feels' 
					#style: #default ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 5 0 0.5 0 ) 
					#name: #componentKindLabel 
					#label: 'Composite Component' 
					#style: #default ) 
				#(#LabelSpec 
					#layout: #(#Point 5 27 ) 
					#label: 'Component Name:' 
					#style: #default ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 52 0 -5 1 77 0 ) 
					#name: #componentName 
					#model: #componentName 
					#style: #default ) ) ) )! !

UIBApplicationModel subclass: #UIBOrderableList
	instanceVariableNames: 'orderableList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!


!UIBOrderableList methodsFor: 'actions'!

moveSelectionDown
	"Change the order of the list items by moving down the selection."

	| collection downIndex downItem |
	collection := self orderableList list.
	downIndex := self orderableList selectionIndex + 1.
	downItem := collection at: downIndex.
	collection at: downIndex put: (collection at: downIndex - 1).
	collection at: downIndex - 1 put: downItem.
	collection changed: #at: with: downIndex. "update selectively to avoid display flicker"
	collection changed: #at: with: downIndex - 1.
	self orderableList selectionIndex: downIndex!

moveSelectionUp
	"Change the order of the list items by moving up the selection."

	| collection upIndex upItem |
	collection := self orderableList list.
	upIndex := self orderableList selectionIndex - 1.
	upItem := collection at: upIndex.
	collection at: upIndex put: (collection at: upIndex + 1).
	collection at: upIndex + 1 put: upItem.
	collection changed: #at: with: upIndex. "update selectively to avoid display flicker"
	collection changed: #at: with: upIndex + 1.
	self orderableList selectionIndex: upIndex! !

!UIBOrderableList methodsFor: 'aspects'!

orderableList

	^orderableList! !

!UIBOrderableList methodsFor: 'changes'!

listSelectionChanged

	| selectionIndex |
	selectionIndex := self orderableList selectionIndex.
	self able: selectionIndex > 1 component: #moveUpButton.
	self able: (selectionIndex > 0 and:[selectionIndex < self orderableList list size]) component: #moveDownButton! !

!UIBOrderableList methodsFor: 'interface opening'!

postBuildWith: aBuilder 

	(self component: #orderableList) component component noMenuBar.
	orderableList selectionIndexHolder onChangeSend: #listSelectionChanged to: self.
	self listSelectionChanged! !

!UIBOrderableList methodsFor: 'initialize-release'!

initialize

	orderableList := SelectionInList  with: OrderedCollection new.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBOrderableList class
	instanceVariableNames: ''!


!UIBOrderableList class methodsFor: 'interface specs'!

buttonsLeftSpec
	"UIBPainter new openOnClass: self andSelector: #buttonsLeftSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Orderable List' 
			#bounds: #(#Rectangle 127 448 291 577 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -25 1 ) 
					#name: #orderableList 
					#model: #orderableList 
					#multipleSelections: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -20 1 50 0 0 1 ) 
					#name: #moveUpButton 
					#flags: 40 
					#model: #moveSelectionUp 
					#label: 'Up' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 55 0 -20 1 105 0 0 1 ) 
					#name: #moveDownButton 
					#flags: 40 
					#model: #moveSelectionDown 
					#label: 'Down' 
					#style: #default 
					#defaultable: true ) ) ) )!

iconSpec
	"UIBPainter new openOnClass: self andSelector: #iconSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Orderable List' 
			#bounds: #(#Rectangle 192 432 356 561 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -35 1 ) 
					#name: #orderableList 
					#model: #orderableList 
					#multipleSelections: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -30 1 30 0 0 1 ) 
					#name: #moveUpButton 
					#flags: 40 
					#model: #moveSelectionUp 
					#label: #up 
					#hasCharacterOrientedLabel: false 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -30 1 -30 1 0 1 0 1 ) 
					#name: #moveDownButton 
					#flags: 40 
					#model: #moveSelectionDown 
					#label: #down 
					#hasCharacterOrientedLabel: false 
					#style: #default 
					#defaultable: true ) ) ) )!

noButtonSpec
	"UIBPainter new openOnClass: self andSelector: #noButtonSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Orderable List' 
			#bounds: #(#Rectangle 77 225 241 354 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #orderableList 
					#model: #orderableList 
					#multipleSelections: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -20 1 50 0 0 1 ) 
					#name: #moveUpButton 
					#flags: 56 
					#model: #moveSelectionUp 
					#label: 'Up' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 55 0 -20 1 105 0 0 1 ) 
					#name: #moveDownButton 
					#flags: 56 
					#model: #moveSelectionDown 
					#label: 'Down' 
					#style: #default 
					#defaultable: true ) ) ) )!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Orderable List' 
			#bounds: #(#Rectangle 192 432 356 561 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -25 1 ) 
					#name: #orderableList 
					#model: #orderableList 
					#multipleSelections: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -20 1 50 0 0 1 ) 
					#name: #moveUpButton 
					#flags: 40 
					#model: #moveSelectionUp 
					#label: 'Up' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -50 1 -20 1 0 1 0 1 ) 
					#name: #moveDownButton 
					#flags: 40 
					#model: #moveSelectionDown 
					#label: 'Down' 
					#style: #default 
					#defaultable: true ) ) ) )! !

!UIBOrderableList class methodsFor: 'generated resources'!

down

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwDownArrowIcon24]
		ifFalse: [^UIBImage cgDownArrowIcon24]!

up

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwUpArrowIcon24]
		ifFalse: [^UIBImage cgUpArrowIcon24]! !

UIFinderVW2 subclass: #UIBFinder
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Misc'!


!UIBFinder methodsFor: 'actions'!

addCanvas

	UIBPainter new
		openOnClass: (Smalltalk at: self className ifAbsent: [^self classGone])
		andSelector: nil!

browseOrEditSpec
	"This message is sent by the class list when a double click is issued."

	self builder window sensor shiftDown
		ifTrue:[(self class isEditableSpecClass: (Smalltalk at: self className)) ifTrue:[self editSpec]]
		ifFalse:[self browse]!

edit
	| clName sel cl editee list le qe meth |
	(clName := self className) isNil
		ifTrue: 
			[(editee := UIFinderVW2 openSourceDialogForCategory: #'interface specs') isNil ifTrue: [^self].
			UIBPainter new openOnClass: (editee at: 1)
				andSelector: (editee at: 2).
			^self].
	(sel := self selector) isNil ifTrue: [(list := self selectorList list) size == 1
			ifTrue: [self selectorList selection: (sel := list at: 1)]
			ifFalse: 
				[list size == 0
					ifTrue: [self referUserToSpecBearingParent]
					ifFalse: [(builder componentAt: #SelectorList) flash].
				^self]].
	cl := Smalltalk at: clName ifAbsent: [^self classGone].
	meth := cl class compiledMethodAt: sel ifAbsent: [].
	(meth == nil or: [meth resourceType == nil])
		ifTrue:
			[meth := cl compiledMethodAt: sel ifAbsent: [].
			(meth == nil or: [meth resourceType == nil])
				ifTrue: [^self selectorGone]].
	meth resourceType = #query
		ifTrue:
			[qe := Smalltalk at: #QueryEditor ifAbsent: [nil].
			qe == nil ifFalse: [^qe new openOnClass: cl andSelector: sel]].
	meth resourceType = #canvas
		ifTrue: [^UIBPainter new openOnClass: cl andSelector: sel].
	meth resourceType = #menu
		ifTrue: [^UIMenuEditor new openOnClass: cl andSelector: sel].
	meth resourceType = #dataModel
		ifTrue:
			[le := Smalltalk at: #LensEditor ifAbsent: [nil].
			le == nil ifFalse: [^le new openOnClass: cl andSelector: sel]].
	meth resourceType = #image
		ifTrue: [^UIMaskEditor new openOnClass: cl andSelector: sel]!

editSpec

	| specClass |
	specClass := Smalltalk at: self className.
	(((self class isExtendedStandardSpecClass: specClass) or: [self class isStandardSpecClass: specClass])
		ifTrue:[UIBExtendedStandardComponentEditor]
		ifFalse:[UIBCompositeComponentEditor]) openOnClass: specClass! !

!UIBFinder methodsFor: 'commands'!

addClass
	"If the new class created understands #windowSpec then the painter is opened using that method. This case happens when the class is a main application"

	| clName newCl |
	clName := self class openTargetClassNameDialogFor: self className.
	clName isNil ifTrue: [^self].
	((Smalltalk includesKey: clName)
		and: [(Smalltalk at: clName) isBehavior])
		ifTrue: [newCl := Smalltalk at: clName]
		ifFalse: 
			[newCl := self class
						createNewApplication: clName
						ofKind: nil
						inCategory: nil
						forClient: self.
			newCl isNil ifTrue: [^self]].
	self class markAsSpecBearer: newCl.
	(self does: newCl inheritFromClassNamed: #LensDataManager)
		ifTrue: [self class openCanvasGeneratorForClass: newCl]
		ifFalse: [UIBPainter new openOnClass: newCl andSelector: ((newCl respondsTo: #windowSpec)
					ifTrue: [#windowSpec]
					ifFalse: [nil])].
	self classNameList selection: clName!

openNewWindowCanvas
	"Open a new canvas."

	UIBPainter new openNewWindowCanvas!

showSpecificationClasses
	| newClasses | 
	self filter: #showSpecificationClasses.
	(builder componentAt: #ClassNameListLabel) widget labelString: 'Specification Classes'.
	self pruneRemovedClasses.
	newClasses := SpecBearingClasses copy select:[:cln| self class isSpecClass: (Smalltalk at: cln)].
	self showClasses: newClasses!

showUserSpecificationClasses
	| newClasses |
	self filter: #showUserSpecificationClasses.
	(builder componentAt: #ClassNameListLabel) widget labelString: 'User Specification Classes'.
	self pruneRemovedClasses.
	newClasses := SpecBearingClasses copy select:[:cln| self class isUserDefinedSpecClass: (Smalltalk at: cln)].
	self showClasses: newClasses! !

!UIBFinder methodsFor: 'private'!

adjustMenuAccordingToFilter
	| sm |
	sm := (menuBar value menuItemLabeled: 'View') submenu.
	1 to: 7 do: [:itemNbr | (sm menuItemAt: itemNbr)
			indication: nil].
	filter == #showSpecificationClasses
		ifTrue: 
			[(sm menuItemLabeled: 'Specification Classes') beOn.
			^self].
	filter == #showUserSpecificationClasses
		ifTrue: 
			[(sm menuItemLabeled: 'User Specification Classes') beOn.
			^self].
	filter == #showAllClasses
		ifTrue: 
			[(sm menuItemLabeled: 'All Classes') beOn.
			^self].
	(filter == #showClassesByCategory or: [filter == #showClassesByLastCategory])
		ifTrue: 
			[(sm menuItemLabeled: 'Classes by Category...') beOn.
			^self].
	filter == #showUserClasses
		ifTrue: 
			[(sm menuItemLabeled: 'User Classes') beOn.
			^self].
	filter == #showSystemClasses
		ifTrue: 
			[(sm menuItemLabeled: 'System Classes') beOn.
			^self].
	filter == #showRecentlyVisitedClasses
		ifTrue: 
			[(sm menuItemLabeled: 'Recently Visited Classes') beOn.
			^self].
	^self!

changedClassName
	| selList sm mi |
	selectorList list: (selList := self computeSelectorList).
	self className isNil
		ifTrue: 
			[#(#startButton #removeButton #browseButton #editButton #editSpecButton) do: [:n | (builder componentAt: n) disable].
			menuBar value: menuBarMenuWithNoSelection.
			(builder window menuBar menuButtons at: (menuBar value indexOfMenuItem: (mi := menuBar value menuItemLabeled: 'Resources'))) isEnabled: mi isEnabled.
			self adjustMenus.
			^self]
		ifFalse: 
			[(builder componentAt: #editSpecButton)
				isEnabled: (self class isEditableSpecClass: (Smalltalk at: self className)).
			#(#removeButton #browseButton ) do: [:n | (builder componentAt: n) enable].
			selList size = 1
				ifTrue: 
					[selectorList selection: (selList at: 1).
					(builder componentAt: #editButton) enable].
			sm := (menuBar value menuItemLabeled: 'Class') submenu.
			(sm menuItemLabeled: 'Edit Spec')
				enabled: (self class isEditableSpecClass: (Smalltalk at: self className)).
			(Smalltalk at: self className) isVisualStartable
				ifTrue: 
					[(builder componentAt: #startButton) enable.
					(sm menuItemLabeled: 'Start') enable]
				ifFalse: 
					[(builder componentAt: #startButton) disable.
					(sm menuItemLabeled: 'Start') disable].
			selList size > 1
				ifTrue: 
					[menuBar value: menuBarMenuWithNoCanvasSelected.
					(builder componentAt: #editButton) disable.
					self adjustMenus]]!

referUserToSpecBearingParent
	| clName totalNumberOfSpecs specBearingParent soleSpec canvases |
	clName := self className.
	totalNumberOfSpecs := 0.
	canvases := Dictionary new.
	(Smalltalk at: clName ifAbsent: [^self classGone]) class allSuperclasses
		do: 
			[:sc | 
			| specCount specs |
			specCount := (specs := sc organization listAtCategoryNamed: #'interface specs') size.
			specCount > 0
				ifTrue: 
					[specBearingParent := sc soleInstance.
					canvases at: specBearingParent put: specs].
			totalNumberOfSpecs := totalNumberOfSpecs + specCount.
			specs isEmpty not ifTrue: [soleSpec := specs first]].
	totalNumberOfSpecs == 1
		ifTrue: [(Dialog
				choose: clName asString , ' inherits a canvas from
' , specBearingParent name , '.' , '
Edit this canvas?'
				labels: #('Edit' 'Cancel' )
				values: #(true false )
				default: true
				for: builder window)
				ifTrue: [UIBPainter new openOnClass: specBearingParent andSelector: soleSpec]]
		ifFalse: [totalNumberOfSpecs == 0
				ifTrue: [Dialog warn: clName , ' has no canvases' for: builder window]
				ifFalse: [self class openInheritedCanvasDialogOn: clName with: canvases]]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBFinder class
	instanceVariableNames: ''!


!UIBFinder class methodsFor: 'class accessing'!

specBearingClasses

	^SpecBearingClasses!

subclassesOfStandardSpecClasses
	"self subclassesOfStandardSpecClasses"

	| classes |
	classes := Set new.
	UIPalette standardSpecsForPalette
		do:[ :clName| classes addAll: (Smalltalk at: clName) subclasses].
	classes remove: UIBCompositeComponentSpec.
	classes remove: EmbeddedDetailSpec.
	classes remove: LinkedDetailSpec.
	^classes - (UIPalette standardSpecsForPalette collect:[:clName| Smalltalk at: clName]) asSet! !

!UIBFinder class methodsFor: 'interface opening'!

open
	"self open"

	| bldr inst |
	bldr := (inst := self new) openInterface: #windowSpec.
	#(#browseButton #startButton #removeButton #editButton #editSpecButton) do: [:n | (bldr componentAt: n) disable].
	inst builder: bldr.
	(bldr window) application: inst; sendWindowEvents: #(#close #release )!

openInheritedCanvasDialogOn: aClassName with: canvases

	| canvasNames builder dialog canvasList |
	canvasNames := Dictionary new.
	canvases keysDo:
		[:cl |
		| clName |
		clName := cl name.
		(canvases at: cl) do:
			[:cnvName |
			| fullName |
			fullName := clName, ' ', cnvName.
			canvasNames at: fullName put: cl -> cnvName]].
	builder := (dialog := SimpleDialog new) builder.
	builder
		aspectAt: #canvasList
		put: (canvasList := SelectionInList with: canvasNames keys asOrderedCollection).
	builder aspectAt: #doOK put:
		[| entry |
		(entry := canvasList selection) isNil
			ifTrue: [(builder componentAt: #canvasList) flash]
			ifFalse:
				[entry := canvasNames at: entry.
				[UIBPainter new
					openOnClass: entry key
					andSelector: entry value] fork.
				dialog close]].
	builder aspectAt: #doAbort put: [dialog close].
	dialog allButOpenFrom: (UISpecification from: self inheritedCanvasDialog).
	dialog builder openDialog.!

openNewClassDialogForName: aClassName subClassing: aSuperName inCategory: aCategory 
	"Open a dialog to confirm or collect the basic information required 
	to create a new class."

	| dialog className catName superName superPick results builder |
	dialog := SimpleDialog new.
	builder := dialog builder.
	builder
		aspectAt: #className
		put:
			(className :=
				(aClassName isNil
					ifTrue: [String new]
					ifFalse: [aClassName asString]) asValue).
	builder
		aspectAt: #classCategory
		put:
			(catName :=
				(aCategory isNil
					ifTrue: ['UIB-Applications-New' copy]
					ifFalse: [aCategory asString]) asValue).
	builder
		aspectAt: #superClassName
		put:
			(superName :=
				(aSuperName isNil
					ifTrue: [String new]
					ifFalse: [aSuperName asString]) asValue).
	builder
		aspectAt: #superPick
		put:
			(superPick :=
				(superName value isEmpty
					ifTrue: [#UIBApplicationModel]
					ifFalse: [#Other]) asValue).
	superPick
		compute:
			[:v |
			v = #Other
				ifTrue:
					[(dialog builder componentAt: #superClassNameField) enable]
				ifFalse:
					[superName value: String new.
					(dialog builder componentAt: #superClassNameField) disable]].
	superName
		compute: 
			[:v | 
			| cl ctrlr |
			ctrlr := (dialog builder componentAt: #superClassNameField) widget controller.
			"ctrlr enableDefault."
			cl := self superClassNamed: v fromController: ctrlr.
			cl notNil
				ifTrue: 
					[superName value == cl name
						ifFalse: [superName setValue: cl name]]].
	builder
		aspectAt: #doAbort
		put:
			[results := nil.
			dialog close].
	builder
		aspectAt: #doOK
		put:
			[((results :=
				self
					resultsForClassName: className value
					andSuperclass:
						(superPick value == #Other
							ifTrue: [superName value]
							ifFalse: [superPick value])
					andCategory: catName value) includes: nil) not
				ifTrue:
					[dialog close]
				ifFalse:
					[(results at: 1) isNil
						ifTrue:
							[(dialog builder componentAt: #classNameField) flash].
					(results at: 2) isNil
						ifTrue:
							[(dialog builder componentAt: #superClassNameField) flash].
					(results at: 3) isNil
						ifTrue:
							[(dialog builder componentAt: #classCategoryField) flash]]].
	dialog allButOpenFrom: (self interfaceSpecFor: #classCreationDialog).
	superPick value: superPick value.
	dialog builder openDialog.
	^results!

openPaletteClassDialogForName: aClassName subClassing: aSuperName inCategory: aCategory 
	"Open a dialog to confirm or collect the basic information required 
	to select/create a new Palette class."

	| dialog className catName superName superPick results builder |
	dialog := SimpleDialog new.
	builder := dialog builder.
	builder
		aspectAt: #className
		put:
			(className :=
				(aClassName isNil
					ifTrue: [String new]
					ifFalse: [aClassName asString]) asValue).
	builder
		aspectAt: #classCategory
		put:
			(catName :=
				(aCategory isNil
					ifTrue: ['UIB-Applications-New' copy]
					ifFalse: [aCategory asString]) asValue).
	builder
		aspectAt: #superClassName
		put:
			(superName :=
				(aSuperName isNil
					ifTrue: [String new]
					ifFalse: [aSuperName asString]) asValue).
	builder
		aspectAt: #superPick
		put:
			(superPick :=
				(superName value isEmpty
					ifTrue: [#UIBPalette]
					ifFalse: [#Other]) asValue).
	superPick
		compute:
			[:v |
			v = #Other
				ifTrue:
					[(dialog builder componentAt: #superClassNameField) enable]
				ifFalse:
					[superName value: String new.
					(dialog builder componentAt: #superClassNameField) disable]].
	superName
		compute: 
			[:v | 
			| cl ctrlr |
			ctrlr := (dialog builder componentAt: #superClassNameField) widget controller.
			"ctrlr enableDefault."
			cl := self superClassNamed: v fromController: ctrlr.
			cl notNil
				ifTrue: 
					[superName value == cl name
						ifFalse: [superName setValue: cl name]]].
	builder
		aspectAt: #doAbort
		put:
			[results := nil.
			dialog close].
	builder
		aspectAt: #doOK
		put:
			[((results :=
				self
					resultsForSpecClassName: className value
					andSuperclass:
						(superPick value == #Other
							ifTrue: [superName value]
							ifFalse: [superPick value])
					andCategory: catName value) includes: nil) not
				ifTrue:
					[dialog close]
				ifFalse:
					[(results at: 1) isNil
						ifTrue:
							[(dialog builder componentAt: #classNameField) flash].
					(results at: 2) isNil
						ifTrue:
							[(dialog builder componentAt: #superClassNameField) flash].
					(results at: 3) isNil
						ifTrue:
							[(dialog builder componentAt: #classCategoryField) flash]]].
	dialog allButOpenFrom: (self interfaceSpecFor: #paletteClassCreationDialog).
	superPick value: superPick value.
	dialog builder openDialog.
	^results!

openSpecClassDialogForName: aClassName subClassing: aSuperName inCategory: aCategory 
	"Open a dialog to confirm or collect the basic information required 
	to select/create a new Specification class."

	| dialog className catName superName superPick results builder |
	dialog := SimpleDialog new.
	builder := dialog builder.
	builder
		aspectAt: #className
		put:
			(className :=
				(aClassName isNil
					ifTrue: [String new]
					ifFalse: [aClassName asString]) asValue).
	builder
		aspectAt: #classCategory
		put:
			(catName :=
				(aCategory isNil
					ifTrue: ['UIB-Applications-New' copy]
					ifFalse: [aCategory asString]) asValue).
	builder
		aspectAt: #superClassName
		put:
			(superName :=
				(aSuperName isNil
					ifTrue: [String new]
					ifFalse: [aSuperName asString]) asValue).
	builder
		aspectAt: #superPick
		put:
			(superPick :=
				(superName value isEmpty
					ifTrue: [#UIBCompositeComponentSpec]
					ifFalse: [#Other]) asValue).
	superPick
		compute:
			[:v |
			v = #Other
				ifTrue:
					[(dialog builder componentAt: #superClassNameField) enable]
				ifFalse:
					[superName value: String new.
					(dialog builder componentAt: #superClassNameField) disable]].
	superName
		compute: 
			[:v | 
			| cl ctrlr |
			ctrlr := (dialog builder componentAt: #superClassNameField) widget controller.
			"ctrlr enableDefault."
			cl := self superClassNamed: v fromController: ctrlr.
			cl notNil
				ifTrue: 
					[superName value == cl name
						ifFalse: [superName setValue: cl name]]].
	builder
		aspectAt: #doAbort
		put:
			[results := nil.
			dialog close].
	builder
		aspectAt: #doOK
		put:
			[((results :=
				self
					resultsForSpecClassName: className value
					andSuperclass:
						(superPick value == #Other
							ifTrue: [superName value]
							ifFalse: [superPick value])
					andCategory: catName value) includes: nil) not
				ifTrue:
					[dialog close]
				ifFalse:
					[(results at: 1) isNil
						ifTrue:
							[(dialog builder componentAt: #classNameField) flash].
					(results at: 2) isNil
						ifTrue:
							[(dialog builder componentAt: #superClassNameField) flash].
					(results at: 3) isNil
						ifTrue:
							[(dialog builder componentAt: #classCategoryField) flash]]].
	dialog allButOpenFrom: (self interfaceSpecFor: #specClassCreationDialog).
	superPick value: superPick value.
	dialog builder openDialog.
	^results! !

!UIBFinder class methodsFor: 'interface specs'!

classCreationDialog
	"UIPainter new openOnClass: self andSelector: #classCreationDialog"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 332 247 ) 
			#max: #(#Point 337 247 ) 
			#bounds: #(#Rectangle 272 328 608 575 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -82 0.5 -35 1 -16 0.5 -5 1 ) 
					#model: #doOK 
					#label: 'OK' 
					#isDefault: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 16 0.5 -35 1 82 0.5 -5 1 ) 
					#model: #doAbort 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#Point 10 12 ) 
					#label: 'CREATE New Application Class' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 38 ) 
					#label: 'Name:' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 68 ) 
					#label: 'Category:' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 10 0 101 0 -10 1 191 0 ) 
					#label: 'Superclass' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 95 0 38 0 -10 1 63 0 ) 
					#name: #classNameField 
					#model: #className ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 95 0 68 0 -10 1 93 0 ) 
					#name: #classCategoryField 
					#model: #classCategory ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 126 0 183 0 148 0 ) 
					#model: #superPick 
					#label: 'UIBApplicationModel' 
					#select: #UIBApplicationModel ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 187 0 126 0 324 0 147 0 ) 
					#model: #superPick 
					#label: 'SimpleDialog' 
					#select: #SimpleDialog ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 154 0 91 0 176 0 ) 
					#model: #superPick 
					#label: 'Other:' 
					#select: #Other ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 97 0 153 0 -16 1 178 0 ) 
					#name: #superClassNameField 
					#model: #superClassName ) ) ) )!

paletteClassCreationDialog
	"UIPainter new openOnClass: self andSelector: #paletteClassCreationDialog"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 332 247 ) 
			#max: #(#Point 337 247 ) 
			#bounds: #(#Rectangle 180 178 516 425 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -82 0.5 -35 1 -16 0.5 -5 1 ) 
					#model: #doOK 
					#label: 'OK' 
					#isDefault: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 16 0.5 -35 1 82 0.5 -5 1 ) 
					#model: #doAbort 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#Point 10 12 ) 
					#label: 'Install on Palette Class' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 38 ) 
					#label: 'Name:' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 68 ) 
					#label: 'Category:' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 10 0 101 0 -10 1 191 0 ) 
					#label: 'Superclass' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 95 0 38 0 -10 1 63 0 ) 
					#name: #classNameField 
					#model: #className ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 95 0 68 0 -10 1 93 0 ) 
					#name: #classCategoryField 
					#model: #classCategory ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 126 0 183 0 148 0 ) 
					#model: #superPick 
					#label: 'UIBPalette' 
					#select: #UIBPalette ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 154 0 91 0 176 0 ) 
					#model: #superPick 
					#label: 'Other:' 
					#select: #Other ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 97 0 153 0 -16 1 178 0 ) 
					#name: #superClassNameField 
					#model: #superClassName ) ) ) )!

specClassCreationDialog
	"UIPainter new openOnClass: self andSelector: #specClassCreationDialog"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 332 247 ) 
			#max: #(#Point 337 247 ) 
			#bounds: #(#Rectangle 180 178 516 425 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -82 0.5 -35 1 -16 0.5 -5 1 ) 
					#model: #doOK 
					#label: 'OK' 
					#isDefault: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 16 0.5 -35 1 82 0.5 -5 1 ) 
					#model: #doAbort 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#Point 10 12 ) 
					#label: 'Install on Specification Class' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 38 ) 
					#label: 'Name:' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 68 ) 
					#label: 'Category:' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 10 0 101 0 -10 1 191 0 ) 
					#label: 'Superclass' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 95 0 38 0 -10 1 63 0 ) 
					#name: #classNameField 
					#model: #className ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 95 0 68 0 -10 1 93 0 ) 
					#name: #classCategoryField 
					#model: #classCategory ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 126 0 183 0 148 0 ) 
					#model: #superPick 
					#label: 'UIBCompositeComponentSpec' 
					#select: #UIBCompositeComponentSpec ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 154 0 91 0 176 0 ) 
					#model: #superPick 
					#label: 'Other:' 
					#select: #Other ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 97 0 153 0 -16 1 178 0 ) 
					#name: #superClassNameField 
					#model: #superClassName ) ) ) )!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'ApplFLab Resource Finder' 
			#min: #(#Point 337 154 ) 
			#bounds: #(#Rectangle 126 166 568 419 ) 
			#flags: 4 
			#menu: #menuBar ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 10 0 56 0 -4 0.5 -10 1 ) 
					#name: #ClassNameList 
					#model: #classNameList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#doubleClickSelector: #browseOrEditSpec ) 
					#tabable: false 
					#menu: #classNameListMenu ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 1 0.5 56 0 -10 1 -10 1 ) 
					#name: #SelectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#doubleClickSelector: #edit ) 
					#tabable: false 
					#menu: #selectorListMenu 
					#multipleSelections: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.167421 0 0 0 0.309955 32 0 ) 
					#name: #startButton 
					#model: #startApplication 
					#tabable: false 
					#label: 'Start' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.309955 0 0 0 0.445701 32 0 ) 
					#name: #addButton 
					#model: #addClass 
					#tabable: false 
					#label: 'Add...' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.445701 0 0 0 0.60181 32 0 ) 
					#name: #removeButton 
					#model: #remove 
					#tabable: false 
					#label: 'Remove...' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 1 0.5 33 0 ) 
					#label: 'Resources' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 1 0 0 0 0 0.167421 32 0 ) 
					#name: #browseButton 
					#model: #browse 
					#tabable: false 
					#label: 'Browse' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.60181 0 0 0 0.800905 32 0 ) 
					#name: #editButton 
					#model: #edit 
					#tabable: false 
					#label: 'Edit' ) 
				#(#LabelSpec 
					#layout: #(#Point 8 33 ) 
					#name: #ClassNameListLabel 
					#label: 'Class' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.803167 0 0 0 0.997737 32 0 ) 
					#name: #editSpecButton 
					#model: #editSpec 
					#tabable: false 
					#label: 'Edit Spec' ) ) ) )! !

!UIBFinder class methodsFor: 'private'!

computeRecentlyVisitedMenu
	"UIFinderVW2 computeRecentlyVisitedMenu"

	| labels values |
	RecentlyVisitedClasses isEmpty
		ifTrue:
			[Dialog warn: 'There are no recently visited classes'].
	labels := OrderedCollection new.
	values := OrderedCollection new.
		RecentlyVisitedClasses copy do:
		[:clName |
		| list cl |
		((cl := Smalltalk at: clName ifAbsent: [nil]) notNil and:
				[(list := cl class organization listAtCategoryNamed: #'interface specs') isEmpty not])
			ifTrue:
				[labels add: clName asString.
				values add:
					(list size == 1
						ifTrue:
							[[UIBPainter new openOnClass: cl andSelector: list first]]
						ifFalse:
							[Menu
								labelArray:
									(list collect: [:elt | elt asString]) asArray
								values:
									(list collect:
										[:selName |
										[UIBPainter new openOnClass: cl andSelector: selName]])])]
			ifFalse:
				[RecentlyVisitedClasses remove: clName ifAbsent: [self error: 'shouldn''t happen']]].
	^Menu
		labelArray: labels asArray
		lines: Array new
		values: values asArray!

createNewApplication: clName ofKind: aKind inCategory: categ forClient: anApplication
	"Using the creation dialog ask the user for all the parameters required for the creation of an 
	ApplicationModel. All the UI roads to create an applicationModel should go through this method. 
	After the class is created if it has an #initialize method it is called"

	"The method in the superclass used a general class defining dialog when present.
	Since this method is only invoked to create ApplicationModels,
	the code below is more appropriate:"

	| a |
	a := self openNewClassDialogForName: clName
			subClassing: nil
			inCategory: nil.
	a == nil ifTrue: [^nil].
	^self createNewClassUsing: a!

resultsForSpecClassName: className andSuperclass: superName andCategory: catName 

	| result |
	result := Array
		with:
			 (className isEmpty ifTrue: [nil] ifFalse: [className asSymbol])
		with:
			(Smalltalk at: superName asSymbol ifAbsent: [nil])
		with:
			(catName isEmpty ifTrue: [nil] ifFalse: [catName]).
	className isEmpty ifTrue: [^result].
	className first isUppercase not
		ifTrue:
			[Dialog warn: 'Class names should be capitalized'.
			result at: 1 put: nil.
			^result].
	(className detect: [:char | char isSeparator] ifNone: [nil]) notNil
		ifTrue:
			[Dialog warn: 'Class names should not include separators'.
			result at: 1 put: nil.
			^result].
	(Scanner new scanTokens: className) size > 1
		ifTrue:
			[Dialog warn: 'Class names should not include binary selectors'.
			result at: 1 put: nil.
			^result].
	^result! !

!UIBFinder class methodsFor: 'testing'!

isCompositeComponentSpecClass: aClass
	"Is aClass a composite component specification class ?"

	^aClass inheritsFrom: UIBCompositeComponentSpec!

isEditableSpecClass: aClass
	"Can aClass be edited by UIBComponentEditor ?"
	"All specification classes can be edited, unless they do not conform to the conventions.
	In that case, the specification class' #canBeEditedByComponentEditor method should answer false."

	^(self isSpecClass: aClass)
		and: [(aClass respondsTo: #canBeEditedByComponentEditor) not
				or:[aClass canBeEditedByComponentEditor]]!

isExtendedStandardSpecClass: subClass

	"Koen: dit is nog steeds niet helemaal correct!!"

	^(subClass inheritsFrom: NamedSpec)
		and:[(self isStandardSpecClass: subClass) not
			and:[(self isCompositeComponentSpecClass: subClass) not]]!

isSpecClass: aClass
	"Is aClass a specification class ?"

	^aClass inheritsFrom: NamedSpec!

isStandardSpecClass: aClass
	"Is aClass a standard specification class ?"
	"This methods expects that the standard UIPalette class answers
	all standard specification classes when sent the #standardSpecsForPalette
	messsage. When using ApplFLab, this is correct, as long as that method has not
	been changed from outside ApplFLab. (ApplFLab does not allow changes to the
	UIPalette class."

	^UIPalette standardSpecsForPalette includes: aClass name!

isUserDefinedSpecClass: aClass
	"Is aClass a user-defined specification class ?"

	^(self isCompositeComponentSpecClass: aClass)
		or:[self isExtendedStandardSpecClass: aClass]!

isUserSpecClass: aClass
	"Is aClass a user specification class ?"

	^aClass inheritsFrom: UIBCompositeComponentSpec! !

!UIBFinder class methodsFor: 'resources'!

classMenu 
	^(Menu new) 
		addItem: ((MenuItem labeled: 'Start') disable; shortcutKeyCharacter: $O) value: #startApplication; 
		addItem: ((MenuItem labeled: 'Browse') disable; shortcutKeyCharacter: $B) value: #browse; 
		addItem: ((MenuItem labeled: 'Edit Spec') disable; shortcutKeyCharacter: $E) value: #editSpec; 
		addItem: ((MenuItem labeled: 'Show Data Forms') disable) value: #showDatabaseApplicationStructure; 
		addItem: (MenuItem labeled: 'File Out As...') disable value: #fileOutClass; 
		addItemGroup: (Array with: (MenuItem labeled: 'Rename As...') disable with: (MenuItem labeled: 'Remove...') disable) values: #(#renameClass #removeClass ); 
		addItemGroup: (Array with: ((MenuItem labeled: 'Add...') shortcutKeyCharacter: $N)) values: #(#addClass ).!

viewMenu
	"UIMenuEditor new openOnClass: self andSelector: #viewMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#label: 'All Classes' ) 
			#(#MenuItem 
				#label: 'User Classes' ) 
			#(#MenuItem 
				#label: 'Specification Classes' ) 
			#(#MenuItem 
				#label: 'User Specification Classes' ) 
			#(#MenuItem 
				#label: 'System Classes' ) 
			#(#MenuItem 
				#label: 'Recently Visited Classes' ) 
			#(#MenuItem 
				#label: 'Classes by Category...' ) 
			#(#MenuItem 
				#label: 'Sort by Name' ) 
			#(#MenuItem 
				#label: 'Sort by Type' ) 
			#(#MenuItem 
				#label: 'Update' ) 
			#(#MenuItem 
				#label: 'Exit' ) ) #(7 2 1 1 ) #(#showAllClasses #showUserClasses #showSpecificationClasses #showUserSpecificationClasses #showSystemClasses #showRecentlyVisitedClasses #showClassesByCategory #sortByName #sortByType #update #closeRequest ) ) decodeAsLiteralArray! !

LabelAndIcon subclass: #UIBLabelAndIcon
	instanceVariableNames: 'iconPosition textCentered '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!
UIBLabelAndIcon comment:
'This class extends the superclass with the ability to change the relative position of the icon wrt. the label, and the ability to align the centers of the label and the icon.

Instance variables:

	iconPosition		#left | #right | #top | #bottom		The relative position of the icon.
	textCentered	<Boolean>						This indicates alignment.'!


!UIBLabelAndIcon methodsFor: 'private'!

baseline
	"Answer y-coordinate of the baseline of the label."

	icon isNil ifTrue: [^self attributes baseline].
	(self iconPosition == #left or: [self iconPosition == #right])
		ifTrue: [| delta |
				^self offset y
					+ self attributes baseline
					- ((delta := self attributes baseline - self icon bounds height / 2) > 0 ifTrue: [delta] ifFalse: [0])].
	self iconPosition == #top
		ifTrue: [^self offset y + self attributes baseline + self gap + self icon bounds height].
	^self offset y + self attributes baseline!

iconOffset
	"Answer the coordinates where the icon should be displayed."

	|delta|
	self iconPosition == #left
		ifTrue: [^self textCentered
				ifTrue:[(Point
						x: self offset x
						y: self offset y + ((delta := self attributes baseline - self icon bounds height / 2) > 0 ifTrue: [delta] ifFalse: [0]))]
				ifFalse: [self offset]].
	self iconPosition == #right
		ifTrue: [^self textCentered
				ifTrue:[(Point
						x: self offset x + self textWidth + self gap
						y: self offset y + ((delta := self attributes baseline - self icon bounds height / 2) > 0 ifTrue: [delta] ifFalse: [0]))]
				ifFalse: [(self offset x + self textWidth + self gap) @ self offset y]].
	self iconPosition == #bottom
		ifTrue: [^self textCentered
				ifTrue:[self offset + (Point
							x: ((delta := self textWidth - self icon preferredBounds width / 2) > 0 ifTrue: [delta] ifFalse: [0])
							y: self offset y + self attributes baseline + gap)]
				ifFalse:[self offset x @ (self offset y + self attributes baseline + gap)]].
	self iconPosition == #top
		ifTrue: [^self textCentered
				ifTrue:[self offset + (Point
							x: ((delta := self textWidth - self icon preferredBounds width / 2) > 0 ifTrue: [delta] ifFalse: [0])
							y: 0)]
				ifFalse:[self offset]]!

left
	"Answer the x-coordinate of the first character of the label."

	|delta|
	self iconPosition == #right ifTrue: [^self offset x].
	(self iconPosition == #top or:[self iconPosition == #bottom])
		ifTrue: [^self offset x
				+  ((self textCentered not or: [delta :=  self icon preferredBounds width - self textWidth < 0]) ifTrue: [0] ifFalse: [delta / 2])].
	^super left!

textWidth
	"Answer the width of the label text, without updating any instance variables."

	| scanner txt |
	txt := self text.
	txt size = 0 ifTrue: [^0].
	scanner := CompositionScanner
				fontPolicy: self fontPolicy
				text: txt
				textAttributes: self attributes.
	scanner
		composeLine: 1
		fromCharacterIndex: 1
		leftMargin: 0
		rightMargin: SmallInteger maxVal.
	^scanner rightX!

top
	"Answer the y-coordinate of the first character of the label."

	| delta |
	(self iconPosition == #left or: [self iconPosition == #right])
		ifTrue: [^ self offset y + (delta := self attributes baseline - self icon bounds height / 2) < 0 ifTrue: [delta] ifFalse: [0]].
	
	^self offset y! !

!UIBLabelAndIcon methodsFor: 'displaying'!

displayOn: aGraphicsContext
	"Display the receiver on aGraphicsContext. The receiver may alter
	aGraphicsContext in any way it chooses."

	icon == nil ifFalse: [icon displayOn: aGraphicsContext at: self iconOffset].
	self displayTextOn: aGraphicsContext!

displayTextOn: aGraphicsContext

	| scanner wid |
	(text == nil or: [text isEmpty]) ifTrue:
		[^self].
	"Do the check for change of emphasis now because clients may
	choose to change the emphasis at any time."
	(text hasChangeOfEmphasis or: [needsScan]) ifFalse:
		[aGraphicsContext
			font: (self attributes fontAt: (text emphasisAt: 1) for: aGraphicsContext fontPolicy);
			displayString: text string from: 1 to: text size at: self left @ self baseline.
		^self].

	wid := (width == nil ifTrue: [SmallInteger maxVal] ifFalse: [width]).

	scanner := DisplayScanner new.
	scanner textStyle: self attributes.
	scanner
		displayLine: (1 to: text size)
		inText: text
		left: self left
		right: wid
		top: self top
		on: aGraphicsContext.! !

!UIBLabelAndIcon methodsFor: 'accessing'!

gap

	^gap!

icon

	^icon!

iconPosition

	^iconPosition!

iconPosition: positionSymbol
	"Set the position of the icon relative to the label.
	#left : icon to the left of the label.
	#right : icon to the right of the label
	#top : icon above the label
	#bottom : icon below the label"

	iconPosition := positionSymbol!

textCentered

	^textCentered!

textCentered: aBoolean
	"aBoolean indicates whether the label and icon centers should be aligned."

	textCentered := aBoolean! !

!UIBLabelAndIcon methodsFor: 'initialize-release'!

initialize

	super initialize.
	self iconPosition: #left.
	self textCentered: true! !

TabBarViewOOP subclass: #HorizontalTabBarViewOOP
	instanceVariableNames: 'cachedWidth tabWidth cacheIndex cacheBox cacheVisual '
	classVariableNames: 'BottomMask LeftScrollButtonImage RightScrollButtonImage '
	poolDictionaries: ''
	category: 'UIB-Support'!


!HorizontalTabBarViewOOP methodsFor: 'constants'!

leftOffsetForDisplay
	"Answer the offset in pixels to begin displaying the tabs from the left edge of the component."

	^2

	"<<BIKI 'please dont remove this button': 29 January 1996,5:00:36 pm, version: 3>>"!

rightOffsetForDisplay
	"Answer the offset in pixels to begin displaying the tabs from the right edge of the component."

	^2

	"<<BIKI 'please dont remove this button': 2 February 1996,1:07:41 pm, version: 1>>"! !

!HorizontalTabBarViewOOP methodsFor: 'displaying'!

displayInteriorRectangularBorderOn: aGC in: rt selected: aBoolean
	"Display a rectangular border such that it is contained by aRectangle." 
	| left bottom  right top corner  bottomAdjust |
	left := rt left   .
	bottom := rt bottom.
	right := rt right .
	top := rt top.
	aBoolean 
		ifTrue: [bottomAdjust := 1]
		ifFalse: [bottomAdjust := 0].
	corner := 2.
	aGC paint: self borderColor.
		aGC displayLineFrom: (left@(top + corner)  ) to: (left@(bottom - bottomAdjust)) .
		aGC displayLineFrom: (left@(top + corner)) to: ((left + corner)@(top )) .
		aGC displayLineFrom:  ((left + corner)@(top )) to:  ((right - corner)@(top )) .
		aGC displayLineFrom: ((right - corner)@(top )) to:  (right @ (top + corner)) .
		aGC displayLineFrom: ((right@(bottom - bottomAdjust))) to: (right @ (top + corner)) .
	aGC paint: ColorValue white.
		aGC displayLineFrom: ((left+1)@bottom) to: ((left+1)@(top + corner)) .
		aGC displayLineFrom: ((left+2)@bottom) to: ((left+2)@(top + corner)) .
		aGC displayLineFrom: ((left+1)@(top + corner)) to: ((left+corner)@(top +1)) .
		aGC displayLineFrom: ((left+2)@(top + corner)) to: ((left+corner)@(top +2)) .
		aGC displayLineFrom: ((left+corner)@(top + 1)) to: ((right-corner)@(top +1)) .
	aGC paint: ColorValue lightGray.
		aGC displayLineFrom:  ((right - corner  )@(top + 3 )) to:  ((right - 1)@(top + corner + 1)).
		aGC displayLineFrom: (((right-1)@(top + corner))) to: ((right-1) @ (bottom - 1)) .
 		aGC displayLineFrom: (((right-2)@(top + corner))) to: ((right-2) @ (bottom - 1)) .
 	aGC paint:   aGC medium backgroundColor. 
 	aGC  displayLineFrom: (((right - 1 )@(bottom))) to: ((left + 2) @ (bottom )) .
	"<<BIKI at the bottom of a mountain: 6 January 1996,10:23:05 pm, version: 22>>"!

displayOn: aGraphicsContext
	"Display on aGraphicsContext in my bounds."

	| left right top bounds clippingBox tabInsideDisplayContext tabClippingBox hasBackgroundColor  |  
	hasBackgroundColor := state isOpaque or: [state hasBackgroundColor].
	self validateScrollPosition.
	bounds := self bounds.
	hasBackgroundColor
		ifTrue: [aGraphicsContext paint: self backgroundColor.
				BottomMask displayOn: aGraphicsContext.
				aGraphicsContext displayRectangle: (18@0 corner: bounds right@(18))].
	clippingBox := aGraphicsContext clippingBounds.
	left := bounds left + 1.
	right := bounds right.
	top := bounds bottom -1.
	bounds bottom.
	aGraphicsContext paint: self borderColor.
	
 	aGraphicsContext displayRectangle: ((left - 0)@ (top- 1) corner: right @ (top )). 
	aGraphicsContext displayLineFrom:  (bounds left + 0) @ ( bounds bottom -1  ) 
							to:  (bounds left +1) @ ( bounds bottom ) . 

	aGraphicsContext paint: ColorValue white.
	aGraphicsContext 
		displayRectangle: ( (bounds left + 1) @ ( bounds bottom -1  ) 
							corner: right @ ( bounds bottom ) ).
	aGraphicsContext paint: self borderColor.
	self numberOfElements = 0 ifTrue: [^self].
	self isScrollingTabs
		ifTrue: [hasBackgroundColor
					ifTrue: [aGraphicsContext paint: self backgroundColor.
							aGraphicsContext
								displayRectangle: (self decrementTabButtonBox origin extent: LeftScrollButtonImage extent).
							aGraphicsContext
								displayRectangle: (self incrementTabButtonBox origin extent: RightScrollButtonImage extent)].
			tabClippingBox := self tabClippingBoxWhenScrolling.
			aGraphicsContext paint: self scrollButtonColor.
			LeftScrollButtonImage displayOn: aGraphicsContext at: self decrementTabButtonBox origin.
			RightScrollButtonImage displayOn: aGraphicsContext at:  self incrementTabButtonBox origin]	
		ifFalse: [tabClippingBox := bounds].

	tabClippingBox height < 2 ifTrue: [ ^self ].
	
	tabInsideDisplayContext := aGraphicsContext copy paint: self tabColor.
	1 to: self numberOfElements do: [:i | 
		| box | 
		box := self boundsOfElementIndex: i inBounds: bounds.
		box right: box right - self gapBetweenTabs.
		box right > tabClippingBox right ifTrue: [^self].
		((clippingBox intersects: box) and: [box width > 0]) ifTrue: [
			"aGraphicsContext paint: self borderColor.
			aGraphicsContext displayInteriorRectangularBorder: box."
			box := box insetBy: (Rectangle left: 1 right: 1 top: 0 bottom: 1).
			tabInsideDisplayContext displayRectangle: box.
			aGraphicsContext paint: self foregroundColor.
 
			(self visualComponentForElementIndex: i inBounds: box) displayOn: aGraphicsContext copy.
			box left: box left -1.
			box right: box right +0.
			box bottom: (box bottom min: bounds bottom -1).
			self displayInteriorRectangularBorderOn: aGraphicsContext in: box selected: i = selectionIndex].
		"displayInteriorRectangularBorderForHorizontalBar:"]

	"<<Stefke thinks ... he has a lookingglass: 2 May 1996,11:00:43 am, version: 22>>"! !

!HorizontalTabBarViewOOP methodsFor: 'private'!

boundsOfElementIndex: anElementIndex inBounds: aRectangle 
	"Answer the bounding box of line anElementIndex."

	| lineGrid scrollButtonMargin tabScrollPositionOffset | 
	"Can not use isScrollingTabs because computeTabScrollPosition needs to use this method."
	tabScrollPosition ~= 0
		ifTrue: [
			scrollButtonMargin := self tabScrollButtonMargin.
			tabScrollPositionOffset := tabScrollPosition - 1]
		ifFalse: [
			scrollButtonMargin := 0.
			tabScrollPositionOffset := 0].
	tabWidth == nil ifFalse: [
		| level | 
		level := self levelOfElement: anElementIndex.
		lineGrid := self lineGrid.
		^(Rectangle origin: anElementIndex - tabScrollPositionOffset - 1 * tabWidth + self leftOffsetForDisplay + scrollButtonMargin @ (level * 2) extent: tabWidth @ lineGrid)].
	cacheIndex = anElementIndex ifTrue: [^(cacheBox ) copy].
	lineGrid := self lineGrid.
	anElementIndex < (tabScrollPositionOffset + 1) ifTrue: [ 
		"Tab is beyond the left edge and not even displayed."
		cacheIndex := anElementIndex.
		cacheBox := Rectangle origin: self leftOffsetForDisplay + scrollButtonMargin@aRectangle top extent: 0@aRectangle height.
		cacheVisual := nil.
		^(cacheBox ) copy].
	(cacheIndex == nil or: [anElementIndex < cacheIndex]) ifTrue: [
		cacheIndex := tabScrollPositionOffset.
		cacheBox := Rectangle origin: self leftOffsetForDisplay + scrollButtonMargin@aRectangle top extent: 0@aRectangle height.
		cacheVisual := nil].
	[cacheIndex < anElementIndex] whileTrue: [
		| level  width|
		cacheIndex := cacheIndex + 1.
		cacheVisual := self visualComponentForElementIndex: cacheIndex. 
		width := self widthFor: cacheVisual . 
		level := self levelOfElement: anElementIndex.
		cacheBox := Rectangle origin: cacheBox right @ (6-level) 
				corner: (cacheBox right+ width + 4) @ (aRectangle height - 12+ (level*2 ))].
	cacheVisual bounds: (cacheBox ) . 
	^(cacheBox ) copy
  

	"<<BIKI: 4 February 1996,1:08:00 pm, version: 6>>"!

casheBoxOffset
 	^0@0

	"<<BIKI at the bottom of a mountain: 5 January 1996,3:35:46 pm, version: 5>>"!

levelOfElement: index 
	^index == selectionIndex
		ifTrue: [self numberOfVisiblePages]
		ifFalse: [self numberOfVisiblePages - 1]  
 

	"<<BIKI at the bottom of a mountain: 6 January 1996,8:16:22 pm, version: 4>>"!

visualComponentForElementIndex: anIndex inBounds: box

	| vc |   
	cacheIndex = anIndex ifTrue: [^cacheVisual].
	vc := self visualComponentForElementIndex: anIndex. 
	vc bounds:box . 
	^vc

	"<<BIKI 'please dont remove this button': 21 January 1996,7:03:49 pm, version: 8>>"!

widthFor: aVisual 

	^true 
		ifTrue: [	cachedWidth isNil
				ifTrue: [
					cachedWidth := 0.
					1 	to:  self numberOfElements
						do:[ :i | cachedWidth := cachedWidth 
								max: (self visualComponentForElementIndex: i )preferredBounds width].  cachedWidth]
				ifFalse: [cachedWidth]
					]
		ifFalse: [aVisual preferredBounds width]

	"<<BIKI 'please dont remove this button': 21 January 1996,7:03:50 pm, version: 7>>"! !

!HorizontalTabBarViewOOP methodsFor: 'private-tab scrolling'!

computeTabScrollPositionFor: anIndex
	"Compute the proper value for the tab scroll position."

	| boundsWidth usableHeight possibleTabs totalTabs maxTabWidth bounds |  
	bounds := self bounds.
	boundsWidth := bounds width.
	usableHeight := boundsWidth - self leftOffsetForDisplay - self rightOffsetForDisplay.
	maxTabWidth := possibleTabs := 0.
	1 to: self numberOfElements do: [:index |
		maxTabWidth := maxTabWidth max: (self boundsOfElementIndex: index inBounds: bounds) width].
	maxTabWidth isZero ifFalse: [possibleTabs := usableHeight // maxTabWidth].
	totalTabs := self numberOfElements.
	totalTabs > possibleTabs
		ifFalse: [tabScrollPosition := 0]
		ifTrue: [
			| end |
			tabScrollPosition = 0 ifTrue: [tabScrollPosition := 1].
			usableHeight := usableHeight - self tabScrollButtonMargin.
			end := (tabScrollPosition + possibleTabs - 1) min: totalTabs.
			"tabScrollPosition :=
				(anIndex between: tabScrollPosition and: end)
					ifTrue: [tabScrollPosition]
					ifFalse: [(anIndex > end
								ifTrue: [tabScrollPosition + (anIndex - end)]
								ifFalse: [anIndex]) max: 1]"].
	tabScrollPositionKnown := true

	"<<BIKI at the bottom of a mountain: 5 January 1996,2:57:07 pm, version: 4>>"!

decrementTabButtonBox
	"Answer the rectangle bounds of the tab scrolling button that decrements the tabScrollingPosition."

	^Rectangle origin: self bounds topLeft + (2@(self bounds bottom - 20)) extent: LeftScrollButtonImage extent

	"<<BIKI at the bottom of a mountain: 8 January 1996,9:49:28 am, version: 6>>"!

incrementTabButtonBox
	"Answer the rectangle bounds of the tab scrolling button that increments the tabScrollingPosition."

	"This isn't the correct position but the correct position is outside my bounds."
	^Rectangle origin: self bounds topRight + (RightScrollButtonImage width negated@((self bounds bottom - 20))) extent: RightScrollButtonImage extent

	"<<BIKI at the bottom of a mountain: 8 January 1996,9:49:45 am, version: 3>>"!

invalidateTabsForScrolling
	"Invalidate the area where the tabs are displayed because they are being scrolled."

	cacheIndex := nil.
	self invalidateRectangle: self tabClippingBoxWhenScrolling!

tabClippingBoxWhenScrolling
	"Answer the rectangle inside self bounds where the tabs are displayed when they are being scrolled."

	^self bounds insetBy: (Rectangle
		left: self leftOffsetForDisplay + self tabScrollButtonMargin
		right: 0
		top: 0 bottom: 0)! !

!HorizontalTabBarViewOOP methodsFor: 'accessing'!

selectionIndex: elementIndex
	"Set the index of the selected item.
	If elementIndex is not zeroIndex then move the target index to
	correspond to the new selection index.  If the elementIndex is
	the zeroIndex then leave the target index where it was."

	|     box old gc left right lb rb |
	((selectionIndex = elementIndex) or: [sequence == nil]) ifTrue: [^self].
	box := self bounds.
	old := selectionIndex max: 1.
	selectionIndex := elementIndex max: 1.
	self numberOfElements = 0 ifTrue: [^self invalidate].
	old < selectionIndex
		ifTrue: [left := old.
				right := selectionIndex + self numberOfVisiblePages min: self numberOfElements]
		ifFalse: [left := selectionIndex.
				right := old + self numberOfVisiblePages min: self numberOfElements].
	lb := self boundsOfElementIndex: left inBounds: box.
	rb := self boundsOfElementIndex: right inBounds: box.
	box :=lb left @ box top corner: rb right@box bottom.
	(state isOpaque or: [state hasBackgroundColor]) 
		ifTrue: [^self invalidateRectangle: box repairNow: true].
	gc := self graphicsContext.
	gc paint: self backgroundColor.
	gc displayRectangle: box.
	gc paint: self foregroundColor.
	self displayOn: gc.! !

!HorizontalTabBarViewOOP methodsFor: 'element accessing'!

elementIndexFor: aPoint
	"Answer the index of the element positioned relative to aPoint, counting from zero."

	| box eb |
	tabWidth == nil
		ifFalse: [	^(aPoint x - self leftOffsetForDisplay) // tabWidth + 1].
	box := self bounds.
	1 to: self numberOfElements do:
		[:i |
		eb := self boundsOfElementIndex: i inBounds: box.
		(aPoint x between: eb left and: eb right)
			ifTrue: [^i]].
	^0! !

!HorizontalTabBarViewOOP methodsFor: 'initialize-release'!

setTabWidth: anInteger

	tabWidth := anInteger! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

HorizontalTabBarViewOOP class
	instanceVariableNames: ''!


!HorizontalTabBarViewOOP class methodsFor: 'resources'!

leftArrowForNoteBook
	"UIMaskEditor new openOnClass: self andSelector: #leftArrowForNoteBook"

	<resource: #image>
	^CachedImage on: (Image extent: 6@13 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 4 put: ColorValue white; yourself)) usingBits: #[170 192 0 0 171 64 0 0 173 64 0 0 181 64 0 0 213 64 0 0 85 64 0 0 149 64 0 0 165 64 0 0 169 64 0 0 170 64 0 0 170 128 0 0 170 160 0 0 170 160 0 0])

	"<<BIKI lost in space: 24 February 1996,12:49:24 am, version: 1>>"!

rightArrowForNoteBook
	"UIMaskEditor new openOnClass: self andSelector: #rightArrowForNoteBook"

	<resource: #image>
	^CachedImage on: (Image extent: 6@13 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 2 put: ColorValue black; at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); yourself)) usingBits: #[143 240 0 0 131 240 0 0 128 240 0 0 128 48 0 0 128 0 0 0 128 16 0 0 128 112 0 0 129 240 0 0 135 240 0 0 159 240 0 0 255 240 0 0 255 240 0 0 255 240 0 0])

	"<<BIKI lost in space: 24 February 1996,12:46:15 am, version: 1>>"! !

!HorizontalTabBarViewOOP class methodsFor: 'initialization'!

initialize 
	"Initialize the class."
	"HorizontalTabBarViewOOP initialize."

	RightScrollButtonImage := self rightArrowForNoteBook.
	LeftScrollButtonImage := self leftArrowForNoteBook.
	BottomMask :=	CachedImage on: (Image extent: 18@17 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[127 255 192 0 63 255 192 0 31 255 192 0 15 255 192 0 7 255 192 0 3 255 192 0 1 255 192 0 0 255 192 0 0 127 192 0 0 63 192 0 0 31 192 0 0 15 192 0 0 7 192 0 0 3 192 0 0 1 192 0 0 0 192 0 0 0 64 0 ])! !

UIDefiner subclass: #UIBDefiner
	instanceVariableNames: 'uibPropertyBindings adaptors models '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Builder/Definer'!
UIBDefiner comment:
'I extend my superclass with enhanced definer operations.

Instance variables:
	uibPropertyBindings	<>
	adaptors				<UIBAspectDictionary>
	models 				<UIBAspectDictionary>'!


!UIBDefiner methodsFor: 'private'!

enumeratorClass

	^UIBAspectEnumerator!

expandPaths: bindingSlots

	| slotNames results |
	slotNames := Set new.
	results := Set new.
	(bindingSlots reject: [:slot| slot key isKindOf: UIBPropertyModel])
		do:
		[:slot |
		| aspect |
		aspect := (self aspectPathClassFor: aClass) forAspect: slot key fromBuilder: nil.
		aspect tail notNil
			ifTrue:
				[slotNames add: aspect head.
				aspect trigger notNil ifTrue: [slotNames add: aspect trigger]]
			ifFalse:
				[results add: slot]].
	slotNames do: [:slnm | results add: slnm -> nil asValue].
	^results!

initStringForModel: modelSlot on: aStream

	aStream
		nextPutAll: modelSlot value;
		space; nextPutAll: 'new'!

initStringForValue: valueSlot on: aStream
	"Overridden here in order to use special initialization strings for models of property fields
	and adaptors for aspects that need one (specified by the user)."

	| property adaptorSpec |
	(property := uibPropertyBindings at: valueSlot key ifAbsent:[nil]) isNil
		ifFalse:[^aStream nextPutAll: property initializationString].
	adaptorSpec := adaptors at: valueSlot key ifAbsent: [^super initStringForValue: valueSlot on: aStream].
	adaptorSpec initializationStringFor: valueSlot value on: aStream!

interactivelyUpgradeDefns: selectionList for: aController
	"NB: if necessary this can be modified so that each and every internal
	aspect of a detail is shown in the define dialog, by linking them all to
	the selfsame spec object and identifying them in terms of the associated
	spec object at generation time (i.e. we tell that fooChannel is the channel
	aspect by finding it at the channel place inside the associated spec)."

	| enum requiredBindings bindingsWantingDefinition modelsToDefine tmp choice windowSpec |
	aController model targetTrouble
		ifTrue:
			[(UIPainter preferenceFor: #installForDefine)
				ifTrue:
					[(aController model installFor: aController) isNil
						ifTrue: [^self]]
				ifFalse:
					[Dialog warn: 'The canvas isn''t installed on any class' for: aController view.
					^self]].
	adaptors := ((windowSpec := aController model makeWindowSpec) isKindOf: UIBWindowSpec)
		ifTrue:[windowSpec adaptors]
		ifFalse:[UIBAspectDictionary new].
	models := (windowSpec isKindOf: UIBWindowSpec)
		ifTrue:[windowSpec models]
		ifFalse:[UIBAspectDictionary new].
	(enum := self enumeratorClass new source: aController model builder source).
	selectionList isEmpty
		ifTrue:
			[enum doSpec: (aController model extractFullSpec)]
		ifFalse:
			[selectionList do:
				[:sw |
				enum doSpec: sw extractedSpec]].
	requiredBindings := enum actions.
	requiredBindings addAll: (self expandPaths: enum bindings associations).
	requiredBindings addAll: (self expandDetails: enum details associations).
	requiredBindings addAll: (enum clients associations).
	requiredBindings addAll: (enum details associations).
	requiredBindings addAll: models associations.
	
	"Filter out those messages that must be inherited from LensDataManager."
	(self does: aClass inheritFromClassNamed: #LensApplicationModel)
		ifTrue:
			[requiredBindings associations do:
				[:assn |
				(aClass excludedBindings includes: assn key)
					ifTrue: [requiredBindings removeKey: assn key]]].

	(requiredBindings isEmpty and: [enum incompletes isEmpty])
		ifTrue:
			[self warnNoRequiredBindingsFor: selectionList.
			^self].
	(self
			alertForMissingProperties: enum incompletes
			among: selectionList
			withNumberRequired: requiredBindings size + enum incompletes size
			for: aController)
		ifFalse:
			[^self].
	(aController canvasHasChanged and: [UIPainter preferenceFor: #installForDefine])
		ifTrue:
			[(choice :=
				Dialog
					choose: 'The canvas has changed since it was last installed.
Install before defining models?'
					labels: #('Install First' 'Define As Is' 'Cancel')
					values: #(#install #define #cancel)
					default: #define
					for: aController view) == #cancel
				ifTrue: [^self].
			(choice == #install and:
				[(aController model installFor: aController) isNil]) 
				ifTrue:
					[^self]].	
	tmp := IdentityDictionary new.
	tmp addAll:
		(self excludedBindings associations reject:
			[:assn |
			((requiredBindings includesKey: assn key) not or:
				[((requiredBindings at: assn key)
					isKindOf: assn value class) not])]).
	self excludedBindings: tmp.
	bindingsWantingDefinition :=
		requiredBindings associations select:
			[:bndg | (self excludedBindings includesKey: bndg key) not].
	modelsToDefine :=
		self
			openDefinitionDialogOn:
				(requiredBindings associations collect: [:bndg | bndg key]) asSortedCollection
			selecting: (bindingsWantingDefinition collect: [:bndg | bndg key]).
	modelsToDefine isNil ifTrue: [^self].
	uibPropertyBindings := IdentityDictionary new: enum bindingPropertyAssociations size.
	(modelsToDefine select:[:mdl| enum bindingPropertyAssociations includesKey: mdl])
		do:[:mdl|uibPropertyBindings at: mdl put: (enum bindingPropertyAssociations at: mdl)].
	self
		define:
			(modelsToDefine collect:
				[:mdl | requiredBindings associationAt: mdl])
		for: aController.
	requiredBindings associations do:
		[:bndg |
		(modelsToDefine includes: bndg key)
			ifTrue: [excludedBindings removeKey: bndg key ifAbsent: []]
			ifFalse: [excludedBindings add: bndg]]!

writeAccessor: aspect for: assn initGen: initStringMethod on: aStream
	"Overridden here in order to use our own comment string."

	aStream cr; cr; nextPutAll: aspect.
	self initializeModels value
		ifTrue:
			[aStream cr; tab;
				nextPutAll: '"This method was generated by '; nextPutAll: self class name; nextPutAll:'.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."']
		ifFalse:
			[aStream cr; tab;
				nextPutAll: '"This method was generated by '; nextPutAll: self class name; nextPutAll:'.  Any edits made here
	may be lost whenever methods are automatically defined."'].
	aStream cr; cr; tab;
		nextPutAll: '^' , aspect.
	self initializeModels value
		ifTrue:
			[aStream
				nextPutAll: ' isNil';
				cr; tab; tab;
				nextPutAll: 'ifTrue:';
				cr; tab; tab; tab;
				nextPut: $[; nextPutAll: aspect; nextPutAll: ' := '.
			self perform: initStringMethod with: assn with: aStream.
			aStream
				nextPut: $];
				cr; tab; tab;
				nextPutAll: 'ifFalse:';
				cr; tab; tab; tab;
				nextPut: $[; nextPutAll: aspect; nextPut: $]].
	aStream nextPut: $!!!

writeDefinitions: bindings for: aController
	"bindings includes all required bindings in the selection set
	that the user has not specifically disallowed.  Test to see whether
	instance variables are already there.  Must check to see whether
	action methods are already there, and do not redefine them if they
	exist.  Always redefine aspect methods against the possibility that
	the type of the model has changed.

	NB: aspect methods incorporate lazy instVar initialization."

	| allnames actionSlots valueSlots listSlots tableSlots clientSlots dsvSlots detailSlots ivNames detailVars codeStream allDetails aspectBindings modelSlots |
	allnames := aClass allInstVarNames asSet.
	aspectBindings := bindings reject:[:binding| models includesKey: binding key].
	modelSlots := bindings select:[:binding| models includesKey: binding key].
	actionSlots := aspectBindings select: [:e | e value isKindOf: BlockClosure].
	valueSlots := aspectBindings select: [:e | e value isKindOf: ValueModel].
	listSlots := aspectBindings select: [:e | e value isKindOf: SelectionInList].
	tableSlots := aspectBindings select: [:e | e value isKindOf: TableInterface].
	clientSlots := aspectBindings select: [:e | e value isKindOf: Symbol].
	dsvSlots := aspectBindings select: [:e | e value isKindOf: DataSetSpec].
	detailSlots := aspectBindings select:
		[:e | self isDataFormSpec: e value].
	detailVars := self findDetailVars: detailSlots.
	ivNames :=
		(((modelSlots, valueSlots, listSlots, tableSlots, clientSlots, dsvSlots) collect: [:e | e key ]), detailVars
			select: [:e | (allnames includes: e asString) not]) asSet.
	codeStream := String new writeStream.
	self writeClassDefiningMessageForIVs: ivNames on: codeStream.
	self writeModels: modelSlots on: codeStream.
	self writeAccessorsForClients: clientSlots andDetails: detailSlots on: codeStream.
	self
		writeSimpleActions: actionSlots
		andDetailActions: detailSlots
		on: codeStream.
	self
		writeSimpleAspects: valueSlots
		andListAspects: listSlots
		andTableAspects: tableSlots
		andDSVAspects: dsvSlots
		on: codeStream.
	
	allDetails := 
		(self enumeratorClass new source: aController model builder source)
			doSpec: aController model extractFullSpec; details.
	(self does: aClass inheritFromClassNamed: #LensApplicationModel)
		ifTrue:
			[self
				writeMixinQueryMethods: detailSlots on: codeStream.

			"The private methods must be written to take into account all details
			on the canvas, not just those currently selected."

			self writePrivateMethods: allDetails for: aController on: codeStream]
		ifFalse:
			[allDetails isEmpty not
				ifTrue:
					[Dialog warn:
'A complete set of definitions could not be generated
to support the Data Form(s) being defined for, because
this canvas is installed on a non-database class.  You
should reinstall the canvas on a new class that is either
a Data Form or a Database Application, and try again.']].
		
	^codeStream contents!

writeModels: modelSlots on: aStream 

	modelSlots isEmpty ifTrue: [^self].
	aStream cr; cr; nextPut: $!!; nextPutAll: aClass name; nextPutAll: ' methodsFor: ''models''!!'.
	self writeAccessorsFor: modelSlots initGen: #initStringForModel:on: on: aStream.
	modelSlots
		do: 
			[:mdl| ].
	aStream nextPutAll: ' !!'!

writeSimpleActionPattern: aSymbol on: aStream
	"Write an appropriate pattern for the given Symbol on the given stream.
	Examples:	#x		->		x
				#x:		->		x: aValue
				#x:y:	->		x: value1 y: value2"

	aSymbol isKeyword
		ifFalse:[	aStream nextPutAll: aSymbol]
		ifTrue:[	|keywords|
				(keywords := aSymbol keywords) size > 1
					ifFalse:[	aStream nextPutAll: (keywords at: 1); nextPutAll: ' aValue']
					ifTrue:[	|count|
							count := 1.
							keywords do:[:keyword|
								aStream
									nextPutAll: keyword;
									nextPutAll:' value';
									nextPutAll: count printString;
									space.
								count := count + 1]]]!

writeSimpleActions: actionSlots on: aStream

	actionSlots isEmpty ifTrue: [^self].
	actionSlots
		do:
			[:actn || property |
			self writeSimpleActionPattern: actn key on: aStream.
			aStream
				cr; tab;
				nextPutAll: '"This stub method was generated by UIBDefiner"';
				cr; cr; tab; nextPut: $^.
				(property := uibPropertyBindings at: actn key ifAbsent:[nil]) isNil
					ifTrue:[aStream nextPutAll: 'self']
					ifFalse:[aStream nextPutAll: property initializationString].
				aStream nextPut:$!!]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBDefiner class
	instanceVariableNames: ''!


!UIBDefiner class methodsFor: 'interface specs'!

defineDialogSpec
	"UIBPainter new openOnClass: self andSelector: #defineDialogSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 242 242 ) 
			#max: #(#Point 242 242 ) 
			#bounds: #(#Rectangle 69 76 311 318 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 3 12 ) 
					#label: 'DEFINE Models, Aspects and Actions' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -82 0.5 -35 1 -16 0.5 -5 1 ) 
					#name: #okButton 
					#model: #doOK 
					#label: 'OK' 
					#isDefault: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 16 0.5 -35 1 82 0.5 -5 1 ) 
					#name: #cancelButton 
					#model: #doAbort 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 16 0 38 0 -14 1 -89 1 ) 
					#model: #modelList 
					#multipleSelections: true ) 
				#(#CheckBoxSpec 
					#layout: #(#AlignmentOrigin 16 0 -73 1 0 0 ) 
					#model: #addInitialization 
					#label: 'Add Initialization' ) ) ) )!

smallDefineDialogSpec
	"UIBPainter new openOnClass: self andSelector: #smallDefineDialogSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 241 160 ) 
			#max: #(#Point 241 160 ) 
			#bounds: #(#Rectangle 95 219 336 379 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 14 0 12 0 ) 
					#label: 'DEFINE Model, Aspect or Action' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -82 0.5 -35 1 -16 0.5 -5 1 ) 
					#name: #okButton 
					#model: #doOK 
					#label: 'OK' 
					#isDefault: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 16 0.5 -35 1 82 0.5 -5 1 ) 
					#name: #cancelButton 
					#model: #doAbort 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 16 0 38 0 -15 1 -95 1 ) 
					#flags: 12 
					#model: #modelList 
					#multipleSelections: true ) 
				#(#CheckBoxSpec 
					#layout: #(#AlignmentOrigin 16 0 -73 1 0 0 ) 
					#model: #addInitialization 
					#label: 'Add Initialization' ) ) ) )! !

UIBApplicationModel subclass: #UIBIconEditor
	instanceVariableNames: 'magnifiedBitView icon doTheCurrentColor colorHolder '
	classVariableNames: 'PasteBuffer '
	poolDictionaries: ''
	category: 'UIB-Support'!


!UIBIconEditor methodsFor: 'change messsages'!

colorHolderChanged

	self colorHolder value ifTrue: [self enableColor] ifFalse: [self disableColor]!

iconHolderChanged

	self setupBitView! !

!UIBIconEditor methodsFor: 'initialize-release'!

color: aBooleanHolder

	colorHolder := aBooleanHolder.
	colorHolder onChangeSend: #colorHolderChanged to: self!

grid: anInteger

	self magnifiedBitView gridding: (anInteger < 1 ifTrue: [1@1] ifFalse: [anInteger @ anInteger])!

icon: anImageHolder

	icon retractInterestsFor: self.
	icon := anImageHolder.
	self setupBitView.
	icon onChangeSend: #iconHolderChanged to: self!

icon: anImageHolder inColor: aBoolean

	self icon: anImageHolder.
	aBoolean ifTrue:[self enableColor] ifFalse:[self disableColor]!

initialize

	self color: true asValue.
	magnifiedBitView := ColorBitView new.
	magnifiedBitView changedPreferredBounds: nil.
	self scale: 6; grid: 13.
	icon := ValueHolder with: (self class emptyIcon image convertToPalette: self preferredPalette).
	icon onChangeSend: #iconHolderChanged to: self!

releaseDependencyRelationShips

	self colorHolder retractInterestsFor: self.
	icon retractInterestsFor: self!

scale: anInteger

	self magnifiedBitView scale: (anInteger < 1 ifTrue: [1@1] ifFalse: [anInteger @ anInteger])! !

!UIBIconEditor methodsFor: 'actions'!

doAccept

	self magnifiedBitView controller imageHasChanged
		ifTrue:[	self magnifiedBitView controller imageHasChanged: false.
				self
					retractInterest: #iconHolderChanged
					from: self iconHolder
					while: [icon value: self magnifiedBitView model copy]]!

doCancel

	self magnifiedBitView controller imageHasChanged
		ifTrue:[	magnifiedBitView model: icon value copy; changedPreferredBounds: nil;invalidate.
				self magnifiedBitView controller imageHasChanged: false]!

doCapture

	| rect image |
	"self changeRequest ifFalse: [^self]."
	rect := self getIconScreenRectangle.
	(rect height == 0 or: [rect width == 0 or: [rect extent = (1@1)]])
		ifTrue: [^self].
	image := Screen default completeContentsOfArea: rect.
	image extent = (1@1) ifTrue: [^self].
	magnifiedBitView model: image; changedPreferredBounds: nil; invalidate.
	self magnifiedBitView controller imageHasChanged: true!

doCopy

	| image r newMap |
	r := Rectangle
			fromUser: magnifiedBitView scale
			phase: magnifiedBitView controller sensor globalOrigin.
	r extent = magnifiedBitView scale ifTrue: [^self].
	(self apertureIntersectsWithScreenRectangle: r) ifFalse: [^self].
	r := self modelRegionFromScreenRegion: r.
	image := magnifiedBitView model.
	newMap :=
		Image
			extent: r extent
			depth: image depth
			bitsPerPixel: image bitsPerPixel
			palette: image palette.
	newMap
		copy: (Rectangle origin: 0 @ 0 corner: r extent)
		from: r origin
		in: image
		rule: RasterOp paint.
	self pasteBuffer: newMap!

doCut

	| image r newMap worker |
	r := Rectangle
			fromUser: magnifiedBitView scale
			phase: magnifiedBitView controller sensor globalOrigin.
	r extent = magnifiedBitView scale ifTrue: [^self].
	(self apertureIntersectsWithScreenRectangle: r) ifFalse: [^self].
	r := self modelRegionFromScreenRegion: r.
	image := magnifiedBitView model.
	newMap :=
		Image
			extent: r extent
			depth: image depth
			bitsPerPixel: image bitsPerPixel
			palette: image palette.
	newMap
		copy: (Rectangle origin: 0 @ 0 corner: r extent)
		from: r origin
		in: image
		rule: RasterOp paint.
	self pasteBuffer: newMap.
	worker := 
		Image
			extent: 1@1
			depth: image depth
			bitsPerPixel: image bitsPerPixel
			palette: image palette.
	worker atPoint: 0@0 put: (image palette indexOf: ColorValue white).
	image tile: r from: 0@0 in: worker rule: RasterOp over.
	magnifiedBitView model: image; invalidate.
	self magnifiedBitView controller imageHasChanged: true!

doFillCurrentColor

	self fillWith: magnifiedBitView controller currentColor.
	self magnifiedBitView controller imageHasChanged: true!

doPaste

	| bufferBounds buffer ctrlr origin bltOrigin r model |
	(buffer := self pasteBuffer) isNil ifTrue: [^self].
	(bufferBounds := buffer bounds scaledBy: magnifiedBitView scale) isNil
		ifTrue: [^self].
	ctrlr := magnifiedBitView controller.
	origin := self getScreenRectangleOfWidth: bufferBounds width andHeight: bufferBounds height.
	(self apertureIntersectsWithScreenRectangle:
			(Rectangle origin: origin extent: bufferBounds extent))
		ifFalse: [^self].
	bltOrigin := (origin - ctrlr sensor globalOrigin) scaledBy: 1 /magnifiedBitView scale.
	r := Rectangle origin: bltOrigin extent: bufferBounds width @ bufferBounds height.
	r extent = (1@1) ifTrue: [^self].
	model := magnifiedBitView model.
	model copy: r from: 0@0 in: buffer rule: RasterOp over.
	magnifiedBitView model: model; invalidate.
	self magnifiedBitView controller imageHasChanged: true!

doToCurrentColor

	self toColor: magnifiedBitView controller currentColor.
	self magnifiedBitView controller imageHasChanged: true!

maskify

	| newImage oldImage colorWhite colorBlack takeBuffer putBuffer |
	oldImage := self magnifiedBitView model copy.
	newImage := oldImage copy.
	Cursor execute showWhile:
		[colorWhite := oldImage palette indexOf: ColorValue white.
		colorBlack := oldImage palette indexOf: ColorValue black.
		takeBuffer := Array new: oldImage width.
		putBuffer := Array new: oldImage width.
		0 to: newImage height -1 do:
			[:rowIndex |
			oldImage rowAt: rowIndex into: takeBuffer.
			1 to: takeBuffer size do:
				[:colIndex |
				(takeBuffer at: colIndex) = colorWhite
					ifTrue: [putBuffer at: colIndex put: colorWhite]
					ifFalse: [putBuffer at: colIndex put: colorBlack]].
		newImage rowAt: rowIndex putAll: putBuffer].
		self magnifiedBitView model: newImage; changedPreferredBounds:nil; invalidate.
		"directBitView model: newImage; changedPreferredBounds:nil; invalidate"].
	self modified: true! !

!UIBIconEditor methodsFor: 'accessing'!

magnifiedBitView

	^magnifiedBitView! !

!UIBIconEditor methodsFor: 'aspects'!

doTheCurrentColor
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^doTheCurrentColor isNil
		ifTrue:
			[doTheCurrentColor := String new asValue]
		ifFalse:
			[doTheCurrentColor]! !

!UIBIconEditor methodsFor: 'components'!

colorButtons
	
	^#(#grey #red #yellow #green #cyan #blue #magenta #darkGrey #darkRed #darkYellow #darkGreen #darkCyan #darkBlue #darkMagenta)!

disableColor
	
	self setColorFor: #black.
	self colorButtons
		do: 
			[:n | 
			(builder componentAt: n) beInvisible.
			(builder componentAt: n) disable]!

enableColor
	
	self colorButtons
		do: 
			[:n | 
			(builder componentAt: n) enable.
			(builder componentAt: n) beVisible]! !

!UIBIconEditor methodsFor: 'private'!

apertureIntersectsWithScreenRectangle: aRectangle

	| viewOrigin|
	viewOrigin :=
		aRectangle origin -
			((builder componentAt: #magnifiedBitView)  component bounds origin +
				magnifiedBitView topComponent globalOrigin + (4@3)).
	^((Rectangle
		origin: (magnifiedBitView localPointToGlobal: 0@0)"origin of bitView in window coordinates"
		extent: magnifiedBitView bounds extent)
	intersects:
		(Rectangle origin: viewOrigin extent: aRectangle extent))!

colorHolder

	^colorHolder!

fillWith: aColorIndex

	| r image worker |
	r := Rectangle
			fromUser: magnifiedBitView scale
			phase: magnifiedBitView controller sensor globalOrigin.
	r extent = magnifiedBitView scale ifTrue: [^self].
	(self apertureIntersectsWithScreenRectangle: r) ifFalse: [^self].
	r := self modelRegionFromScreenRegion: r.
	image := magnifiedBitView model.
	worker := 
		Image
			extent: 1@1
			depth: image depth
			bitsPerPixel: image bitsPerPixel
			palette: image palette.
	worker atPoint: 0@0 put: aColorIndex.
	image tile: r from: 0@0 in: worker rule: RasterOp over.
	magnifiedBitView model: image; invalidate!

getIconScreenRectangle

	^Rectangle origin:(
	Cursor crossHair showWhile: [
	Screen default
		dragShape: (Rectangle origin: 0@0 extent: 26@26) asPointArray
		offset: 0@0
		gridPhase:
			0@0
		gridSpacing: 1@1
		boundedBy: nil
		whileButton: 0
		isDown: false])
	extent: 26@26!

getScreenRectangleOfWidth: width andHeight: height

	^Screen default
		dragShape: (Rectangle origin: 0@0 extent: width@height) asPointArray
		offset: 0@0
		gridPhase:
			(magnifiedBitView localPointToGlobal: 0@0) +
				magnifiedBitView topComponent globalOrigin
		gridSpacing: magnifiedBitView scale
		boundedBy: nil
		whileButton: 0
		isDown: false.!

iconHolder

	^icon!

modelRegionFromScreenRegion: aRectangle

	| r |
	r := aRectangle translatedBy:
			magnifiedBitView controller sensor globalOrigin negated.
	r := r scaledBy: 1 / magnifiedBitView scale.
	^r!

pasteBuffer

	^PasteBuffer!

pasteBuffer: anImage

	PasteBuffer := anImage!

preferredPalette

	^MappedPalette withColors: ((Array new: 16)
						at: 1 put: ColorValue black;
						at: 2 put: ColorValue darkGray;
						at: 3 put: ColorValue white;
						at: 4 put: ColorValue red;
						at: 5 put: ColorValue olive;
						at: 6 put: ColorValue green;
						at: 7 put: ColorValue blue;
						at: 8 put: ColorValue darkCyan;
						at: 9 put: ColorValue darkMagenta;
						at: 10 put: ColorValue darkRed;
						at: 11 put: ColorValue darkGreen;
						at: 12 put: ColorValue magenta;
						at: 13 put: ColorValue yellow;
						at: 14 put: ColorValue lightGray;
						at: 15 put: ColorValue cyan;
						at: 16 put: ColorValue navy; yourself)!

rectangleFromUserLimitedTo: extentPoint 
	"It is lamentably necessary to duplicate the code from Rectangle class 
	here, so that limitations can be imposed on the size of the rectangle 
	specified by the user."

	| originPoint |
	^Cursor crossHair
		showWhile: 
			[originPoint := Screen default
						dragShape: (0 @ 0 extent: 1@1) asPointArray
						offset: 0 @ 0
						gridPhase: 0@0
						gridSpacing: 1@1
						boundedBy: nil
						whileButton: 0
						isDown: false.
			Screen default
				resizeRectangle: (Rectangle origin: originPoint extent: 1@1)
				minimumExtent: 0@0
				resizeIncrement: 1@1
				boundedBy: (Rectangle origin: originPoint extent: extentPoint)
				whileButton: 0
				isDown: true]!

setColorFor: aButtonId

	| currentLookPreferences color colorNumber |
	self builder isNil ifFalse:[
	color := (self builder componentAt: aButtonId) lookPreferences backgroundColor.
	currentLookPreferences := (self builder componentAt: #currentColor) lookPreferences copy.
	currentLookPreferences setBackgroundColor: color.
	colorNumber := magnifiedBitView model palette
					indexOf: color
					ifAbsent: [magnifiedBitView model palette indexOfPaintNearest: color].
	magnifiedBitView controller currentColor: colorNumber.
	(builder componentAt: #currentColor) lookPreferences: currentLookPreferences]!

setupBitView

	magnifiedBitView model: (icon value copy convertToPalette: self preferredPalette).
	self setColorFor: #black.
	magnifiedBitView changedPreferredBounds: nil.
	magnifiedBitView invalidate!

toColor: aColorIndex

	| controller point oldImage zeroColor newImage takeBuffer putBuffer |
	controller := builder window controller.
	oldImage := magnifiedBitView model copy.
	Cursor crossHair showWhile:
		[[controller poll. controller sensor anyButtonPressed not] whileTrue: [].
		[controller sensor anyButtonPressed] whileTrue: []].
	point := magnifiedBitView controller sensor cursorPoint.
	(magnifiedBitView bounds containsPoint: point) ifFalse: [^self].
	point := (point scaledBy: 1 / magnifiedBitView scale) truncated.
	(oldImage bounds containsPoint: point)
		ifFalse: [^self].
	zeroColor := oldImage atPoint: point.
	newImage := oldImage copy.
	takeBuffer := Array new: oldImage width.
	putBuffer := Array new: oldImage width.
	0 to: newImage height -1 do:
		[:rowIndex |
		oldImage rowAt: rowIndex into: takeBuffer.
		1 to: takeBuffer size do:
			[:colIndex |
			(takeBuffer at: colIndex) = zeroColor
				ifTrue: [putBuffer at: colIndex put: aColorIndex]
				ifFalse: [putBuffer at: colIndex put: (takeBuffer at: colIndex)]].
		newImage rowAt: rowIndex putAll: putBuffer].
	magnifiedBitView model: newImage; changedPreferredBounds:nil; invalidate! !

!UIBIconEditor methodsFor: 'binding'!

actionFor: aKey 
	"Return a block that will be sent the message value when the 
	button is pressed."

	(aKey copyFrom: 1 to: 2) = 'do'
		ifTrue:[^super actionFor: aKey]
		ifFalse:[^[self setColorFor: aKey]]! !

!UIBIconEditor methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	"This message is sent by the builder when it has completed work on 
	either a complete window or a SubCanvas."

	self setupBitView! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBIconEditor class
	instanceVariableNames: ''!


!UIBIconEditor class methodsFor: 'interface specs'!

colorsAtBottomSpec
	"UIBPainter new openOnClass: self andSelector: #colorsAtBottomSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'Icon Editor-#colorsAtBottomSpec' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 0 0 -75 1 -48 1 ) 
					#name: #magnifiedBitView 
					#flags: 11 
					#component: #magnifiedBitView ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 106 0 158 20 ) 
							#model: #doFillCurrentColor 
							#label: #fillRectangleImage 
							#hasCharacterOrientedLabel: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 106 23 158 43 ) 
							#model: #doToCurrentColor 
							#label: #changeColorImage 
							#hasCharacterOrientedLabel: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 0 46 20 ) 
							#model: #doCut 
							#label: 'Cut' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 49 0 102 20 ) 
							#model: #doCopy 
							#label: 'Copy' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 23 46 43 ) 
							#model: #doPaste 
							#label: 'Paste' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 50 23 102 43 ) 
							#model: #doCapture 
							#label: 'Capture' 
							#style: #default ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame 1 0 -43 1 159 0 0 1.0 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 0 60 20 ) 
							#model: #doCancel 
							#label: 'Cancel' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 23 60 43 ) 
							#model: #doAccept 
							#label: 'Accept' 
							#style: #default ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame -72 1 -316 1 0 0.973684 0 0.16 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#InputFieldSpec 
							#layout: #(#Rectangle 0 0 70 20 ) 
							#name: #currentColor 
							#flags: 0 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #black ) ) 
							#model: #doTheCurrentColor 
							#tabable: false 
							#isReadOnly: true ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 60 35 80 ) 
							#name: #red 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #red ) 
								#setSelectionBackgroundColor: #(#ColorValue #red ) ) 
							#model: #red 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 80 35 100 ) 
							#name: #yellow 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #yellow ) 
								#setSelectionBackgroundColor: #(#ColorValue #yellow ) ) 
							#model: #yellow 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 40 35 60 ) 
							#name: #grey 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #lightGray ) 
								#setSelectionBackgroundColor: #(#ColorValue #lightGray ) ) 
							#model: #grey 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 60 70 80 ) 
							#name: #darkRed 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkRed ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkRed ) ) 
							#model: #darkRed 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 80 70 100 ) 
							#name: #darkYellow 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #olive ) 
								#setSelectionBackgroundColor: #(#ColorValue #olive ) ) 
							#model: #darkYellow 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 40 70 60 ) 
							#name: #darkGrey 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #gray ) 
								#setSelectionBackgroundColor: #(#ColorValue #gray ) ) 
							#model: #darkGrey 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 20 35 40 ) 
							#name: #white 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #white ) 
								#setSelectionBackgroundColor: #(#ColorValue #white ) ) 
							#model: #white 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 20 70 40 ) 
							#name: #black 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #black ) 
								#setSelectionBackgroundColor: #(#ColorValue #black ) ) 
							#model: #black 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 100 35 120 ) 
							#name: #green 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #green ) 
								#setSelectionBackgroundColor: #(#ColorValue #green ) ) 
							#model: #green 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 120 35 140 ) 
							#name: #cyan 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #cyan ) 
								#setSelectionBackgroundColor: #(#ColorValue #cyan ) ) 
							#model: #cyan 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 140 35 160 ) 
							#name: #blue 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #blue ) 
								#setSelectionBackgroundColor: #(#ColorValue #blue ) ) 
							#model: #blue 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 160 35 180 ) 
							#name: #magenta 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #magenta ) 
								#setSelectionBackgroundColor: #(#ColorValue #magenta ) ) 
							#model: #magenta 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 160 70 180 ) 
							#name: #darkMagenta 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkMagenta ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkMagenta ) ) 
							#model: #darkMagenta 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 100 70 120 ) 
							#name: #darkGreen 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkGreen ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkGreen ) ) 
							#model: #darkGreen 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 120 70 140 ) 
							#name: #darkCyan 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkCyan ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkCyan ) ) 
							#model: #darkCyan 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 140 70 160 ) 
							#name: #darkBlue 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #navy ) 
								#setSelectionBackgroundColor: #(#ColorValue #navy ) ) 
							#model: #darkBlue 
							#tabable: false ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame -74 1 142 0 0 0.984962 322 0 ) ) ) ) ) )!

componentSpec
	"UIBPainter new openOnClass: self andSelector: #componentSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Icon Editor-#componentSpec' 
			#bounds: #(#Rectangle 48 129 313 362 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 0 0 -75 1 -48 1 ) 
					#name: #magnifiedBitView 
					#flags: 11 
					#component: #magnifiedBitView ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 106 0 158 20 ) 
							#model: #doFillCurrentColor 
							#label: #fillRectangleImage 
							#hasCharacterOrientedLabel: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 106 23 158 43 ) 
							#model: #doToCurrentColor 
							#label: #changeColorImage 
							#hasCharacterOrientedLabel: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 0 46 20 ) 
							#model: #doCut 
							#label: 'Cut' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 49 0 102 20 ) 
							#model: #doCopy 
							#label: 'Copy' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 23 46 43 ) 
							#model: #doPaste 
							#label: 'Paste' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 50 23 102 43 ) 
							#model: #doCapture 
							#label: 'Capture' 
							#style: #default ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame 1 0 -43 1 159 0 0 1.0 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 0 60 20 ) 
							#model: #doCancel 
							#label: 'Cancel' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 23 60 43 ) 
							#model: #doAccept 
							#label: 'Accept' 
							#style: #default ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame -65 1 -43 1 0 1 0 1 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#InputFieldSpec 
							#layout: #(#Rectangle 0 0 70 20 ) 
							#name: #currentColor 
							#flags: 0 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #black ) ) 
							#model: #doTheCurrentColor 
							#tabable: false 
							#isReadOnly: true ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 60 35 80 ) 
							#name: #red 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #red ) 
								#setSelectionBackgroundColor: #(#ColorValue #red ) ) 
							#model: #red 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 80 35 100 ) 
							#name: #yellow 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #yellow ) 
								#setSelectionBackgroundColor: #(#ColorValue #yellow ) ) 
							#model: #yellow 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 40 35 60 ) 
							#name: #grey 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #lightGray ) 
								#setSelectionBackgroundColor: #(#ColorValue #lightGray ) ) 
							#model: #grey 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 60 70 80 ) 
							#name: #darkRed 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkRed ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkRed ) ) 
							#model: #darkRed 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 80 70 100 ) 
							#name: #darkYellow 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #olive ) 
								#setSelectionBackgroundColor: #(#ColorValue #olive ) ) 
							#model: #darkYellow 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 40 70 60 ) 
							#name: #darkGrey 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #gray ) 
								#setSelectionBackgroundColor: #(#ColorValue #gray ) ) 
							#model: #darkGrey 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 20 35 40 ) 
							#name: #white 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #white ) 
								#setSelectionBackgroundColor: #(#ColorValue #white ) ) 
							#model: #white 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 20 70 40 ) 
							#name: #black 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #black ) 
								#setSelectionBackgroundColor: #(#ColorValue #black ) ) 
							#model: #black 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 100 35 120 ) 
							#name: #green 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #green ) 
								#setSelectionBackgroundColor: #(#ColorValue #green ) ) 
							#model: #green 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 120 35 140 ) 
							#name: #cyan 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #cyan ) 
								#setSelectionBackgroundColor: #(#ColorValue #cyan ) ) 
							#model: #cyan 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 140 35 160 ) 
							#name: #blue 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #blue ) 
								#setSelectionBackgroundColor: #(#ColorValue #blue ) ) 
							#model: #blue 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 160 35 180 ) 
							#name: #magenta 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #magenta ) 
								#setSelectionBackgroundColor: #(#ColorValue #magenta ) ) 
							#model: #magenta 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 160 70 180 ) 
							#name: #darkMagenta 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkMagenta ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkMagenta ) ) 
							#model: #darkMagenta 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 100 70 120 ) 
							#name: #darkGreen 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkGreen ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkGreen ) ) 
							#model: #darkGreen 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 120 70 140 ) 
							#name: #darkCyan 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkCyan ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkCyan ) ) 
							#model: #darkCyan 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 140 70 160 ) 
							#name: #darkBlue 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #navy ) 
								#setSelectionBackgroundColor: #(#ColorValue #navy ) ) 
							#model: #darkBlue 
							#tabable: false ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame -70 1 0 0 0 1 180 0 ) ) ) ) ) )!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Icon Editor-#windowSpec' 
			#bounds: #(#Rectangle 160 110 409 343 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ArbitraryComponentSpec 
					#layout: #(#Rectangle 0 5 170 175 ) 
					#name: #magnifiedBitView 
					#flags: 11 
					#component: #magnifiedBitView ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 113 176 167 202 ) 
					#model: #doFillCurrentColor 
					#label: #fillRectangleImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 113 204 167 230 ) 
					#model: #doToCurrentColor 
					#label: #changeColorImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 1 176 55 202 ) 
					#model: #doCut 
					#label: 'Cut' 
					#style: #default ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 56 176 110 202 ) 
					#model: #doCopy 
					#label: 'Copy' 
					#style: #default ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 1 204 55 230 ) 
					#model: #doPaste 
					#label: 'Paste' 
					#style: #default ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 180 176 234 202 ) 
					#model: #doCancel 
					#label: 'Cancel' 
					#style: #default ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 57 204 111 230 ) 
					#model: #doCapture 
					#label: 'Capture' 
					#style: #default ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 176 6 246 24 ) 
					#name: #currentColor 
					#flags: 0 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #black ) ) 
					#model: #doTheCurrentColor 
					#tabable: false 
					#isReadOnly: true ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 60 211 78 ) 
					#name: #red 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #red ) 
						#setSelectionBackgroundColor: #(#ColorValue #red ) ) 
					#model: #red 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 78 211 96 ) 
					#name: #yellow 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #yellow ) 
						#setSelectionBackgroundColor: #(#ColorValue #yellow ) ) 
					#model: #yellow 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 42 211 60 ) 
					#name: #grey 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #lightGray ) 
						#setSelectionBackgroundColor: #(#ColorValue #lightGray ) ) 
					#model: #grey 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 211 60 246 78 ) 
					#name: #darkRed 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #darkRed ) 
						#setSelectionBackgroundColor: #(#ColorValue #darkRed ) ) 
					#model: #darkRed 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 211 78 246 96 ) 
					#name: #darkYellow 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #olive ) 
						#setSelectionBackgroundColor: #(#ColorValue #olive ) ) 
					#model: #darkYellow 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 211 42 246 60 ) 
					#name: #darkGrey 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #gray ) 
						#setSelectionBackgroundColor: #(#ColorValue #gray ) ) 
					#model: #darkGrey 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 24 211 42 ) 
					#name: #white 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #white ) 
						#setSelectionBackgroundColor: #(#ColorValue #white ) ) 
					#model: #white 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 211 24 246 42 ) 
					#name: #black 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #black ) 
						#setSelectionBackgroundColor: #(#ColorValue #black ) ) 
					#model: #black 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 96 211 114 ) 
					#name: #green 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #green ) 
						#setSelectionBackgroundColor: #(#ColorValue #green ) ) 
					#model: #green 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 114 211 132 ) 
					#name: #cyan 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #cyan ) 
						#setSelectionBackgroundColor: #(#ColorValue #cyan ) ) 
					#model: #cyan 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 132 211 150 ) 
					#name: #blue 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #blue ) 
						#setSelectionBackgroundColor: #(#ColorValue #blue ) ) 
					#model: #blue 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 150 211 168 ) 
					#name: #magenta 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #magenta ) 
						#setSelectionBackgroundColor: #(#ColorValue #magenta ) ) 
					#model: #magenta 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 211 150 246 168 ) 
					#name: #darkMagenta 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #darkMagenta ) 
						#setSelectionBackgroundColor: #(#ColorValue #darkMagenta ) ) 
					#model: #darkMagenta 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 211 96 246 114 ) 
					#name: #darkGreen 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #darkGreen ) 
						#setSelectionBackgroundColor: #(#ColorValue #darkGreen ) ) 
					#model: #darkGreen 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 211 114 246 132 ) 
					#name: #darkCyan 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #darkCyan ) 
						#setSelectionBackgroundColor: #(#ColorValue #darkCyan ) ) 
					#model: #darkCyan 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 211 132 246 150 ) 
					#name: #darkBlue 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #navy ) 
						#setSelectionBackgroundColor: #(#ColorValue #navy ) ) 
					#model: #darkBlue 
					#tabable: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 180 204 234 230 ) 
					#model: #doAccept 
					#label: 'Accept' 
					#style: #default ) ) ) )! !

!UIBIconEditor class methodsFor: 'binding'!

visualFor: aKey 
	"Return an instance of any non-abstract subclass of 
	VisualComponent (in practice usually either ComposedText or 
	Image) for use as a label for a widget. Check the visual registry if no 
	implementation has been provided."

	^UIMaskEditor visualFor: aKey! !

!UIBIconEditor class methodsFor: 'resources'!

colorPaletteImage

	^CachedImage on: (Image
			extent: 32 @ 32
			depth: 4
			bitsPerPixel: 4
			palette: (MappedPalette withColors: ((Array new: 16)
						at: 1 put: ColorValue black;
						at: 2 put: ColorValue darkGray;
						at: 3 put: ColorValue white;
						at: 4 put: ColorValue red;
						at: 5 put: ColorValue olive;
						at: 6 put: ColorValue green;
						at: 7 put: ColorValue blue;
						at: 8 put: ColorValue darkCyan;
						at: 9 put: ColorValue darkMagenta;
						at: 10 put: ColorValue darkRed;
						at: 11 put: ColorValue darkGreen;
						at: 12 put: ColorValue magenta;
						at: 13 put: ColorValue yellow;
						at: 14 put: ColorValue lightGray;
						at: 15 put: ColorValue cyan;
						at: 16 put: ColorValue navy; yourself))
			usingBits: (ByteArray fromPackedString: 'KS1<resource: #image>
	^Z2H"H"H"H"H"H"H"H"4<W&,"H"H"H"H"H"H"H"HA%J_8H"H"H"H"H"H"H"H"@YR''>BH"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"H"Hb'))!

emptyIcon
	"self emptyIcon image"

	^UIBImage bwEmptyIcon26! !

UIPropertiesTool subclass: #UIBPropertiesTool
	instanceVariableNames: 'aspectsHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter-Tools'!
UIBPropertiesTool comment:
'I am an enhanced version of the VisualWorks properties tool.

<to be completed>'!


!UIBPropertiesTool methodsFor: 'testing'!

currentCanvasIsPluggablePainter

	^controller isKindOf: UIBPluggablePainterController! !

!UIBPropertiesTool methodsFor: 'private'!

changedStatusBar
	
	| tx |
	self builder window label:
		(((tx := self statusBarText value) isNil or: [tx isEmpty])
			ifTrue: ['ApplFLab Properties Tool']
			ifFalse: ['ApplFLab Properties Tool on: ' , tx])!

computeSliceInfo
	"Retrieve the slice information and build a menu based on it."

	"Overridden here because the superclass expects the first slice
	to be #Basics and we want it to be an arbitrary name.
	(See the last line of the code.)"

	| mb slicesArray found foundIndex |
	found := false.
	mb := MenuBuilder new.
	slicesArray := currentSpecCopy class slices.
	sliceInfo := IdentityDictionary new.
	foundIndex := 1.
	1 to: slicesArray size
		do: 
			[:index | 
			| info sliceName |
			info := slicesArray at: index.
			sliceName := info at: 1.
			mb add: sliceName -> sliceName.
			sliceInfo at: sliceName put: info.
			sliceName == slice value
				ifTrue: 
					[found := true.
					self class isItNotebook ifTrue: [foundIndex := index]]].
	slicesMenu value: mb menu.
	self class isItNotebook ifTrue: [self replaceTheTabList: self masterList index: foundIndex].
	found ifFalse: [slice setValue: ((slicesArray at: 1) at: 1) "take the name of the first slice"]!

reloadSelectionInformation
	"If the new selection is really new then reload all selection 
	information. Note: it is important that 'selection', 'controller', 
	'selectionKind', and 'currentSpecCopy' be set at the same 
	time (as they are in this method - and only this method and 
	'setUpForNil')."

	| newController newSelection |
	lock == true ifTrue: [^self].
	newController := selectionHolder value.
	newController == nil ifTrue: [^self setUpForNil].
	newSelection := newController selectionList.
	selection == newSelection 
		ifTrue: [client isNil ifTrue: [^self].
				client usesConservativeReload ifFalse: [^self]].
	selection := newSelection.
	controller := newController.
	selection size = 0
		ifTrue: 
			["self currentCanvasIsPluggablePainter ifTrue:[^self setUpForNil]."
			((newController isKindOf: UIBPropertiesPainterController) and:[newController model targetComponent isCompositeComponent])
				ifTrue:[selectionKind := #propertiesSlice]
				ifFalse:[	selectionKind := #window].
			currentSpecCopy := controller model windowSpec copy]
		ifFalse: [selection size = 1
				ifTrue: 
					[selectionKind := #single.
					currentSpecCopy := selection first spec copy]
				ifFalse: 
					[selectionKind := #multi.
					currentSpecCopy := MultiSpec new]].
	statusBarText value: (controller model dependents at: 1) label asString.
	self computeSliceInfo.
	self displayButtonsForUnmodifiedState.
	slice value: slice value asSymbol!

setSpecChannel
	"Given a 'slice' and a 'currentSpecCopy', build and fill-in the slice." 

	| subCanvas currentSpec info specHolder subSpecIdent specSelector |
	lastSlice := slice value.
	slice value == #None ifTrue: [^self sliceOrSelectionChanged].
	(client notNil and: [client ~~ self ]) 
		ifTrue: [ client release ].
	(subBuilder notNil and: [ (subBuilder aspectAt: #releasingAgent) notNil ]) 
		ifTrue: [ (subBuilder aspectAt: #releasingAgent) release ].
	info := sliceInfo at: slice value.
	specSelector := info at: 2.
	subSpecIdent := info size >= 4 
				ifTrue: [info at: 4]
				ifFalse: [nil].
	specChannel := (subSpecIdent notNil
				ifTrue: [currentSpecCopy subSpecFor: subSpecIdent]
				ifFalse: [currentSpecCopy]) asValue.
	currentSpecBindings := IdentityDictionary new.
	(info size >= 3 and: [(info at: 3) notNil])
		ifTrue: 
			["PATCH !!" specHolder := client := (Smalltalk at: ((info at: 3) = #PositionToolModel ifTrue:[#UIBPositionToolModel] ifFalse: [info at: 3])) new
			"ORIGINAL: specHolder := client := (Smalltalk at: (info at: 3)) new"]
		ifFalse: 
			[client := self.
			specHolder := specChannel value].
	currentSpecBindings at: #propertiesTool put: self.
	specHolder class
		addBindingsTo: currentSpecBindings
		for: specHolder
		channel: specChannel. 
	selectionKind == #window
		ifTrue: 
			[self currentCanvasIsPluggablePainter "Koen: is this test really necessary in VW 2.5?"
				ifFalse:[currentSpecCopy label: specChannel value label].
			aspectsHolder := nil.
			currentSpecBindings at: #availableAspects put: self availableAspectsHolder].
	subCanvas := (builder componentAt: #specCanvas) widget.
	subBuilder := builder newSubBuilder.

	"use the bindings that were just collected"
	subBuilder bindings: currentSpecBindings.

	subBuilder aspectAt: #parentModel put: self.
	currentSpec := UISpecification from: (specHolder class perform: specSelector).
	subCanvas
		client: client
		spec: currentSpec
		builder: subBuilder.
	specChannel dependents 
		do: [:dep | Object messageNotUnderstoodSignal 
					handle: [:ex | ex return] 
					do: [dep compute: [:v | self displayButtonsForModifiedState]]].
	(subBuilder aspectAt: #releasingAgent) notNil 
		ifTrue: [ (subBuilder aspectAt: #releasingAgent) validateComponentsFor: subBuilder ].
	self setDropTargets.
	self sliceOrSelectionChanged.!

sliceChanged

	super sliceChanged.
	aspectsHolder := nil. "Clear the cache, since aspects may be added or removed. CHECK IT (later)"
	^self! !

!UIBPropertiesTool methodsFor: 'component accessing'!

specEditorComponentNamed: aSymbol

	^subBuilder componentAt: aSymbol! !

!UIBPropertiesTool methodsFor: 'privileged'!

availableApplicationModelsHolder

	| applModels |
	applModels := nil.
	^BlockValue with: [applModels isNil
						ifTrue:[applModels := ApplicationModel allSubclasses asSortedCollection:[:x :y| x name <= y name]].
					applModels]!

availableAspects

	^(self availableAspectsFrom: self controller model extractSpecCollection) asSortedCollection!

availableAspectsFrom: specCollection

	| enumerator |
	(enumerator := UIBAspectEnumerator new "source: self component targetClass") doSpec: specCollection.
	^enumerator bindings keys asSortedCollection!

availableAspectsHolder

	aspectsHolder isNil
		ifTrue:[
			aspectsHolder := BlockValue with: [self availableAspects]].
	^aspectsHolder! !

!UIBPropertiesTool methodsFor: 'actions'!

apply
	"Copy the information in 'currentSpecCopy' to the selected components."

	| labelM |
	(self isDataValidForSpec: currentSpecCopy) ifFalse: [^self].
	(controller == nil or: [controller view == nil])
		ifTrue: [^self].
	lock := true.
	client preapply.
	selectionKind == #single
		ifTrue: 
			["replaceElement:etc. will cause change to be noted, and 
			select: will 
			cause UIPainterWatchers to be alerted."
			| selElem sel spec doReselect |
			selElem := selection first.
			sel := controller selectionList.
			doReselect := sel size = 1 and: [sel first = selElem].
			spec := currentSpecCopy copy.
			spec layout: selElem spec layout.
			selElem := controller replaceElement: selElem basedOnSpec: spec.
			selection := Array with: selElem.
			doReselect ifTrue: [controller select: selElem]]
		ifFalse: [selectionKind == #multi
				ifTrue: 
					["replaceElement:etc. will cause change to be noted, 
					and 
					select: will cause UIPainterWatchers to be alerted."
					| newSelection spec doReselect |
					doReselect := controller selectionList == selection.
					newSelection := OrderedCollection new: selection size.
					selection
						do: 
							[:selElem | 
							spec := selElem spec copy.
							currentSpecCopy copyPropertiesTo: spec.
							newSelection add: (controller replaceElement: selElem basedOnSpec: spec)].
					selection := newSelection.
					doReselect ifTrue: [controller selectionList: newSelection]]
				ifFalse: [selectionKind == #window
						ifTrue: 
							[((labelM := currentSpecBindings at: #label ifAbsent:[]) notNil and:
								[labelM value isEmpty and:
									[(UIPainter preferenceFor: #hostWindowManager)
									== #OSFMotif]])
								ifTrue: 
									[(subBuilder componentAt: #labelField) flash.
									^self].
							controller model windowSpec: currentSpecCopy copy.
							self currentCanvasIsPluggablePainter
								ifFalse:[	controller model fixBuildersWindow.
										controller model builder window flushCaches.
										controller model builder window label: labelM value].
							controller canvasHasChanged: true]]].
	self statusBarText value: (controller model dependents at: 1) label asString.
	self displayButtonsForUnmodifiedState.
	aspectsHolder := nil. "Koen: dit heeft weinig effect vermits comboboxes hun lijst slechts 1 maal accessen. Misschien heeft het meer zin een #changed te sturen (maar een combobox blijkt niet dependent van zijn lijstholder !!!!???!!!!!!"
	lock := false!

isDataValidForSpec: aSpec

	^((UIBFinder isCompositeComponentSpecClass: aSpec class)
		ifTrue:[aSpec isDataValidFor: self]
		ifFalse:[aSpec isDataValid])!

selectWindow

	"Code copied from SelectMode>removeSelectionsInController:"
	controller broadcastPendingSelectionChange.
	controller removeSelections! !

!UIBPropertiesTool methodsFor: 'interface opening'!

openAtCursor
	"Open the receiver centered at the cursor."

	"Overridden here in order to use our own builder class."

	|  spec box |
	builder := UIBBuilder new.
	builder source: self.
	spec := self class interfaceSpecFor: #windowSpec.
	self preBuildWith: builder.
	builder add: spec.
	self postBuildWith: builder.
	builder window model: self.
	box := 0@0 extent: builder window displayBox extent.
	box := box
		align: box center
		with: WindowSensor cursorPoint.
	builder openIn: box.
	self postOpenWith: builder.
	^builder!

openInterface: aSymbol 
	"Open the ApplicationModel's user interface, using the specification 
	named."

	"Overridden here in order to use our own builder class."

	|  spec |
	builder := UIBBuilder new.
	builder source: self.
	spec := self class interfaceSpecFor: aSymbol.
	self preBuildWith: builder.
	builder add: spec.
	self postBuildWith: builder.
	builder window model: self.
	builder openWithExtent: spec window bounds extent.
	self postOpenWith: builder.
	^builder! !

!UIBPropertiesTool methodsFor: 'initialize-release'!

initialize

	"| currentController aspects |"
	super initialize.
	"aspectsCached := false.
	currentController := nil.
	aspectsHolder :=
		BlockValue with: [(aspectsCached and:[currentController == controller]) 
						ifFalse:[	aspects := (self availableAspectsFrom: self controller model extractSpecCollection) asSortedCollection.
								currentController := controller.
								aspectsCached := true].
					aspects]"! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertiesTool class
	instanceVariableNames: ''!


!UIBPropertiesTool class methodsFor: 'interface specs'!

windowNotebookSpec
	"UIPainter new openOnClass: self andSelector: #windowNotebookSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Properties Tool' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 6 102 414 479 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 289 0 -396 1 0 1.75853 0 -0.100592 ) 
					#model: #statusBarText 
					#tabable: false 
					#isReadOnly: true ) 
				#(#NoteBookSpec 
					#layout: #(#LayoutFrame 4 0 4 0 -4 1 -39 1 ) 
					#name: #specCanvas 
					#model: #sliceMasterList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#requestValueChangeSelector: #validateChangeOfPage ) 
					#rightInset: 95 
					#bottomInset: 0 ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 4 0 -32 1 64 0 0 0.99449 ) 
					#name: #applyButton 
					#model: #apply 
					#label: 'Apply' 
					#isDefault: true 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -89 1 -32 1 -47 1 0 0.994792 ) 
					#name: #prevButton 
					#model: #selectPrev 
					#tabable: false 
					#label: 'Prev' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -46 1 -32 1 -4 1 0 0.994792 ) 
					#name: #nextButton 
					#model: #selectNext 
					#tabable: false 
					#label: 'Next' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 65 0 -32 1 131 0 0 0.994792 ) 
					#name: #readButton 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 132 0 -32 1 230 0 0 0.994792 ) 
					#name: #applyAndCloseButton 
					#model: #applyAndClose 
					#label: 'Apply & Close' 
					#isDefault: false 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -150 1 -32 1 -89 1 0 0.994695 ) 
					#name: #windowButton 
					#model: #selectWindow 
					#tabable: false 
					#label: 'Window' 
					#defaultable: true ) ) ) )! !

DragHandle subclass: #UIBDragHandle
	instanceVariableNames: 'view '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter-Support'!
UIBDragHandle comment:
'I enhance my superclass with the addition of 4 more handles for a component (spec). The 4 extra handles can be used to resize a component in one direction only.

ApplFLab changes 3 system methods, i.e. ComponentSpec #dragHandlesFor:subject:view:isPrimary:, #handlesFor:subject:view:isPrimary:in:, #attachControlModesForWrapper:toHandles:, to associate UIBDragHandles instead of standard DragHandles with selected components.

If a component should not get 8 drag handles, or if a component should not get handles at the usual positions (i.e. top left, top right, bottom left, bottom right, top center, left center, bottom center, right center), the component''s specification class should override #handlesFor:subject:view:isPrimary:in: and #attachControlModesForWrapper:toHandles:.'!


!UIBDragHandle methodsFor: 'initialize-release'!

asBottomCenter

	selector := #bottomCenter.
	block := [:wr :sub :vw | self actualPoint: wr bounds bottomCenter of: wr in: vw]!

asBottomLeft

	selector := #bottomLeft.
	block := [:wr :sub :vw | self actualPoint: wr bounds bottomLeft of: wr in: vw]!

asCenter

	selector := #center.
	block := [:wr :sub :vw | self actualPoint: wr bounds center of: wr in: vw]!

asCorner

	selector := #corner.
	block := [:wr :sub :vw | self actualPoint: wr bounds corner of: wr in: vw]!

asDividerCorner

	selector := #corner.
	block := [:wr :sub :vw | self actualPoint: (sub orientation == #vertical 
		ifTrue: [wr bounds bottomLeft]
		ifFalse: [wr bounds topRight]) of: wr in: vw]!

asLeftCenter

	selector := #leftCenter.
	block := [:wr :sub :vw | self actualPoint: wr bounds leftCenter of: wr in: vw]!

asOrigin

	selector := #origin.
	block := [:wr :sub :vw | self actualPoint: wr bounds origin of: wr in: vw]!

asRightCenter

	selector := #rightCenter.
	block := [:wr :sub :vw | self actualPoint: wr bounds rightCenter of: wr in: vw]!

asTopCenter

	selector := #topCenter.
	block := [:wr :sub :vw | self actualPoint: wr bounds topCenter of: wr in: vw]!

asTopRight

	selector := #topRight.
	block := [:wr :sub :vw | self actualPoint: wr bounds topRight of: wr in: vw]! !

!UIBDragHandle methodsFor: 'accessing'!

view

	^view!

view: painterView

	view := painterView! !

!UIBDragHandle methodsFor: 'private'!

actualPoint: aPoint of: aWrapper in: painterView

	^(aWrapper localPointToGlobal: aPoint) - (painterView localPointToGlobal: painterView bounds origin)!

getOrigin

	^block value: self wrapper value: self subject value: self view! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBDragHandle class
	instanceVariableNames: ''!


!UIBDragHandle class methodsFor: 'instance creation'!

wrapper: aWrapper subject: aSubject isPrimary: aBoolean

	self shouldNotImplement!

wrapper: aWrapper subject: aSubject view: painterView isPrimary: aBoolean

	| dh |
	dh := super wrapper: aWrapper subject: aSubject isPrimary: aBoolean.
	dh view: painterView.
	^dh! !

Object subclass: #UIBPaletteItem
	instanceVariableNames: 'holderClass selector name '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Palette'!


!UIBPaletteItem methodsFor: 'initialize-release'!

componentName: aString holderClass: className selector: aSymbol

	name := aString.
	holderClass := className.
	selector := aSymbol!

componentName: aString holderClassName: className selector: aSymbol

	name := aString.
	holderClass := Smalltalk at: className ifAbsent: [nil].
	selector := aSymbol! !

!UIBPaletteItem methodsFor: 'accessing'!

componentName

	^name!

holderClass

	^holderClass!

name

	^self spec class name!

paletteIconImage

	| spec iconSelector |
	spec := self spec.
	(spec isKindOf: CompositeSpecCollection) ifTrue: [^UIBImage groupPaletteIcon]. "Koen: dirty patch!!"
	iconSelector := self componentName select: [:char| char isAlphaNumeric].
	iconSelector at: 1 put: iconSelector first asLowercase.
	iconSelector := (iconSelector , 'PaletteIcon') asSymbol.
	(self holderClass class includesSelector: iconSelector) ifTrue: [^self holderClass perform: iconSelector].
	^spec class paletteIconImage!

selector

	^selector!

spec

	^(self holderClass isNil or: [(self holderClass class includesSelector: self selector) not])
		ifTrue: [self halt: 'Koen: wat betekent dit?']
		ifFalse: [UISpecification from: (self holderClass perform: self selector)]!

specGenerationBlock

	^ [:ctrlr :point | |spec|
		spec := self spec.
		(spec isKindOf: CompositeSpecCollection) "Koen: dirty patch!!"
			ifTrue: [spec compositeSpec layout: ((ctrlr gridPoint: point) extent: spec compositeSpec layout extent)]
			ifFalse: [spec layout: ((ctrlr gridPoint: point) extent: spec layout extent)].
		spec]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPaletteItem class
	instanceVariableNames: ''!


!UIBPaletteItem class methodsFor: 'instance creation'!

componentName: aString holderClassName: className selector: aSymbol

	^self new componentName: aString holderClassName: className selector: aSymbol! !

UIBLabelAndVisualRepository subclass: #UIBImage
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!
UIBImage comment:
'I am a class that holds onto images that are used by many ApplFLab classes.'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBImage class
	instanceVariableNames: ''!


!UIBImage class methodsFor: 'launcher'!

componentEditorIcon

	^self new buildImage: #componentEditorIconImage mask: #componentEditorIconMask bw: #componentEditorIconBW!

paletteIcon

	^self new buildImage: #paletteIconImage mask: #paletteIconMask bw: #paletteIconBW!

palettesIcon

	^self new buildImage: #palettesIconImage mask: #palettesIconMask bw: #palettesIconBW! !

!UIBImage class methodsFor: 'launcher-resources'!

componentEditorIconBW
	"UIMaskEditor new openOnClass: self andSelector: #componentEditorIconBW"

	<resource: #image>
	^(Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 254 0 0 128 3 128 0 128 3 255 0 128 2 1 0 128 3 255 0 128 2 128 0 135 2 255 0 130 2 1 0 191 226 255 0 144 34 128 0 152 18 128 0 136 10 128 0 140 58 128 0 132 226 128 0 135 162 128 0 130 146 128 0 128 130 128 0 128 2 128 0 128 2 128 0 128 2 128 0 128 2 128 0 255 254 128 0 128 0 128 0 255 255 128 0])!

componentEditorIconImage
	"UIMaskEditor new openOnClass: self andSelector: #componentEditorIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 6) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 4915); at: 3 put: ColorValue white; at: 4 put: ColorValue yellow; at: 5 put: ColorValue lightGray; at: 6 put: ColorValue green; yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@H"H"H"ADQDQDQDQ@@BH"H"ADQDQDQDQ@@@@@@@ADQDQDQDQ@UUUUUPADQDQDQDQ@@@@@@@ADQDQDQDQ@DBH"H"ADQ@@DQDQ@D@@@@@ADQDADQDQ@EUUUUPA@@@@@@DQ@D@@@@@AD@2L#HDQ@DBH"H"AD@CH2L Q@DBH"H"ADPBL#H2A@DBH"H"ADP@H2L@A@DBH"H"ADQ@L @DQ@DBH"H"ADQ@@@PDQ@DBH"H"ADQDA@Q@Q@DBH"H"ADQDQ@QDQ@DBH"H"ADQDQDQDQ@DBH"H"ADQDQDQDQ@DBH"H"ADQDQDQDQ@DBH"H"ADQDQDQDQ@DBH"H"@@@@@@@@@@DBH"H"@QDQDQDQDQDBH"H"@@@@@@@@@@@BH"H"'))!

componentEditorIconMask
	"UIMaskEditor new openOnClass: self andSelector: #componentEditorIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 254 0 0 255 255 128 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 128 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0 255 255 128 0])!

paletteIconBW
	"UIMaskEditor new openOnClass: self andSelector: #paletteIconBW"

	<resource: #image>
	^(Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 7 224 0 0 248 24 0 3 0 4 0 4 192 50 0 25 224 123 0 33 224 121 0 64 192 49 0 64 6 1 0 140 15 1 0 158 15 6 0 158 6 24 0 76 0 96 0 64 48 64 0 64 120 192 0 48 120 128 0 8 51 128 0 6 2 0 0 1 252 0 0 0 0 0 0 0 0 0 0 0 0 0 0])!

paletteIconImage
	"UIMaskEditor new openOnClass: self andSelector: #paletteIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 8) at: 1 put: ColorValue black; at: 2 put: ColorValue white; at: 3 put: ColorValue magenta; at: 4 put: ColorValue lightGray; at: 5 put: ColorValue yellow; at: 6 put: ColorValue green; at: 7 put: ColorValue red; at: 8 put: ColorValue blue; yourself)) usingBits: (ByteArray fromPackedString: 'DQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQD@@@@QDQDQDQDP@@@3L3L@DQDQDQ@CL3L3L3L3@QDQDPL2H3L3L3USLADQ@CL"H#L3L5UUL@DPL3L"H#L3L5UUL0DCL3L2H3L3L3USL0DCL3L3L3M&L3L3L0@3MDL3L3Y&X3L3L0@3QDP3L3Y&X3L3@A@3QDP3L3M&L3L@DQDCMDL3L3L3L0@QDQDCL3L3M7L3L0DQDQDCL3L3]7\3L@DQDQDP@3L3]7\3LADQDQDQDCL3M7L0@ADQDQDQDP@3L3L0DQDQDQDQDQD@@@@ADQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQ'))!

paletteIconMask
	"UIMaskEditor new openOnClass: self andSelector: #paletteIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 7 224 0 0 255 248 0 3 255 252 0 7 255 254 0 31 255 255 0 63 255 255 0 127 255 255 0 127 255 255 0 255 255 255 0 255 255 254 0 255 255 248 0 127 255 224 0 127 255 192 0 127 255 192 0 63 255 128 0 15 255 128 0 7 254 0 0 1 252 0 0 0 0 0 0 0 0 0 0 0 0 0 0])!

palettesIconBW
	"UIMaskEditor new openOnClass: self andSelector: #palettesIconBW"

	<resource: #image>
	^(Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 7 224 0 0 248 24 0 3 0 4 0 4 192 50 0 25 224 123 0 33 224 121 0 64 192 49 0 64 6 1 0 140 15 1 0 158 15 6 0 158 6 24 0 76 0 96 0 64 48 64 0 64 120 192 0 48 120 128 0 8 51 128 0 6 2 0 0 1 252 0 0 0 0 219 0 0 0 219 0 0 0 0 0])!

palettesIconImage
	"UIMaskEditor new openOnClass: self andSelector: #palettesIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 8) at: 1 put: ColorValue black; at: 2 put: ColorValue white; at: 3 put: ColorValue magenta; at: 4 put: ColorValue lightGray; at: 5 put: ColorValue yellow; at: 6 put: ColorValue green; at: 7 put: ColorValue red; at: 8 put: ColorValue blue; yourself)) usingBits: (ByteArray fromPackedString: 'DQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQDQD@@@@QDQDQDQDP@@@3L3L@DQDQDQ@CL3L3L3L3@QDQDPL2H3L3L3USLADQ@CL"H#L3L5UUL@DPL3L"H#L3L5UUL0DCL3L2H3L3L3USL0DCL3L3L3M&L3L3L0@3MDL3L3Y&X3L3L0@3QDP3L3Y&X3L3@A@3QDP3L3M&L3L@DQDCMDL3L3L3L0@QDQDCL3L3M7L3L0DQDQDCL3L3]7\3L@DQDQDP@3L3]7\3LADQDQDQDCL3M7L0@ADQDQDQDP@3L3L0DQDQDQDQDQD@@@@ADQDQDQDQDQDQDQDQD@D@D@DQDQDQDQDQD@D@D@DQDQDQDQDQDQDQDQ'))!

palettesIconMask
	"UIMaskEditor new openOnClass: self andSelector: #palettesIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 7 224 0 0 255 248 0 3 255 252 0 7 255 254 0 31 255 255 0 63 255 255 0 127 255 255 0 127 255 255 0 255 255 255 0 255 255 254 0 255 255 248 0 127 255 224 0 127 255 192 0 127 255 192 0 63 255 128 0 15 255 128 0 7 254 0 0 1 252 0 0 0 0 219 0 0 0 219 0 0 0 0 0])! !

!UIBImage class methodsFor: 'palette-resources'!

bwGroupIcon
	"UIMaskEditor new openOnClass: self andSelector: #bwGroupIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 120 255 199 0 120 1 199 0 120 253 199 0 125 253 255 0 125 253 255 0 125 192 15 0 125 223 239 0 125 223 239 0 125 223 239 0 124 31 239 0 127 223 239 0 127 223 239 0 120 223 199 0 120 192 7 0 120 255 199 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0])!

cgGroupIcon
	"UIMaskEditor new openOnClass: self andSelector: #cgGroupIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); at: 5 put: ColorValue lightGray; yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@H"H"H"H"H"H"H"H!!@@@@@BL3L3L3L3L3L3L3LP@@@@@#L3L3L3L3L3L3L3D@@@@@H3L3L3L3L3L3L3L1@@@@@BL3@@QDQDQDP@@3LP@@@@@#L0@@@@@@QD@@L3D@@@@@H3L@ADQDPDQ@@CL1@@@@@BL3PDQDQDADQDP3LP@@@@@#L4ADQDQ@QDQDL3D@@@@@H3M@QD@@@@@@ACL1@@@@@BL3PDQ@QDQDQ@P3LP@@@@@#L4ADPDQDQDPDL3D@@@@@H3M@QDADQDQDACL1@@@@@BL3P@@@QDQDQ@P3LP@@@@@#L4QDPDQDQDPDL3D@@@@@H3MDQDADQDQDACL1@@@@@BL3@@Q@QDQDP@@3LP@@@@@#L0@DP@@@@@@@L3D@@@@@H3L@ADQDQDQ@@CL1@@@@@BL3L3L3L3L3L3L3LP@@@@@#L3L3L3L3L3L3L3D@@@@@H3L3L3L3L3L3L3L1@@@@@BL3L3L3L3L3L3L3LP@@@@@QDQDQDQDQDQDQDQD@@@@@@@@@@@@@@@@@@@@@@@@@@b'))! !

!UIBImage class methodsFor: 'palette'!

groupPaletteIcon
	"Answer an image to reperesent a group on the palette"

	^Screen default colorDepth == 1
			ifTrue: [self bwGroupIcon]
			ifFalse: [self cgGroupIcon]! !

!UIBImage class methodsFor: 'default'!

bwDefaultPaletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #bwDefaultPaletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0])!

bwEmptyIcon26
	"UIMaskEditor new openOnClass: self andSelector: #bwEmptyIcon26"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 127 255 255 128 0 0 0 0])!

cgDefaultPaletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #cgDefaultPaletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a'))! !

!UIBImage class methodsFor: 'arrow'!

bwDownArrowIcon24
	"UIMaskEditor new openOnClass: self andSelector: #bwDownArrowIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 0 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 127 255 254 0 63 255 252 0 31 255 248 0 15 255 240 0 7 255 224 0 3 255 192 0 1 255 128 0 0 255 0 0 0 126 0 0 0 60 0 0 0 24 0 0 0 0 0 0])!

bwLeftArrowIcon24
	"UIMaskEditor new openOnClass: self andSelector: #bwLeftArrowIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 0 0 0 0 16 0 0 0 48 0 0 0 112 0 0 0 240 0 0 1 240 0 0 3 240 0 0 7 240 0 0 15 240 0 0 31 255 254 0 63 255 254 0 127 255 254 0 127 255 254 0 63 255 254 0 31 255 254 0 15 240 0 0 7 240 0 0 3 240 0 0 1 240 0 0 0 240 0 0 0 112 0 0 0 48 0 0 0 16 0 0 0 0 0 0])!

bwRightArrowIcon24
	"UIMaskEditor new openOnClass: self andSelector: #bwRightArrowIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 0 0 0 0 8 0 0 0 12 0 0 0 14 0 0 0 15 0 0 0 15 128 0 0 15 192 0 0 15 224 0 0 15 240 0 127 255 248 0 127 255 252 0 127 255 254 0 127 255 254 0 127 255 252 0 127 255 248 0 0 15 240 0 0 15 224 0 0 15 192 0 0 15 128 0 0 15 0 0 0 14 0 0 0 12 0 0 0 8 0 0 0 0 0 0])!

bwUpArrowIcon24
	"UIMaskEditor new openOnClass: self andSelector: #bwUpArrowIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 0 0 0 0 24 0 0 0 60 0 0 0 126 0 0 0 255 0 0 1 255 128 0 3 255 192 0 7 255 224 0 15 255 240 0 31 255 248 0 63 255 252 0 127 255 254 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 0 0 0])!

cgDownArrowIcon24
	"UIMaskEditor new openOnClass: self andSelector: #cgDownArrowIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 2 put: ColorValue black; yourself)) usingBits: #[0 0 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 127 255 254 0 63 255 252 0 31 255 248 0 15 255 240 0 7 255 224 0 3 255 192 0 1 255 128 0 0 255 0 0 0 126 0 0 0 60 0 0 0 24 0 0 0 0 0 0])!

cgLeftArrowIcon24
	"UIMaskEditor new openOnClass: self andSelector: #cgLeftArrowIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 2 put: ColorValue black; yourself)) usingBits: #[0 0 0 0 0 16 0 0 0 48 0 0 0 112 0 0 0 240 0 0 1 240 0 0 3 240 0 0 7 240 0 0 15 240 0 0 31 255 254 0 63 255 254 0 127 255 254 0 127 255 254 0 63 255 254 0 31 255 254 0 15 240 0 0 7 240 0 0 3 240 0 0 1 240 0 0 0 240 0 0 0 112 0 0 0 48 0 0 0 16 0 0 0 0 0 0])!

cgRightArrowIcon24
	"UIMaskEditor new openOnClass: self andSelector: #cgRightArrowIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 2 put: ColorValue black; yourself)) usingBits: #[0 0 0 0 0 8 0 0 0 12 0 0 0 14 0 0 0 15 0 0 0 15 128 0 0 15 192 0 0 15 224 0 0 15 240 0 127 255 248 0 127 255 252 0 127 255 254 0 127 255 254 0 127 255 252 0 127 255 248 0 0 15 240 0 0 15 224 0 0 15 192 0 0 15 128 0 0 15 0 0 0 14 0 0 0 12 0 0 0 8 0 0 0 0 0 0])!

cgUpArrowIcon24
	"UIMaskEditor new openOnClass: self andSelector: #cgUpArrowIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 2 put: ColorValue black; yourself)) usingBits: #[0 0 0 0 0 24 0 0 0 60 0 0 0 126 0 0 0 255 0 0 1 255 128 0 3 255 192 0 7 255 224 0 15 255 240 0 31 255 248 0 63 255 252 0 127 255 254 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 0 0 0])! !

!UIBImage class methodsFor: 'plus/minus'!

bwMinusIcon24
	"UIMaskEditor new openOnClass: self andSelector: #bwMinusIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0])!

bwPlusIcon24
	"UIMaskEditor new openOnClass: self andSelector: #bwPlusIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 0 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 0 0 0])!

cgMinusIcon24
	"UIMaskEditor new openOnClass: self andSelector: #cgMinusIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 2 put: ColorValue black; yourself)) usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0])!

cgPlusIcon24
	"UIMaskEditor new openOnClass: self andSelector: #cgPlusIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 2 put: ColorValue black; yourself)) usingBits: #[0 0 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 127 255 254 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 126 0 0 0 0 0 0])! !

!UIBImage class methodsFor: 'component editor'!

componentIcon

	^self new buildImage: #componentIconImage mask: #componentIconMask bw: #componentIconBW!

generalIcon

	^self new buildImage: #generalIconImage mask: #generalIconMask bw: #generalIconBW!

installIcon

	^self new buildImage: #installIconImage mask: #installIconMask bw: #installIconBW!

paintingIcon

	^self new buildImage: #paintingIconImage mask: #paintingIconMask bw: #paintingIconBW!

paletteEditorIcon

	^self new buildImage: #paletteEditorIconImage mask: #paletteEditorIconMask bw: #paletteEditorIconBW!

propertiesIcon

	^self new buildImage: #propertiesIconImage mask: #propertiesIconMask bw: #propertiesIconBW!

slicesIcon

	^self new buildImage: #slicesIconImage mask: #slicesIconMask bw: #slicesIconBW! !

!UIBImage class methodsFor: 'component editor-resources'!

componentIconBW
	"UIMaskEditor new openOnClass: self andSelector: #componentIconBW"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 124 0 0 0 16 0 0 63 255 192 0 48 0 64 0 24 0 32 0 24 0 32 0 12 0 16 0 12 0 16 0 12 0 16 0 6 0 8 0 6 0 8 0 3 0 4 0 3 0 4 0 3 0 24 0 7 128 96 0 5 129 160 0 13 134 48 0 8 220 16 0 8 236 16 0 0 12 0 0 0 12 0 0 0 12 0 0 0 0 0 0])!

componentIconImage
	"UIMaskEditor new openOnClass: self andSelector: #componentIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 3) at: 1 put: ColorValue black; at: 2 put: ColorValue green; at: 3 put: ColorValue white; yourself)) usingBits: #[170 170 170 170 170 170 0 0 170 170 128 10 170 170 0 0 170 170 168 170 170 170 0 0 160 0 0 0 10 170 0 0 160 102 102 102 74 170 0 0 168 25 153 153 146 170 0 0 168 38 102 102 98 170 0 0 170 9 153 153 152 170 0 0 170 6 102 102 100 170 0 0 170 9 153 153 152 170 0 0 170 130 102 102 102 42 0 0 170 129 153 153 153 42 0 0 170 160 102 102 102 74 0 0 170 160 153 153 153 138 0 0 170 160 102 102 100 42 0 0 170 128 25 153 130 170 0 0 170 136 38 100 34 170 0 0 170 8 25 130 160 170 0 0 170 42 4 10 168 170 0 0 170 42 2 10 168 170 0 0 170 170 170 10 170 170 0 0 170 170 170 10 170 170 0 0 170 170 170 10 170 170 0 0 170 170 170 170 170 170 0 0])!

componentIconMask
	"UIMaskEditor new openOnClass: self andSelector: #componentIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 124 0 0 0 16 0 0 63 255 192 0 58 170 192 0 29 85 96 0 26 170 160 0 13 85 80 0 14 170 176 0 13 85 80 0 6 170 168 0 7 85 88 0 3 170 172 0 3 85 84 0 3 170 184 0 7 213 96 0 5 171 160 0 13 214 48 0 8 252 16 0 8 236 16 0 0 12 0 0 0 12 0 0 0 12 0 0 0 0 0 0])!

generalIconBW
	"UIMaskEditor new openOnClass: self andSelector: #generalIconBW"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 62 0 0 0 34 0 0 0 34 0 0 0 34 0 0 0 62 0 0 0 0 0 0 0 62 0 0 0 226 0 0 0 130 0 0 0 194 0 0 0 98 0 0 0 34 0 0 0 34 0 0 0 34 0 0 0 34 0 0 0 34 0 0 0 99 0 0 0 193 128 0 0 128 128 0 0 255 128 0 0 0 0 0 0 0 0 0])!

generalIconImage
	"UIMaskEditor new openOnClass: self andSelector: #generalIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 3) at: 1 put: ColorValue black; at: 2 put: ColorValue white; at: 3 put: ColorValue lightGray; yourself)) usingBits: #[85 85 85 85 85 85 0 0 85 85 85 85 85 85 0 0 85 85 80 1 85 85 0 0 85 85 82 161 85 85 0 0 85 85 82 161 85 85 0 0 85 85 82 161 85 85 0 0 85 85 80 1 85 85 0 0 85 85 85 85 85 85 0 0 85 85 80 1 85 85 0 0 85 85 2 161 85 85 0 0 85 85 42 161 85 85 0 0 85 85 10 161 85 85 0 0 85 85 66 161 85 85 0 0 85 85 82 161 85 85 0 0 85 85 82 161 85 85 0 0 85 85 82 161 85 85 0 0 85 85 82 161 85 85 0 0 85 85 82 161 85 85 0 0 85 85 66 160 85 85 0 0 85 85 10 168 21 85 0 0 85 85 42 170 21 85 0 0 85 85 0 0 21 85 0 0 85 85 85 85 85 85 0 0 85 85 85 85 85 85 0 0])!

generalIconMask
	"UIMaskEditor new openOnClass: self andSelector: #generalIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 62 0 0 0 62 0 0 0 62 0 0 0 62 0 0 0 62 0 0 0 0 0 0 0 62 0 0 0 254 0 0 0 254 0 0 0 254 0 0 0 126 0 0 0 62 0 0 0 62 0 0 0 62 0 0 0 62 0 0 0 62 0 0 0 127 0 0 0 255 128 0 0 255 128 0 0 255 128 0 0 0 0 0 0 0 0 0])!

installIconBW
	"UIMaskEditor new openOnClass: self andSelector: #installIconBW"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 16 0 0 0 48 0 0 0 98 0 0 0 198 0 0 1 142 0 0 3 31 254 0 6 63 254 0 12 31 254 0 24 14 0 0 48 6 6 0 24 2 12 0 12 0 24 0 6 0 48 0 3 0 96 0 1 128 192 0 0 193 128 0 0 99 0 0 0 54 0 0 0 28 0 0 0 8 0 0 0 0 0 0 0 0 0 0])!

installIconImage
	"UIMaskEditor new openOnClass: self andSelector: #installIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 0 0 0 0 0 0 0 0 16 0 0 0 48 0 0 0 98 0 0 0 198 0 0 1 142 0 0 3 31 254 0 6 63 254 0 12 31 254 0 24 14 0 0 48 6 6 0 24 2 12 0 12 0 24 0 6 0 48 0 3 0 96 0 1 128 192 0 0 193 128 0 0 99 0 0 0 54 0 0 0 28 0 0 0 8 0 0 0 0 0 0 0 0 0 0])!

installIconMask
	"UIMaskEditor new openOnClass: self andSelector: #installIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 16 0 0 0 48 0 0 0 98 0 0 0 198 0 0 1 142 0 0 3 31 254 0 6 63 254 0 12 31 254 0 24 14 0 0 48 6 6 0 24 2 12 0 12 0 24 0 6 0 48 0 3 0 96 0 1 128 192 0 0 193 128 0 0 99 0 0 0 54 0 0 0 28 0 0 0 8 0 0 0 0 0 0 0 0 0 0])!

paintingIconBW
	"UIMaskEditor new openOnClass: self andSelector: #paintingIconBW"

	<resource: #image>
	^(Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 43 109 128 0 32 0 0 0 0 0 128 0 32 0 128 0 32 0 0 0 0 0 128 0 32 0 128 0 32 0 0 0 22 219 128 0 0 0 192 0 0 0 224 0 0 0 240 0 0 0 248 0 0 0 252 0 0 0 254 0 0 0 248 0 0 0 248 0 0 0 152 0 0 0 12 0 0 0 12 0 0 0 6 0 0 0 6 0 0 0 0 0])!

paintingIconImage
	"UIMaskEditor new openOnClass: self andSelector: #paintingIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 3) at: 1 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 2 put: ColorValue black; at: 3 put: ColorValue white; yourself)) usingBits: #[162 8 32 130 170 170 0 0 162 170 170 168 170 170 0 0 170 170 170 168 170 170 0 0 162 170 170 170 170 170 0 0 162 170 170 168 170 170 0 0 170 170 170 170 170 170 0 0 162 170 170 168 170 170 0 0 170 170 170 168 170 170 0 0 160 130 8 34 170 170 0 0 170 170 170 170 106 170 0 0 170 170 170 170 90 170 0 0 170 170 170 170 86 170 0 0 170 170 170 170 85 170 0 0 170 170 170 170 85 106 0 0 170 170 170 170 85 90 0 0 170 170 170 170 85 86 0 0 170 170 170 170 85 106 0 0 170 170 170 170 85 106 0 0 170 170 170 170 105 106 0 0 170 170 170 170 170 90 0 0 170 170 170 170 170 90 0 0 170 170 170 170 170 150 0 0 170 170 170 170 170 150 0 0 170 170 170 170 170 170 0 0])!

paintingIconMask
	"UIMaskEditor new openOnClass: self andSelector: #paintingIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[45 182 0 0 32 1 0 0 0 1 0 0 32 0 0 0 32 1 0 0 0 0 0 0 32 1 0 0 0 1 0 0 54 219 128 0 0 1 192 0 0 1 224 0 0 1 240 0 0 1 248 0 0 1 252 0 0 1 254 0 0 1 255 0 0 1 252 0 0 1 252 0 0 1 252 0 0 1 30 0 0 0 30 0 0 0 15 0 0 0 15 0 0 0 6 0])!

paletteEditorIconBW
	"UIMaskEditor new openOnClass: self andSelector: #paletteEditorIconBW"

	<resource: #image>
	^(Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 16 0 0 0 48 0 0 0 96 0 0 0 192 0 0 1 128 0 0 3 0 0 0 7 224 0 0 254 24 0 3 28 4 0 4 56 50 0 24 56 123 0 32 128 121 0 65 192 49 0 71 198 1 0 143 143 1 0 128 15 6 0 134 6 24 0 79 0 96 0 79 48 64 0 70 120 192 0 48 120 128 0 8 51 128 0 6 2 0 0 1 252 0 0])!

paletteEditorIconImage
	"UIMaskEditor new openOnClass: self andSelector: #paletteEditorIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 7) at: 1 put: ColorValue black; at: 2 put: ColorValue white; at: 3 put: ColorValue yellow; at: 4 put: ColorValue lightGray; at: 5 put: ColorValue green; at: 6 put: ColorValue red; at: 7 put: ColorValue blue; yourself)) usingBits: (ByteArray fromPackedString: 'DQDQDQDQDQDQDADQDQDQDQDQDQDQ@ADQDQDQDQDQDQDP@QDQDQDQDQDQDQD@DQDQDQDQDQDQDQ@ADQDQDQDQDQDQDP@QDQDQDQDQDQDQD@@@@QDQDQDQDP@@@@L3L@DQDQDQ@CL0@CL3L3@QDQDPL3L@@3L3QCLADQ@CL3L@@3L4QDL@DPL3L0L3L3L4QDL0DCL3L@@3L3L3QCL0DCL@@@@3MUL3L3L0@3L @@L3UUT3L3L0@3H"H3L3UUT3L3@A@3H"H3L3MUL3L@DQDCL"L3L3L3L0@QDQDCL3L3M&L3L0DQDQDCL3L3Y&X3L@DQDQDP@3L3Y&X3LADQDQDQDCL3M&L0@ADQDQDQDP@3L3L0DQDQDQDQDQD@@@@ADQDQDQ'))!

paletteEditorIconMask
	"UIMaskEditor new openOnClass: self andSelector: #paletteEditorIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 16 0 0 0 48 0 0 0 96 0 0 0 192 0 0 1 128 0 0 3 0 0 0 7 224 0 0 255 248 0 3 255 252 0 7 255 254 0 31 255 255 0 63 255 255 0 127 255 255 0 127 255 255 0 255 255 255 0 255 255 254 0 255 255 248 0 127 255 224 0 127 255 192 0 127 255 192 0 63 255 128 0 15 255 128 0 7 254 0 0 1 252 0 0])!

propertiesIconBW
	"UIMaskEditor new openOnClass: self andSelector: #propertiesIconBW"

	<resource: #image>
	^(Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[63 254 0 0 32 3 128 0 32 3 255 0 32 2 1 0 32 3 255 0 32 2 128 0 35 130 255 0 33 2 1 0 63 242 255 0 40 18 128 0 44 10 128 0 36 6 128 0 38 30 128 0 34 114 128 0 35 210 128 0 33 74 128 0 32 66 128 0 32 2 128 0 32 2 128 0 32 2 128 0 32 2 128 0 63 254 128 0 32 0 128 0 63 255 128 0])!

propertiesIconImage
	"UIMaskEditor new openOnClass: self andSelector: #propertiesIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: ColorValue green; at: 3 put: ColorValue white; at: 4 put: ColorValue lightGray; at: 5 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 4915); yourself)) usingBits: (ByteArray fromPackedString: 'H @@@@@@@@H"H"H"H L3L3L3L0@BH"H"H L3L3L3L0@@@@@@H L3L3L3L0L3L3L0H L3L3L3L0@@@@@@H L3L3L3L0PBH"H"H L3@@L3L0P@@@@@H L3LCL3L0P3L3L0H @@@@@@L0P@@@@@H LAHRD L0PBH"H"H L@D!!HR@0PBH"H"H L0HRD!!H@PBH"H"H L0@!!HP@@PBH"H"H L3@R@@L0PBH"H"H L3@@@0L0PBH"H"H L3LC@3@0PBH"H"H L3L3@3L0PBH"H"H L3L3L3L0PBH"H"H L3L3L3L0PBH"H"H L3L3L3L0PBH"H"H L3L3L3L0PBH"H"H @@@@@@@@PBH"H"H QDQDQDQDPBH"H"H @@@@@@@@@BH"H"'))!

propertiesIconMask
	"UIMaskEditor new openOnClass: self andSelector: #propertiesIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[63 254 0 0 63 255 128 0 63 255 255 0 63 255 255 0 63 255 255 0 63 255 128 0 63 255 255 0 63 255 255 0 63 255 255 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0 63 255 128 0])!

slicesIconBW
	"UIMaskEditor new openOnClass: self andSelector: #slicesIconBW"

	<resource: #image>
	^(Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[63 254 0 0 32 3 128 0 32 3 255 0 32 2 1 0 32 3 255 0 32 2 128 0 32 2 255 0 32 2 1 0 32 2 255 0 32 2 128 0 32 2 255 0 32 2 129 0 32 2 255 0 32 2 128 0 32 2 255 0 32 2 129 0 32 2 255 0 32 2 128 0 32 2 255 0 32 2 129 0 32 2 255 0 63 254 128 0 32 0 128 0 63 255 128 0])!

slicesIconImage
	"UIMaskEditor new openOnClass: self andSelector: #slicesIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: ColorValue green; at: 3 put: ColorValue white; at: 4 put: ColorValue lightGray; at: 5 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 4915); yourself)) usingBits: (ByteArray fromPackedString: 'H @@@@@@@@H"H"H"H L3L3L3L0@BH"H"H L3L3L3L0@@@@@@H L3L3L3L0DQDQDPH L3L3L3L0@@@@@@H L3L3L3L0PBH"H"H L3L3L3L0P@@@@@H L3L3L3L0PQDQDPH L3L3L3L0P@@@@@H L3L3L3L0PBH"H"H L3L3L3L0P@@@@@H L3L3L3L0PADQDPH L3L3L3L0P@@@@@H L3L3L3L0PBH"H"H L3L3L3L0P@@@@@H L3L3L3L0PADQDPH L3L3L3L0P@@@@@H L3L3L3L0PBH"H"H L3L3L3L0P@@@@@H L3L3L3L0PADQDPH L3L3L3L0P@@@@@H @@@@@@@@PBH"H"H QDQDQDQDPBH"H"H @@@@@@@@@BH"H"'))!

slicesIconMask
	"UIMaskEditor new openOnClass: self andSelector: #slicesIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[63 254 0 0 63 255 128 0 63 255 255 0 63 255 255 0 63 255 255 0 63 255 128 0 63 255 255 0 63 255 255 0 63 255 255 0 63 255 128 0 63 255 255 0 63 255 255 0 63 255 255 0 63 255 128 0 63 255 255 0 63 255 255 0 63 255 255 0 63 255 128 0 63 255 255 0 63 255 255 0 63 255 255 0 63 255 128 0 63 255 128 0 63 255 128 0])! !

!UIBImage class methodsFor: 'cut/copy/past/undo'!

bwUndoIcon24
	"UIMaskEditor new openOnClass: self andSelector: #bwUndoIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 0 0 0 112 0 14 0 120 0 30 0 124 0 62 0 62 0 124 0 31 0 248 0 15 129 240 0 7 195 224 0 3 231 192 0 1 255 128 0 0 255 0 0 0 126 0 0 0 126 0 0 0 255 0 0 1 255 128 0 3 231 192 0 7 195 224 0 15 129 240 0 31 0 248 0 62 0 124 0 124 0 62 0 120 0 30 0 112 0 14 0 0 0 0 0])!

cgUndoIcon24
	"UIMaskEditor new openOnClass: self andSelector: #cgUndoIcon24"

	<resource: #image>
	^CachedImage on: (Image extent: 24@24 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 2 put: ColorValue black; yourself)) usingBits: #[0 0 0 0 112 0 14 0 120 0 30 0 124 0 62 0 62 0 124 0 31 0 248 0 15 129 240 0 7 195 224 0 3 231 192 0 1 255 128 0 0 255 0 0 0 126 0 0 0 126 0 0 0 255 0 0 1 255 128 0 3 231 192 0 7 195 224 0 15 129 240 0 31 0 248 0 62 0 124 0 124 0 62 0 120 0 30 0 112 0 14 0 0 0 0 0])! !

ApplicationModel subclass: #UIBFileOut
	instanceVariableNames: 'classOrCategory agora list filter inOneFile total '
	classVariableNames: 'LastFilterString '
	poolDictionaries: ''
	category: 'UIB-Installer'!
UIBFileOut comment:
'I am a small application to file-out categories or classes.
Multiple selection enables filing-out of several categories or classes at a time.
I feature an ''Agora'' switch to display only Agora categories and classes.

Koen De Hondt
Version 1.0b, August 1993'!


!UIBFileOut methodsFor: 'initialize-release'!

initialize

	inOneFile := false asValue.
	filter := self lastFilterString asValue.
	classOrCategory := #categories asValue.
	list := MultiSelectionInList new.
	total := (PluggableAdaptor on: list listHolder)
			getBlock: [:m| m value size]
			putBlock: [:m :p| "Do nothing. Field is read-ony."]
			updateBlock: [:m :a :p| true]! !

!UIBFileOut methodsFor: 'aspects'!

classOrCategory

	^classOrCategory!

filter
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^filter!

inOneFIle

	^inOneFile!

inOneFile
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^inOneFile!

list

	^list!

total
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^total! !

!UIBFileOut methodsFor: 'private'!

categories

	^Smalltalk organization categories asSortedCollection!

classesOf: categories

	| organization classes |
	organization := Smalltalk organization.
	classes := SortedCollection new: categories size * 10.
	categories do:[:cat|classes addAll: (organization listAtCategoryNamed: cat)].
	^classes!

filter: symbols with: matchString

	^symbols select:[:symbol| matchString match: symbol]!

forCategories

	^self classOrCategory value = #categories!

lastFilterString

	^LastFilterString!

lastFilterString: matchString

	LastFilterString := matchString!

selectionChanged

	list selectionIndexes isEmpty
		ifTrue:[self fileOutButton disable]
		ifFalse:[self fileOutButton enable]

	"<<KDH: 4 March 1994,1:17:11 pm, version: 1>>"!

update

	Cursor wait showWhile:[| target |
		target := self categories.
		self forCategories ifFalse:[target := self classesOf: target].
		target := self filter: target with: self filter value.
		self list list: target asList]! !

!UIBFileOut methodsFor: 'components'!

countLabel

	^(builder componentAt: #countLabel) widget!

fileOutButton

	^builder componentAt: #fileOutButton! !

!UIBFileOut methodsFor: 'actions'!

fileOut

	self inOneFile value
		ifTrue: [self fileOutInOneFile]
		ifFalse: [self fileOutInMultipleFiles]!

fileOutInMultipleFiles

	| pathNameToFolder |
	(pathNameToFolder := FileDialog getDirectory: 'Select a file out destination folder:')
		isNil ifTrue: [^self].
	classOrCategory value = #categories
		ifFalse:[self list selections do:[:symbol| self fileOutClass: symbol in: pathNameToFolder]]
		ifTrue:[self list selections do:[:symbol| self fileOutCategory: symbol in: pathNameToFolder]]!

fileOutInOneFile
	"File out the selected classes/categories in 1 file.
	Order the classes appropriately before filing them out, so that they can be filed in without 'nil superclass' exceptions."

	| pathNameToFile |
	(pathNameToFile := FileDialog putFile: 'Select a file out destination file:') isNil ifTrue: [^self].
	classOrCategory value = #categories
		ifTrue:[self fileOutCategories: self list selections in: pathNameToFile]
		ifFalse:[self fileOutClasses: (self superclassOrder: self list selections) in: pathNameToFile]!

selectAll
	"This stub method was generated by UIDefiner"

	self list selectionIndexes: (1 to: self list list size) asSet!

selectNone
	"This stub method was generated by UIDefiner"

	self list selectionIndexes: Set new! !

!UIBFileOut methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	"This message is sent by the builder when it has completed work on 
	either a complete window or a SubCanvas."

	(aBuilder componentAt: #list) widget container container noMenuBar.
	self filter onChangeSend: #update to: self.
	self classOrCategory onChangeSend: #update to: self.
	self list selectionIndexHolder onChangeSend: #selectionChanged to: self.
	self update! !

!UIBFileOut methodsFor: 'events'!

noticeOfWindowClose: aWindow 
	"The ApplicationWindow aWindow is in the process of closing. 
	You have been notified."

	self lastFilterString: self filter value! !

!UIBFileOut methodsFor: 'file out'!

fileOutCategories: categoryCollection in: pathNameToFile

	self fileOutClasses:
		(self superclassOrder:
			(categoryCollection
				inject: (OrderedCollection new: 200)
				into: [:col :category| col addAll: (Smalltalk organization listAtCategoryNamed: category). col]))
		in: pathNameToFile!

fileOutCategories: categoryCollection with: aBlock in: pathNameToFile

	self
		fileOutClasses:
			(self superclassOrder:
				(categoryCollection
					inject: (OrderedCollection new: 200)
					into: [:col :category| col addAll: (Smalltalk organization listAtCategoryNamed: category). col]))
		with: aBlock
		in: pathNameToFile!

fileOutCategory: symbol in: pathnameToFolder

	| fileManager |
	fileManager := SourceCodeStream on: (pathnameToFolder asFilename construct: symbol asString , '.st') writeStream.
	fileManager deferInitializations.
	[Smalltalk organization fileOutCategorySource: symbol on: fileManager.
	fileManager finishInitializations]
		valueNowOrOnUnwindDo: [fileManager close]!

fileOutClass: symbol in: pathnameToFolder

	| fileManager |
	fileManager := SourceCodeStream on: (pathnameToFolder asFilename construct: symbol asString , '.st') writeStream.
	[fileManager timeStamp.
	(Smalltalk at: symbol) fileOutSourceOn: fileManager.]
		valueNowOrOnUnwindDo: [fileManager close]!

fileOutClasses: classesCollection in: pathnameToFile

	| fileManager |
	fileManager := SourceCodeStream on: pathnameToFile writeStream.
	fileManager deferInitializations.
	[fileManager timeStamp.
	classesCollection do: [:aClass| aClass fileOutSourceOn: fileManager.].
	fileManager finishInitializations]
		valueNowOrOnUnwindDo: [fileManager close]!

fileOutClasses: classesCollection with: aBlock in: pathnameToFile

	| fileManager |
	fileManager := SourceCodeStream on: pathnameToFile writeStream.
	fileManager deferInitializations.
	[fileManager timeStamp.
	classesCollection do: [:aClass| aClass fileOutSourceOn: fileManager. fileManager cr;cr.].
	fileManager cr;cr.
	fileManager finishInitializations.
	aBlock value: fileManager]
		valueNowOrOnUnwindDo: [fileManager close]!

superclassOrder: classNameCollection
	"Answer an ordered collection of classes in 'superclass-first' order."

	^SystemUtils sortForLoading: (classNameCollection collect: [:name| Smalltalk at: name])! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBFileOut class
	instanceVariableNames: ''!


!UIBFileOut class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'UIB File Out' 
			#min: #(#Point 247 281 ) 
			#bounds: #(#Rectangle 85 134 452 483 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 -110 1 0 1.0 ) 
					#name: #list 
					#model: #list 
					#multipleSelections: true ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#ActionButtonSpec 
							#layout: #(#LayoutFrame 2 0 273 0 87 0 302 0 ) 
							#name: #fileOutButton 
							#model: #fileOut 
							#label: 'File Out ...' 
							#style: #default 
							#defaultable: true ) 
						#(#RadioButtonSpec 
							#layout: #(#LayoutOrigin 2 0 0 0 ) 
							#name: #categories 
							#model: #classOrCategory 
							#label: 'Categories' 
							#select: #categories ) 
						#(#RadioButtonSpec 
							#layout: #(#LayoutOrigin 2 0 23 0 ) 
							#name: #classes 
							#model: #classOrCategory 
							#label: 'Classes' 
							#style: #default 
							#select: #classes ) 
						#(#ActionButtonSpec 
							#layout: #(#LayoutFrame 2 0 173 0 87 0 204 0 ) 
							#name: #selectAllButton 
							#model: #selectAll 
							#label: 'Select All' 
							#style: #default 
							#defaultable: true ) 
						#(#DividerSpec 
							#layout: #(#LayoutFrame 0 0 260 0 88 0 264 0 ) 
							#name: #divider ) 
						#(#LabelSpec 
							#layout: #(#LayoutOrigin 2 0 132 0 ) 
							#name: #totalLabel 
							#label: 'Total:' 
							#style: #default ) 
						#(#InputFieldSpec 
							#layout: #(#Rectangle 41 127 81 150 ) 
							#name: #total 
							#flags: 0 
							#model: #total 
							#isReadOnly: true 
							#type: #number )
						#(#ActionButtonSpec 
							#layout: #(#LayoutFrame 2 0 216 0 87 0 247 0 ) 
							#name: #selectNoneButton 
							#model: #selectNone 
							#label: 'Select None' 
							#style: #default 
							#defaultable: true ) 
						#(#DividerSpec 
							#layout: #(#LayoutFrame 1 0 159 0 88 0 163 0 ) 
							#name: #separator ) 
						#(#LabelSpec 
							#layout: #(#Point 2 55 ) 
							#name: #filterLabel 
							#label: 'Filter:' ) 
						#(#InputFieldSpec 
							#layout: #(#Rectangle 2 84 86 107 ) 
							#name: #filter 
							#model: #filter ) 
						#(#CheckBoxSpec 
							#layout: #(#Point 2 309 ) 
							#name: #inOneFile 
							#model: #inOneFile 
							#label: 'In 1 File' )  ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame -100 1 10 0 -10 1 342 0 ) ) ) ) ) )! !

!UIBFileOut class methodsFor: 'class initialization'!

initialize

	"self initialize"
	self initializeFilter!

initializeFilter

	LastFilterString := '*'	 "select all"! !

UIBApplicationModel subclass: #UIBSubPropertyField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBSubPropertyField class
	instanceVariableNames: ''!


!UIBSubPropertyField class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'SubProperty Field' 
			#bounds: #(#Rectangle 209 143 409 343 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #componentHolder ) ) ) )! !

Model subclass: #UIBEncodableModel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Basics'!
UIBEncodableModel comment:
'I am an abstract superclass for models that can be stored in literal array encodings.'!


!UIBEncodableModel methodsFor: 'private'!

fromLiteralArrayEncoding: anArray
	"Fill the receiver with decoded values found in the given literal array encoding."

	self preLiteralEncoding.
	2 to: anArray size by: 2
		do: [:i | self perform: (anArray at: i) with: (anArray at: i + 1)].
	self postLiteralArrayDecoding!

postLiteralArrayDecoding

	"Default is to do nothing."!

preLiteralEncoding

	"Default is to do nothing."! !

!UIBEncodableModel methodsFor: 'converting'!

classNameEncodingOn: aStream

	aStream nextPut: self class name!

literalArrayEncoding
	"Return a literal suitable for reconstituting the receiver."

	| encodingStream |
	encodingStream := WriteStream on: (Array new).
	self classNameEncodingOn: encodingStream.
	self literalArrayEncodingOn: encodingStream.
	^encodingStream contents!

literalArrayEncodingOn: aStream
	"Put a literal encoding suitable for reconstituting the receiver on aStream.
	Use #nextPut: to store each value of the encoding.
	The class name is already on the stream."

	self subclassResponsibility! !

!UIBEncodableModel methodsFor: 'initialize-release'!

initialize

	"Default is to do nothing."! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBEncodableModel class
	instanceVariableNames: ''!


!UIBEncodableModel class methodsFor: 'instance creation'!

new

	^super new initialize! !

!UIBEncodableModel class methodsFor: 'private'!

decodeFromLiteralArray: anArray
	"Return an instance based on the information encoded in anArray."

	^self basicNew fromLiteralArrayEncoding: anArray! !

UIBEncodableModel subclass: #UIBNonEncodableModel
	instanceVariableNames: 'nonEncodableModel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Basics'!
UIBNonEncodableModel comment:
'I am that is used to store standard VisualWorks objects which provide no way to store them in literal array encodings.
I use their storeString format to store them in literal arrays.'!


!UIBNonEncodableModel methodsFor: 'accessing'!

nonEncodableModel

	^nonEncodableModel!

nonEncodableModel: anObject

	nonEncodableModel := anObject! !

!UIBNonEncodableModel methodsFor: 'converting'!

literalArrayEncodingOn: aStream
	"Put a literal encoding suitable for reconstituting the receiver on aStream.
	Use #nextPut: to store each value of the encoding.
	The class name is already on the stream."

	aStream nextPut: #storeStringEncoding:; nextPut: self nonEncodableModel storeString! !

!UIBNonEncodableModel methodsFor: 'private'!

storeStringEncoding: aString

	self nonEncodableModel: (self class readObjectFromString: aString)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBNonEncodableModel class
	instanceVariableNames: ''!


!UIBNonEncodableModel class methodsFor: 'instance creation'!

decodeFromLiteralArray: anArray

	^(super decodeFromLiteralArray: anArray) nonEncodableModel!

on: anObject

	^self new nonEncodableModel: anObject!

readObjectFrom: aStream
	"Create an object based on the contents of aStream."

	^self evaluatorClass evaluate: aStream!

readObjectFromString: aString
	"Create an object based on the contents of aString."

	^self readObjectFrom: (ReadStream on: aString)! !

UIBEncodableModel subclass: #UIBAspectDictionary
	instanceVariableNames: 'dictionary '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBAspectDictionary methodsFor: 'converting'!

literalArrayEncodingOn: aStream

	self dictionary keysAndValuesDo:
		[:key :value|
			aStream
				nextPut: key literalArrayEncoding;
				nextPut: value literalArrayEncoding].! !

!UIBAspectDictionary methodsFor: 'private'!

dictionary

	^dictionary!

fromLiteralArrayEncoding: anArray

	2 to: anArray size by: 2 do: [:index| self at: (anArray at: index) decodeAsLiteralArray
									put: (anArray at: index + 1) decodeAsLiteralArray].
	self postLiteralArrayDecoding! !

!UIBAspectDictionary methodsFor: 'initialize-release'!

initialize

	super initialize.
	dictionary := IdentityDictionary new: 20! !

!UIBAspectDictionary methodsFor: 'testing'!

isEmpty

	^self dictionary isEmpty! !

!UIBAspectDictionary methodsFor: 'accessing'!

associations

	^self dictionary associations!

at: aSymbol

	^self dictionary at: aSymbol!

at: aSymbol ifAbsent: absentBlock

	^self dictionary at: aSymbol ifAbsent: absentBlock!

at: aSymbol put: aValue

	| alreadyExists |
	alreadyExists := self dictionary includesKey: aSymbol.
	self dictionary at: aSymbol put: aValue.
	self changed: (alreadyExists ifTrue:[#at:replace:] ifFalse:[#at:put:]).
	^aValue!

includesKey: aSymbol

	^self dictionary includesKey: aSymbol!

keys

	^self dictionary keys!

removeKey: aSymbol

	| removedValue |
	removedValue := self dictionary removeKey: aSymbol.
	self changed: #removeKey: with: aSymbol.
	^removedValue! !

!UIBAspectDictionary methodsFor: 'printing'!

printOn: aStream 

	super printOn: aStream.
	aStream nextPutAll: ' with: '.
	self dictionary associations asArray printOn: aStream.! !

!UIBAspectDictionary methodsFor: 'copying'!

postCopy

	super postCopy.
	dictionary := dictionary copy
	"models keys do:[:key| models at: key put: (models at: key) copy].
	adaptors keys do:[:key| adaptors at: key put: (adaptors at: key) copy]."! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBAspectDictionary class
	instanceVariableNames: ''!


!UIBAspectDictionary class methodsFor: 'private'!

decodeFromLiteralArray: anArray
	"Return an instance based on the information encoded in anArray."

	^self new fromLiteralArrayEncoding: anArray! !

UIBApplicationModel subclass: #UIBComponentLookAndFeelEditor
	instanceVariableNames: 'lookAndFeel minorKey majorKey default defaultHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources-UI'!


!UIBComponentLookAndFeelEditor methodsFor: 'initialize-release'!

initialize

	| selectionHolder  |
	lookAndFeel :=  SelectionInList new.
	defaultHolder := nil asValue.
	(selectionHolder := lookAndFeel selectionHolder)
		compute:[:value|
				builder isNil
					ifFalse:[	self able: value notNil components: #(#duplicateButton #default #editButton).
							self able: (value notNil and:[self lookAndFeel list size > 1]) component: #removeButton]].
	default := (PluggableAdaptor on: selectionHolder)
			getBlock: [:m| (m value notNil and:[m value  == self defaultHolder value]) ifTrue:[#default] ifFalse:[#notDefault]]
			putBlock: [:m :v|
					m value  == self defaultHolder value
						ifFalse:[v == #default
								ifTrue:[|previousIndex|
										previousIndex := self indexOfDefault.
										self defaultHolder value: m value.
										lookAndFeel list changed: #at: with: previousIndex.
										lookAndFeel list changed: #at: with: lookAndFeel selectionIndex]
								ifFalse:[self halt]]]
			updateBlock: [:m :v :p| true].!

listHolder: lookAndFeelListHolder defaultHolder: aUIBComponentLookAndFeelHolder

	self listHolder: lookAndFeelListHolder.
	self defaultHolder: aUIBComponentLookAndFeelHolder! !

!UIBComponentLookAndFeelEditor methodsFor: 'interface opening'!

postBuildWith: aBuilder

	builder := aBuilder.
	self able:self lookAndFeel selectionIndex ~= 0 components: #(#duplicateButton #default #editButton).
	self able: (self lookAndFeel selectionIndex ~= 0 and:[self lookAndFeel list size > 1]) component: #removeButton.
	(self widget: #lookAndFeel)
		visualBlock:
			[:v :i | BoundedWrapper on: (Label with: (self displayStringFor: (v sequence at: i)))];
		selectedVisualBlock:
			[:v :i ||rw|
			rw := ReversingWrapper on: (Label with:(self displayStringFor: (v sequence at: i))).
			rw reverse setValue: true.
			BoundedWrapper on: rw].! !

!UIBComponentLookAndFeelEditor methodsFor: 'private'!

defaultHolder

	^defaultHolder!

defaultHolder: aUIBComponentLookAndFeelHolder

	defaultHolder := aUIBComponentLookAndFeelHolder!

displayStringFor: aUIBComponentLookAndFeel

	|aStream|
	aStream := WriteStream on: String new.
	aUIBComponentLookAndFeel exists
		ifTrue:[aStream
				nextPutAll: aUIBComponentLookAndFeel specHolderClass;
				nextPutAll: aUIBComponentLookAndFeel specSelector printString]
		ifFalse:[aStream nextPutAll: 'New/Uninstalled'].
	^(aUIBComponentLookAndFeel == self defaultHolder value)
		ifTrue:[aStream contents asText allBold]
		ifFalse:[aStream contents]!

indexOfDefault

	|index|
	index := 0.
	self lookAndFeel list detect:[:look| index := index + 1. look == self defaultHolder value] ifNone:[^0].
	^index!

listHolder

	^self lookAndFeel listHolder!

listHolder: aListHolder

	self lookAndFeel listHolder: aListHolder! !

!UIBComponentLookAndFeelEditor methodsFor: 'actions'!

add
	"Add a new ComponentLookAndFeel to the list and select it.
	Make sure that it is the default if it is the only item after addition."

	self addLookAndFeel: UIBComponentLookAndFeel new!

addExisting
	"Add an existing ComponentLookAndFeel to the list and select it.
	Make sure that it is the default if it is the only item after addition."

	| look |
	(UIBResourceSelectorDialog openOnResource: (look := UIBComponentLookAndFeel new) desiredResourceTypes: (Set with: #canvas))
		ifTrue:[self addLookAndFeel: look]!

addLookAndFeel: aUIBComponentLookAndFeel
	"Add aUIBComponentLookAndFeel to the list and select it.
	Make sure that it is the default if it is the only item after addition."

	self lookAndFeel list add: aUIBComponentLookAndFeel.
	self lookAndFeel list size = 1 ifTrue:[self defaultHolder value: aUIBComponentLookAndFeel].
	self lookAndFeel selectionIndex: self lookAndFeel list size!

duplicate
	"Add a duplication of the current selection to the list and select it.
	Make sure that it is the default if it is the only item after addition."

	self addLookAndFeel: self lookAndFeel selection copy!

edit

	(UIBResourceSelectorDialog openOnResource: self lookAndFeel selection desiredResourceTypes: (Set with: #canvas))
		ifTrue:[self lookAndFeel list changed: #at: with: self lookAndFeel selectionIndex]!

remove
	"Remove the selection from the list and select the one preceeding the current selection or the first (if any) if the first one is selected.
	Make sure that another item (the first) becomes the default one if the removed one is the default."

	| selIndex |
	((selIndex := self lookAndFeel selectionIndex) > 0
		and:[|removed|
			removed := self lookAndFeel list removeAtIndex: selIndex.
			self lookAndFeel selectionIndex: (selIndex > 1 ifTrue:[selIndex - 1] ifFalse:[self lookAndFeel list size > 0 ifTrue:[1] ifFalse:[0]]).
			removed == self defaultHolder value
			and:[self lookAndFeel list isEmpty not]])
		ifTrue:[	self defaultHolder value: self lookAndFeel selection.
				self lookAndFeel list changed: #at: with: self lookAndFeel selectionIndex.
				self default changed: #value]! !

!UIBComponentLookAndFeelEditor methodsFor: 'aspects'!

default
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^default!

lookAndFeel
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^lookAndFeel! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBComponentLookAndFeelEditor class
	instanceVariableNames: ''!


!UIBComponentLookAndFeelEditor class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'LookAndFeelEditor' 
			#bounds: #(#Rectangle 125 249 350 421 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -90 1 ) 
					#name: #lookAndFeel 
					#model: #lookAndFeel 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#doubleClickSelector: #edit ) ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutOrigin -90 1 -85 1 ) 
					#name: #default 
					#model: #default 
					#label: 'Is Default' 
					#style: #default 
					#select: #default ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -85 1 105 0 -60 1 ) 
					#name: #addButton 
					#model: #add 
					#label: 'Add New' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -25 1 105 0 0 1.0 ) 
					#name: #duplicateButton 
					#model: #duplicate 
					#label: 'Duplicate' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -90 1 -55 1 0 1 -30 1 ) 
					#name: #removeButton 
					#model: #remove 
					#label: 'Remove' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -55 1 105 0 -30 1 ) 
					#name: #addExistingButton 
					#model: #addExisting 
					#label: 'Add Existing ...' 
					#style: #default 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -90 1 -25 1 0 1 0 1 ) 
					#name: #editButton 
					#model: #edit 
					#label: 'Change ...' 
					#style: #default 
					#defaultable: true ) ) ) )! !

UIBEncodableModel subclass: #UIBProperty
	instanceVariableNames: 'name '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Properties'!
UIBProperty comment:
'This is the abstract superclass of all property classes.'!


!UIBProperty methodsFor: 'accessing'!

defaultGeneratedCode
	"Answer a(n initialization) String that is to be generated for the receiver."

	"For most subclasses this is appropriate:"

	^'nil asValue'!

defaultModelFromCustomCode: aString

	"Most subclasses ignore the custom code, since they have a fixed default model, so:"

	^self defaultModel!

inBuilder: builder withCustomCode: aString

	^self subclassResponsibility!

name

	^name!

onlyDefaultCodeGeneration
	"Answer a Boolean indicating whether the receiver cannot support custom code generation."

	^false! !

!UIBProperty methodsFor: 'converting'!

literalArrayEncodingOn: aStream
	"Put a literal encoding suitable for reconstituting the receiver on aStream."

	aStream
		nextPut: #name:;
		nextPut: self name! !

!UIBProperty methodsFor: 'private'!

customDefaultModelFrom: aString

	^Compiler new
		evaluate: aString in: nil receiver: nil notifying: nil
		ifFail: [self error:'Compile error while determining custom default model.']!

defaultModel
	"Answer an object that acts as default model for the receiver."

	"For most subclasses this is appropriate:"

	^nil asValue!

inBuilder: builder withSelector: getSelector withCustomCode: aString
	"getSelector <Symbol>"

	| m |
	name isNil ifTrue:[^self defaultModelFromCustomCode: aString].
	m := builder perform: getSelector with:name.
	m == nil ifFalse: [^m].
	builder isEditing ifFalse: [^builder raiseErrorMessage: self class propertyName , ': <1p> not found!!' with: name].
	m := self defaultModelFromCustomCode: aString.
	builder cacheWhileEditing ifTrue: [builder perform: (getSelector , 'put:') with: name with: m].
	^m! !

!UIBProperty methodsFor: 'privileged-accessing'!

name: aSymbol

	name := aSymbol! !

!UIBProperty methodsFor: 'building'!

bindInAspectEnumerator: aUIBAspectEnumerator withCustomCode: aString

	"For most subclasses this is appropriate:"

	self name isNil
		ifFalse:[aUIBAspectEnumerator bindings at: self name put: (self defaultModelFromCustomCode: aString)]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBProperty class
	instanceVariableNames: ''!


!UIBProperty class methodsFor: 'interface specs'!

comboEditSpec
	"UIBPainter new openOnClass: self andSelector: #comboEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Aspect Input Field' 
			#bounds: #(#Rectangle 427 181 686 221 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#model: #name 
					#style: #default 
					#isReadOnly: false 
					#type: #symbol 
					#comboList: #availableAspects ) ) ) )!

editSpec
	"UIBPainter new openOnClass: self andSelector: #editSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Property Input Field' 
			#bounds: #(#Rectangle 332 229 615 298 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #name 
					#model: #name 
					#type: #symbol ) ) ) )! !

!UIBProperty class methodsFor: 'accessing'!

propertyName
	"Answer a String containing the type of property."

	^self subclassResponsibility! !

UIBProperty subclass: #UIBVisualProperty
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Properties'!


!UIBVisualProperty methodsFor: 'accessing'!

inBuilder: builder withCustomCode: aString

	^self inBuilder: builder withSelector: #visualAt: withCustomCode: aString! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBVisualProperty class
	instanceVariableNames: ''!


!UIBVisualProperty class methodsFor: 'accessing'!

propertyName

	^'Visual'! !

UIBProperty subclass: #UIBAspectProperty
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Properties'!


!UIBAspectProperty methodsFor: 'accessing'!

defaultModelFromCustomCode: aString

	^aString isEmpty
		ifFalse:[self customDefaultModelFrom: aString]
		ifTrue:[super defaultModelFromCustomCode: aString]!

inBuilder: builder withCustomCode: aString


	^self inBuilder: builder withSelector: #aspectAt: withCustomCode: aString

	"| m |
	name == nil ifTrue: [^self defaultModel].
	m := builder aspectAt: name.
	m == nil ifFalse: [^m].
	builder isEditing ifFalse: [^builder raiseError: 'binding: % not found!!' with: name].
	m := self defaultModel.
	builder cacheWhileEditing ifTrue: [builder aspectAt: name put: m].
	^m"! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBAspectProperty class
	instanceVariableNames: ''!


!UIBAspectProperty class methodsFor: 'accessing'!

propertyName

	^'Aspect'! !

NoteBookSpec subclass: #OOPNoteBookSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!


!OOPNoteBookSpec methodsFor: 'building'!

dispatchTo: policy with: builder

	policy oopNoteBook: self into: builder! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

OOPNoteBookSpec class
	instanceVariableNames: ''!


!OOPNoteBookSpec class methodsFor: 'private-interface building'!

componentName

	^'Fancy Notebook'! !

!OOPNoteBookSpec class methodsFor: 'interface specs'!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Fancy Notebook-Details' 
			#min: #(#Point 266 263 ) 
			#bounds: #(#Rectangle 25 198 291 461 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 10 0 24 0 -10 1 71 0 ) 
					#label: 'Major Tabs' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 10 0 137 0 -10 1 189 0 ) 
					#label: 'Insets' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 15 43 ) 
					#model: #majorTabsOnRight 
					#tabable: true 
					#label: 'right' 
					#select: true ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 85 43 ) 
					#model: #majorTabsOnRight 
					#tabable: true 
					#label: 'top' 
					#select: false ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 72 159 113 182 ) 
					#model: #rightInset 
					#tabable: true 
					#menu: #fieldMenu 
					#alignment: #right 
					#numChars: 3 
					#type: #number ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 207 159 248 182 ) 
					#model: #bottomInset 
					#tabable: true 
					#menu: #fieldMenu 
					#alignment: #right 
					#numChars: 3 
					#type: #number ) 
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 80 0 203 0 -10 1 225 0 ) 
					#model: #style 
					#menu: #fontMenu ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 231 ) 
					#model: #tabable 
					#tabable: true 
					#label: 'Can Tab' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 4 0 0.5 0 ) 
					#label: 'Notebook' ) 
				#(#LabelSpec 
					#layout: #(#Point 9 202 ) 
					#label: 'Font:' ) 
				#(#LabelSpec 
					#layout: #(#Point 17 158 ) 
					#label: 'Right:' ) 
				#(#LabelSpec 
					#layout: #(#Point 132 158 ) 
					#label: 'Top:' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 10 0 78 0 -10 1 130 0 ) 
					#label: 'Binding' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 207 99 248 122 ) 
					#model: #binderWidth 
					#tabable: true 
					#menu: #fieldMenu 
					#alignment: #right 
					#numChars: 2 
					#type: #number ) 
				#(#LabelSpec 
					#layout: #(#Point 144 98 ) 
					#label: 'Width:' ) ) ) )! !

!OOPNoteBookSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 6) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 3 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 4 put: ColorValue white; at: 5 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 7099); at: 6 put: (ColorValue scaledRed: 0 scaledGreen: 4915 scaledBlue: 8191); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L2@@@@@CDQDQDQDQDQDQDQD @@@@@1DQDQDQDQDQDQDQH@@@@@LQDQDQDQDQDQDQDR@@@@@CDQ@DL@AC@DL@@AD @@@@@1DSMCL3P3MCL0@QH@@@@@LQ@@@@@@@@@@@0DR@@@@@CDPMST5MST5MPLAD @@@@@1DEMST5MST5LC@QH@@@@@LQ@5MST5MST5@0DR@@@@@CDPT5MST5MST0LAD @@@@@1DCT0@@@@ASTC@QH@@@@@LQASTCL3L0MS@0DR@@@@@CDPMS@@@@@EMPLAD @@@@@1DEMST5MST5LC@QH@@@@@LQ@5MST5MST5@0DR@@@@@CDPT5MST5MST0LAD @@@@@1DCT5MST5MSTC@QH@@@@@LQ@C@0LC@0LC@ADR@@@@@CDPAPTEAPTEAPDQD @@@@@1DQDQDQDQDQDQDQH@@@@@LQDQDQDQDQDQDQDR@@@@@CDQDQDQDQDQDQDQD @@@@@"H"H"H"H"H"H"H"H@@@@@@@@@@@@@@@@@@@@@@@@@@b'))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 255 255 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 135 123 188 192 129 8 140 192 143 255 244 192 136 0 20 192 136 0 20 192 136 0 20 192 136 255 20 192 136 129 20 192 136 255 20 192 136 0 20 192 136 0 20 192 136 0 20 192 136 0 20 192 136 0 20 192 141 85 88 192 141 85 80 192 128 0 0 192 128 0 0 192 128 0 0 192 255 255 255 192 255 255 255 192])! !

UIBApplicationModel subclass: #UIBPaletteEditor
	instanceVariableNames: 'possibleUicsList paletteClassList installedUicsList paletteName numberOfColumns '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Palette'!
UIBPaletteEditor comment:
'UIBPaletteEditor is an application for editing palettes.

Creating a palette is done by selecting a number of user interface components and giving a name. Palettes are installed on subclasses of UIBPalette, a direct subclass of UIPalette, the standard VisualWorks palette. All application logic needed for display of the palette and selection of the user interface components is done by UIPalette. As a consequence, only two methods need to be generated by UIBPaletteEditor: ''activeSpecsList'', which returns an array of specification classes, and ''paletteName'', which returns a name (String) for the palette. This name is used in palette selection menus and lists.'!


!UIBPaletteEditor methodsFor: 'actions'!

addUicToPalette

	| addedAssoc specList selectionIndex |
	specList := self installedUicsList list collect:[:assoc| assoc value].
	addedAssoc := self possibleUicsList selection.
	(selectionIndex := self installedUicsList selectionIndex) = 0
		ifTrue:[specList addFirst: addedAssoc value]
		ifFalse:[specList add: addedAssoc value beforeIndex: selectionIndex + 1].
	self newSpecSymbolList: specList.
	self installedUicsList selection: addedAssoc.
	self installedUicSelectionChanged!

installPalette
	"Install the list of selected specs in the selected class."

	self
		installSpecList: (self installedUicsList list collect:[:assoc|assoc value])
		name: self paletteName value
		columns: self numberOfColumns value
		on: self paletteClassList selection value!

moveDown
	"Change the order of the installed UICs by moving down the selection."

	| uics downIndex downUic |
	uics := self installedUicsList list.
	downIndex := self installedUicsList selectionIndex + 1.
	downUic := uics at: downIndex.
	uics at: downIndex put: (uics at: downIndex - 1).
	uics at: downIndex - 1 put: downUic.
	uics changed: #at: with: downIndex. "update selectively to avoid display flicker"
	uics changed: #at: with: downIndex - 1.
	self installedUicsList selectionIndex: downIndex.
	self installedUicSelectionChanged!

moveUp
	"Change the order of the installed UICs by moving up the selection."

	| uics upIndex upUic |
	uics := self installedUicsList list.
	upIndex := self installedUicsList selectionIndex - 1.
	upUic := uics at: upIndex.
	uics at: upIndex put: (uics at: upIndex + 1).
	uics at: upIndex + 1 put: upUic.
	uics changed: #at: with: upIndex. "update selectively to avoid display flicker"
	uics changed: #at: with: upIndex + 1.
	self installedUicsList selectionIndex: upIndex.
	self installedUicSelectionChanged!

newPalette

	| newPaletteClass classNameOrNil |
	(classNameOrNil := UIBClassInstaller installPaletteClass: 'NewPalette') isNil ifTrue: [^self].
	newPaletteClass := Smalltalk at: classNameOrNil.
	self
		installSpecList: (self installedUicsList list collect:[:assoc|assoc value])
		name: self paletteName value
		columns: self numberOfColumns value
		on: newPaletteClass.
	((self paletteClassList list collect:[:assoc|assoc value]) includes: newPaletteClass) ifFalse:[self newPaletteList].
	self paletteClassList selectionIndexHolder value: ((self paletteClassList list collect:[:assoc|assoc value]) indexOf: newPaletteClass)!

removePalette
	"This code is copied from Browser>removeClass."

	| class | 
	Dictionary keyNotFoundSignal 
		handle: [:ex |
				Dialog
					warn: 'Can''t remove the palette. The class representing it no longer exists.'
					for: self interfaceWindow. 
				ex return]
				"KeyNotFoundSignal is raised when the class name to be removed 
				in the Palette Editor is already removed in another Browser."
		do: [class := self paletteClassList selection value.
			(Dialog confirm: 'Are you sure you want to remove the selected palette ?')
				ifTrue: 
				[class subclasses size > 0
					ifTrue: [self notify: 'The class representing this palette (' , class name , ') has subclasses'].
				class removeFromSystem.
				self newPaletteList]]!

removeUicFromPalette

	| removedAssoc |
	self newSpecSymbolList:
		((self installedUicsList list collect:[:assoc| assoc value])
			remove: (removedAssoc := self installedUicsList selection) value;
			yourself).
	self possibleUicsList selection: removedAssoc.
	self otherUicSelectionChanged!

revertPalette

	self paletteSelectionChanged!

tryPalette

	self paletteClassList selection value openPalette! !

!UIBPaletteEditor methodsFor: 'aspects'!

installedUicsList

	^installedUicsList!

numberOfColumns

	^numberOfColumns!

paletteClassList

	^paletteClassList!

paletteName
	
	^paletteName!

possibleUicsList

	^possibleUicsList! !

!UIBPaletteEditor methodsFor: 'components'!

addButton

	^self builder componentAt: #addUicButton!

downButton

	^self builder componentAt: #moveDownButton!

installAsButton

	^self builder componentAt: #newPaletteButton!

installButton

	^self builder componentAt: #installPaletteButton!

installedUicListView

	^self builder componentAt: #installedUicList!

numberOfColumnsField

	^self builder componentAt: #numberOfColumnsField!

numberOfColumnsLabel

	^self builder componentAt: #numberOfColumnsLabel!

paletteClassListView

	^self builder componentAt: #paletteClassList!

paletteNameField

	^self builder componentAt: #paletteNameField!

paletteNameLabel

	^self builder componentAt: #paletteNameLabel!

possibleUicListView

	^self builder componentAt: #possibleUicList!

removeButton

	^self builder componentAt: #removeUicButton!

removePaletteButton

	^self builder componentAt: #removePaletteButton!

revertButton

	^self builder componentAt: #revertPaletteButton!

tryButton

	^self builder componentAt: #tryPaletteButton!

upButton

	^self builder componentAt: #moveUpButton! !

!UIBPaletteEditor methodsFor: 'component state'!

widget: aWidget enable: aBoolean

	aBoolean
		ifTrue:[aWidget enable]
		ifFalse:[aWidget disable]! !

!UIBPaletteEditor methodsFor: 'changes'!

installedUicSelectionChanged

	| selectionIndex |
	selectionIndex := self installedUicsList selectionIndex.
	self able: selectionIndex > 0 component: #removeUicButton.
	self able: selectionIndex > 1 component: #moveUpButton.
	self able: (selectionIndex > 0 and:[ selectionIndex < self installedUicsList list size]) component: #moveDownButton!

numberOfColumnsChanged

	| selection |
	selection := self paletteClassList selection.
	self able: (((selection isNil or:[selection value ~= UIBPalette]) and:[self paletteName value size > 0]) and:[self numberOfColumns value > 2]) component: #newPaletteButton!

otherUicSelectionChanged

	self able: self possibleUicsList selection notNil component: #addUicButton!

paletteNameChanged

	| selection |
	selection := self paletteClassList selection.
	self able: (((selection isNil or:[selection value ~= UIBPalette]) and:[self paletteName value size > 0]) and:[self numberOfColumns value > 2]) component: #newPaletteButton.
	self disableComponent: #installPaletteButton!

paletteSelectionChanged

	| selection nonStandardPaletteSelected nonStandardPaletteOrNilSelected |
	self newSpecSymbolList: 
		((selection := self paletteClassList selection) isNil
			ifFalse:[selection value activeSpecsList copy]
			ifTrue:[#()]).
	self paletteName value: (selection isNil ifTrue:[''] ifFalse:[self class paletteNameForClass: selection value]).
	self numberOfColumns value: 
		(selection isNil ifTrue:[self class defaultNumberOfColumns] ifFalse:[selection value numberOfColumns]).
	nonStandardPaletteOrNilSelected := selection isNil or:[selection value ~= UIBPalette].
	nonStandardPaletteSelected := (selection notNil and:[selection value ~= UIBPalette]).
	self able: nonStandardPaletteOrNilSelected components: #(#paletteNameLabel #paletteNameField #numberOfColumnsLabel #numberOfColumnsField #revertPaletteButton #installedUicList #possibleUicList).
	self able: (nonStandardPaletteOrNilSelected and:[self paletteName value size > 0]) component: #newPaletteButton.
	self able: nonStandardPaletteSelected components: #(#installPaletteButton #removePaletteButton).
	self able: selection notNil component: #tryPaletteButton.
	selection isNil ifTrue:[self paletteNameField takeKeyboardFocus]! !

!UIBPaletteEditor methodsFor: 'updating'!

newPalette: paletteClass
	"A new palette was selected. Update the application accordingly."
	"paletteClass = UIPalette or subclass"

	self installedUicsList list:
		(self orderedSpecAssociationsOf: paletteClass activeSpecsList copy) asList.
	self possibleUicsList list:
		(self sortedSpecAssociationsOf: self allUICSpecSymbols - paletteClass activeSpecsList copy asSet) asList!

newPaletteList

	self determinePalettes.
	self paletteClassList selectionIndex: 1!

newSpecSymbolList: listOfSpecSymbols
	"Update the application according to the new list of specs."

	self installedUicsList list:
		(self orderedSpecAssociationsOf: listOfSpecSymbols) asList.
	self possibleUicsList list:
		(self sortedSpecAssociationsOf: self allUICSpecSymbols - listOfSpecSymbols asSet) asList.
	self installedUicSelectionChanged; otherUicSelectionChanged! !

!UIBPaletteEditor methodsFor: 'initialize-release'!

initialize

	paletteClassList := SelectionInList  with: OrderedCollection new.
	paletteName :=  String new asValue.
	numberOfColumns := self class defaultNumberOfColumns asValue.
	installedUicsList := SelectionInList with: List new.
	possibleUicsList := SelectionInList with: List new.
	self newPaletteList! !

!UIBPaletteEditor methodsFor: 'private'!

allUICSpecSymbols
	"Answer a Set of all spec classes corresponding to
	user interface components that can be fetched from a palette."

	^((NamedSpec allSubclasses asSet remove: UIBCompositeComponentSpec ifAbsent:[]; yourself)
			select:[:specClass| specClass class includesSelector: #paletteIcon])
		collect:[:specClass| specClass name]!

determinePalettes

	self paletteClassList list: self class palettesWithNames!

installSpecList: specList name: nameString columns: number on: paletteClass

	self class installSpecList: specList name: nameString columns: number on: paletteClass!

orderedSpecAssociationsOf: specSymbolCollection
	"Answer an OrderedCollection of Associations between spec class symbols and spec classes."

	^((specSymbolCollection
		collect:[:specSymbol|
				(Smalltalk includesKey: specSymbol)
					ifTrue:[Association key: (Smalltalk at: specSymbol) componentName value: specSymbol]
					ifFalse:[nil]]) select:[:x| x notNil])
	asOrderedCollection!

sortedSpecAssociationsOf: specSymbolCollection
	"Answer a SortedCollection of Associations between spec class symbols and spec classes."

	^(specSymbolCollection
		collect:[:specSymbol|Association key: (Smalltalk at: specSymbol) componentName value: specSymbol])
	asSortedCollection: [:assoc1 :assoc2| assoc1 key < assoc2 key]! !

!UIBPaletteEditor methodsFor: 'interface opening'!

postBuildWith: aBuilder 

	self paletteClassListView component component noMenuBar.
	self possibleUicListView component component noMenuBar.
	self installedUicListView component component noMenuBar.
	self paletteSelectionChanged!

postOpenWith: aBuilder 

	self paletteNameField widget controller continuousAccept: true.
	self numberOfColumnsField widget controller continuousAccept: true! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPaletteEditor class
	instanceVariableNames: ''!


!UIBPaletteEditor class methodsFor: 'generating'!

installSpecInstance: spec named: componentName on: paletteClass

	| specList selector aStream |
	selector := componentName select: [:char| char isAlphaNumeric].
	selector at: 1 put: selector first asLowercase.
	selector := selector , 'Spec'.
	specList := paletteClass activeSpecsList copyWith: (Array with: componentName with: paletteClass name with: selector asSymbol).

	aStream := String new writeStream.
	aStream
		nextPut: $!!; nextPutAll: paletteClass name; nextPutAll: ' class methodsFor: ''accessing-specs''!!';
		cr; cr;
		nextPutAll: 'activeSpecsList';
		cr; crtab;
		nextPut: $^; store: specList asArray;
		nextPutAll: '!!';
		cr; cr;
		nextPutAll: selector;
		cr; crtab;
		nextPut: $^.
	spec class prettyPrintSpecArray: spec literalArrayEncoding on: aStream tabLevel: 1.
	aStream
		nextPutAll: '!! !!'.
	aStream contents readStream fileIn!

installSpecList: specList name: nameString columns: number on: paletteClass

	(String new writeStream
		nextPut: $!!; nextPutAll: paletteClass name; nextPutAll: ' class methodsFor: ''accessing-specs''!!';
		cr; cr;
		nextPutAll: 'activeSpecsList';
		cr; crtab;
		nextPut: $^; store: specList asArray;
		nextPutAll: '!! !!';
		cr;
		nextPut: $!!; nextPutAll: paletteClass name; nextPutAll: ' class methodsFor: ''accessing''!!';
		cr; cr;
		nextPutAll: 'paletteName';
		cr; crtab;
		nextPut: $^; store: nameString;
		nextPutAll: '!! ';
		cr; cr;
		nextPutAll: 'numberOfColumns';
		cr; crtab;
		nextPut: $^; store: number;
		nextPutAll: '!! !!';
		contents)
	readStream fileIn! !

!UIBPaletteEditor class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Palette Editor' 
			#bounds: #(#Rectangle 237 138 571 424 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0 22 0 -90 1 77 0 ) 
					#name: #paletteClassList 
					#model: #paletteClassList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #paletteSelectionChanged 
						#doubleClickSelector: #tryPalette ) ) 
				#(#LabelSpec 
					#layout: #(#Point 5 0 ) 
					#label: 'Installed Palettes:' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -80 1 86 0 -5 1 111 0 ) 
					#name: #tryPaletteButton 
					#flags: 40 
					#model: #tryPalette 
					#label: 'Open' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -80 1 2 0 -5 1 27 0 ) 
					#name: #installPaletteButton 
					#model: #installPalette 
					#label: 'Install' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -80 1 58 0 -5 1 83 0 ) 
					#name: #removePaletteButton 
					#model: #removePalette 
					#label: 'Remove' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -80 1 30 0 -5 1 55 0 ) 
					#name: #newPaletteButton 
					#model: #newPalette 
					#label: 'Install As...' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#Point 5 113 ) 
					#name: #paletteNameLabel 
					#label: 'Name:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 55 0 116 0 -5 1 141 0 ) 
					#name: #paletteNameField 
					#model: #paletteName 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #paletteNameChanged ) ) 
				#(#LabelSpec 
					#layout: #(#Point 5 140 ) 
					#label: 'On Palette:' ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0 162 0 -25 0.5 -38 1 ) 
					#name: #installedUicList 
					#model: #installedUicsList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #installedUicSelectionChanged 
						#doubleClickSelector: #removeUicFromPalette ) 
					#multipleSelections: false ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 25 0.5 140 0 ) 
					#label: 'Other:' ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 25 0.5 162 0 -5 1 -5 1 ) 
					#name: #possibleUicList 
					#model: #possibleUicsList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #otherUicSelectionChanged 
						#doubleClickSelector: #addUicToPalette ) 
					#multipleSelections: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -15 0.5 162 0 15 0.5 192 0 ) 
					#name: #addUicButton 
					#model: #addUicToPalette 
					#label: #addButtonIcon 
					#hasCharacterOrientedLabel: false 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -15 0.5 197 0 15 0.5 227 0 ) 
					#name: #removeUicButton 
					#model: #removeUicFromPalette 
					#label: #removeButtonIcon 
					#hasCharacterOrientedLabel: false 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -15 0.5 -35 1 15 0.5 -5 1 ) 
					#name: #revertPaletteButton 
					#model: #revertPalette 
					#label: #revertButtonIcon 
					#hasCharacterOrientedLabel: false 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 5 0 -35 1 35 0 -5 1 ) 
					#name: #moveUpButton 
					#flags: 40 
					#model: #moveUp 
					#label: #upButtonIcon 
					#hasCharacterOrientedLabel: false 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 45 0 -35 1 75 0 -5 1 ) 
					#name: #moveDownButton 
					#flags: 40 
					#model: #moveDown 
					#label: #downButtonIcon 
					#hasCharacterOrientedLabel: false 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#Point 5 83 ) 
					#name: #numberOfColumnsLabel 
					#label: 'Columns:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 78 84 123 109 ) 
					#name: #numberOfColumnsField 
					#model: #numberOfColumns 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #numberOfColumnsChanged ) 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) ) ) )! !

!UIBPaletteEditor class methodsFor: 'accessing-palettes'!

defaultNumberOfColumns

	^3!

openPaletteFromUserSelection

	"self openPaletteFromUserSelection"

	| selection |
	(selection := UIBPaletteEditor palettesMenuForOpening startUp) = 0
		ifFalse: [selection value]!

paletteNameForClass: aPaletteClass
	"Since the standard class UIPalette does not have a 'paletteName' method and its subclasses do have one:"

	^aPaletteClass == UIBPalette
		ifTrue:[self standardPaletteName]
		ifFalse:[aPaletteClass paletteName]!

palettesMenuForOpening

	"self palettesMenuForOpening startUp"

	| nameClassAssocs |
	nameClassAssocs := UIBPaletteEditor palettesWithNames asArray.
	^Menu
		labelArray: (nameClassAssocs collect:[:assoc| assoc key])
		lines: #(1)
		values: (nameClassAssocs collect:[:assoc| [assoc value openPalette]])!

palettesMenuForSelection

	"self palettesMenuForSelection startUp"

	| nameClassAssocs |
	nameClassAssocs := UIBPaletteEditor palettesWithNames asArray.
	^Menu
		labelArray: (nameClassAssocs collect:[:assoc| assoc key])
		lines: #(1)
		values: (nameClassAssocs collect:[:assoc| assoc value])!

palettesMenuForSelectionOrNone
	"Answer a pop-up menu of existing palettes and return the selection or nil.
	The selection can also be #none, indicating that no palette was selected but
	the menu was not dismissed." 

	"self palettesMenuForSelectionOrNone startUp"

	| nameClassAssocs |
	nameClassAssocs := UIBPaletteEditor palettesWithNames add: 'None' -> #none beforeIndex: 1; asArray.
	^Menu
		labelArray: (nameClassAssocs collect:[:assoc| assoc key])
		lines: #(2)
		values: (nameClassAssocs collect:[:assoc| assoc value])!

palettesWithNames
	"Anser an orderedCollection of name-palette class associations."

	"self palettesWithNames"

	| nameToClassAssocs |
	nameToClassAssocs :=
		(UIBPalette allSubclasses asSortedCollection: [:x :y| x paletteName <= y paletteName]) asOrderedCollection
			collect: [:paletteClass| Association key: paletteClass paletteName value: paletteClass].
	nameToClassAssocs addFirst: (Association key: UIBPalette paletteName value: UIBPalette).
	^nameToClassAssocs!

standardPaletteName
	"Answer an appropriate name for the standard VW palette."

	^'Standard Palette'! !

!UIBPaletteEditor class methodsFor: 'generated resources'!

addButtonIcon

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwLeftArrowIcon24]
		ifFalse: [^UIBImage cgLeftArrowIcon24]!

downButtonIcon

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwDownArrowIcon24]
		ifFalse: [^UIBImage cgDownArrowIcon24]!

removeButtonIcon

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwRightArrowIcon24]
		ifFalse: [^UIBImage cgRightArrowIcon24]!

revertButtonIcon

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwUndoIcon24]
		ifFalse: [^UIBImage cgUndoIcon24]!

upButtonIcon

	Screen default colorDepth == 1
		ifTrue: [^UIBImage bwUpArrowIcon24]
		ifFalse: [^UIBImage cgUpArrowIcon24]! !

Model subclass: #UIBPerson
	instanceVariableNames: 'name '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBPerson methodsFor: 'accessing'!

name

	^name!

name: aValue

	name := aValue.
	self changed: #name! !

Object subclass: #UIBComponentGenerator
	instanceVariableNames: 'component aspectEnumerator propertyNames '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Generation'!
UIBComponentGenerator comment:
'I am a generator for user-defined components.
I generate specifications as well as normal Smalltalk code. Subclasses of UIBApplicationModel are generated to hold onto the component''s user interfaces. One specification class is generated to represent the component in VisualWorks.

Instance variables:
	component		<UIBComponent>			The user-defined component to generate code for.
	aspectEnumerator	<UIBAspectEnumerator>		The enumerator that enumerates all information of the component required for the generation.
	propertyNames	<IdentitySet of: Symbol>		The names of the component-specific properties.'!


!UIBComponentGenerator methodsFor: 'generating'!

determinePropertyNames

	| namesAlreadyInUse instance |
	namesAlreadyInUse := IdentityDictionary new.
	instance := self component targetClass basicNew.
	self component targetClass superclass addBindingsTo: namesAlreadyInUse for: instance channel: instance asValue.
	propertyNames := aspectEnumerator bindings keys - namesAlreadyInUse keys!

generate

	"Order is important!!"
	self
		resetAspectEnumerator;
		determinePropertyNames;
		generateInstanceVariables;
		generateInstanceMethods;
		generateClassMethods.
	self component targetClass flushIcons.
	Transcript cr; show: self component targetClassName; show: ' defined.'; cr!

generateClassMethods

	self
		generateComponentNameMethod;
		generateSlicesMethod;
		generateBindingsMethod;
		generateSpecMethods;
		generatePaletteIconMethod;
		generatePaletteMonoIconMethod!

generateInstanceMethods

	self
		generateAccessorMethods!

generateInstanceVariables
	"Generate instance variables for holding the properties of the slice interfaces.
	Make sure that instance variables are not defined twice and that no instance
	variables are defined for properties of superclasses."
	"Since other methods rely on the fact that IVs of a spec class may only represent properties,
	also compile the class definition when no IVs are needed."
	"Removing properties from a specification may lead to compiler 'Undeclared' errors,
	since old property methods refer to IVs that no longer exist."

	self fileInStreamWith:[:aStream| self classDefiningMessageForIVs: propertyNames on: aStream]!

oldGenerateInstanceVariables
	"Generate instance variables for holding the properties of the slice interfaces.
	Make sure that instance variables are not defined twice and that no instance
	variables are defined for properties of superclasses."
	"Since other methods rely on the fact that IVs of a spec class may only represent properties,
	also compile the class definition when no IVs are needed."
	"Removing properties from a specification may lead to compiler 'Undeclared' errors,
	since old property methods refer to IVs that no longer exist."

	| ivNames |
	ivNames := ((aspectEnumerator bindings keys collect: [:x|x asString])
					"Some properties of superclasses are not kept in instance variables, so reject them:"
					reject:[:x| self component targetClass superclass canUnderstand: x asSymbol])
				"Reject all instance variables of superclasses:"
				- self component targetClass superclass allInstVarNames asSet.
	self fileInStreamWith:[:aStream| self classDefiningMessageForIVs: ivNames on: aStream]! !

!UIBComponentGenerator methodsFor: 'generating-class'!

generateBindingsMethod

	self
		generateStreamWith: [:aStream| self bindingsMethodOn: aStream]
		inClassProtocol: #'private-interface building'!

generateComponentNameMethod

	self
		generateStreamWith: [:aStream| self componentNameMethodOn: aStream]
		inClassProtocol: #'private-interface building'!

generatePaletteIconMethod

	self
		generateStreamWith: [:aStream| self paletteIconMethodOn: aStream]
		inClassProtocol: #'resources'!

generatePaletteMonoIconMethod

	self
		generateStreamWith: [:aStream| self paletteMonoIconMethodOn: aStream]
		inClassProtocol: #'resources'!

generateSlicesMethod

	self
		generateStreamWith: [:aStream| self sliceMethodOn: aStream]
		inClassProtocol: #'private-interface building'!

generateSpecMethods
	"Generate spec methods for the specs that reside in the target class."

	self component slices
		do: [:slice|
			(self component isOurOwnSlice: slice)
				ifTrue:[self generateSpecFromEditSlice: slice]]! !

!UIBComponentGenerator methodsFor: 'generating-instance'!

generateAccessorMethods

	self
		generateReadAccessorMethodsFor: self component targetClass instVarNames;
		generateWriteAccessorMethodsFor: self component targetClass instVarNames;
		generateDecodeAccessorMethodsFor: self component targetClass instVarNames!

generateDecodeAccessorMethodsFor: ivNames

	ivNames do:[:ivName|
		self
			generateStreamWith: [:aStream| self decodeAccessorMethodFor: ivName on: aStream]
			inInstanceProtocol: #'decoding']!

generateReadAccessorMethodsFor: ivNames

	ivNames do:[:ivName|
		self
			generateStreamWith: [:aStream| self readAccessorMethodFor: ivName on: aStream]
			inInstanceProtocol: #'accessing']!

generateWriteAccessorMethodsFor: ivNames

	ivNames do:[:ivName|
		self
			generateStreamWith: [:aStream| self writeAccessorMethodFor: ivName on: aStream]
			inInstanceProtocol: #'accessing']! !

!UIBComponentGenerator methodsFor: 'private-generating'!

classDefiningMessageForIVs: ivNames on: codeStream 
	"Create a new class definition string starting with the current one. Build the 
	instance variables string by taking the new instance variables separated by spaces. Then format 
	the class definition message and put it as the next chunk in the code stream"

	"Original code taken from UIDefiner>writeClassDefiningMessageForIVs: ivNames on: codeStream."

	| aStream msg |
	aStream := String new writeStream.
	msg := self component targetClass definitionMessage.
	"Spec classes should only have instance variables for holding properties,
	so the following line is retracted from the original code fragment."
	"aStream nextPutAll: (msg arguments at: 2). aStream space. "
	ivNames do: [:e | aStream nextPutAll: e; space].
	msg arguments at: 2 put: aStream contents.
	aStream := String new writeStream.
	msg receiver printOn: aStream.
	msg selector keywords with: msg arguments
		do: 
			[:word :arg | 
			arg == self component targetClass name
				ifTrue: [aStream space]
				ifFalse: [aStream cr; tab].
			aStream nextPutAll: word; space; store: arg].
	codeStream nextChunkPut: aStream contents!

fileInStreamWith: streamBlock

	| aStream |
	aStream := String new writeStream.
	streamBlock value: aStream.
	aStream contents readStream fileIn!

generateStreamWith: streamBlock inClass: aClass inProtocol: protocolName
	"Execute streamBlock, which takes a stream.
	Generate the contents of the stream as a method in the given class and protocol."

	Cursor execute showWhile:
		[| aStream |
		aStream := String new writeStream.
		streamBlock value: aStream.
		aClass compile: aStream contents classified: protocolName asSymbol]!

generateStreamWith: streamBlock inClassProtocol: protocolName
	"Execute streamBlock, which takes a stream.
	Generate the contents of the stream as a class method in the target class and the given protocol."

	self generateStreamWith: streamBlock inClass: self component targetClass class inProtocol: protocolName!

generateStreamWith: streamBlock inInstanceProtocol: protocolName
	"Execute streamBlock, which takes a stream.
	Generate the contents of the stream as an instance method in the target class and the given protocol."

	self generateStreamWith: streamBlock inClass: self component targetClass inProtocol: protocolName!

resetAspectEnumerator
	"Initialize my aspectEnumerator instance variable for the current target class and slice specs."

	aspectEnumerator :=
		(UIBAspectEnumerator new source: self component targetClass)
			doSpecs: (self component ownSlices collect: [:slice|slice fullSpec])! !

!UIBComponentGenerator methodsFor: 'private-generating-class'!

bindingsMethodOn: aStream
	"Generate the #addBindingsTo:for:channel: method on aStream."

	aStream
		nextPutAll: 'addBindingsTo: env for: inst channel: aChannel'; cr; crtab;
		nextPutAll: 'super addBindingsTo: env for: inst channel: aChannel.'.
	(aspectEnumerator bindingSpecAssociations associations select: [:assoc| propertyNames includes: assoc key]) do:
		[:binding|
		aStream crtab; nextPutAll: 'env at: '; nextPutAll: binding key storeString; nextPutAll: ' put: '.
		(binding value isKindOf: UIBPropertyComponentSpec) "Is a property component being used in a properties slice ?"
			ifFalse:[(binding value isKindOf: UIBCompositeComponentSpec) "Is a custom component being used in a properties slice ?"
					ifTrue:[self customComponentBinding: binding on: aStream]
					ifFalse:[self standardBinding: binding on: aStream]]
			ifTrue:[self uibPropertyBinding: binding on: aStream].
		aStream nextPut: $.].
	(aspectEnumerator menuSpecAssociations associations select: [:assoc| propertyNames includes: assoc key]) do:
		[:binding|
		aStream crtab;  nextPutAll: 'env at: '; nextPutAll: binding key storeString;
		nextPutAll: ' put: self '; nextPutAll: binding key asString;
		nextPut: $.]!

componentNameMethodOn: aStream
	"Generate the #componentName method on aStream."

	aStream
		nextPutAll: 'componentName'; cr; crtab;
		nextPut: $^; nextPutAll: self component componentName storeString!

customComponentBinding: bindingToSpecAssociation on: aStream

	| aspectName |
	aStream
		nextPutAll: '(self adapt: inst accessWith: ';
		nextPutAll: (aspectName := bindingToSpecAssociation key) storeString;
		nextPutAll: ' assignWith: ';
		nextPutAll: (bindingToSpecAssociation value class putSelectorForGetSelector: aspectName) storeString;
		nextPutAll: ' channel: aChannel)'!

generateSpecFromEditSlice: editSlice

	UIBPainter
		store: editSlice fullSpec
		toClass: self component targetClass class
		methodName: editSlice specSelector.
	UIBFinder installed: (Array with: self component targetClassName with: editSlice specSelector).!

paletteIconMethodOn: aStream
	"Generate the #paletteIcon method on aStream."

	aStream
		nextPutAll: 'paletteIcon'; crtab;
		nextPutAll: '"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"'; cr; crtab;
		nextPutAll: '<resource: #image>'; crtab;
		nextPutAll: '^CachedImage on: (';
		nextPutAll: self component paletteIcon minimalStorageString;
		nextPut: $)!

paletteMonoIconMethodOn: aStream
	"Generate the #paletteMonoIcon method on aStream."

	aStream
		nextPutAll: 'paletteMonoIcon'; crtab;
		nextPutAll: '"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"'; cr; crtab;
		nextPutAll: '<resource: #image>'; crtab;
		nextPutAll: '^CachedImage on: (';
		nextPutAll: self component paletteMonoIcon minimalStorageString;
		nextPut: $)!

sliceMethodOn: aStream
	"Generate the #slices method on aStream. Pretty print the slice array."

	| theSlices |
	theSlices := self component realSlices.
	aStream
		nextPutAll: 'slices'; cr; crtab;
		nextPutAll: '^#( '.
	 1 to: self component slices size - 1 do:
		[:index| aStream nextPutAll: (theSlices at: index) storeString; crtab; tab].
	aStream
		nextPutAll: theSlices last storeString;
		nextPutAll: ' )'!

standardBinding: bindingToSpecAssociation on: aStream

	| aspectName |
	aStream
		"nextPutAll: '(self adapt: inst forAspect: ';
		nextPutAll: bindingToSpecAssociation key storeString;
		nextPutAll: ' channel: aChannel)'"

"Koen: is dit correcter dan wat boven staat?"

		nextPutAll: '(self adapt: inst accessWith: ';
		nextPutAll: (aspectName := bindingToSpecAssociation key) storeString;
		nextPutAll: ' assignWith: ';
		nextPutAll: (UIBCompositeComponentSpec putSelectorForGetSelector: aspectName) storeString;
		nextPutAll: ' channel: aChannel)'!

uibPropertyBinding: bindingToSpecAssociation on: aStream

	"aStream
		nextPutAll: '(self adapt: inst forAspect: ';
		nextPutAll: bindingToSpecAssociation value targetAspect storeString;
		nextPutAll: ' accessPath: #(';
		nextPutAll: bindingToSpecAssociation key storeString;
		nextPutAll: ') channel: aChannel)'"

	aStream
		nextPutAll: '(self adapt: inst forAspect: ';
		nextPutAll: '#property';
		nextPutAll: ' accessPath: #(';
		nextPutAll: bindingToSpecAssociation key storeString;
		nextPutAll: ') channel: aChannel)'! !

!UIBComponentGenerator methodsFor: 'private-generating-instance'!

decodeAccessorMethodFor:ivName on: aStream
	"Generate the decode accessor method for ivName on aStream."
	"Decode accessor messages are sent when decoding literal array encodings.
	The messages correspond to the keywords used in the encodings."

	((aspectEnumerator bindingSpecAssociations at: ivName asSymbol) isKindOf: UIBPropertyComponentSpec)
		ifFalse:[aStream
				nextPutAll: ivName; nextPutAll: ': aValue'; cr; crtab;
				nextPutAll: ivName;  nextPutAll: ' := aValue decodeAsLiteralArray']
		ifTrue:[aStream
				nextPutAll: ivName; nextPutAll: ': aValue'; cr; crtab;
				nextPutAll: 'self '; nextPutAll: ivName;
				space; nextPutAll: 'property:';
				space; nextPutAll: 'aValue decodeAsLiteralArray']!

readAccessorMethodFor:ivName on: aStream
	"Generate the read accessor method for ivName on aStream. Use the default model as initial value."

	| bindingsToSpecs spec m |
	bindingsToSpecs := aspectEnumerator bindingSpecAssociations.
	aStream nextPutAll: ivName; cr; crtab; nextPut:$^; nextPutAll: ivName.
	spec := bindingsToSpecs at: ivName asSymbol.
	(spec isKindOf: UIBPropertyComponentSpec)
		ifTrue:[	aStream
					nextPutAll: ' == nil'; crtab: 2;
					nextPutAll:'ifTrue:['; nextPutAll: ivName; nextPutAll: ' := ';
					nextPutAll: spec property storeString;
					nextPutAll: ']'; crtab: 2; nextPutAll:'ifFalse:['; nextPutAll: ivName; nextPut: $].
				^self].
	(((m := aspectEnumerator bindings at: ivName asSymbol) isKindOf: ValueModel) ifTrue:[m := m value] ifFalse:[m]) isNil
		ifFalse:[	aStream nextPutAll: ' == nil ifTrue:['.
				(spec class canUnderstand: #defaultModelString)
					ifTrue:[aStream nextPutAll: spec defaultModelString]
					ifFalse:[ aStream nextPutAll: m storeString].
				aStream
					nextPutAll: '] ifFalse:['; nextPutAll: ivName; nextPut: $]]!

writeAccessorMethodFor:ivName on: aStream
	"Generate the write accessor method for ivName on aStream."

	aStream
		nextPutAll: 'set'; nextPut: ivName first asUppercase;
		nextPutAll: (ivName copyFrom: 2 to: ivName size);
		nextPutAll: ': aValue'; cr; crtab;
		nextPutAll: ivName;  nextPutAll: ' := aValue'! !

!UIBComponentGenerator methodsFor: 'private-accessing'!

component

	^component! !

!UIBComponentGenerator methodsFor: 'initialize-release'!

forComponent: aUIBComponent

	component := aUIBComponent! !

!UIBComponentGenerator methodsFor: 'validation'!

allPropertiesHaveNames

	self resetAspectEnumerator.
	^aspectEnumerator incompletes isEmpty!

isValidForInstall
	"Answer a Boolean indicating that all data are valid for installation of a component."

	"Check whether all property fields have names, otherwise some IVs and accessors are not generated."

	self allPropertiesHaveNames
		ifFalse:[Dialog warn:'Can''t install: some properties are not named.'. ^false].
	^true! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBComponentGenerator class
	instanceVariableNames: ''!


!UIBComponentGenerator class methodsFor: 'instance creation'!

forComponent: aUIBComponent

	^self new forComponent: aUIBComponent! !

UIBComponentGenerator subclass: #UIBExtendedStandardComponentGenerator
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Generation'!


UIPainter subclass: #UIBPainter
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!


!UIBPainter methodsFor: 'private'!

findControls
	"Overridden here in order to use our own canvas tool."

	^self dependents
		detect:
			[:dpndnt |
			((dpndnt isKindOf: ApplicationWindow) and:
				[dpndnt model isKindOf: UIBCanvasTool])]
		ifNone: nil!

installInSystem

	self
		store: self makeFullSpec
		toClass: self targetClass class
		methodName: self targetSelector.
	Transcript cr; show: self targetClass class name, '>', self targetSelector, ' defined'.
	UIBFinder installed: (Array with: self targetClass name with: self targetSelector).
	self accept!

openAnyControls
	"Overridden here in order to use our own canvas tool."

	| canvasToolView |
	canvasToolView := nil.
	UIBCanvasTool allInstances size = 0 ifFalse: [ScheduledControllers scheduledControllers do: [:c | Object errorSignal handle: [:ex | ex return]
				do: [(c model isKindOf: UICanvasTool)
						ifTrue: [canvasToolView := c view]]]].
	canvasToolView isNil
		ifTrue: [UICanvasTool new openInterface: #windowSpecTight]
		ifFalse: [canvasToolView isCollapsed
				ifTrue: [canvasToolView expand]
				ifFalse: [canvasToolView raise]]!

openControlsNear: mainWindow

	"Overridden here in order to use our own builder class."

	| ccBuilder ctrlr |
	ccBuilder := UIBBuilder new.
	ctrlr := self builder composite controller.
	ValueHolder with: #Default.
	ccBuilder aspectAt: #gridMenu put: self class gridModeMenu.
	ccBuilder aspectAt: #gridMode put: ctrlr showGrid.
	ctrlr showGrid compute: 
		[:v | 
		v ~= #Off
			ifTrue: 
				[(ccBuilder componentAt: #GridSizeField) enable.
				(ccBuilder componentAt: #HConstrainButton) enable.
				(ccBuilder componentAt: #VConstrainButton) enable]
			ifFalse: 
				[(ccBuilder componentAt: #GridSizeField) disable.
				(ccBuilder componentAt: #HConstrainButton) disable.
				(ccBuilder componentAt: #VConstrainButton) disable]].
	ccBuilder aspectAt: #griddedHorizontally put: ctrlr griddedHorizontally.
	ccBuilder aspectAt: #griddedVertically put: ctrlr griddedVertically.
	ccBuilder aspectAt: #gridStep put: ctrlr gridStep.
	ccBuilder aspectAt: #fenced put: ctrlr fenced.
	ccBuilder aspectAt: #lookMenu put: self defaultLookMenu.
	ccBuilder aspectAt: #lookSelection put: currentLook.
	ccBuilder add: (self class interfaceSpecFor: #controlsSpec).
	(ccBuilder componentAt: #LookSelector) widget menu: self defaultLookMenu.
	ctrlr showGrid setValue: ctrlr showGrid value.
	ccBuilder openAt: (self class canvasControlPlaceNear: mainWindow for: ccBuilder window extent).
	(ccBuilder window) application: self; model: #canvasControls; beSlave.
	(ccBuilder window) icon: (Icon constantNamed: #canvasControl).
	^ccBuilder window!

openPainterWindows: winSpec  withPalette: paletteClass
	"Used by all the various opening methods -- except when spawning. 
	Depending on user preferences, may open a satellite palette or (possibly 
	in the future) other auxiliary windows, as well as the builder window used 
	for interface painting. Do the initial 'accept' for the user. If the host 
	window manager is OpenWindows, delay awhile in the fond hope that 
	the window manager's information will eventually stabilize."

	| mainWindow winSpecBounds ctrlr |
	(mainWindow := builder window) application: self.
	mainWindow controller: UIPainterSystemController new.
	mainWindow label: winSpec label.

	"The value of mainWindow minimumSize and maximumSize will set the 
	actual range of sizes available through the host window manager's 
	controls. The range of sizes available through VW's window control 
	menu will be controlled by minWindowExtent and maxWindowExtent."

	mainWindow minimumSize: WindowSpec initialMin.
	mainWindow maximumSize: (UIPainter preferenceFor: #maximumCanvasWidth)
			@ (UIPainter preferenceFor: #maximumCanvasHeight).
	winSpec colors == nil ifFalse: [mainWindow lookPreferences: winSpec colors].
	mainWindow icon: (Icon constantNamed: #painter).
	(winSpecBounds := winSpec bounds) isNil
		ifTrue: [mainWindow openWithExtent: 200 @ 200 andType: #normal]
		ifFalse: [mainWindow openWithExtent: winSpecBounds extent andType: #normal].
	mainWindow beMaster.
	(Delay forMilliseconds: ((self class preferenceFor: #hostWindowManager)
			== #OpenWindows
			ifTrue: [500]
			ifFalse: [200])) wait.
	(self class preferenceFor: #openControlsWithCanvas)
		= #many
		ifTrue: [self openToolsFor: mainWindow]
		ifFalse: [(self class preferenceFor: #openControlsWithCanvas)
				= #one ifTrue: [self openAnyControls]].
	paletteClass isNil
		ifFalse: [self openPalette: paletteClass for: mainWindow].
	(ctrlr := self findPainterController) notNil ifTrue: [ctrlr becomeLastControllerWithSelection].
	self accept!

openPalette: paletteClass for: mainWindow
	"Make sure that if canvas controls exist and are collapsed that
	they do not expand also."

	| exstgPal exstgCC oldWEBlock | 
	(exstgPal := self findPalette) notNil
		ifTrue:
			[exstgPal
				displayBox:
					((paletteClass palettePlaceNear: mainWindow for: exstgPal bounds extent)
						extent: exstgPal bounds extent).
			exstgPal isCollapsed
				ifTrue:
					[((exstgCC := self findPalette) notNil and:
							[exstgCC isCollapsed])
						ifTrue:
							[oldWEBlock := exstgCC windowEventBlock.
							exstgCC windowEventBlock:
								[:w :ev :ow |
								exstgCC windowEventBlock: oldWEBlock. true]].
					exstgPal expand]
				ifFalse:
					[exstgPal raise]]
		ifFalse:
			[(paletteClass openPaletteNear: mainWindow)
				application: self; beSlave]!

openToolsNear: mainWindow
	"Overridden here in order to use our own canvas tool."

	| ccBuilder ct |
	ct := UIBCanvasTool new.
	ccBuilder :=  ct allButOpenInterface: #windowSpecTight.
	ccBuilder openAt: (self class canvasToolsPlaceNear: mainWindow bounds: ccBuilder window extent).
	ct postOpenWith: ccBuilder.
	(ccBuilder window) application: self; model: ct; beSlave.
	(ccBuilder window) icon: (Icon constantNamed: #canvasControl).
	^ccBuilder window!

preferredBuilderClass

	^UIBBuilder!

runInstallationDialog
	"The assumption embodied here is that the source for resources 
	while painting is a class:  the send of targetClass: will also change 
	the source instVar of the receiver's builder."

	| result |
	result :=
		self targetClass isNil
			ifTrue: [UIBFinder openDestinationDialogForCategory: #'interface specs' defaultSelector: #windowSpec]
			ifFalse:
				[UIBFinder
					openDestinationDialogWithClass: self targetClass
					andSelector: (self targetSelector isNil ifTrue: [#windowSpec] ifFalse: [self targetSelector])
					andCategory: #'interface specs'].
	result isNil ifTrue: [^nil].
	self targetClass: (result at: 1).
	self targetSelector: (result at: 2).
	^result!

store: aSpec toClass: class methodName: methodName

	self class store: aSpec toClass: class methodName: methodName! !

!UIBPainter methodsFor: 'initialize-release'!

initializeBuilder
	self builder: self preferredBuilderClass new.
	builder isEditing: true.
	builder composite: UIPainterView new.
	builder composite controller: UIBPainterController new!

initializeDefiner

	definer := UIBDefiner for: self targetClass!

initializeWindowSpec

	self windowSpec: UIBWindowSpec new! !

!UIBPainter methodsFor: 'interface opening'!

openNewWindowCanvasWithPalette: aPaletteClass
	"Open a new canvas in a window and place the given palette alongside.
	Do not open a palette window if no palette class is given."

	self setupBuilder.
	self openPainterWindows: builder spec withPalette: aPaletteClass! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPainter class
	instanceVariableNames: ''!


!UIBPainter class methodsFor: 'accessing'!

painterClassCommentName
	"Answer the Painter class name that should be used in comment strings of spec selectors."

	^#UIBPainter "Not 'self name' because subclasses may not be able to open specs in a window."!

preferredPaletteClass

	^UIBPalette! !

!UIBPainter class methodsFor: 'instance creation'!

new
	"Overridden here since the implementation in the superclass is not abstract with respect to the class."
 
	^self basicNew initialize! !

!UIBPainter class methodsFor: 'storing specs'!

store: aSpec toClass: class methodName: methodName
	"Copied from FullSpec for generating our own comment string."

	| array s|
	array := aSpec literalArrayEncoding.
	s := (String new: 100) writeStream.
	s nextPutAll: methodName; cr.
	"Put in a nice comment for re-opening the painter."
	s tab;
		nextPut:$"; nextPutAll: self painterClassCommentName;
		nextPutAll: ' new openOnClass: self andSelector: #';
		nextPutAll: methodName; nextPut: $"; cr;
		crtab; nextPutAll: '<resource: #canvas>';
		crtab; nextPut: $^.
	FullSpec prettyPrintSpecArray: array on: s tabLevel: 1.
	class compile: s contents classified: #'interface specs'.
	class removeSelector: #markedAsSystemClass.! !

DragMode subclass: #UIBSideDragMode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter-Support'!
UIBSideDragMode comment:
'UIBSideDragMode  is used when the user is adjusting the size of a selected component by manipulating one of its four ''handles'' on the sides.'!


!UIBSideDragMode methodsFor: 'control'!

dragObject: aHandle startingAt: aPoint inController: aController 

	| startPt box constrainedX |
	startPt := aHandle getOrigin.
	box := aHandle wrapper bounds.
	aController hideHandles.
	constrainedX := aHandle selector == #leftCenter or: [ aHandle selector == #rightCenter].
	self redButtonDragWhileTrue: 
			[:point |
			| pt |
			pt := self constrain: point from: startPt horizontally: constrainedX.
			aController isFenced
				ifTrue:
					[pt := (self containedPointFor: pt in: aController view bounds)].
			pt = startPt
				ifFalse: 
					[| bb tb|
					bb := aHandle wrapper bounds.
					tb := self stretchRectangle: box from: startPt to: pt.
					(tb height >= 1 and: [tb width >= 1])
						ifTrue: [box := tb.
								aController view
								newBounds: box
								oldBounds: bb
								forWrapper: aHandle wrapper.
								startPt := pt]]] inController: aController.
	aController canvasHasChanged: true.
	aController showHandles! !

!UIBSideDragMode methodsFor: 'private'!

stretchRectangle: rect from: start to: new 

	| delta |
	delta := new - start.
	start = rect leftCenter
		ifTrue: [^Rectangle vertex: rect origin + delta vertex: rect corner].
	start = rect rightCenter
		ifTrue: [^Rectangle vertex: rect origin vertex: rect corner + delta].
	start = rect topCenter
		ifTrue: [^Rectangle vertex: rect topRight + delta vertex: rect bottomLeft].
	start = rect bottomCenter
		ifTrue: [^Rectangle vertex: rect bottomLeft + delta vertex: rect topRight].
	^super stretchRectangle: rect from: start to: new! !

Model subclass: #UIBComponent
	instanceVariableNames: 'targetClassName componentName slices placementExtent paletteIcon paletteMonoIcon hasChanged '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components'!
UIBComponent comment:
'I represent a user-defined component. I hold onto all necessary information to generate specifications and application code. The generation is done by a UIBComponentgenerator.

Instance variables:
	targetClassName	<Symbol>	The name of the receiver''s target specification class.
	componentName	<String>	The name of the receiver (for use while painting).
	placementExtent	<Point>	The default size of the receiver when dragged off a palette.
	slices			<OrderedCollection of: UIBSlice>	The slices in the receiver''s properties tool.
	paletteIcon		<Image>	The receiver''s colour palette icon.
	paletteMonoIcon	<Image>	The receiver''s black and white palette icon.
	lookAndFeels		<List of: UIBComponentLookAndFeel>	The user interfaces of the receiver.
	defaultLookAndFeel	<UIBComponentLookAndFeel>	The default user interface of the receiver.
	hasChanged 		<Boolean>	Indication of the ''installed'' state of the receiver.'!


!UIBComponent methodsFor: 'updating'!

makeLookAndFeelsConsistent

	self lookAndFeels do: [:look| look makeConsistent].!

updateSlices

	self slices:
		(self editSlicesOf: 
			((self targetClass notNil and:[self targetClass respondsTo: #slices])
				ifTrue:[self targetClass slices]
				ifFalse:[self class defaultSlices])).
	self changed: #slices! !

!UIBComponent methodsFor: 'accessing'!

componentName

	^componentName!

componentName: aValue

	componentName := aValue.
	self slices do:[:slice| slice windowLabel: componentName].!

defaultEditSlice

	^UIBSlice
		fromSliceArray: #(#'New Sheet' #newSheetEditSpec)
		forTargetClass: self targetClass
		forComponentName: self componentName!

hasChanged: aBoolean

	hasChanged := aBoolean!

paletteIcon

	^paletteIcon!

paletteIcon: aCachedImage

	paletteIcon := aCachedImage!

paletteMonoIcon

	^paletteMonoIcon!

paletteMonoIcon: aCachedImage

	paletteMonoIcon := aCachedImage!

placementExtent

	^placementExtent!

placementExtent: aPoint

	placementExtent := aPoint!

slices

	^slices!

slices: slicesOrderedCollection

	slices := slicesOrderedCollection!

targetClass

	^Smalltalk at: self targetClassName ifAbsent:[nil]!

targetClassName

	^targetClassName!

targetClassName: aSymbol

	targetClassName := aSymbol.
	self slices do:[:slice| slice targetClass: (Smalltalk at: targetClassName ifAbsent:[nil])]!

targetTrouble

	^self targetClass isNil! !

!UIBComponent methodsFor: 'initialize-release'!

initialize

	self
		slices: (self editSlicesOf: self class defaultSlices);
		targetClassName: nil;
		componentName: self class defaultComponentName;
		placementExtent: self class defaultPlacementExtent;
		paletteIcon: self class defaultPaletteIcon image;
		paletteMonoIcon: self class defaultPaletteMonoIcon image!

initializeForClass: aSpecClass

	self initialize. "Fill the receiver with default values in case some of the messages below are not understood."
	self targetClassName: aSpecClass name.
	(aSpecClass respondsTo: #componentName)
		ifTrue:[self componentName: aSpecClass componentName].
	(aSpecClass respondsTo: #slices)
		ifTrue:[self slices: (self editSlicesOf: aSpecClass slices)].
	(aSpecClass respondsTo: #paletteIcon)
		"RadioButtonSpec answers an Image, rather than a CachedImage in VW2.0 (the convention). So:"
		ifTrue:[|icon| self paletteIcon: (((icon := aSpecClass paletteIcon) isKindOf: Image) ifTrue:[icon] ifFalse:[icon image])].
	(aSpecClass respondsTo: #paletteMonoIcon)
		"For consistency with the comment above:"
		ifTrue:[|icon| self paletteMonoIcon: (((icon := aSpecClass paletteMonoIcon) isKindOf: Image) ifTrue:[icon] ifFalse:[icon image])]! !

!UIBComponent methodsFor: 'testing'!

isCompositeComponent
	"Answer a Boolean whether this component is a composite component."

	^false!

isExtendedStandardComponent
	"Answer a Boolean whether this component is an extension of a standard VW component."

	^false!

isStandardComponent
	"Answer a Boolean whether this component is a standard VW component."

	^false!

isUserDefinedComponent
	"Answer a Boolean whether this component is user defined."

	^false!

specHasChanged

	self lookAndFeels detect:[:look| look specHasChanged] ifNone:[^false].
	^true! !

!UIBComponent methodsFor: 'private'!

editSlicesOf: slicesArray
	"Answer an OrderedCollection of UIBSlices based on slicesArray."

	^(slicesArray
		collect:[:sliceDef |
				UIBSlice
					fromSliceArray: sliceDef
					forTargetClass: self targetClass])
		asOrderedCollection!

isOurOwnSlice: editSlice

	^editSlice isSimple!

ownSlices

	^self slices select: [:slice|self isOurOwnSlice: slice]!

realSlices

	"UIBSpecGenerator new realSlices"

	^self slices asArray collect: [:slice| slice literalSlice]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBComponent class
	instanceVariableNames: ''!


!UIBComponent class methodsFor: 'instance creation'!

forClass: aSpecClass
	"This method creates an instance of one of the receiver's subclasses."

	^self basicNew initializeForClass: aSpecClass!

new

	^self basicNew initialize! !

!UIBComponent class methodsFor: 'factory'!

preferredComponentEditorClass
	"Answer a ComponentEditor class of which instances are able to edit the receiver."

	^self subclassResponsibility!

preferredComponentGeneratorClass
	"Answer a ComponentGenerator class of which instances are able to generate code for the receiver."

	^self subclassResponsibility! !

!UIBComponent class methodsFor: 'defaults'!

defaultComponentName

	^'New Component'!

defaultComponentSpec
	"UIPainter new openOnClass: self andSelector: #defaultComponentSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec
			#label: 'Unlabeled Component' 
			#bounds: #(#Rectangle 148 314 413 638 )) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )!

defaultPaletteIcon

	^UIBImage cgDefaultPaletteIcon!

defaultPaletteMonoIcon

	^UIBImage bwDefaultPaletteIcon!

defaultPlacementExtent

	^50@50!

defaultPropertiesSpec
	"UIPainter new openOnClass: self andSelector: #defaultPropertiesSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'No Properties' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )!

defaultSlices

	^UISpecification slices! !

UIBComponent subclass: #UIBStandardComponent
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components'!
UIBStandardComponent comment:
'My instances represent models for the UIBComponentEditor that refer to standard VW widgets.'!


!UIBStandardComponent methodsFor: 'testing'!

isStandardComponent
	"Answer a Boolean whether this component a standard VW component."

	^true! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBStandardComponent class
	instanceVariableNames: ''!


!UIBStandardComponent class methodsFor: 'editor accessing'!

preferredComponentEditorClass
	"Answer a ComponentEditor class of which instances are able to edit the receiver."

	^UIBExtendedStandardComponentEditor! !

UIBPainter subclass: #UIBPluggablePainter
	instanceVariableNames: 'painterView canvas '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!
UIBPluggablePainter comment:
'I am a Painter that can be plugged into a Subcanvas, in contrast to my superclass which expects a Painter to be the top-level application in a Window.

Instance variables:

	canvas	<UIBCanvas>	Holds the edited canvas.
						The instance variables defined in the superclass (windowSpec, targetClass, targetSelector)
						are kept in sync with the state of this object.'!


!UIBPluggablePainter methodsFor: 'private'!

applyWindowSpec

	"We don't seem to need this."

	"builder policy
		finalHookupWindow: windowSpec
		component: builder window component
		into: builder"!

fixBuildersWindow

	"We don't need to fix the window, since it's plugged into a subcanvas."

	"builder fixWindowWith: windowSpec"!

forFullSpec: aFullSpec

	windowSpec := aFullSpec window.
	builder add: aFullSpec component.
	self applyWindowSpec!

gridView

	|gw|
	gw := GridWrapper on: painterView.
	gw grid: painterView controller gridStep.
	gw showGrid: painterView controller showGrid.
	gw griddedHorizontally: painterView controller griddedHorizontally.
	gw griddedVertically: painterView controller griddedVertically.
	^gw!

makeWindowSpec

	"| win |
	win := builder window."
	"windowSpec min: self minWindowExtent.
	windowSpec max: self maxWindowExtent."
	"windowSpec label: ''. the label is filled in by the enclosing application"
	"windowSpec bounds:
		(Rectangle
			origin: self painterView displayBox origin
			extent:
				(self prefWindowExtent notNil
					ifTrue: [self prefWindowExtent]
					ifFalse: [self painterView displayBox extent])).
	windowSpec colors: self painterView getLookPreferences."
	^windowSpec!

targetTrouble

	"ORIGINAL:
	| tgtClass tgtSelector |
	^(tgtClass := self targetClass) isNil or:
		[(tgtSelector := self targetSelector) isNil or:
			[(tgtClass respondsTo: tgtSelector) not]]"

	"IN DE HUIDIGE COMPONENT EDITOR VOLDOET DIT:"

	^self targetClass isNil or:[self targetSelector isNil]! !

!UIBPluggablePainter methodsFor: 'interface opening'!

forCanvas: aCanvas
	"aCanvas <UIBCanvas>."

	self forFullSpec: aCanvas fullSpec.
	self targetClass: (Smalltalk at: aCanvas specHolderClass ifAbsent: [nil]).
	self targetSelector: aCanvas specSelector.
	self canvas: aCanvas!

makeActivePainter

	| ctrlr |
	(ctrlr := self findPainterController) notNil ifTrue: [ctrlr becomeLastControllerWithSelection]!

makeInactivePainter

	| ctrlr |
	(ctrlr := self findPainterController) notNil ifTrue: [ctrlr unbecomeLastControllerWithSelection]! !

!UIBPluggablePainter methodsFor: 'accessing'!

canvas

	^canvas!

canvas: aCanvas
	"aCanvas <UIBCanvas>."

	canvas := aCanvas!

canvasHasChanged

	^painterView controller canvasHasChanged!

painterView

	^painterView!

targetClass

	(targetClass notNil and: [targetClass isObsolete])
		ifTrue:
			[targetClass := nil.
			self canvas specHolderClass: nil].
	^targetClass!

targetClass: aClass

	super targetClass: aClass.
	self canvas specHolderClass: (aClass isNil ifTrue:[nil] ifFalse:[aClass name])!

targetSelector: aSelector

	super targetSelector: aSelector.
	self canvas specSelector: aSelector!

windowSpec: aWindowSpec

	super windowSpec: aWindowSpec.
	self canvas fullSpec window: aWindowSpec! !

!UIBPluggablePainter methodsFor: 'initialize-release'!

initialize

	self initializeCanvas.
	super initialize!

initializeBuilder

	self builder: self preferredBuilderClass new.
	builder isEditing: self preferredBuilderEditingState.
	painterView := self preferredPainterViewClass new.
	painterView controller: self preferredControllerClass new.
	painterView model: self.
	painterView controller currentMode: UIPalette currentModeHolder.
	builder composite: painterView!

initializeCanvas

	canvas :=  self preferredCanvasClass new!

initializeWindowSpec

	super initializeWindowSpec.
	self windowSpec label: ''!

preferredBuilderEditingState

	^true!

preferredCanvasClass

	^UIBComponentLookAndFeel!

preferredControllerClass

	^UIBPluggablePainterController!

preferredPainterViewClass

	^UIBPluggablePainterView! !

!UIBPluggablePainter methodsFor: 'support'!

changeComponentPolicyTo: aPolicyName

	"Overridden here to bypass messages sent to the window."

	| aPolicy currentState controller view formerPrimary formerSelections newSelections |
	aPolicy := (Smalltalk at: aPolicyName) basicNew.
	controller := (view := builder composite) controller.
	controller broadcastPendingSelectionChange.
	currentState := self extractFullSpec.
	(formerPrimary := controller primarySelection) notNil
		ifTrue: [formerPrimary := formerPrimary spec].
	formerSelections := controller selectionList collect: [:sw | sw spec].
	controller removeSelections.
	view components copy do:
		[:wrapper | view remove: wrapper. wrapper release].
	builder policy: aPolicy.
	(view := view topComponent)
		edgeDecorationPolicy: aPolicy borderLayoutPolicy.
	view widgetPolicy: aPolicy widgetPolicy.
	self fixBuildersWindow.
	builder add: currentState component.
	"builder window flushCaches."	"Koen: the builder of a UIBPluggablePainter has no window !!"
	newSelections :=
		(builder composite components select:
			[:elt |
			(elt isKindOf: SpecWrapper) and:
				[formerSelections includes: elt spec]]).
	formerPrimary notNil
		ifTrue:
			[controller select:
				(builder composite components detect:
					[:sw | formerPrimary == sw spec]).
			controller appendSelections: newSelections]
		ifFalse:
			[controller selectionList: newSelections]!

installFor: aController
	"Overridden here to avoid problems with the VisualWorks convention
	that a Painter is the topmost component in a window. See the comment below."

	"make sure anything unaccepted is applied by the PropertiesTool"
	aController broadcastPendingSelectionChange.
	(self targetTrouble or:
		[(UIPainter preferenceFor: #avoidInstallationDialog) not xor:
			(aController sensor shiftDown)]) "Ask aController, not the window, since a pluggable painter has no window directly."
		ifTrue:
			[self runInstallationDialog isNil
				ifTrue: [^nil]].
	self installInSystem.
	aController canvasHasChanged: false! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPluggablePainter class
	instanceVariableNames: ''!


!UIBPluggablePainter class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Properties Painter' 
			#bounds: #(#Rectangle 229 258 424 476 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #gridView 
					#flags: 0 
					#component: #gridView ) ) ) )! !

!UIBPluggablePainter class methodsFor: 'instance creation'!

forCanvas: aCanvas
 
	^self new forCanvas: aCanvas! !

SimpleComponent subclass: #VisualBinderComponentOOP
	instanceVariableNames: 'binderPosition binderThickness '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!


!VisualBinderComponentOOP methodsFor: 'displaying'!

displayOn: gc

	|   box left right top bottom |
	box := self bounds.
	state hasBackgroundColor
		ifTrue: [gc paint: self backgroundColor.
				gc displayRectangle: box].
	gc paint: self borderColor.
	left := box left.
	right := box right.
	top := box top.
	bottom := box bottom.
 	gc displayRectangle: (left@(bottom- 1) corner: right@(bottom)).
	gc displayLineFrom: (left)@(top ) to: (left)@bottom.
	gc paint: ColorValue white.
	gc displayRectangle: ((left+2)@top corner: (left+3)@(bottom -1)) .
	gc paint: ColorValue lightGray.
	gc displayRectangle: ((left+2)@(bottom -2) corner: (right - 1)@(bottom -1)) .
	gc paint: self selectionBackgroundColor.
	
	
	"binderPosition == #left
		ifTrue: [^gc displayRectangle: ((left+1)@(top+1) corner: (left+binderThickness)@(bottom))].
	binderPosition == #top
		ifTrue: [^gc displayRectangle: ((left+1)@(top+1) corner: right@(top+binderThickness))]"

	"<<BIKI at the bottom of a mountain: 11 January 1996,5:06:47 pm, version: 9>>"! !

!VisualBinderComponentOOP methodsFor: 'initialize-release'!

binderPosition: aSymbol

	binderPosition := aSymbol!

binderThickness: aNumber

	binderThickness := aNumber!

initialize

	super initialize.
	binderPosition := #left.
	binderThickness := 0

	"<<BIKI at the bottom of a mountain: 5 January 1996,5:03:41 pm, version: 1>>"! !

!VisualBinderComponentOOP methodsFor: 'visual properties'!

borderColor
	"Answer the receiver's border color (around flat regions)."
	
	^ColorValue gray! !

!VisualBinderComponentOOP methodsFor: 'bounds accessing'!

preferredBounds
	"Answer the Screen's bounding box.
	Group boxes are expected to be wrapped with a  BoundedWrapper."

	^Screen default bounds! !

UIPalette subclass: #UIBPalette
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Palette'!
UIBPalette comment:
'I am the abstract superclass of the all palettes built with ApplFLab.

Each subclass should override the #paletteName method, which returns the name of the palette. This name is displayed in the title bar of the palette window.

I fix a bug in my superclass with respect to the number of button columns displayed in my user interface. Subclasses can override the #numberOfColumns method to display a different number of columns than the default.'!


!UIBPalette methodsFor: 'private-icons'!

adaptButton: newButtonSpec toRepresent: aSpec 
	"Given aSpec and a prototype spec create a new spec for a 
	button containing proper label and model. Add 
	visual to the dictionary in builder."

	| sName iconName |
	sName := aSpec name.
	iconName := (sName , 'Icon') asSymbol.
	newButtonSpec model: sName.
	builder visualAt: iconName put: aSpec paletteIconImage.
	newButtonSpec label: iconName.
	builder aspectAt: aSpec name put: (self adaptorFor: (aSpec isBehavior ifTrue: [sName] ifFalse: [aSpec]))!

numberOfColumns

	^self class numberOfColumns!

populateSpec: prototypeSpec 

	"Overridden here because the super's method is buggy when the number of colums is different from 3.
	Also changed #iconPrototypeSpec on the class side."

	| w h cols p c firstX rows   rect |
	rect := (prototypeSpec layout rectangleRelativeTo: builder window bounds preferred: nil).
	w := rect width.
	h := rect height.
	cols := self numberOfColumns.
	p := rect topLeft.
	firstX := p x.
	c := 0. 
	activeSpecs
		do: 
			[:spec | 
			| newButtonSpec |
			newButtonSpec := prototypeSpec copy.
			newButtonSpec layout: prototypeSpec layout copy.
			(newButtonSpec layout) 
				left: newButtonSpec layout left + p x;
				right: newButtonSpec layout right + p x;
				top: newButtonSpec layout top + p y;
				bottom: newButtonSpec layout bottom + p y.
			self adaptButton: newButtonSpec toRepresent: spec.
			builder add: newButtonSpec.
			c := c + 1.
			(c \\ cols) isZero
				ifTrue: 
					[p := p + (0 @ h).
					p x: firstX]
				ifFalse: [p := p + (w @ 0)]].
	rows := c - 1 // cols.
	cols := cols - 3.
	p := (cols * w) @ (rows * h).
	p := builder window minimumSize + p.
	(builder window) changeExtent: p; minimumSize: p; maximumSize: p!

updateActiveSpecs
	"Take a list of symbols and build a list containing classes.
	If the symbol is not a valid class name do not add it to the list."

	activeSpecs := OrderedCollection new.
	self class activeSpecsList
		do: 
			[:sym | 
			| spec |
			spec := sym isSymbol
					ifTrue: [Smalltalk at: sym ifAbsent: [nil]]
					ifFalse: [UIBPaletteItem componentName: sym first holderClassName:  (sym at: 2) selector: sym last].
			spec notNil ifTrue: [activeSpecs add: spec]]! !

!UIBPalette methodsFor: 'private'!

adaptorFor: aSpecClassName

	^(PluggableAdaptor on: self currentModeHolder)
				getBlock: 
					[:m | | cl | cl := m value specClass.
					 (cl isKindOf: UIBPaletteItem)
						ifTrue: [cl == aSpecClassName]
						ifFalse: [cl notNil and: [cl name == aSpecClassName]]]
				putBlock:
					[:m :v |
					v
						ifTrue: [self checkForSticky
								ifTrue: [self makeSticky]
								ifFalse:
									[m value class == SelectMode
										ifFalse: [self noSticky]].
							m value: (self placementFeelFor: aSpecClassName)]
						ifFalse: [(m value isKindOf: SelectMode)
									ifFalse: [m value: SelectMode new]]]
				updateBlock: [:m :v :p | true]!

placementFeelFor: aSpecClassName

	^aSpecClassName isSymbol
		ifTrue: [super placementFeelFor: aSpecClassName]
		ifFalse: [UIPainter placementFeelClass forSpecClass: aSpecClassName]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPalette class
	instanceVariableNames: ''!


!UIBPalette class methodsFor: 'accessing'!

numberOfColumns

	^3!

paletteName
	"Return a name for the application to be built with this palette.
	This name is used in palette selection menus and lists."

	^'Standard Palette'! !

!UIBPalette class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Palette' 
			#min: #(#Point 89 99 ) 
			#bounds: #(#Rectangle 449 118 538 217 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 3 3 31 31 ) 
					#flags: 0 
					#colors: 
					#(#LookPreferences 
						#setSelectionBackgroundColor: #(#ColorValue #black ) ) 
					#model: #Select 
					#tabable: false 
					#label: #selectIconImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -31 1 3 0 -3 1 31 0 ) 
					#flags: 0 
					#colors: 
					#(#LookPreferences 
						#setSelectionBackgroundColor: #(#ColorValue #black ) ) 
					#model: #Sticky 
					#tabable: false 
					#label: #stickyIconImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 2 0 43 0 -2 1 -20 1 ) 
					#name: #iconView 
					#flags: 0 
					#colors: 
					#(#LookPreferences 
						#setSelectionBackgroundColor: #(#ColorValue #black ) ) 
					#component: #iconView ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0 38 0 0 1 42 0 ) ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame -4 0 -23 1 3 1 0 1 ) 
					#model: #toolName 
					#tabable: false 
					#alignment: #center 
					#isReadOnly: true ) ) ) )! !

!UIBPalette class methodsFor: 'installing palette items'!

addSpecInstance: spec named: componentName

	UIBPaletteEditor installSpecInstance: spec named: componentName on: self! !

!UIBPalette class methodsFor: 'resources'!

iconPrototypeSpec

	"Overridden here because the result of the super's method introduces a bug in #populateSpec:.
	Also changed #populateSpec:."


	^#(#ActionButtonSpec #layout: #(#Rectangle 1 1 29 29 ) #flags: 0 #name: #specIcon #tabable: false #hasCharacterOrientedLabel: false )! !

!UIBPalette class methodsFor: 'interface opening'!

openPaletteNear: mainWindow

	"Don't change the look of the standard palette, but change the label of custom palettes:"

	| window |
	window := super openPaletteNear: mainWindow.
	self == UIBPalette ifFalse:[window label: self paletteName , ' Palette'].
	^window! !

UIPainterController subclass: #UIBPainterController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!
UIBPainterController comment:
'I am the controller for a UIBPainterView.

I extend my superclass in several ways, the most important of which being the support for a ''run mode''. If the run mode button on the Palette is selected, the user is able to manipulate the painted components as if the application is running.

I use other drag handles than my superclass. Most component (specs) are displayed with 8 drag handles instead of 4. See UIBDragHandle for more information.'!


!UIBPainterController methodsFor: 'testing'!

isCanvasToolActionAware

	^true! !

!UIBPainterController methodsFor: 'commands'!

doBrowse

	self sensor shiftDown
		ifTrue: [self doBrowseApplicationModel]
		ifFalse: [super doBrowse]!

doBrowseApplicationModel

	(Smalltalk at: (UIPainter preferenceFor: #browserType)) newOnClass: self model targetClass!

doCut

	"Overridden here in order to be able to cut a component nested in a composite (group)."
	"Each reference to the receiver's view is replaced by a reference to the enclosing composite of a component."

	| sel  bldr walker |
	
	self broadcastPendingSelectionChange.
	sel := "self selectedComponents" selections. "Koen: #selectedComponents returns the selected components in the order in which they appear in the receiver's view. The order is irrelevant, so just take the selections."
	sel isNil ifTrue: [^self].
	self quietlyNoteChangeToCanvas.
	ScrapPrimary :=
		self primarySelection notNil
			ifTrue:
				[SpecCollection new fromCollection:
					(Array with: self primarySelection)]
			ifFalse: [nil].
	Scrap :=
		SpecCollection new fromCollection:
			(sel copyWithout:
				(sel detect: [:sw | sw == self primarySelection] ifNone: [])).
	bldr := self builder.
	walker := FilteredSpecEnumerator new.
	walker block: [:s | s name == nil ifFalse: [bldr namedComponents removeKey: s name ifAbsent: []]. true].
	ScrapPrimary == nil ifFalse: [walker doSpec: ScrapPrimary].
	Scrap == nil ifFalse: [walker doSpec: Scrap]. 
	self removeSelections.
	sel do: [:s | (self compositeOf: s) removeComponent: s. "This allows a cut of multiple selections across composite boundaries."
			s release]!

doDefineAll

	model definer
		interactivelyUpgradeDefns: #()
		for: self!

doDialog
	"Overridden in order to use our own properties tool."

	UIBPropertiesTool new openAtCursor!

doInstallSpecInstanceOnPalette

	| sel  selectedPaletteClass componentName component | 
	sel := self selectedComponents.
	"The following should be OK when the operate menu is configured correctly."
	sel size = 1 ifFalse: [Dialog warn:'Sorry, this command is currently implemented for 1 selection only.'. ^self].
	(selectedPaletteClass := self showPaletteDialog) isNil ifTrue: [^nil].
	(componentName := Dialog request: 'Enter a name for the component:' initialAnswer: '') isEmpty ifTrue: [^nil].
	component := sel first copy.
	component beFixedIn: self view bounds.
	selectedPaletteClass addSpecInstance: component savableSpec named: componentName!

doProperties
	"Overridden here in order to use our own properties tool."

	UIBPropertiesTool open!

replaceElement: sel basedOnSpec: spec

	"Overridden here in order to be able to replace a component nested in a composite (group)."
	"Each reference to the receiver's view is replaced by a reference to a 'composite' which is determined at the beginning of this method."

	| sc index newElement comps old pi composite|
	composite := self compositeOf: sel.
	index := composite components indexOf: sel ifAbsent: [^self error: 'no such element'].
	"Remember old spec for when we cut"
	pi := nil asValue.
	sel downcastEvent: #returnPersistentInformation with: pi  from: self.
	old := sel spec.
	sel spec: spec.	
	"Get info out before cut.  This is important for composites"
	sc := (SpecCollection new fromCollection: (Array with: sel)) collection.
	"Put old spec back so cut puts it in the right place."
	sel spec: old.

	"Lowlevel in line cut that causes not updating"
	canvasHasChanged := true.
	(self selectionList includes: sel) ifTrue: [
		self primarySelection: nil.
		self selections: nil.
		self setHandles: nil].
	composite removeComponent: sel. sel release.
	self builder add: sc first inComposite: composite.
	comps := composite components.
	newElement := comps last.
	index =  comps size
		ifFalse: [ "Koen: put the replaced component (which is located at the end, see above) at the correct index."
				comps removeLast.
				comps add: newElement beforeIndex: index.
				composite bounds: composite bounds "Force an update of the display."].
	pi value notNil ifTrue: [ newElement downcastEvent: #usePersistentInformation with: pi from: self ].
	^newElement! !

!UIBPainterController methodsFor: 'initialize-release'!

initializeMenu
	| sel newMenu |
	menuHolder := 
			[newMenu := (sel := self selectionList) isEmpty
						ifTrue: [self class noSelectMenu]
						ifFalse: [sel size = 1
								ifTrue: [self class singleSelectMenu]
								ifFalse: [self class multiSelectMenu]].
			self adjustMenu: newMenu andModel: model]! !

!UIBPainterController methodsFor: 'private'!

adjustMenu: newMenu andModel: aModel 
	| s |
	(aModel targetClass isNil and: [(UISettings preferenceFor: #installForDefine) not and: [(UISettings preferenceFor: #installForOpen) not]])
		ifTrue: 
			[(newMenu menuItemLabeled: 'browse...') disable.
			(newMenu menuItemLabeled: 'define...') disable.
			(newMenu menuItemLabeled: 'define all...') disable.
			(newMenu menuItemLabeled: 'open') disable]
		ifFalse: 
			[(newMenu menuItemLabeled: 'browse...') enable.
			(newMenu menuItemLabeled: 'define...') enable.
			(newMenu menuItemLabeled: 'define all...') enable.
			(newMenu menuItemLabeled: 'open') enable].
	(s := newMenu menuItemLabeled: 'special') submenu notNil
		ifTrue: [s enable]
		ifFalse: [s disable].
	((newMenu menuItemLabeled: 'arrange') submenu menuItemLabeled: 'special group') submenu: self applFLabGroupMenu.
	^newMenu!

applFLabGroupMenu
	"Answer a Menu with the composites that are applicable on the current selection(s)."

	| compositeSpecClasses groupMenu selectedComponents | 
	compositeSpecClasses := 
		((UIBCompositeSpec allSubclasses
			select: [:aClass | aClass class includesSelector: #componentName])
			asSortedCollection: [:class1 :class2 | class1 name <= class2 name])
			asArray.
	compositeSpecClasses isEmpty
		ifTrue: [groupMenu :=Menu labelArray: #('No special groups installed').
				(groupMenu menuItemAt: 1) disable]
		ifFalse: [groupMenu := Menu
					labelArray:  (compositeSpecClasses collect: [:aClass | aClass componentName])
					values: (compositeSpecClasses collect: [: aClass| [:ctrl| self doEmbed: aClass]]).
				selectedComponents := self selections.
				1 to: compositeSpecClasses size do: [: index|
				(groupMenu menuItemAt: index) enabled: ((compositeSpecClasses at: index) canBeGrouped: selectedComponents)]].
	^groupMenu!

compositeOf: visualPart
	"Answer the CompositePart in which visualPart resides."

	| composite |
	composite := visualPart.
	[composite isKindOf: CompositePart] whileFalse: [composite := composite container].
	^composite!

excludedSpecs
	"Answer a Collection of widget specification classes that should not be
	painted on canvasses of which the receiver is the model."

	^Set with: UIBPropertyFieldSpec with: UIBSubPropertyFieldSpec!

modeIsAllowed: mode
	"Answer a Boolean indicating whether (the configuration of) mode
	is allowed in canvasses of which the receiver is the model."

	^(self excludedSpecs includes: mode specClass) not!

showPaletteDialog
	"Show a dialog with a list of existing palettes without the standard palette
	and return the selection or nil." 

	| nameClassAssocs selection |
	nameClassAssocs := UIBPaletteEditor palettesWithNames removeFirst; yourself.
	selection := Dialog 
		choose: 'Select a palette:' 
		fromList: (nameClassAssocs collect:[:assoc| assoc key]) asArray
		values: (1 to: nameClassAssocs size) asArray
		lines: 10 
		cancel: [nil].
	^selection isNil
		ifTrue: [nil]
		ifFalse: [ (nameClassAssocs at: selection) value]! !

!UIBPainterController methodsFor: 'private-grouping'!

doEmbed: compositeClass
	"Embed the selected widgets is a composite according to compositeSpecClass."

	"This body is copied from #embed, where each reference to the standard CompositePart and CompositeSpec classes is replaced by objects retrieved from the method argument.
	Note that #doEmbed: CompositeSpec does not work!!"

	| sels comp box  s |
	self broadcastPendingSelectionChange.
	(sels := self selectedComponents) size > 0 ifFalse: [^self].
	self canvasHasChanged: true.
	self removeSelections.
	self builder newComposite: compositeClass newComposite.
	comp := self builder composite.
	box := sels first bounds.
	2 to: sels size do: [:i | box := box merge: (sels at: i) bounds].
	1 to: sels size do:
		[:i |
		| wrapper newBox |
		wrapper := sels at: i.
		newBox := wrapper bounds translatedBy: box origin negated.
		wrapper newLayout: (self
			embedLayout: wrapper layout
			for: newBox
			containedBy: box).
		wrapper newBounds: newBox containingBounds: box.
		view remove: wrapper.
		comp addWrapper: wrapper].
	comp computePreferredBounds.
	s := compositeClass new layout: box.
	self builder add: s.
	self select: self builder wrapper.! !

!UIBPainterController methodsFor: 'handle manipulation'!

handlesFor: aWrapper
	"This method ensures that handles can be attached to nested components in nested painter views."

	^aWrapper
		painterDragHandles:
			(self primarySelection isNil or:
				[aWrapper == self primarySelection])
		inView: self view! !

!UIBPainterController methodsFor: 'private-runmode'!

applflabRunModeControlActivity

	(self sensor keyboardPressed and: [self keyboardProcessor willProcessKeyboardEvents])
		ifTrue: [self keyboardProcessor currentConsumer processKeyboard].
	^self controlToNextLevel!

applflabRunModeIsControlActive

	^self viewHasCursor!

applflabRunModeIsControlWanted

	^self viewHasCursor! !

!UIBPainterController methodsFor: 'control events'!

sendEvent: eventSymbol at: aPoint
	"Overridden here in order to cancel widget placements that are not allowed."
	"In this class (sub)property field placement is not allowed."

	| mode |
	"Transcript cr; show: 'Mode: '; nextPutAll: self currentMode value printString; space; show: eventSymbol asString, ' at: ', aPoint printString."
	(mode := self currentMode value) notNil
		ifTrue: 
			[eventSymbol == #RedDown ifTrue:
				[^mode redDownAt: aPoint inController: self].
			eventSymbol == #RedUp ifTrue:
				[^mode redUpAt: aPoint inController: self].
			eventSymbol == #YellowDown ifTrue:
				[^mode yellowDownAt: aPoint inController: self].
			eventSymbol == #YellowUp ifTrue:
				[^mode yellowUpAt: aPoint inController: self].
			eventSymbol == #KeyboardEvent ifTrue:
				[^mode keyboardEventAt: aPoint inController: self].
			eventSymbol == #BlueDown ifTrue:
				[^mode blueDownAt: aPoint inController: self].
			eventSymbol == #BlueUp ifTrue:
				[^mode blueUpAt: aPoint inController: self].
			eventSymbol == #MouseEntry ifTrue:
				[^((mode isKindOf: PlacementMode) and:[(self modeIsAllowed: mode) not])
					ifTrue:[Dialog warn: 'Sorry, painting ' , 
									(mode specClass componentName first isVowel ifTrue: ['an '] ifFalse: ['a ']) ,
									mode specClass componentName , 
									' on this canvas is not allowed.']
					ifFalse:[mode mouseEnteredAt: aPoint inController: self]].
			eventSymbol == #MouseExit ifTrue:
				[^mode mouseExitedAt: aPoint inController: self]].
	^nil! !

!UIBPainterController methodsFor: 'control defaults'!

controlActivity

	^(currentMode value isKindOf: UIBRunMode)
		ifTrue: [self applflabRunModeControlActivity]
		ifFalse: [super controlActivity]!

controlToNextLevel
	"Pass control to the next control level, that is, to the Controller of a subView of 
	the receiver's view if possible. The receiver finds the subView (if any) whose controller	
	wants control and sends that controller the message startUp."

	| aView |
	aView := view componentWantingControl.
	aView == nil ifFalse: [aView startUp]!

isControlActive

	^(currentMode value isKindOf: UIBRunMode)
		ifTrue: [self applflabRunModeIsControlActive]
		ifFalse: [super isControlActive]!

isControlWanted

	^(currentMode value isKindOf: UIBRunMode)
		ifTrue: [self applflabRunModeIsControlWanted]
		ifFalse: [self keyboardProcessor setActive: nil.
				super isControlWanted]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPainterController class
	instanceVariableNames: 'noSelectMenu singleSelectMenu multiSelectMenu '!


!UIBPainterController class methodsFor: 'resources'!

canvasMenu
	"UIMenuEditor new openOnClass: self andSelector: #canvasMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#label: 'edit' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'copy' ) 
						#(#MenuItem 
							#label: 'cut' ) 
						#(#MenuItem 
							#label: 'paste' ) 
						#(#MenuItem 
							#label: 'accept' ) 
						#(#MenuItem 
							#label: 'cancel' 
							#submenu: #(#Menu #(
									#(#MenuItem 
										#label: 'confirm' ) ) #(1 ) #(#cancel ) ) ) 
						#(#MenuItem 
							#label: 'spawn' ) ) #(3 2 1 ) #(#doCopy #doCut #doPaste #accept nil #doSpawn ) ) ) 
			#(#MenuItem 
				#label: 'tools' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'palette' ) 
						#(#MenuItem 
							#label: 'canvas tool' ) 
						#(#MenuItem 
							#label: 'image editor' ) 
						#(#MenuItem 
							#label: 'menu editor' ) 
						#(#MenuItem 
							#label: 'reusable data form components' ) ) #(2 2 1 ) #(#doPalette #doCanvasTool #maskEditor #menuEditor #openReusableComponents ) ) ) 
			#(#MenuItem 
				#label: 'layout' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'window' 
							#submenu: #(#Menu #(
									#(#MenuItem 
										#label: 'fixed size' ) 
									#(#MenuItem 
										#label: 'min size' ) 
									#(#MenuItem 
										#label: 'pref size' ) 
									#(#MenuItem 
										#label: 'max size' ) 
									#(#MenuItem 
										#label: 'clear all' ) ) #(1 3 1 ) #(#setAllWindowInfo #setWindowMinSize #setWindowPrefSize #setWindowMaxSize #setWindowToDefaults ) ) ) 
						#(#MenuItem 
							#label: 'fixed' ) 
						#(#MenuItem 
							#label: 'relative' ) 
						#(#MenuItem 
							#label: 'constrained...' ) 
						#(#MenuItem 
							#label: 'be bounded' ) 
						#(#MenuItem 
							#label: 'be unbounded' ) ) #(1 3 2 ) #(nil #doLayoutFixed #doLayoutRelative #fractionalConstraintDialog #doMakeBounded #doMakeUnBounded ) ) ) 
			#(#MenuItem 
				#label: 'arrange' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'snap to grid' ) 
						#(#MenuItem 
							#label: 'group' ) 
						#(#MenuItem 
							#label: 'special group' ) 
						#(#MenuItem 
							#label: 'ungroup' ) 
						#(#MenuItem 
							#label: 'bring forward' ) 
						#(#MenuItem 
							#label: 'bring to front' ) 
						#(#MenuItem 
							#label: 'send backward' ) 
						#(#MenuItem 
							#label: 'send to back' ) 
						#(#MenuItem 
							#label: 'align...' ) 
						#(#MenuItem 
							#label: 'distribute...' ) 
						#(#MenuItem 
							#label: 'equalize...' ) ) #(1 3 4 3 ) #(#doSnapSelectionToGrid #doGroup nil #doUngroup #toVisualFrontOne #toVisualFront #toVisualBackOne #toVisualBack #alignDialog #distributeDialog #equalizeDialog ) ) ) 
			#(#MenuItem 
				#label: 'special' )
			#(#MenuItem 
				#label: 'ApplFLab' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'Install On Palette...')) #(1 ) #(#doInstallSpecInstanceOnPalette )))
			#(#MenuItem 
				#label: 'properties' ) 
			#(#MenuItem 
				#label: 'install...' ) 
			#(#MenuItem 
				#label: 'define...' ) 
			#(#MenuItem 
				#label: 'define all...' ) 
			#(#MenuItem 
				#label: 'browse...' ) 
			#(#MenuItem 
				#label: 'open' ) ) #(5 1 6) #(nil nil nil nil nil nil #doProperties #doInstall #doDefine #doDefineAll #doBrowse #doOpen ) ) decodeAsLiteralArray! !

!UIBPainterController class methodsFor: 'class accessing'!

multiSelectMenu

	^multiSelectMenu!

noSelectMenu

	^noSelectMenu!

singleSelectMenu

	^singleSelectMenu! !

!UIBPainterController class methodsFor: 'class initialization'!

initialize
	"self initialize"

	multiSelectMenu := self canvasMenu.
	(multiSelectMenu menuItemLabeled: 'special') submenu: nil; disable.
	((multiSelectMenu menuItemLabeled: 'layout') submenu menuItemLabeled: 'constrained...') disable.
	(multiSelectMenu menuItemLabeled: 'ApplFLab') disable.

	singleSelectMenu := self canvasMenu.
	((singleSelectMenu menuItemLabeled: 'arrange') submenu menuItemLabeled: 'align...') disable.
	((singleSelectMenu menuItemLabeled: 'arrange') submenu menuItemLabeled: 'distribute...') disable.
	((singleSelectMenu menuItemLabeled: 'arrange') submenu menuItemLabeled: 'equalize...') disable.
	(singleSelectMenu menuItemLabeled: 'special')
		submenu:
			[| ctrlr |
			(ctrlr := LastControllerWithSelection value) notNil
				ifTrue: [ctrlr selectionPopUpMenu]
				ifFalse: [nil]].

	noSelectMenu := self canvasMenu.
	((noSelectMenu menuItemLabeled: 'layout') submenu menuItemLabeled: 'fixed') disable.
	((noSelectMenu menuItemLabeled: 'layout') submenu menuItemLabeled: 'relative') disable.
	((noSelectMenu menuItemLabeled: 'layout') submenu menuItemLabeled: 'constrained...') disable.
	((noSelectMenu menuItemLabeled: 'layout') submenu menuItemLabeled: 'be bounded') disable.
	((noSelectMenu menuItemLabeled: 'layout') submenu menuItemLabeled: 'be unbounded') disable.
	(noSelectMenu menuItemLabeled: 'arrange') disable.
	(noSelectMenu menuItemLabeled: 'special') submenu: nil; disable.
	(noSelectMenu menuItemLabeled: 'ApplFLab') disable.! !

UIBPainterController subclass: #UIBPluggablePainterController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!
UIBPluggablePainterController comment:
'I am the controller for UIBPluggablePainters.'!


!UIBPluggablePainterController methodsFor: 'private'!

unbecomeLastControllerWithSelection

	LastControllerWithSelection value == self ifTrue: [LastControllerWithSelection value: nil]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPluggablePainterController class
	instanceVariableNames: ''!


!UIBPluggablePainterController class methodsFor: 'class initialization'!

initialize
	"This method is empty, but must be here to be sure that it is initialized when it is filed in."
	"(Filing out a class generates an invokation of #initialize only if the class understands #initialize.)"

	"self initialize"

	super initialize.! !

ControlMode subclass: #UIBRunMode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!
UIBRunMode comment:
'I represent the run mode for a UIBPainterController (also see that class'' comment). Standard UIPainterControllers already have a notion of ''run mode'' (nil as value of UIPalette currentMode''), but it is not used. I am introduced in order not to interfere with the standard run mode.
In fact, I do little or nothing. For now, I only serve as model for a run mode button on the Palette.'!


!UIBRunMode methodsFor: 'accessing'!

specClass
	"Standard palette items expect that a mode understand #specClass."

	^nil! !

!UIBRunMode methodsFor: 'control'!

redDownAt: aPoint inController: aController

	| obj composite cwc |
	obj := aController view hitDetect: aPoint. 
	"quickly get the component wanting control if it is a specWrapper on a CompositePart"
	((obj isKindOf: SpecWrapper) and: [obj widget isKindOf: CompositePart])
		ifTrue: [composite := obj.
				[cwc := composite widget hitDetect: (composite widget globalPointToLocal: aPoint).
				cwc notNil and: [cwc widget isKindOf: CompositePart]] whileTrue: [composite := cwc].
				(cwc isNil and: [composite ~= obj]) ifTrue: [cwc := composite].
				cwc widget controller controlLoop].
	^nil! !

AspectEnumerator subclass: #UIBAspectEnumerator
	instanceVariableNames: 'bindingPropertyAssociations bindingSpecAssociations menuSpecAssociations '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Builder/Definer'!
UIBAspectEnumerator comment:
'I extend AspectEnumerator with enumeration of custom components.

#bindingsOfUIBcomponents returns an IdentityDictionary containing the name - spec associations.'!


!UIBAspectEnumerator methodsFor: 'secondary dispatch'!

bindUIBComponentSpec: aSpec ifIncomplete: aBlock

	aSpec models do:[:m|
		m isIncompleteForBinding ifTrue: [incompletes add: aSpec. ^aBlock value].
		m bindInAspectEnumerator: self.
		m property name isNil
			ifFalse:[	bindingPropertyAssociations at: m property name put: m.
					bindingSpecAssociations at: m property name put: aSpec]]!

bindUIBPropertyComponentSpec: aSpec ifIncomplete: aBlock

	aSpec models do:[:m| 
		m name isNil
			ifTrue: [incompletes add: aSpec. ^aBlock value]
			ifFalse:[	bindings at: m name put: m defaultModel.
					bindingPropertyAssociations at: m name put: m.
					bindingSpecAssociations at: m name put: aSpec]]!

doLeafMenuButtonSpec: aSpec

	super doLeafMenuButtonSpec: aSpec.
	aSpec menu isNil ifFalse:[menuSpecAssociations at: aSpec menu put: aSpec]!

doLeafSubCanvasSpec: aSpec

	| majorKey minorKey spec |
	(aSpec isKindOf: UIBCompositeComponentSpec) ifFalse:[^super doLeafSubCanvasSpec: aSpec].
	(aSpec isKindOf: UIBPropertyComponentSpec)
		ifTrue:[self bindUIBPropertyComponentSpec: aSpec ifIncomplete:[^self]]
		ifFalse:[self bindUIBComponentSpec: aSpec ifIncomplete:[^self]].

	majorKey := aSpec majorKey.
	minorKey := aSpec minorKey.
	majorKey == nil
		ifFalse:
			[ | class |
			class := Smalltalk at: majorKey ifAbsent: [nil].
			class == nil
				ifFalse:
					[spec := class  messageNotUnderstoodSignal
						handle:
							[:ex |
							ex parameter selector == minorKey
								ifTrue: [ex returnWith: nil]
								ifFalse: [ex reject]]
						from: class
						do: [class perform: minorKey]]]
		ifTrue: [spec := self safelyPerform: #specificationFor: key: minorKey].
	spec == nil ifTrue: [incompletes add: aSpec.  ^self].	
	"self doSpec: (UISpecification from: spec) componentSpec"!

doLeafWidgetSpec: aSpec
	
	aSpec models size > 1 ifTrue: [^self doMultipleModelLeafWidgetSpec: aSpec].
	self doLeafWidgetSpec: aSpec forModel: aSpec model andDefaultModel: aSpec defaultModel!

doLeafWidgetSpec: aSpec forModel: aModel andDefaultModel: aDefaultModel
	aModel == nil ifTrue: [incompletes add: aSpec.  ^self].
	bindings at: aModel put: aDefaultModel.
	bindingSpecAssociations at: aModel put: aSpec!

doMultipleModelLeafWidgetSpec: aSpec
	"I assume that aSpec answers #models and #defaultModels with OrderedCollections that match."
	
	aSpec models with: aSpec defaultModels do:
		[:aModel :aDefaultModel | 
		self doLeafWidgetSpec: aSpec forModel: aModel andDefaultModel: aDefaultModel]! !

!UIBAspectEnumerator methodsFor: 'initialize-release'!

initialize

	super initialize.
	bindingPropertyAssociations := IdentityDictionary new.
	bindingSpecAssociations := IdentityDictionary new.
	menuSpecAssociations :=  IdentityDictionary new.! !

!UIBAspectEnumerator methodsFor: 'accessing'!

bindingPropertyAssociations

	^bindingPropertyAssociations!

bindingSpecAssociations

	^bindingSpecAssociations!

menuSpecAssociations

	^menuSpecAssociations! !

UIBCompositePart subclass: #UIBComposingComposite
	instanceVariableNames: 'spaceBetweenItems leftSpace topSpace '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Composites'!
UIBComposingComposite comment:
'I place my components automatically based on the space allocated in the #bounds: message. I start placing components in my top left corner with an offset according to the offsets in my leftSpace and topSpace instance variables. I also take the value of my spaceBetweenItems instance variable into account. I do not care about my right and bottom sides. If my components bounds cross these sides, they are clipped.

I am not a subclass of ComposingComposite because that class assumes that the components are arranged horizontally. Moreover, my creator does not like to introduce intermediate classes in the VisualWorks class hierarchy.
I provide the necessary protocol for updating when my bounds change (copied from ComposingComposite).

Subclasses should override #layoutComponentsForBounds:.
Subclasses should override the methods in the ''defaults'' protocol (and possibly the ''initialize-release'' protocol) if they want other initial values for the instance variables.

Instance Variables:
	spaceBetweenItems	<Integer>	The space (in pixels) between two components.
	leftSpace			<Integer>	The space (in pixels) between my left and the components'' lefts.
	topSpace			<Integer>	The space (in pixels) between my top and the components'' tops.'!


!UIBComposingComposite methodsFor: 'defaults'!

defaultSpaceBetweenItems

	^5!

defaultSpaceOnTheSides

	^3! !

!UIBComposingComposite methodsFor: 'initialize-release'!

initialize

	super initialize.
	self initializeSpacing!

initializeSpacing
	"Initialize the spacing parameters between sub components and between the subcomponents and the receiver."

	spaceBetweenItems := self defaultSpaceBetweenItems.
	leftSpace := topSpace := self defaultSpaceOnTheSides! !

!UIBComposingComposite methodsFor: 'private'!

addComponent: aVisualComponent
	"Add aVisualComponent to the receiver's components.  Display
	aVisualComponent if the receiver is open."

	self isOpen
		ifTrue: [ | lastPreferredBounds |
				lastPreferredBounds := self preferredBounds.
				components addLast: aVisualComponent.
				aVisualComponent container: self.
				self bounds: self bounds.
				lastPreferredBounds = preferredBounds
					ifFalse: [self changedPreferredBounds: lastPreferredBounds].
				self invalidateRectangle: self bounds]
		ifFalse: [components addLast: aVisualComponent.
				aVisualComponent container: self.
				preferredBounds := nil]!

layoutComponentsForBounds: newBounds
	"The receiver has been sized to the given parameters.  
	Re-layout all of the receiver's components."

	self subclassResponsibility!

removeComponent: aVisualComponent
	"Remove aVisualComponent from the receiver's components.
	Redisplay any now exposed component."

	|  lastPreferredBounds |
	lastPreferredBounds := self preferredBounds.
	components remove: aVisualComponent.
	self bounds: self bounds.
	lastPreferredBounds = preferredBounds
		ifFalse: [self changedPreferredBounds: lastPreferredBounds].
	self invalidateRectangle: self bounds.
	^aVisualComponent!

replaceComponent: aVisualComponent at: index
	"Replace the VisualComponent at index by aVisualComponent.
	Display aVisualComponent if the receiver is open."

	| currentComponentAtIndex |
	currentComponentAtIndex := components at: index.
	self isOpen
		ifTrue: [ | lastPreferredBounds |
				lastPreferredBounds := self preferredBounds.
				components at: index put:aVisualComponent.
				aVisualComponent container: self.
				self bounds: self bounds.
				lastPreferredBounds = preferredBounds
					ifFalse: [self changedPreferredBounds: lastPreferredBounds].
				self invalidateRectangle: self bounds]
		ifFalse: [components at: index put:aVisualComponent.
				aVisualComponent container: self.
				preferredBounds := nil].
	^currentComponentAtIndex! !

!UIBComposingComposite methodsFor: 'accessing'!

leftSpace

	^leftSpace!

leftSpace: anInteger

	leftSpace := anInteger!

spaceBetweenItems

	^spaceBetweenItems!

spaceBetweenItems: anInteger

	spaceBetweenItems := anInteger!

topSpace

	^topSpace!

topSpace: anInteger

	topSpace := anInteger! !

SimpleDialog subclass: #UIBSimpleDialog
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Basics'!


!UIBSimpleDialog methodsFor: 'initialize-release'!

initialize
	"Overridden here in order to use our own builder class."

	accept := false asValue.
	cancel := false asValue.
	close := false asValue.
	builder := UIBBuilder new.
	builder aspectAt: #accept put: accept.
	builder aspectAt: #cancel put: cancel.
	builder aspectAt: #close put: close.
	escapeIsCancel := true! !

!UIBSimpleDialog methodsFor: 'private'!

doAccept

	accept value: true! !

!UIBSimpleDialog methodsFor: 'components-access'!

component: anIDsymbol

	^self builder componentAt: anIDsymbol!

widget: anIDsymbol
	"Answer the widget corresponding to the given ID.
	For custom components,
		answer the custom component object rather than the subcanvas widget.
		Use '(self component: anIDsymbol) widget' to fetch its subcanvas widget."

	| component |
	^(component := self builder customComponentAt: anIDsymbol) isNil
		ifTrue:[(self component: anIDsymbol) widget]
		ifFalse:[component]! !

!UIBSimpleDialog methodsFor: 'components-enabling'!

able: aBoolean component: anIDsymbol

	(self component: anIDsymbol) isEnabled: aBoolean! !

!UIBSimpleDialog methodsFor: 'binding'!

actionFor: aKey 
	"Depending on the arity of aKey, return a block that will be sent the message #value or #valueWithArguments:.
	This method is the generalization of the one in the superclass. It can now be used for binding arbitrary callback actions."

	aKey isKeyword
		ifTrue:[^[:args| self perform: aKey withArguments: (args copyFrom: 1 to: aKey numArgs)]]
		ifFalse:[^super actionFor: aKey]! !

UIBSimpleDialog subclass: #FileDialog
	instanceVariableNames: 'currentSelection selectedFilename filenameString '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-File selection (New)'!


!FileDialog methodsFor: 'initialize-release'!

initialize

	super initialize.
	currentSelection := Filename defaultDirectory asValue.
	filenameString := String new asValue.
	filenameString compute: [(self widget: #selector) updateOpenButtonForPut].
	selectedFilename := nil asValue.
	selectedFilename compute: [self doAccept]! !

!FileDialog methodsFor: 'aspects'!

currentSelection

	^currentSelection!

filenameString

	^filenameString!

selectedFilename

	^selectedFilename! !

!FileDialog methodsFor: 'actions'!

filenameStringNotEmpty
	"This stub method was generated by UIBDefiner"

	^self filenameString value isEmpty not!

isDirectory: aFilename

	^aFilename exists and:[ aFilename isDirectory]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FileDialog class
	instanceVariableNames: ''!


!FileDialog class methodsFor: 'interface specs'!

getDirectorySpec
	"UIBPainter new openOnClass: self andSelector: #getDirectorySpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: '' 
			#bounds: #(#Rectangle 147 178 467 382 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#FileSelectorSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -28 1 ) 
					#name: #selector 
					#flags: 0 
					#minorKey: #extendedSpec 
					#openButtonLabel: 'Open' 
					#volumesButtonLabel: 'Volumes' 
					#enablePutBlock: 
					#(#UIBActionProperty 
						#name: nil ) 
					#filter: 
					#(#UIBActionProperty 
						#name: 
						#isDirectory: ) 
					#filename: 
					#(#UIBAspectProperty 
						#name: #selectedFilename ) 
					#forPut: false 
					#currentSelection: 
					#(#UIBAspectProperty 
						#name: #currentSelection ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 145 0 -5 1 170 0 ) 
					#name: #cancelButton 
					#model: #doCancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 5 0 -28 1 244 0 -3 1 ) 
					#name: #selectDirectoryButton 
					#model: #selectDirectory 
					#label: 'Select Directory' 
					#defaultable: true ) ) ) )!

getDirectoryWithPromptSpec
	"UIBPainter new openOnClass: self andSelector: #getDirectoryWithPromptSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: '' 
			#bounds: #(#Rectangle 489 161 809 395 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#FileSelectorSpec 
					#layout: #(#LayoutFrame 0 0 30 0 0 1 -28 1 ) 
					#name: #selector 
					#flags: 0 
					#minorKey: #extendedSpec 
					#openButtonLabel: 'Open' 
					#volumesButtonLabel: 'Volumes' 
					#enablePutBlock: 
					#(#UIBActionProperty 
						#name: nil ) 
					#filter: 
					#(#UIBActionProperty 
						#name: 
						#isDirectory: ) 
					#filename: 
					#(#UIBAspectProperty 
						#name: #selectedFilename ) 
					#forPut: false 
					#currentSelection: 
					#(#UIBAspectProperty 
						#name: #currentSelection ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 175 0 -5 1 200 0 ) 
					#name: #cancelButton 
					#model: #doCancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 5 0 -28 1 244 0 -3 1 ) 
					#name: #selectDirectoryButton 
					#model: #selectDirectory 
					#label: 'Select Directory' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#Point 5 5 ) 
					#name: #prompt 
					#label: #prompt ) ) ) )!

getFileSpec
	"UIBPainter new openOnClass: self andSelector: #getFileSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: '' 
			#bounds: #(#Rectangle 164 217 484 415 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#FileSelectorSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #selector 
					#flags: 0 
					#openButtonLabel: 'Open' 
					#volumesButtonLabel: 'Volumes' 
					#enablePutBlock: 
					#(#UIBActionProperty 
						#name: nil ) 
					#filter: 
					#(#UIBActionProperty 
						#name: nil ) 
					#filename: 
					#(#UIBAspectProperty 
						#name: #selectedFilename ) 
					#forPut: false 
					#currentSelection: 
					#(#UIBAspectProperty 
						#name: #currentSelection ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 110 0 -5 1 135 0 ) 
					#name: #cancelButton 
					#model: #doCancel 
					#label: 'Cancel' 
					#defaultable: true ) ) ) )!

getFileWithPromptSpec
	"UIBPainter new openOnClass: self andSelector: #getFileWithPromptSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: '' 
			#bounds: #(#Rectangle 146 221 466 419 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#FileSelectorSpec 
					#layout: #(#LayoutFrame 0 0 30 0 0 1 0 1 ) 
					#name: #selector 
					#flags: 0 
					#openButtonLabel: 'Open' 
					#volumesButtonLabel: 'Volumes' 
					#enablePutBlock: 
					#(#UIBActionProperty 
						#name: nil ) 
					#filter: 
					#(#UIBActionProperty 
						#name: nil ) 
					#filename: 
					#(#UIBAspectProperty 
						#name: #selectedFilename ) 
					#forPut: false 
					#currentSelection: 
					#(#UIBAspectProperty 
						#name: #currentSelection ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 140 0 -5 1 165 0 ) 
					#name: #cancelButton 
					#model: #doCancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#Point 5 5 ) 
					#name: #prompt 
					#label: #prompt ) ) ) )!

putFileSpec
	"UIBPainter new openOnClass: self andSelector: #putFileSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: '' 
			#min: #(#Point 241 199 ) 
			#bounds: #(#Rectangle 108 210 428 435 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#FileSelectorSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -50 1 ) 
					#name: #selector 
					#flags: 0 
					#minorKey: #extendedSpec 
					#openButtonLabel: 'Save' 
					#volumesButtonLabel: 'Volumes' 
					#enablePutBlock: 
					#(#UIBActionProperty 
						#name: #filenameStringNotEmpty ) 
					#filter: 
					#(#UIBActionProperty 
						#name: nil ) 
					#filename: 
					#(#UIBAspectProperty 
						#name: #selectedFilename ) 
					#forPut: true 
					#currentSelection: 
					#(#UIBAspectProperty 
						#name: #currentSelection ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 145 0 -5 1 170 0 ) 
					#name: #cancelButton 
					#model: #doCancel 
					#tabable: false 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 5 0 -54 1 ) 
					#name: #promptLabel 
					#label: 'Save File As:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 -30 1 -5 1 -5 1 ) 
					#name: #filenameField 
					#model: #filenameString ) ) ) )!

putFileWithPromptSpec
	"UIBPainter new openOnClass: self andSelector: #putFileWithPromptSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: '' 
			#min: #(#Point 241 199 ) 
			#bounds: #(#Rectangle 99 203 419 459 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#FileSelectorSpec 
					#layout: #(#LayoutFrame 0 0 30 0 0 1 -50 1 ) 
					#name: #selector 
					#flags: 0 
					#minorKey: #extendedSpec 
					#openButtonLabel: 'Save' 
					#volumesButtonLabel: 'Volumes' 
					#enablePutBlock: 
					#(#UIBActionProperty 
						#name: #filenameStringNotEmpty ) 
					#filter: 
					#(#UIBActionProperty 
						#name: nil ) 
					#filename: 
					#(#UIBAspectProperty 
						#name: #selectedFilename ) 
					#forPut: true 
					#currentSelection: 
					#(#UIBAspectProperty 
						#name: #currentSelection ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 175 0 -5 1 200 0 ) 
					#name: #cancelButton 
					#model: #doCancel 
					#tabable: false 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 5 0 -54 1 ) 
					#name: #promptLabel 
					#label: 'Save File As:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 -30 1 -5 1 -5 1 ) 
					#name: #filenameField 
					#model: #filenameString ) 
				#(#LabelSpec 
					#layout: #(#Point 5 5 ) 
					#name: #prompt 
					#label: #prompt ) ) ) )! !

!FileDialog class methodsFor: 'interface opening'!

getDirectory
	"Display a file selection dialog without prompt string for locating a directory.
	Return the pathname of the selected directory or nil if the dialog was canceled."

	"self getDirectory"

	^self getDirectory: nil!

getDirectory: promptStringOrNil
	"Display a file selection dialog with the given prompt string for locating a directory.
	Return the pathname of the selected directory or nil if the dialog was canceled."

	"self getDirectory: 'Select a destination folder:'"

	| anInstance selector specSelector |
	anInstance := self new.
	promptStringOrNil isNil
		ifTrue: [specSelector := #getDirectorySpec]
		ifFalse: [specSelector := #getDirectoryWithPromptSpec.
				anInstance builder labelAt: #prompt put: promptStringOrNil].
	anInstance builder actionAt:# selectDirectory put: [anInstance doAccept].
	anInstance
		postBuildBlock: [: instance :aBuilder| selector := anInstance widget: #selector.
						(anInstance widget: #selectDirectoryButton) labelString: 'Select "', selector currentDirectoryName , '"'.
						selector currentDirectory compute:[
							(anInstance widget: #selectDirectoryButton) labelString: 'Select "', selector currentDirectoryName , '"'.
							anInstance able: selector currentDirectoryIsDesktop not component: #selectDirectoryButton]].
	^(self openOn: anInstance withSpec: specSelector)
		ifTrue:[(anInstance widget: #selector) currentDirectory value]
		ifFalse:[nil]!

getFile
	"self getFile"

	| anInstance |
	^(self openOn: (anInstance := self new) withSpec: #getFileSpec)
		ifTrue:[anInstance selectedFilename value]
		ifFalse:[nil]!

getFileFiltered: filterBlock
	"self getFileFiltered: [:file| '*.st' match: file first asString]"

	^self getFileFiltered: filterBlock prompt: nil!

getFileFiltered: filterBlock prompt: promptStringOrNil
	"self getFileFiltered: [:file| '*.st' match: file first asString] prompt: 'Select a Smalltalk file:' "

	| anInstance specSelector |
	anInstance := self new.
	promptStringOrNil isNil
		ifTrue: [specSelector := #getFileSpec]
		ifFalse: [specSelector := #getFileWithPromptSpec.
				anInstance builder labelAt: #prompt put: promptStringOrNil].
	anInstance allButOpenFrom: (self interfaceSpecFor:specSelector).
	(anInstance widget: #selector)  filter: filterBlock.
	anInstance builder openDialog.
	^(anInstance accept value)
		ifTrue:[anInstance selectedFilename value]
		ifFalse:[nil]!

putFile
	"self putFile"

	^self putFile: nil!

putFile: promptStringOrNil
	"Display a file selection dialog with the given prompt string for saving a file.
	Return the pathname of the selected file or nil if the dialog was canceled."
	"self putFile: 'Enter a file:'"

	| anInstance specSelector |
	anInstance := self new.
	promptStringOrNil isNil
		ifTrue: [specSelector := #putFileSpec]
		ifFalse: [specSelector := #putFileWithPromptSpec.
				anInstance builder labelAt: #prompt put: promptStringOrNil].
	anInstance
		postBuildBlock: [: instance :aBuilder|
						(aBuilder componentAt: #filenameField) widget controller continuousAccept: true].
	^(self openOn: anInstance withSpec: specSelector)
		ifTrue:[anInstance selectedFilename value construct: anInstance filenameString value]
		ifFalse:[nil]! !

UIBPropertiesTool subclass: #UIBPropertiesTool2
	instanceVariableNames: 'componentMenu componentMenuSelection menuSelectionHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter-Tools'!
UIBPropertiesTool2 comment:
'This a experimental class. Do not use it!!'!


!UIBPropertiesTool2 methodsFor: 'actions'!

apply
	"Copy the information in 'currentSpecCopy' to the selected 
	components."

	| labelM |
	((UIBFinder isCompositeComponentSpecClass: self currentSpecCopy2 class)
		ifTrue:[self currentSpecCopy2 isDataValidFor: self]
		ifFalse:[self currentSpecCopy2 isDataValid]) ifFalse: [^self].
	(controller == nil or: [controller view == nil])
		ifTrue: [^self].
	lock := true.
	client preapply.
	selectionKind == #single
		ifTrue: 
			["replaceElement:etc. will cause change to be noted, and 
			select: will 
			cause UIPainterWatchers to be alerted."
			| selElem sel spec doReselect |
			selElem := selection first.
			sel := controller selectionList.
			doReselect := sel size = 1 and: [sel first = selElem].
			spec := self currentSpecCopy2 copy.
			spec layout: selElem spec layout.
			selElem := controller replaceElement: selElem basedOnSpec: spec.
			selection := Array with: selElem.
			doReselect ifTrue: [controller select: selElem]]
		ifFalse: [selectionKind == #multi
				ifTrue: 
					["replaceElement:etc. will cause change to be noted, 
					and 
					select: will cause UIPainterWatchers to be alerted."
					| newSelection spec doReselect |
					doReselect := controller selectionList == selection.
					newSelection := OrderedCollection new: selection size.
					selection
						do: 
							[:selElem | 
							spec := selElem spec copy.
							currentSpecCopy copyPropertiesTo: spec.
							newSelection add: (controller replaceElement: selElem basedOnSpec: spec)].
					selection := newSelection.
					doReselect ifTrue: [controller selectionList: newSelection]]
				ifFalse: [selectionKind == #window
						ifTrue: 
							[((labelM := currentSpecBindings at: #label ifAbsent:[]) notNil and:
								[labelM value isEmpty and:
									[(UIPainter preferenceFor: #hostWindowManager)
									== #OSFMotif]])
								ifTrue: 
									[(subBuilder componentAt: #labelField) flash.
									^self].
							controller model windowSpec: currentSpecCopy copy.
							controller model fixBuildersWindow.
							controller model builder window flushCaches.
							controller model builder window label: labelM value.
							controller canvasHasChanged: true]]].
	self statusBarText value: (controller model dependents at: 1) label asString.
	self displayButtonsForUnmodifiedState.
	lock := false!

test

	selectionKind == #single
		ifTrue: 
			[| selElem |
			selElem := selection first.
			"((Smalltalk at: selElem spec majorKey) new allButOpenInterface: selElem spec minorKey) inspect"
			(((controller model builder componentAt: selElem spec name) widget components
				select:[:wrapper| wrapper spec name notNil])
				collect:[:wrapper|wrapper spec name]) inspect]! !

!UIBPropertiesTool2 methodsFor: 'private'!

componentMenu

	^componentMenu!

componentMenuFrom: aSpec

	| mb |
	mb := MenuBuilder new.
	mb add: aSpec class componentName -> aSpec.
	(UIBFinder isCompositeComponentSpecClass: aSpec class)
		ifTrue:[	mb line.
				(((selection first  widget components
					select:[:wrapper| wrapper spec name notNil])
					asSortedCollection:[:w1 :w2| w1 spec name <= w2 spec name])
					do:[:wrapper|mb add: (wrapper spec name , ' (', wrapper spec class componentName , ')')
										-> wrapper spec])].
	^mb menu!

computeSliceInfo
	"Retrieve the slice information and build a menu based on it."

	"Overridden here because the superclass expects the first slice
	to be #Basics and we want it to be an arbitrary name.
	(See the last line of the code.)"

	| mb slicesArray found foundIndex |
	found := false.
	mb := MenuBuilder new.
	slicesArray := self currentSpecCopy2 class slices.
	sliceInfo := IdentityDictionary new.
	foundIndex := 1.
	1 to: slicesArray size
		do: 
			[:index | 
			| info sliceName |
			info := slicesArray at: index.
			sliceName := info at: 1.
			mb add: sliceName -> sliceName.
			sliceInfo at: sliceName put: info.
			sliceName == slice value
				ifTrue: 
					[found := true.
					self class isItNotebook ifTrue: [foundIndex := index]]].
	slicesMenu value: mb menu.
	self class isItNotebook ifTrue: [self replaceTheTabList: self masterList index: foundIndex].
	found ifFalse: [slice setValue: ((slicesArray at: 1) at: 1) "take the name of the first slice"]!

currentSpecCopy2

	^self componentMenuSelection value!

reloadSelectionInformation
	"If the new selection is really new then reload all selection 
	information. Note: it is important that 'selection', 'controller', 
	'selectionKind', and 'currentSpecCopy' be set at the same 
	time (as they are in this method - and only this method and 
	'setUpForNil')."

	| newController newSelection |
	lock == true ifTrue: [^self].
	newController := selectionHolder value.
	newController == nil ifTrue: [^self setUpForNil].
	newSelection := newController selectionList.
	selection == newSelection 
		ifTrue: [client isNil ifTrue: [^self].
				client usesConservativeReload ifFalse: [^self]].
	selection := newSelection.
	controller := newController.
	statusBarText value: (controller model dependents at: 1) label asString.
	selection size = 0
		ifTrue: 
			[(newController isKindOf: UIBPropertiesPainterController)
				ifTrue:[selectionKind := #propertiesSlice]
				ifFalse:[	selectionKind := #window].
			currentSpecCopy := controller model windowSpec]
		ifFalse: [selection size = 1
				ifTrue: 
					[selectionKind := #single.
					currentSpecCopy := selection first spec copy]
				ifFalse: 
					[selectionKind := #multi.
					currentSpecCopy := MultiSpec new]].
	self updateComponentMenuFrom: currentSpecCopy.
	self computeSliceInfo.
	self displayButtonsForUnmodifiedState.
	slice value: slice value asSymbol!

setSpecChannel
	"Given a 'slice' and a 'currentSpecCopy', build and fill-in the slice." 

	| subCanvas currentSpec info specHolder subSpecIdent specSelector |
	lastSlice := slice value.
	slice value == #None ifTrue: [^self sliceOrSelectionChanged].
	(client notNil and: [client ~~ self ]) 
		ifTrue: [ client release ].
	(subBuilder notNil and: [ (subBuilder aspectAt: #releasingAgent) notNil ]) 
		ifTrue: [ (subBuilder aspectAt: #releasingAgent) release ].
	info := sliceInfo at: slice value. 
	specSelector := info at: 2.
	subSpecIdent := info size >= 4 
				ifTrue: [info at: 4]
				ifFalse: [nil].
	specChannel := (subSpecIdent notNil
				ifTrue: [self currentSpecCopy2 subSpecFor: subSpecIdent]
				ifFalse: [self currentSpecCopy2]) asValue.
	currentSpecBindings := IdentityDictionary new.
	(info size >= 3 and: [(info at: 3) notNil])
		ifTrue: 
			[specHolder := client := (Smalltalk at: (info at: 3)) new]
		ifFalse: 
			[client := self.
			specHolder := specChannel value].
	currentSpecBindings at: #propertiesTool put: self.
	specHolder class
		addBindingsTo: currentSpecBindings
		for: specHolder
		channel: specChannel.
	selectionKind == #window
		ifTrue: 
			[| labelM |
			self currentSpecCopy2 label: controller model builder window label.
			currentSpecBindings at: #label put: (labelM := AspectAdaptor forAspect: #label).
			labelM subjectChannel: self currentSpecCopy2 asValue].
	subCanvas := (builder componentAt: #specCanvas) widget.
	subBuilder := builder newSubBuilder.

	"use the bindings that were just collected"
	subBuilder bindings: currentSpecBindings.

	subBuilder aspectAt: #parentModel put: self.
	currentSpec := UISpecification from: (specHolder class perform: specSelector).
	subCanvas
		client: client
		spec: currentSpec
		builder: subBuilder.
	specChannel dependents do: [:dep | dep compute: [:v | self displayButtonsForModifiedState]].
	(subBuilder aspectAt: #releasingAgent) notNil 
		ifTrue: [ (subBuilder aspectAt: #releasingAgent) validateComponentsFor: subBuilder ].
	self sliceOrSelectionChanged.!

updateComponentMenuFrom: aSpec

	self componentMenu value: 
		(selectionKind == #none
		ifTrue:[	MenuBuilder new add: 'None' -> aSpec; menu]
		ifFalse:[	selectionKind == #single
				ifTrue: [	self componentMenuFrom: aSpec]
				ifFalse:[	selectionKind == #multi
						ifTrue:[	MenuBuilder new add: 'Multiple Components' -> aSpec; menu]
						ifFalse:[	selectionKind == #window
								ifTrue:[	MenuBuilder new add: 'Window' -> aSpec; menu]
								ifFalse:[	selectionKind == #propertiesSlice
										ifTrue:[	MenuBuilder new add: 'Properties Slice' -> aSpec; menu]
										ifFalse:[	self notify: 'Unknown selectionKind.']]]]]).
	menuSelectionHolder value: (self componentMenu value valueAt: 1).
	(self builder componentAt: #componentMenu) widget isEnabled: self componentMenu value numberOfItems >1! !

!UIBPropertiesTool2 methodsFor: 'aspects'!

componentMenuSelection

	^componentMenuSelection! !

!UIBPropertiesTool2 methodsFor: 'initialize-release'!

initialize

	super initialize.
	componentMenu := Menu new asValue.
	componentMenuSelection := (PluggableAdaptor on: (menuSelectionHolder := nil asValue))
		getBlock:[:m| m value]
		putBlock:[:m :newSelection| "send by MenuButton" m value: newSelection.
								self computeSliceInfo.
								self displayButtonsForUnmodifiedState.
								slice value: slice value asSymbol]
		updateBlock:[:m :aspect :parameter| "sent by me" true]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertiesTool2 class
	instanceVariableNames: ''!


!UIBPropertiesTool2 class methodsFor: 'interface specs'!

windowNotebookSpec
	"UIBPainter new openOnClass: self andSelector: #windowNotebookSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Properties Tool' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 111 214 519 621 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 289 0 -396 1 0 1.75853 0 -0.100592 ) 
					#model: #statusBarText 
					#tabable: false 
					#isReadOnly: true ) 
				#(#NoteBookSpec 
					#layout: #(#LayoutFrame 4 0 34 0 -4 1 -39 1 ) 
					#name: #specCanvas 
					#model: #sliceMasterList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#requestValueChangeSelector: #validateChangeOfPage ) 
					#rightInset: 95 
					#bottomInset: 0 ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 4 0 -32 1 64 0 -2 1 ) 
					#name: #applyButton 
					#model: #apply 
					#label: 'Apply' 
					#isDefault: true 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -109 1 -32 1 -57 1 -2 1 ) 
					#name: #prevButton 
					#model: #selectPrev 
					#tabable: false 
					#label: 'Prev' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -56 1 -32 1 -4 1 -2 1 ) 
					#name: #nextButton 
					#model: #selectNext 
					#tabable: false 
					#label: 'Next' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 65 0 -32 1 131 0 -2 1 ) 
					#name: #readButton 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 132 0 -32 1 263 0 -2 1 ) 
					#name: #applyAndCloseButton 
					#model: #applyAndClose 
					#label: 'Apply & Close' 
					#isDefault: false 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 331 338 379 358 ) 
					#name: #testButton 
					#model: #test 
					#label: 'Test' 
					#defaultable: true ) 
				#(#MenuButtonSpec 
					#layout: #(#Rectangle 22 5 289 29 ) 
					#name: #componentMenu 
					#model: #componentMenuSelection 
					#menu: #componentMenu ) ) ) )! !

UIBProperty subclass: #UIBLabelProperty
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Properties'!


!UIBLabelProperty methodsFor: 'accessing'!

inBuilder: builder withCustomCode: aString

	^self inBuilder: builder withSelector: #labelAt: withCustomCode: aString! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBLabelProperty class
	instanceVariableNames: ''!


!UIBLabelProperty class methodsFor: 'accessing'!

propertyName

	^'Label'! !

Object subclass: #UIBSpecLayoutChanger
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!


!UIBSpecLayoutChanger methodsFor: 'changing layout'!

move: spec to: aPoint

	|layout|
	layout := spec layout.
	layout moveTo: aPoint.
	spec layout: layout! !

UIBPluggablePainter subclass: #UIBPropertiesPainter
	instanceVariableNames: 'targetComponent '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!
UIBPropertiesPainter comment:
'I am a Painter for properties slices in the PropertiesTool.
I expect to live in a window of which the application is a UIBSpecificationEditor.'!


!UIBPropertiesPainter methodsFor: 'initialize-release'!

forComponent: aUIBComponent

	targetComponent := aUIBComponent!

initializeWindowSpec

	windowSpec := UIBPropertiesSliceSpec new!

preferredCanvasClass

	^UIBSlice!

preferredControllerClass

	^UIBPropertiesPainterController! !

!UIBPropertiesPainter methodsFor: 'accessing'!

targetComponent

	^targetComponent! !

!UIBPropertiesPainter methodsFor: 'private'!

makeWindowSpec
	"The windowSpec is in fact a UIBPropertiesSliceSpec, which does not need min, max or pref extents, nor coloring information, since it is only used in a Subcanvas. So, just return the current value of the instance variable."

	^windowSpec! !

!UIBPropertiesPainter methodsFor: 'interface opening'!

forCanvas: aCanvas
	"aCanvas <UIBCanvas>."

	self forFullSpec: aCanvas fullSpec.
	self targetClass: aCanvas targetClass.
	self targetSelector: aCanvas specSelector! !

CompositePart subclass: #NoteBookCompositeOOP
	instanceVariableNames: 'binder tabBar bottomTabBar subCanvas '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!


!NoteBookCompositeOOP methodsFor: 'initialize-release'!

binder: aBinder tabBar: aTabBar rightInset: rInteger bottomInset: bInteger bottomTabBar: btb subcanvas: aSubcanvas insets: insetsRect

	| lf1 lf2 lf3 lf4 rightInset bottomInset |   
	rightInset := rInteger + 1.
	bottomInset := bInteger + 1.
	lf1 := LayoutFrame new	"binder"
		rightFraction: 1; rightOffset: rightInset negated;
		bottomFraction: 1; topOffset: bottomInset .
	lf2 := LayoutFrame new	"vertical tabs" 
		leftFraction: 1; leftOffset: rightInset negated;
		rightFraction: 1; 
		topOffset: bottomInset - 14;
		bottomFraction: 1; bottomOffset: (0 - 20 max: 0) negated.
	lf3 := LayoutFrame new	"horizontal tabs" 
		rightFraction: 1; rightOffset: rightInset negated;
		 bottomOffset: bottomInset .

	lf4 := LayoutFrame new	"subcanvas"
		topOffset: bottomInset + insetsRect top;
		leftOffset: insetsRect left;
		rightFraction: 1; rightOffset: (rightInset negated - insetsRect right);
		bottomFraction: 1; bottomOffset: insetsRect bottom negated.
		

	binder := aBinder.
	tabBar := aTabBar.
	bottomTabBar := btb.
	subCanvas := aSubcanvas.
	self add: binder in: lf1.
	self add: tabBar in: lf2.
	self add: bottomTabBar in: lf3.
	self add: subCanvas in: lf4

	"<<BIKI at the bottom of a mountain: 11 January 1996,5:02:31 pm, version: 5>>"! !

!NoteBookCompositeOOP methodsFor: 'refreshing'!

refreshBottomTabBar

	self bottomTabBar invalidate

	"<<MaPL: 23 May 1996,9:19:57 am, version: 1>>"!

refreshRightTabBar

	self rightTabBar invalidate

	"<<MaPL: 23 May 1996,9:20:18 am, version: 2>>"!

refreshTabs

	self refreshBottomTabBar.
	self refreshRightTabBar.

	"<<MaPL: 23 May 1996,9:20:48 am, version: 2>>"! !

!NoteBookCompositeOOP methodsFor: 'accessing'!

binder

	^binder!

bottomTabBar

	^bottomTabBar!

rightTabBar

	^tabBar!

subCanvas

	^subCanvas! !

!NoteBookCompositeOOP methodsFor: 'rebuilding'!

client: appModel

	^subCanvas client: appModel!

client: appModel spec: aSpec

	^subCanvas client: appModel spec: aSpec!

client: appModel spec: aSpec builder: aBuilder 

	^subCanvas client: appModel spec: aSpec builder: aBuilder! !

UIBProperty subclass: #UIBClientProperty
	instanceVariableNames: 'className '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Properties'!


!UIBClientProperty methodsFor: 'accessing'!

className

	^className!

defaultGeneratedCode

	^'<class name> new'!

inBuilder: builder withCustomCode: aString


	^self inBuilder: builder withSelector: #clientAt: withCustomCode: aString

	"| m |
	name == nil ifTrue: [^self defaultModel].
	m := builder clientAt: name.
	m == nil ifFalse: [^m].
	builder isEditing ifFalse: [^builder raiseError: 'client: % not found!!' with: name].
	m := self defaultModel.
	builder cacheWhileEditing ifTrue: [builder clientAt: name put: m].
	^m"!

onlyDefaultCodeGeneration

	^true! !

!UIBClientProperty methodsFor: 'private'!

defaultModel

	^className isNil
		ifTrue:[nil]
		ifFalse:[(Smalltalk at: className ifAbsent:[self error:'Class for client does not exist.']) new]! !

!UIBClientProperty methodsFor: 'privileged-accessing'!

className: aSymbol

	className := aSymbol! !

!UIBClientProperty methodsFor: 'converting'!

literalArrayEncodingOn: aStream
	"Put a literal encoding suitable for reconstituting the receiver on aStream."

	super literalArrayEncodingOn: aStream.
	aStream
		nextPut: #className:;
		nextPut: self className! !

!UIBClientProperty methodsFor: 'building'!

bindInAspectEnumerator: aUIBAspectEnumerator withCustomCode: aString

	self name isNil
		ifFalse:[aUIBAspectEnumerator clients at: self name put: self className]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBClientProperty class
	instanceVariableNames: ''!


!UIBClientProperty class methodsFor: 'accessing'!

propertyName

	^'Client'! !

!UIBClientProperty class methodsFor: 'interface specs'!

comboEditSpec
	"UIBPainter new openOnClass: self andSelector: #comboEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Client Combo Box' 
			#bounds: #(#Rectangle 291 198 574 267 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -3 0.5 ) 
					#name: #name 
					#model: #name 
					#type: #symbol ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 0 0 3 0.5 0 1 0 1 ) 
					#model: #className 
					#style: #default 
					#isReadOnly: false 
					#type: #symbol 
					#comboList: #availableApplicationModels ) ) ) )!

editSpec
	"UIBPainter new openOnClass: self andSelector: #editSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Client Input Field' 
			#bounds: #(#Rectangle 339 155 622 224 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -3 0.5 ) 
					#name: #name 
					#model: #name 
					#type: #symbol ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 3 0.5 0 1 0 1 ) 
					#name: #className 
					#model: #className 
					#type: #symbol ) ) ) )! !

UIBApplicationModel subclass: #UIBAdaptorEditor
	instanceVariableNames: 'adaptorSpec modelSpecs '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBAdaptorEditor methodsFor: 'accessing'!

adaptorSpec

	^adaptorSpec! !

!UIBAdaptorEditor methodsFor: 'private'!

defaultAdaptorSpecClass

	^self subclassResponsibility!

updateAdaptorModels

	"Default is to do nothing."!

updateModelSpecsModels

	"Default is to do nothing."! !

!UIBAdaptorEditor methodsFor: 'initialize-release'!

adaptorSpec: aUIBAdaptorSpec

	adaptorSpec := aUIBAdaptorSpec.
	self updateAdaptorModels!

initialize

	super initialize.
	adaptorSpec := self defaultAdaptorSpecClass new.
	modelSpecs := UIBAspectDictionary new!

modelSpecs

	^modelSpecs!

modelSpecs: aUIBAspectDictionary

	modelSpecs := aUIBAspectDictionary.
	self updateModelSpecsModels! !

UIBAdaptorEditor subclass: #UIBAspectAdaptorEditor
	instanceVariableNames: 'subjectSendsUpdates aspectName subjectAccessor subjectSelector subjectAccessorChoices '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBAspectAdaptorEditor methodsFor: 'initialize-release'!

initialize

	super initialize.
	aspectName := (AspectAdaptor forAspect: #aspect) subject: self adaptorSpec; subjectSendsUpdates: true.
	subjectSelector := (AspectAdaptor forAspect: #subjectSelector) subject: self adaptorSpec; subjectSendsUpdates: true.
	subjectAccessor := (AspectAdaptor forAspect: #subjectAccessor) subject: self adaptorSpec; subjectSendsUpdates: true.
	subjectSendsUpdates := (AspectAdaptor forAspect: #subjectSendsUpdates) subject: self adaptorSpec; subjectSendsUpdates: true.
	subjectAccessorChoices := List new asValue! !

!UIBAspectAdaptorEditor methodsFor: 'aspects'!

aspectName
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^aspectName isNil
		ifTrue:
			[aspectName := nil asValue]
		ifFalse:
			[aspectName]!

subjectAccessor
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^subjectAccessor!

subjectAccessorChoices
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^subjectAccessorChoices!

subjectSelector
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^subjectSelector isNil
		ifTrue:
			[subjectSelector := nil asValue]
		ifFalse:
			[subjectSelector]!

subjectSendsUpdates
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^subjectSendsUpdates isNil
		ifTrue:
			[subjectSendsUpdates := false asValue]
		ifFalse:
			[subjectSendsUpdates]! !

!UIBAspectAdaptorEditor methodsFor: 'private'!

defaultAdaptorSpecClass

	^UIBAspectAdaptorSpec!

updateAdaptorModels

	self aspectName subject: self adaptorSpec.
	self subjectSelector subject: self adaptorSpec.
	self subjectAccessor subject: self adaptorSpec.
	self subjectSendsUpdates subject: self adaptorSpec!

updateModelSpecsModels

	self subjectAccessorChoices value: self modelSpecs keys asSortedCollection asList! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBAspectAdaptorEditor class
	instanceVariableNames: ''!


!UIBAspectAdaptorEditor class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Aspect Adaptor Editor' 
			#bounds: #(#Rectangle 335 146 591 395 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 5 68 ) 
					#name: #aspectLabel 
					#label: 'For aspect:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 85 0 68 0 -5 1 88 0 ) 
					#name: #aspectName 
					#model: #aspectName 
					#type: #symbol ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 5 100 ) 
					#name: #subjectSendsUpdates 
					#model: #subjectSendsUpdates 
					#label: 'Subject sends updates' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 5 0 120 0 -5 1 -5 1 ) 
					#name: #accessPathLabel 
					#label: 'Access Path' ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 5 0 36 0 -5 1 58 0 ) 
					#name: #subjectAccessor 
					#model: #subjectAccessor 
					#type: #symbol 
					#comboList: #subjectAccessorChoices ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 105 5 ) 
					#name: #subjectChannelRadioButton 
					#model: #subjectSelector 
					#label: 'On subject channel:' 
					#select: #subjectChannel ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 5 5 ) 
					#name: #subjectRadioButton 
					#model: #subjectSelector 
					#label: 'On subject:' 
					#select: #subject ) ) ) )!

windowSpec2
	"UIBPainter new openOnClass: self andSelector: #windowSpec2"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Aspect Adaptor Editor' 
			#bounds: #(#Rectangle 112 236 368 485 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 5 60 ) 
					#name: #aspectLabel 
					#label: 'For aspect:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 85 0 60 0 -5 1 80 0 ) 
					#name: #aspectName 
					#model: #aspectName 
					#type: #symbol ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 30 0 -5 1 50 0 ) 
					#name: #'subjectAccessor' 
					#model: #subjectAccessor 
					#type: #symbol ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 5 5 ) 
					#name: #subjectRadioButton 
					#model: #subjectSelector 
					#label: 'On subject:' 
					#select: #subject ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 100 5 ) 
					#name: #subjectChannelRadioButton 
					#model: #subjectSelector 
					#label: 'On subject channel:' 
					#select: #subjectChannel ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 5 90 ) 
					#name: #subjectSendsUpdates 
					#model: #subjectSendsUpdates 
					#label: 'Subject sends updates' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 5 0 110 0 -5 1 -5 1 ) 
					#name: #accessPathLabel 
					#label: 'Access Path' ) ) ) )! !

WindowSpec subclass: #UIBWindowSpec
	instanceVariableNames: 'models adaptors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Basics'!
UIBWindowSpec comment:
'I extend my superclass with the the ability to associate models and adaptors with applications at painting time, so that less coding of aspect methods needs to be done afterwards.

Also see the UIBAdaptorSpec hierarchy.

Instance variables:
	models	<UIBAspectDictionary>	The dictionary of models for the window''s application.
	adaptors	<UIBAspectDictionary>	The dictionary of adaptors for the window''s application.'!


!UIBWindowSpec methodsFor: 'initialize-release'!

initialize

	super initialize.
	models := UIBAspectDictionary new.
	adaptors := UIBAspectDictionary new.! !

!UIBWindowSpec methodsFor: 'accessing'!

adaptors

	^adaptors!

adaptors: aUIBAspectDictionary

	adaptors := aUIBAspectDictionary!

models

	^models!

models: aUIBAspectDictionary

	models := aUIBAspectDictionary! !

!UIBWindowSpec methodsFor: 'copying'!

postCopy

	super postCopy.
	models := models copy.
	adaptors := adaptors copy.
	^self! !

!UIBWindowSpec methodsFor: 'private'!

fromLiteralArrayEncoding: anArray

	super fromLiteralArrayEncoding: anArray.
	"Since the receiver is initialized before decoding, the models and adaptors IVs are filled with literal arrays, unless they were not specified in the literal spec (in which case they still hold the initialization values, i.e. UIBAspectDictionaries)"
	(models isKindOf: Array) ifTrue:[models := models decodeAsLiteralArray].
	(adaptors isKindOf: Array) ifTrue:[adaptors := adaptors decodeAsLiteralArray]!

literalArrayEncoding
	"Strip out empty models and/or adaptor dictionaries before encoding."

	| m a encoding |
	m := models.
	a := adaptors.
	models isEmpty ifTrue:[models := nil].
	adaptors isEmpty ifTrue:[adaptors := nil].
	encoding := super literalArrayEncoding.
	models := m.
	adaptors := a.
	^encoding! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBWindowSpec class
	instanceVariableNames: ''!


!UIBWindowSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #models put: (self adapt: inst forAspect: #models channel: aChannel).
	env at: #adaptors put: (self adapt: inst forAspect: #adaptors channel: aChannel).!

slices
	^#(	(Basics basicsEditSpec)
		(Details detailsEditSpec)
		(Models propSpec UIBModelEditorSlice)
		(Aspects aspectsEditSpec)
		(Color propSpec ColorToolModel) 
		(Position propSpec PositionToolModel) 
		(#'Drop Target'	dropTargetSpec))! !

!UIBWindowSpec class methodsFor: 'interface specs'!

aspectsEditSpec
	"UIBPainter new openOnClass: self andSelector: #aspectsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'aspects edit  spec' 
			#min: #(#Point 300 222 ) 
			#max: #(#Point 300 222 ) 
			#bounds: #(#Rectangle 34 108 334 330 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBAspectEditorSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#flags: 0 
					#modelSpecs: 
					#(#UIBAspectProperty 
						#name: #models ) 
					#adaptorSpecs: 
					#(#UIBAspectProperty 
						#name: #adaptors ) 
					#availableAspects: 
					#(#UIBAspectProperty 
						#name: #availableAspects ) ) ) ) )!

modelsEditSpec
	"UIBPainter new openOnClass: self andSelector: #modelsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Models Slice' 
			#min: #(#Point 300 222 ) 
			#max: #(#Point 300 222 ) 
			#bounds: #(#Rectangle 56 127 356 349 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBModelEditorSpec 
					#layout: #(#LayoutFrame 5 0 5 0 -5 1 -5 1 ) 
					#flags: 0 
					#modelSpecs: 
					#(#UIBAspectProperty 
						#name: #models ) ) ) ) )! !

CompositeSpecCollection subclass: #UIBCompositeSpecCollection
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Composites'!
UIBCompositeSpecCollection comment:
'I am a CompositeSpecCollection that asks the componentSpec for its preferred user interface component, instead of a UIBuilder.'!


!UIBCompositeSpecCollection methodsFor: 'building'!

addTo: builder withPolicy: policy

	builder newComposite: self compositeSpec newComposite.
	1 to: collection size do:
		[:i |
		builder add: (collection at: i)].
	builder add: compositeSpec! !

UIBApplicationModel subclass: #UIBPropertyField
	instanceVariableNames: 'property '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!
UIBPropertyField comment:
'A UIBpropertyField displays the interface used to edit the target aspects of a UIBProperty.'!


!UIBPropertyField methodsFor: 'initalize-release'!

initialize

	property := UIBAspectProperty new asValue! !

!UIBPropertyField methodsFor: 'binding'!

aspectFor: aKey 
	"Answer an AspectAdaptor that uses a key to access the receiver's property."

	^(AspectAdaptor forAspect: aKey) subjectChannel: property! !

!UIBPropertyField methodsFor: 'model accessing'!

property

	^property!

property: aPropertyHolder

	property := aPropertyHolder! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertyField class
	instanceVariableNames: ''!


!UIBPropertyField class methodsFor: 'interface specs'!

comboEditSpec
	"This spec is only here to fool the AspectEnumerator that expects this spec here and not in the subclasses of UIBProperty."

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Property Editor' 
			#bounds: #(#Rectangle 209 143 409 343 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #componentHolder ) ) ) )!

editSpec
	"This spec is only here to fool the AspectEnumerator that expects this spec here and not in the subclasses of UIBProperty."

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Property Editor' 
			#bounds: #(#Rectangle 209 143 409 343 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #componentHolder ) ) ) )!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Property Editor' 
			#bounds: #(#Rectangle 209 143 409 343 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #componentHolder ) ) ) )! !

Inspector subclass: #UIBInspector
	instanceVariableNames: 'objectHolder pathMenu '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Development Extras'!


!UIBInspector methodsFor: 'private-menu messages'!

inspectField

	self fieldListHolder selectionIndex isZero
		ifFalse: [self inspectNestedObject: self fieldValue.
				self addInspectedObjectToPath]! !

!UIBInspector methodsFor: 'aspects'!

objectHolder

	^objectHolder! !

!UIBInspector methodsFor: 'initialize-release'!

inspect: anObject 
	"Set anObject to be the object inspected by the receiver."

	super inspect: anObject.
	objectHolder := anObject asValue.
	pathMenu := (Menu labelArray: (Array with: anObject class name) values: (Array with: anObject )) asValue!

inspectNestedObject: anObject 
	"Set anObject to be the object inspected by the receiver."

	object := anObject.
	self resetFields! !

!UIBInspector methodsFor: 'private'!

addInspectedObjectToPath

	| values selectionIndex menu | 
	menu := self pathMenu value.
	selectionIndex := menu indexOfMenuItem: menu selectionMemory. "We should not send  #selectionMemory (see class Menu)."
	(selectionIndex isZero or: [selectionIndex = menu numberOfItems])
		ifFalse: [values := menu values copyFrom: 1 to: selectionIndex]
		ifTrue: [values := menu values].
	values := values copyWith: object.
	self pathMenu value: (Menu labelArray: (values collect: [:v | v class name]) values: values).
	objectHolder retractInterestsFor: self.
	self objectHolder value: object.
	objectHolder onChangeSend: #menuSelectionChanged to: self.!

menuSelectionChanged

	objectHolder value  == object ifFalse: [self inspectNestedObject: objectHolder value]!

pathMenu

	^pathMenu! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBInspector class
	instanceVariableNames: ''!


!UIBInspector class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Unlabeled Canvas' 
			#bounds: #(#Rectangle 48 168 355 503 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 1 0 25 0 -1 0.4 -1 1 ) 
					#name: #fieldList 
					#model: #fieldListHolder 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#doubleClickSelector: #inspectField 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #fieldMenuHolder ) 
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 1 0.4 1 0 -1 1 -1 1 ) 
					#name: #text 
					#model: #textHolder 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: 
						#textAccepted: 
						#requestValueChangeSelector: 
						#textAcceptAllowed: ) 
					#menu: #textMenuHolder ) 
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 1 0 1 0 -1 0.4 25 0 ) 
					#name: #path 
					#model: #objectHolder 
					#menu: #pathMenu ) ) ) )! !

UIBAdaptorEditor subclass: #UIBValueHolderEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBValueHolderEditor methodsFor: 'private'!

defaultAdaptorSpecClass

	^UIBValueHolderSpec! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBValueHolderEditor class
	instanceVariableNames: ''!


!UIBValueHolderEditor class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'ValueHolder Editor' 
			#bounds: #(#Rectangle 138 162 405 453 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )! !

UIBPalette subclass: #UIBPropertiesPalette
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Palette'!
UIBPropertiesPalette comment:
'I represent the properties palette, a palette that contains all the property-entry components.'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertiesPalette class
	instanceVariableNames: ''!


!UIBPropertiesPalette class methodsFor: 'accessing-specs'!

activeSpecsList

	^#(#UIBPropertyFieldSpec #UIBSubPropertyFieldSpec #UIBPropertyInputFieldSpec)! !

!UIBPropertiesPalette class methodsFor: 'accessing'!

numberOfColumns

	^3!

paletteName

	^'Properties'! !

UIBPluggablePainterController subclass: #UIBPropertiesPainterController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!


!UIBPropertiesPainterController methodsFor: 'control defaults'!

controlActivity

	| specEditor |
	specEditor := self view topComponent model.
	(specEditor targetComponent isOurOwnSlice: specEditor specSlices selection)
		ifTrue:[super controlActivity]! !

!UIBPropertiesPainterController methodsFor: 'testing'!

isCanvasToolActionAware

	^false! !

!UIBPropertiesPainterController methodsFor: 'private'!

adjustMenu: newMenu andModel: aModel 
	| s |
	super adjustMenu: newMenu andModel: aModel.
	(s := newMenu menuItemLabeled: 'special') submenu notNil
		ifTrue: [s enable]
		ifFalse: [s disable].
	^newMenu!

excludedSpecs
	"Answer a Collection of widget specification classes that should not be
	painted on canvasses of which the receiver is the model."
	"Overridden here to cancel the excluded specs in UIBPainterController."

	^Set new! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertiesPainterController class
	instanceVariableNames: ''!


!UIBPropertiesPainterController class methodsFor: 'class initialization'!

initialize
	"This method is empty, but must be here to be sure that it is initialized when it is filed in."
	"(Filing out a class generates an invokation of #initialize only if the class understands #initialize.)"

	"self initialize"

	super initialize.! !

!UIBPropertiesPainterController class methodsFor: 'resources'!

canvasMenu
	"UIMenuEditor new openOnClass: self andSelector: #canvasMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#label: 'edit' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'copy' ) 
						#(#MenuItem 
							#label: 'cut' ) 
						#(#MenuItem 
							#label: 'paste' ) 
						#(#MenuItem 
							#label: 'accept' ) 
						#(#MenuItem 
							#label: 'cancel' 
							#submenu: #(#Menu #(
									#(#MenuItem 
										#label: 'confirm' ) ) #(1 ) #(#cancel ) ) ) 
						#(#MenuItem 
							#label: 'spawn' ) ) #(3 2 1 ) #(#doCopy #doCut #doPaste #accept nil #doSpawn ) ) ) 
			#(#MenuItem 
				#label: 'tools' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'palette' ) 
						#(#MenuItem 
							#label: 'canvas tool' ) 
						#(#MenuItem 
							#label: 'image editor' ) 
						#(#MenuItem 
							#label: 'menu editor' ) 
						#(#MenuItem 
							#label: 'reusable data form components' ) ) #(2 2 1 ) #(#doPalette #doCanvasTool #maskEditor #menuEditor #openReusableComponents ) ) ) 
			#(#MenuItem 
				#label: 'layout' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'window' 
							#submenu: #(#Menu #(
									#(#MenuItem 
										#label: 'fixed size' ) 
									#(#MenuItem 
										#label: 'min size' ) 
									#(#MenuItem 
										#label: 'pref size' ) 
									#(#MenuItem 
										#label: 'max size' ) 
									#(#MenuItem 
										#label: 'clear all' ) ) #(1 3 1 ) #(#setAllWindowInfo #setWindowMinSize #setWindowPrefSize #setWindowMaxSize #setWindowToDefaults ) ) ) 
						#(#MenuItem 
							#label: 'fixed' ) 
						#(#MenuItem 
							#label: 'relative' ) 
						#(#MenuItem 
							#label: 'constrained...' ) 
						#(#MenuItem 
							#label: 'be bounded' ) 
						#(#MenuItem 
							#label: 'be unbounded' ) ) #(1 3 2 ) #(nil #doLayoutFixed #doLayoutRelative #fractionalConstraintDialog #doMakeBounded #doMakeUnBounded ) ) ) 
			#(#MenuItem 
				#label: 'arrange' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'snap to grid' ) 
						#(#MenuItem 
							#label: 'group' ) 
						#(#MenuItem 
							#label: 'special group' ) 
						#(#MenuItem 
							#label: 'ungroup' ) 
						#(#MenuItem 
							#label: 'bring forward' ) 
						#(#MenuItem 
							#label: 'bring to front' ) 
						#(#MenuItem 
							#label: 'send backward' ) 
						#(#MenuItem 
							#label: 'send to back' ) 
						#(#MenuItem 
							#label: 'align...' ) 
						#(#MenuItem 
							#label: 'distribute...' ) 
						#(#MenuItem 
							#label: 'equalize...' ) ) #(1 2 4 3 ) #(#doSnapSelectionToGrid #doGroup nil #doUngroup #toVisualFrontOne #toVisualFront #toVisualBackOne #toVisualBack #alignDialog #distributeDialog #equalizeDialog ) ) ) 
			#(#MenuItem 
				#label: 'special' )
			#(#MenuItem 
				#label: 'ApplFLab' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'Install On Palette...')) #(1 ) #(#doInstallSpecInstanceOnPalette )))
			#(#MenuItem 
				#label: 'properties' )  ) #(5 1 1) #(nil nil nil nil nil nil #doProperties ) ) decodeAsLiteralArray! !

VisualLauncher subclass: #UIBVisualLauncher
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Misc'!


!UIBVisualLauncher methodsFor: 'actions'!

browseAllClasses

	self builder window sensor shiftDown
		ifTrue:[self openApplicationForClassNamed: #FullBrowser]
		ifFalse:[super browseAllClasses]!

browseApplications

	self openApplicationForClassNamed: #UIBFinder!

fullBrowseAllClasses

	self openApplicationForClassNamed: #FullBrowser!

newDataMain
	"Create a new database application and then open a painter on its canvas"

	| newClass |
	newClass := UIBFinder
				createNewApplication: nil
				ofKind: #LensMainApplication
				inCategory: nil
				forClient: self.
	newClass notNil
		ifTrue:
			[UIBPainter new openOnClass: newClass andSelector: #windowSpec]!

openComponentEditor

	| kindAndClass |
	(kindAndClass := UIBComponentEditorSelector selectComponentKind) isNil
		ifFalse:[(Smalltalk at: (kindAndClass at: 1)) preferredComponentEditorClass openOnClass: (kindAndClass at: 2)]!

openPaletteEditor

	UIBPaletteEditor open!

toolsApplFLabInstaller

	UIBApplFLabInstaller open!

toolsCanvasTool
	"Overridden here in order to use our own canvas tool."

	UIBCanvasTool new openInterface: #windowSpecTight!

toolsCodingAssistant

	CodingAssistant open!

toolsNewCanvas
	"Open a new Canvas with a palette chosen from a menu of existing palettes.
	Do not show the palette menu when the shift key is pressed." 

	| selectedPaletteClass |
	self builder window sensor shiftDown
		ifFalse:[	(selectedPaletteClass := self showPaletteMenuWithNone) isNil ifTrue:[^self].
				selectedPaletteClass == #none ifTrue:[selectedPaletteClass := nil]]
		ifTrue:[	selectedPaletteClass := nil].
	UIBPainter new openNewWindowCanvasWithPalette: selectedPaletteClass!

toolsOpenPalette
	"Show a pop-up menu of existing palettes and open the one selected by the user." 

	UIBPaletteEditor openPaletteFromUserSelection!

toolsPalette

	self toolsOpenPalette! !

!UIBVisualLauncher methodsFor: 'private'!

reInstallInterface
	"Install the receiver's user interface again. Keep the same window. 
	This happens when changing projects, restarting, and look and feel 
	changes."

	"Overridden here in order to use our own builder class."

	| spec window wid cp wid2 transcriptState |
	transcriptState := self getTranscriptState.
	wid := builder componentAt: #textViewID.
	builder composite removeComponent: wid.
	window := builder window.
	window component release.
	builder := UIBBuilder new.
	builder setWindow: window.
	builder source: self.
	spec := self class interfaceSpecFor: #windowSpec.
	self preBuildWith: builder.
	builder add: spec.
	wid2 := builder componentAt: #textViewID.
	cp := wid2 container.
	cp removeComponent: wid2.
	wid2 release.
	wid2 widget release.    "It doesn't get sent to the edge decorators component unless it has created the edge widgets"
	cp addWrapper: wid.
	builder componentAt: #textViewID put: wid.
	wid widget controller keyboardProcessor: builder keyboardProcessor.
	self postBuildWith: builder.
	builder doFinalHookup.
	self postOpenWith: builder.
	self setTranscriptState: transcriptState.
	^builder!

showPaletteMenuWithNone
	"Show a pop-up menu of existing palettes and return the selection or nil.
	The selection can also be #none, indicating that no palette was selected but
	the menu was not dismissed." 

	| selection |
	^(selection := UIBPaletteEditor palettesMenuForSelectionOrNone startUp) = 0
		ifTrue:[nil]
		ifFalse:[selection]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBVisualLauncher class
	instanceVariableNames: ''!


!UIBVisualLauncher class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'VisualWorks + ApplFLab' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 146 302 572 441 ) 
			#flags: 4 
			#menu: #newMenuBar ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 0 0 32 32 ) 
					#model: #openFileList 
					#tabable: false 
					#label: #fileListIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 32 0 64 32 ) 
					#model: #browseAllClasses 
					#tabable: false 
					#label: #allClassesIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 112 0 144 32 ) 
					#model: #toolsNewCanvas 
					#tabable: false 
					#label: #newCanvasIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 265 0 297 32 ) 
					#model: #browseApplications 
					#tabable: false 
					#label: #finderIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 297 0 329 32 ) 
					#model: #openDataModelBrowser 
					#tabable: false 
					#label: #dbToolIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 345 0 377 32 ) 
					#model: #openHelpBrowser 
					#tabable: false 
					#label: #helpIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 64 0 96 32 ) 
					#model: #toolsNewWorkspace 
					#tabable: false 
					#label: #workspaceIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 32 0 2 1 0 1 ) 
					#name: #textViewID 
					#flags: 9 
					#component: #textView ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 393 0 425 32 ) 
					#name: #extFinderButton 
					#flags: 56 
					#model: #openExternalFinder 
					#tabable: false 
					#label: #extFinderIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 144 0 176 32 ) 
					#model: #openComponentEditor 
					#tabable: false 
					#label: #componentEditorIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 177 0 209 32 ) 
					#model: #openPaletteEditor 
					#tabable: false 
					#label: #paletteEditorIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 214 0 246 32 ) 
					#model: #toolsOpenPalette 
					#tabable: false 
					#label: #palettesIcon 
					#hasCharacterOrientedLabel: false ) ) ) )! !

!UIBVisualLauncher class methodsFor: 'class accessing'!

labelAndVisualRepository
	"Answer the object that holds the receiver's labels ans visuals."

	^UIBImage new! !

!UIBVisualLauncher class methodsFor: 'resource accessing'!

visualAt: key ifAbsent: aBlock 
	"Retrieve the indicated visual from the receiver's label and visual repository.
	If not found, try the super's default visuals registry."

	^self labelAndVisualRepository visualAt: key ifAbsent: [super visualAt: key ifAbsent: aBlock]! !

!UIBVisualLauncher class methodsFor: 'resources'!

menuBar
	"MenuEditor new openOnClass: self andSelector: #menuBar"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '&File' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: '&Save As...' 
							#value: #imageSaveAs ) 
						#(#MenuItem 
							#rawLabel: '&Perm Save As...' 
							#value: #filePermSaveAs ) 
						#(#MenuItem 
							#rawLabel: 'Perm &Undo As...' 
							#value: #filePermUndoAs ) 
						#(#MenuItem 
							#rawLabel: '&Collect Garbage' 
							#value: #collectGarbage ) 
						#(#MenuItem 
							#rawLabel: 'Collect All &Garbage' 
							#value: #collectAllGarbage ) 
						#(#MenuItem 
							#rawLabel: 'Se&ttings' 
							#value: #visualWorksSettings ) 
						#(#MenuItem 
							#rawLabel: 'E&xit VisualWorks...' 
							#value: #visualWorksExit ) ) #(3 2 1 1 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: '&Browse' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: '&All Classes' 
							#value: #browseAllClasses 
							#labelImage: #(#ResourceRetriever nil #allClassesIcon ) ) 
						#(#MenuItem 
							#rawLabel: 'Class &Named...' 
							#value: #browseClassNamed ) 
						#(#MenuItem 
							#rawLabel: '&Resources' 
							#value: #browseApplications 
							#labelImage: #(#ResourceRetriever nil #finderIcon ) ) 
						#(#MenuItem 
							#rawLabel: 'References &To...' 
							#value: #browseSendersOf ) 
						#(#MenuItem 
							#rawLabel: '&Implementors Of...' 
							#value: #browseImplementorsOf ) ) #(3 2 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: '&Tools' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: '&File List' 
							#value: #openFileList 
							#labelImage: #(#ResourceRetriever nil #fileListIcon ) ) 
						#(#MenuItem 
							#rawLabel: 'File &Editor...' 
							#value: #openFileEditor ) 
						#(#MenuItem 
							#rawLabel: '&Workspace' 
							#value: #toolsNewWorkspace 
							#labelImage: #(#ResourceRetriever nil #workspaceIcon ) ) 
						#(#MenuItem 
							#rawLabel: 'Parcel &List' 
							#value: #openParcelList ) 
						#(#MenuItem 
							#rawLabel: '&New Canvas' 
							#value: #toolsNewCanvas 
							#labelImage: #(#ResourceRetriever nil #newCanvasIcon ) ) 
						#(#MenuItem 
							#rawLabel: 'New Component' 
							#value: #openComponentEditor 
							#labelImage: #(#ResourceRetriever nil #componentEditorIcon ) ) 
						#(#MenuItem 
							#rawLabel: 'Palette Editor' 
							#value: #openPaletteEditor 
							#labelImage: #(#ResourceRetriever nil #paletteEditorIcon ) ) 
						#(#MenuItem 
							#rawLabel: '&Palette ...' 
							#value: #toolsPalette 
							#labelImage: #(#ResourceRetriever nil #palettesIcon ) ) 
						#(#MenuItem 
							#rawLabel: '&Canvas Tool' 
							#value: #toolsCanvasTool ) 
						#(#MenuItem 
							#rawLabel: '&Image Editor' 
							#value: #toolsMaskEditor ) 
						#(#MenuItem 
							#rawLabel: '&Menu Editor' 
							#value: #toolsMenuEditor ) 
						#(#MenuItem 
							#rawLabel: 'Coding Assistant' 
							#value: #toolsCodingAssistant ) 
						#(#MenuItem 
							#rawLabel: '&Advanced' 
							#nameKey: #advanced ) 
						#(#MenuItem 
							#rawLabel: '&DLL and C Connect' 
							#nameKey: #dllcc 
							#value: #openExternalFinder 
							#labelImage: #(#ResourceRetriever nil #extFinderIcon ) ) 
						#(#MenuItem 
							#rawLabel: 'ApplFLab Installer' 
							#value: #toolsApplFLabInstaller ) 
						#(#MenuItem 
							#rawLabel: 'System &Transcript' 
							#nameKey: #transcript 
							#value: #toggleSystemTranscript 
							#indication: true ) ) #(4 8 3 1 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: '&Changes' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 'Open Change &List' 
							#value: #changesOpenChangeList ) 
						#(#MenuItem 
							#rawLabel: '&File Out Changes...' 
							#value: #changesFileOutChanges ) 
						#(#MenuItem 
							#rawLabel: '&Empty Changes...' 
							#value: #changesEmptyChanges ) 
						#(#MenuItem 
							#rawLabel: 'Changed &Methods' 
							#value: #changesChangedMethods ) 
						#(#MenuItem 
							#rawLabel: 'Inspect &ChangeSet' 
							#value: #changesInspectChangeSet ) 
						#(#MenuItem 
							#rawLabel: 'Open &Project' 
							#value: #changesOpenProject ) 
						#(#MenuItem 
							#rawLabel: 'E&xit Project' 
							#value: #changesExitProject ) ) #(1 4 2 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: '&Database' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 'Ad Hoc &SQL' 
							#nameKey: #adHoc 
							#value: #openAdHocQuery ) 
						#(#MenuItem 
							#rawLabel: 'Data &Modeler' 
							#nameKey: #dataModeler 
							#value: #openDataModelBrowser 
							#labelImage: #(#ResourceRetriever nil #dbToolIcon ) ) 
						#(#MenuItem 
							#rawLabel: 'Canvas &Composer' 
							#nameKey: #canvasComposer 
							#value: #openCanvasComposer ) 
						#(#MenuItem 
							#rawLabel: 'New Data &Form...' 
							#nameKey: #dataForm 
							#value: #newDataForm ) 
						#(#MenuItem 
							#rawLabel: 'New Database &Application...' 
							#nameKey: #dataBaseAp 
							#value: #newDataMain ) ) #(1 4 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: '&Window' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 'Re&fresh All' 
							#value: #winRefreshAll ) 
						#(#MenuItem 
							#rawLabel: '&Collapse All' 
							#value: #winCollapseAll ) 
						#(#MenuItem 
							#rawLabel: 'Re&store All' 
							#value: #winRestoreAll ) 
						#(#MenuItem 
							#rawLabel: '&Windows' 
							#nameKey: #windowsMenu ) ) #(3 1 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: '&Help' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 'Open Online &Documentation' 
							#value: #openHelpBrowser 
							#labelImage: #(#ResourceRetriever nil #helpIcon ) ) 
						#(#MenuItem 
							#rawLabel: '&Quick Start Guides...' 
							#value: #openGuidingDialog ) 
						#(#MenuItem 
							#rawLabel: 'About &VisualWorks...' 
							#value: #helpAbout ) ) #(2 1 ) nil ) ) ) #(7 ) nil ) decodeAsLiteralArray! !

UIBComponent subclass: #UIBUserDefinedComponent
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components'!
UIBUserDefinedComponent comment:
'I am an abstract superclass of all user defined components that can be edited by the UIBComponentEditor.'!


!UIBUserDefinedComponent methodsFor: 'testing'!

isUserDefinedComponent
	"Answer a Boolean whether this component is user defined."

	^true! !

UIBUserDefinedComponent subclass: #UIBExtendedStandardComponent
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components'!


!UIBExtendedStandardComponent methodsFor: 'testing'!

isExtendedStandardComponent
	"Answer a Boolean whether this component is an extension of a standard VW component."

	^true! !

!UIBExtendedStandardComponent methodsFor: 'initialize-release'!

initializeForClass: aSpecClass

	| block |
	super initializeForClass: aSpecClass.
	block := PlacementMode placementExtentBlockFor: aSpecClass.
	self placementExtent: 
		((block notNil and: [block numArgs = 2])
			ifTrue:[PlacementMode placementExtentFor: aSpecClass withLabel: '' inBuilder: UIBBuilder new]
			ifFalse:[PlacementMode placementExtentFor: aSpecClass inBuilder: UIBBuilder new])! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBExtendedStandardComponent class
	instanceVariableNames: ''!


!UIBExtendedStandardComponent class methodsFor: 'editor accessing'!

preferredComponentEditorClass
	"Answer a ComponentEditor class of which instances are able to edit the receiver."

	^UIBExtendedStandardComponentEditor! !

!UIBExtendedStandardComponent class methodsFor: 'factory'!

preferredComponentGeneratorClass
	"Answer a ComponentGenerator class of which instances are able to generate code for the receiver."

	^UIBExtendedStandardComponentGenerator! !

UIBuilder subclass: #UIBBuilder
	instanceVariableNames: 'customComponent namedCustomComponents '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Builder/Definer'!
UIBBuilder comment:
'I extend my superclass with registration of user-defined components.

Instance variables:
	customComponent			<VisualComponent>		The current user-defined component being incorporated
	namedCustomComponents	<IdentityDictionary>	Names for user-defined components'!


!UIBBuilder methodsFor: 'initialize-release'!

initialize

	super initialize.
	namedCustomComponents := IdentityDictionary new! !

!UIBBuilder methodsFor: 'accessing'!

customComponent
	"Answer the value for the current custom component."

	^customComponent!

customComponent: aValue
	"Set the value for current custom component"

	customComponent := aValue!

customComponentAt: aKey
	"Retrieve the UIBApplicationModel of the indicated component."

	^namedCustomComponents at: aKey ifAbsent: [nil]!

customComponentAt: aKey put: aUIBApplicationModel
	"Associate aKey with aUIBApplicationModel."

	^namedCustomComponents at: aKey put: aUIBApplicationModel! !

!UIBBuilder methodsFor: 'source accessing'!

defaultSource
	"Answer the class that should be used when labels and visuals are requested at painting time."
	"It is probably a good idea to override this method when you override #builderClass in your subclass of UIBApplicationModel."

	^UIBApplicationModel! !

!UIBBuilder methodsFor: 'binding'!

labelAt: aKey
	"Find a binding for the label named aKey, either in the bindings 
	cache, or from the source."

	"Overridden here in order to use another default source (i.e when painting) instead of ApplicationModel."

	| b | 
	b := labels at: aKey ifAbsent: [nil].
	b == nil ifFalse: [^b].
	source == nil 
		ifTrue: [^self defaultSource labelAt: aKey ifAbsent: [nil]].
	b := self safelyPerform: #labelFor: key: aKey.
	b == nil ifTrue: [^nil].
	isEditing ifFalse: [labels at: aKey put: b].
	^b!

visualAt: aKey
	"Find a binding for the visual named aKey, either in the visuals 
	cache, or from the source."

	"Overridden here in order to use another default source (i.e when painting) instead of ApplicationModel."

	| b |
	b := visuals at: aKey ifAbsent: [nil].
	b == nil ifFalse: [^b].
	source == nil 
		ifTrue: [^self defaultSource visualAt: aKey ifAbsent: [nil]].
	b := self safelyPerform: #visualFor: key: aKey.
	b == nil ifTrue: [^nil].
	isEditing ifFalse: [visuals at: aKey put: b].
	^b! !

!UIBBuilder methodsFor: 'adding'!

add: aSpec inComposite: aComposite

	self
		newComposite: aComposite;
		"Koen: the following line cause a problem, since the added component's ID is added to the namedComponents collection of the builder, even when the component is not at the top level of the window. But: is this a problem? It only happens at painting time, when the names of the components are not used (yet)."
		add: aSpec;
		endComposite.! !

UIBApplicationModel subclass: #UIBClassInstaller
	instanceVariableNames: 'classCategory superClassName superPick className targetClassHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Misc'!


!UIBClassInstaller methodsFor: 'changes'!

superClassNameChanged

	| cl ctrlr |
	ctrlr := (self widget: #superClassNameField) controller.
	cl := UIBFinder superClassNamed: self superClassName value fromController: ctrlr.
	cl notNil ifTrue: [self superClassName value == cl name ifFalse: [self superClassName setValue: cl name]]!

superPickChanged

	self superPick value == #Other
		ifTrue: [self enableComponent: #superClassNameField]
		ifFalse: [self superClassName value: String new.
				self disableComponent: #superClassNameField]! !

!UIBClassInstaller methodsFor: 'private'!

categories

	^(Smalltalk organization categories collect: [:cat| cat asString]) asSortedCollection asList asValue!

classInTarget: targetArray

	^Smalltalk at: (targetArray at: 1) ifAbsent:[nil]!

defaultCategory

	^'UIB-Applications-New' copy!

superClassNames

	^("UIBCompositeComponentSpec" (Smalltalk at: self superPick value) allSubclasses collect: [:aClass| aClass name asString]) asSortedCollection asList asValue!

targetTrouble: targetArray

	^(self classInTarget: targetArray) isNil!

validateTarget

	| results |
	results := UIBFinder
				resultsForSpecClassName: (self className value isNil ifTrue: [String new] ifFalse: [self className value])
				andSuperclass:
					(self superPick value == #Other
						ifTrue: [(self superClassName value isNil ifTrue: [String new] ifFalse: [self superClassName value])]
						ifFalse: [self superPick value])
				andCategory: self classCategory value.
	(results includes: nil) not
		ifTrue: [^results]
		ifFalse: [(results at: 1) isNil
					ifTrue: [(self component: #classNameField) flash].
				(results at: 3) isNil
					ifTrue: [(self component: #classCategoryField) flash].
				(results at: 2) isNil
					ifTrue: [(self component: #superClassNameField) flash].
				^nil]! !

!UIBClassInstaller methodsFor: 'initialize-release'!

initialize

	super initialize.
	className := String new asValue.
	classCategory := self defaultCategory asValue.
	superClassName := String new asValue.
	superPick := #UIBCompositeComponentSpec asValue.
	targetClassHolder := nil asValue!

releaseDependencyRelationShips

	self superPick retractInterestsFor: self.
	self superClassName retractInterestsFor: self!

superPickHolder: superclassNameHolder

	superPick := superclassNameHolder!

targetClassNameHolder

	^targetClassHolder!

targetClassNameHolder: aClassNameHolder

	| targetClass |
	targetClassHolder := aClassNameHolder.
	self className value: targetClassHolder value.
	(targetClass := Smalltalk at: targetClassHolder value ifAbsent: [nil]) isNil
		ifFalse: [self superClassName value: targetClass superclass name.
				self classCategory value: targetClass category]

	"Don't bother with changes of the classNameHolder, it's only an output channel."! !

!UIBClassInstaller methodsFor: 'aspects'!

classCategory
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^classCategory!

className
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^className!

superClassName
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^superClassName!

superPick
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^superPick! !

!UIBClassInstaller methodsFor: 'actions'!

accept

	| target |
	(target := self validateTarget) isNil ifTrue: [^self].
	(self targetTrouble: target)
		ifTrue: [UIBFinder createNewClassUsing: target].
	self targetClassNameHolder value: (target at: 1)! !

!UIBClassInstaller methodsFor: 'interface opening'!

postBuildWith: aBuilder 

	super postBuildWith: aBuilder.
	self superPick onChangeSend: #superPickChanged to: self.
	self superClassName onChangeSend: #superClassNameChanged to: self.
	self superPickChanged! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBClassInstaller class
	instanceVariableNames: ''!


!UIBClassInstaller class methodsFor: 'interface specs'!

classCreationSpec
	"UIBPainter new openOnClass: self andSelector: #classCreationSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 137 65 475 298 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 10 11 ) 
					#label: 'Install on Specification Class' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 36 ) 
					#label: 'Name:' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 83 ) 
					#label: 'Category:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 10 0 58 0 -10 1 83 0 ) 
					#name: #classNameField 
					#model: #className ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 10 0 107 0 -10 1 133 0 ) 
					#name: #classCategoryField 
					#model: #classCategory 
					#isReadOnly: false 
					#comboList: #categories ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -30 0.5 -31 1 30 0.5 -7 1 ) 
					#model: #accept 
					#label: 'Install' 
					#isDefault: true ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 5 0 136 0 -5 1 250 0 ) 
					#label: 'Superclass' ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 161 0 223 0 183 0 ) 
					#model: #superPick 
					#label: 'UIBCompositeComponentSpec' 
					#select: #UIBCompositeComponentSpec ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 189 0 91 0 211 0 ) 
					#model: #superPick 
					#label: 'Other:' 
					#select: #Other ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 40 0 213 0 -15 1 239 0 ) 
					#name: #superClassNameField 
					#model: #superClassName 
					#isReadOnly: false 
					#comboList: #superClassNames ) ) ) )!

paletteDialogSpec
	"UIBPainter new openOnClass: self andSelector: #paletteDialogSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 9 114 347 347 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 10 12 ) 
					#label: 'Install on Palette Class' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 38 ) 
					#label: 'Name:' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 68 ) 
					#label: 'Category:' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 10 0 101 0 -10 1 191 0 ) 
					#label: 'Superclass' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 95 0 38 0 -10 1 63 0 ) 
					#name: #classNameField 
					#model: #className ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 126 0 112 0 148 0 ) 
					#model: #superPick 
					#label: 'UIBPalette' 
					#select: #UIBPalette ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 154 0 91 0 176 0 ) 
					#model: #superPick 
					#label: 'Other:' 
					#select: #Other ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 95 0 68 0 -10 1 93 0 ) 
					#name: #classCategoryField 
					#model: #classCategory 
					#isReadOnly: false 
					#comboList: #categories ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 0.5 -32 1 -10 0.5 -8 1 ) 
					#model: #accept 
					#label: 'Install' 
					#isDefault: true ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 97 0 153 0 -16 1 178 0 ) 
					#name: #superClassNameField 
					#model: #superClassName 
					#isReadOnly: false 
					#comboList: #superClassNames ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 10 0.5 -32 1 70 0.5 -8 1 ) 
					#model: #cancel 
					#label: 'Cancel' 
					#isDefault: false ) ) ) )!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 79 91 417 324 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 10 12 ) 
					#label: 'Install on Specification Class' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 38 ) 
					#label: 'Name:' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 68 ) 
					#label: 'Category:' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 10 0 101 0 -10 1 191 0 ) 
					#label: 'Superclass' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 95 0 38 0 -10 1 63 0 ) 
					#name: #classNameField 
					#model: #className ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 126 0 223 0 148 0 ) 
					#model: #superPick 
					#label: 'UIBCompositeComponentSpec' 
					#select: #UIBCompositeComponentSpec ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 20 0 154 0 91 0 176 0 ) 
					#model: #superPick 
					#label: 'Other:' 
					#select: #Other ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 95 0 68 0 -10 1 93 0 ) 
					#name: #classCategoryField 
					#model: #classCategory 
					#isReadOnly: false 
					#comboList: #categories ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -30 0.5 -32 1 30 0.5 -8 1 ) 
					#model: #accept 
					#label: 'Install' 
					#isDefault: true ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 97 0 153 0 -16 1 178 0 ) 
					#name: #superClassNameField 
					#model: #superClassName 
					#isReadOnly: false 
					#comboList: #superClassNames ) ) ) )! !

!UIBClassInstaller class methodsFor: 'interface opening'!

installPaletteClass: aClassName
	"Show a dialog to install a class with default name aClassName.
	Answer the actual class name or nil if the dialog was canceled."

	"self installPaletteClass: 'NewPalette'"

	| classnameHolder instance |
	^(((instance := self new) targetClassNameHolder: (classnameHolder := aClassName asString asValue); superPickHolder: #UIBPalette asValue)
		openDialogInterface: #paletteDialogSpec)
			ifTrue: [instance accept.
					classnameHolder value]
			ifFalse: [nil]! !

IntegratedSpecModel subclass: #UIBIntegratedSpecModel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Basics'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBIntegratedSpecModel class
	instanceVariableNames: ''!


!UIBIntegratedSpecModel class methodsFor: 'private-interface building'!

adapt: inst forAspect: aspect accessPath: aSequencableCollection channel: aChannel

	^aChannel == nil
		ifTrue: [(AspectAdaptor subject: inst) forAspect: aspect; accessPath: aSequencableCollection]
		ifFalse: [(AspectAdaptor subjectChannel: aChannel) forAspect: aspect; accessPath: aSequencableCollection]!

adapt: inst forAspect: aspect channel: aChannel

	^aChannel == nil
		ifTrue: [(AspectAdaptor subject: inst) forAspect: aspect]
		ifFalse: [(AspectAdaptor subjectChannel: aChannel) forAspect: aspect]! !

UIBIntegratedSpecModel subclass: #UIBModelEditorSlice
	instanceVariableNames: 'modelsInApplication modelName models modelClasses modelClassFilter aspectDictionaryHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBModelEditorSlice methodsFor: 'actions'!

addModel
	"This stub method was generated by UIBDefiner"

	modelsInApplication at: #new put: #ValueModel.
	self models selection: #new.
	self enableApply!

preapply

	super preapply.
	self aspectDictionaryHolder value: self modelsInApplication copy!

precancel
	"Do any canceling on the model level, and answer if this 
	is sufficient cancelation (otherwise model is recreated)."

	"Koen: let the system worry about this, not us:"

	^false!

removeModel
	"This stub method was generated by UIBDefiner"

	modelsInApplication removeKey: self models selection.
	self enableApply.! !

!UIBModelEditorSlice methodsFor: 'initialize-release'!

initialize

	| modelSelectionHolder currentFilter |
	super initialize.
	aspectDictionaryHolder := UIBAspectDictionary new asValue.
	modelsInApplication := aspectDictionaryHolder value.
	(models := SelectionInList new)
		listHolder: ((PluggableAdaptor on: modelsInApplication)
					getBlock: [:m| m keys asSortedCollection asList]
					putBlock: [:m :v|]
					updateBlock: [:m :a :p| a == #at:put: or:[a == #removeKey:]]).
	(modelSelectionHolder := models selectionHolder)
		compute: [:newSelection| self ableComponentsForSelection: newSelection notNil].
	modelName := ((PluggableAdaptor on: modelSelectionHolder)
					getBlock: [:m| m value isNil ifTrue:[nil] ifFalse:[m value]]
					putBlock: [:m :v| v == m value
									ifFalse: [modelsInApplication at: v put: (modelsInApplication removeKey: m value).
											models selection: v]]
					updateBlock: [:m : a :p | true]).
	modelClassFilter := ((PluggableAdaptor on: modelSelectionHolder)
						getBlock: [:m| |actualModel|
								(m value isNil or: [(modelsInApplication at: m value) == #ValueModel])
									ifTrue:[#ValueModel]
									ifFalse:[((actualModel := Smalltalk at: (modelsInApplication at: m value)) inheritsFrom: ValueModel)
											ifTrue:[#ValueModel]
											ifFalse:[((modelsInApplication at: m value) == #Model or:[actualModel inheritsFrom: Model])
														ifTrue:[#Model] ifFalse:[#Object]]]]
						putBlock: [:m :v| modelsInApplication at: modelSelectionHolder value put: v. self enableApply]
						updateBlock: [:m :a :p| true]).
	currentFilter := nil.
	(modelClasses := SelectionInList new)
		listHolder: ((PluggableAdaptor on: modelClassFilter)
					getBlock: [:m| ((Smalltalk at: m value) withAllSubclasses collect: [:cl| cl name]) asSortedCollection asList]
					putBlock: [:m :v| "putting is no functionality for this list" self halt]
					updateBlock: [:m :a :p| currentFilter ~= m value and:[currentFilter := m value. true]]);
		selectionIndexHolder: ((PluggableAdaptor on: modelSelectionHolder)
					getBlock: [:m|m value isNil
								ifTrue:[0]
								ifFalse:[modelClasses list indexOf: (modelsInApplication at: m value) ifAbsent:[0 "dit zou niet mogen!!"]]]
					putBlock: [:m :v| v == 0
								ifTrue:[]
								ifFalse:[modelsInApplication at: modelSelectionHolder value put: (modelClasses list at: v)].
								 self enableApply]
					updateBlock: [:m :a :p| true]).
	modelClassFilter onChangeSend: #makeSureModelClassIsInView to: self!

modelsInApplication: aUIBAspectDictionary

	self models listHolder model: (modelsInApplication := aUIBAspectDictionary)!

modelSpecs: aUIBAspectDictionaryHolder

	aspectDictionaryHolder := aUIBAspectDictionaryHolder.
	self modelsInApplication: aUIBAspectDictionaryHolder value copy! !

!UIBModelEditorSlice methodsFor: 'aspects'!

modelClasses
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^modelClasses!

modelClassFilter
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^modelClassFilter!

modelName
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^modelName!

models
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^models! !

!UIBModelEditorSlice methodsFor: 'private'!

ableComponentsForSelection: selectionBoolean

	self
		able: selectionBoolean
		components: #(#modelClasses #modelFilter #valueModelFilter #objectFilter #modelName #removeButton)!

aspectDictionaryHolder

	^aspectDictionaryHolder!

makeSureModelClassIsInView

	modelClasses selectionIndex = 0
		ifFalse:[(self builder componentAt: #modelClasses) widget
				makeVisible: self modelClasses selectionIndex "Koen: #makeVisible: is in fact a private method!!"]!

modelsInApplication

	^modelsInApplication!

reloadSelectionInformation

	self disableApply.
	self modelsInApplication: self aspectDictionaryHolder value copy! !

!UIBModelEditorSlice methodsFor: 'interface opening'!

postBuildWith: aBuilder

	self modelSpecs: (aBuilder aspectAt: #modelSpecs).
	self models selectionIndex: (self models list isEmpty ifTrue:[0] ifFalse:[1]).
	self ableComponentsForSelection: self models selectionIndex ~= 0.
	"self makeSureModelClassIsInView. Koen: this has no effect when executed in this method."
	self modelName
		compute: [:newName| |c|
				c := (self builder componentAt: #modelName) widget controller.
				newName isNil ifFalse:[(self builder componentAt: #modelName) takeKeyboardFocus.
				c selectFrom: 1 to: c text size]]!

preBuildWith: aBuilder

	self modelSpecs: (aBuilder aspectAt: #modelSpecs)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBModelEditorSlice class
	instanceVariableNames: ''!


!UIBModelEditorSlice class methodsFor: 'interface specs'!

propSpec
	"UIBPainter new openOnClass: self andSelector: #propSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Model Editor-#windowSpec' 
			#bounds: #(#Rectangle 178 114 399 311 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -5 0.333333 ) 
					#name: #models 
					#model: #models ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutOrigin 5 0 33 0.333333 ) 
					#name: #modelFilter 
					#model: #modelClassFilter 
					#label: 'Model' 
					#select: #Model ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutOrigin 70 0 33 0.333333 ) 
					#name: #valueModelFilter 
					#model: #modelClassFilter 
					#label: 'ValueModel' 
					#select: #ValueModel ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutOrigin 170 0 33 0.333333 ) 
					#name: #objectFilter 
					#model: #modelClassFilter 
					#label: 'All' 
					#select: #Object ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 55 0.333333 0 1 0 1 ) 
					#name: #modelClasses 
					#model: #modelClasses ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 0 0.333333 -50 1 22 0.333333 ) 
					#name: #modelName 
					#model: #modelName 
					#type: #symbol ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -47 1 0 0.333333 -25 1 22 0.333333 ) 
					#name: #addModel 
					#model: #addModel 
					#label: '+' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 1 0 0.333333 0 1 22 0.333333 ) 
					#name: #removeButton 
					#model: #removeModel 
					#label: '-' 
					#defaultable: true ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0 28 0.333333 0 1 30 0.333333 ) ) ) ) )!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Model Editor-#windowSpec' 
			#bounds: #(#Rectangle 178 114 399 311 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -5 0.333333 ) 
					#name: #models 
					#model: #models ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutOrigin 5 0 33 0.333333 ) 
					#name: #modelFilter 
					#model: #modelClassFilter 
					#label: 'Model' 
					#select: #Model ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutOrigin 70 0 33 0.333333 ) 
					#name: #valueModelFilter 
					#model: #modelClassFilter 
					#label: 'ValueModel' 
					#select: #ValueModel ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutOrigin 170 0 33 0.333333 ) 
					#name: #objectFilter 
					#model: #modelClassFilter 
					#label: 'All' 
					#select: #Object ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 55 0.333333 0 1 0 1 ) 
					#name: #modelClasses 
					#model: #modelClasses ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 0 0.333333 -50 1 22 0.333333 ) 
					#name: #modelName 
					#model: #modelName 
					#type: #symbol ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -47 1 0 0.333333 -25 1 22 0.333333 ) 
					#name: #addModel 
					#model: #addModel 
					#label: '+' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 1 0 0.333333 0 1 22 0.333333 ) 
					#name: #removeButton 
					#model: #removeModel 
					#label: '-' 
					#defaultable: true ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0 28 0.333333 0 1 30 0.333333 ) ) ) ) )! !

!UIBModelEditorSlice class methodsFor: 'examples'!

example1
	"self example1"

	^self openOn: (self new modelsInApplication: (UIBAspectDictionary new at: #test put: #ValueHolder; at: #model put: #ValueHolder; at: #valueModel put: #ValueHolder; yourself))! !

!UIBModelEditorSlice class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).
	env at: #modelSpecs put: (self adapt: inst forAspect: #models channel: aChannel).! !

UIBIntegratedSpecModel subclass: #UIBPropertyFieldSlice
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBPropertyFieldSlice methodsFor: 'changes'!

generationModeChanged

	| customSelected |
	customSelected := (self builder aspectAt: #generationMode) value == #custom.
	self able: customSelected components: #(#generatedCodeField).
	customSelected ifFalse:[(self builder aspectAt: #generatedCode)
							value: specChannel value property defaultInitializationString]!

propertyTypeChanged

	(Smalltalk at: (self builder aspectAt: #propertyType) value) new onlyDefaultCodeGeneration
		ifTrue:[(self builder aspectAt: #generationMode) value: #default.
				self able: false components: #(#customRadioButton #defaultRadioButton)]
		ifFalse:[self able: true components: #(#customRadioButton #defaultRadioButton)].
	self generationModeChanged.! !

!UIBPropertyFieldSlice methodsFor: 'interface opening'!

postBuildWith: aBuilder 

	(self builder aspectAt: #propertyType) onChangeSend: #propertyTypeChanged to: self.
	(self builder aspectAt: #generationMode) onChangeSend: #generationModeChanged to: self.
	self propertyTypeChanged! !

!UIBPropertyFieldSlice methodsFor: 'actions'!

precancel
	"Do any canceling on the model level, and answer if this 
	is sufficient cancelation (otherwise model is recreated)."

	"Koen: let the system worry about this, not us:"

	^false! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertyFieldSlice class
	instanceVariableNames: ''!


!UIBPropertyFieldSlice class methodsFor: 'interface specs'!

propSpec
	"UIBPainter new openOnClass: self andSelector: #propSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Property Field' 
			#bounds: #(#Rectangle 350 266 614 577 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 4 0 0.5 0 ) 
					#label: 'Property Field' ) 
				#(#LabelSpec 
					#layout: #(#Point 5 30 ) 
					#name: #propertyLabel 
					#label: 'Property:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 70 0 30 0 -5 1 50 0 ) 
					#name: #propertyNameField 
					#model: #propertyName 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#Point 5 93 ) 
					#name: #typeLabel 
					#label: 'Type:' ) 
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 70 0 91 0 -5 1 114 0 ) 
					#name: #typeMenu 
					#model: #propertyType 
					#menu: #typeMenu ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 5 128 ) 
					#name: #nilAllowed 
					#model: #nilAllowed 
					#label: 'Nil allowed' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 70 0 56 0 -5 1 76 0 ) 
					#model: #name 
					#type: #string ) 
				#(#LabelSpec 
					#layout: #(#Point 5 56 ) 
					#label: 'ID:' ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#LabelSpec 
							#layout: #(#Point 0 1 ) 
							#label: 'Initialize' ) 
						#(#RadioButtonSpec 
							#layout: #(#Point 63 0 ) 
							#name: #before 
							#model: #initBeforeBuilding 
							#label: 'before' 
							#select: #before ) 
						#(#RadioButtonSpec 
							#layout: #(#Point 123 0 ) 
							#name: #after 
							#model: #initBeforeBuilding 
							#label: 'after building' 
							#select: #after ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 5 153 222 173 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#GroupBoxSpec 
							#layout: #(#LayoutFrame 0 0.0 0 0.0 0 1.0 0 1.0 ) 
							#name: #codeGenerationBox 
							#label: 'Code Generation' ) 
						#(#RadioButtonSpec 
							#layout: #(#AlignmentOrigin 0 0.240157 20 0 0.25 0 ) 
							#name: #customRadioButton 
							#model: #generationMode 
							#label: 'Custom' 
							#select: #custom ) 
						#(#RadioButtonSpec 
							#layout: #(#AlignmentOrigin 0 0.763779 20 0 0.75 0 ) 
							#name: #defaultRadioButton 
							#model: #generationMode 
							#label: 'Default' 
							#select: #default ) 
						#(#TextEditorSpec 
							#layout: #(#LayoutFrame 5 0 40 0 0 0.980315 0 0.974138 ) 
							#name: #generatedCodeField 
							#model: #generatedCode 
							#style: #system ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 5 185 259 301 ) ) ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 147 128 ) 
					#name: #runtimeStyle 
					#model: #runtimeStyle 
					#label: 'Combo Box Style' ) ) ) )! !

!UIBPropertyFieldSlice class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	UIBPropertyFieldSpec addBindingsTo: env for: inst channel: aChannel! !

UIBApplicationModel subclass: #UIBLookAndFeelListEditor
	instanceVariableNames: 'lookAndFeelEditor specSelector specHolderClass default '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources-UI'!


!UIBLookAndFeelListEditor methodsFor: 'accessing'!

lookAndFeelEditor
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^lookAndFeelEditor isNil
		ifTrue:
			[lookAndFeelEditor := UIBLookAndFeelEditor new]
		ifFalse:
			[lookAndFeelEditor]! !

!UIBLookAndFeelListEditor methodsFor: 'actions'!

add
	"This stub method was generated by UIBDefiner"

	self builder addSpec: (SubCanvasSpec new majorKey: #UIBLookAndFeelEditor; minorKey: #windowSpec)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBLookAndFeelListEditor class
	instanceVariableNames: ''!


!UIBLookAndFeelListEditor class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'LookAndFeelListEditor' 
			#bounds: #(#Rectangle 364 184 684 388 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 25 0 ) 
					#majorKey: #UIBLookAndFeelEditor 
					#minorKey: #windowSpec 
					#clientKey: #lookAndFeelEditor ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 24 167 72 187 ) 
					#name: #addButton 
					#model: #add 
					#label: 'Add' 
					#defaultable: true ) ) ) )! !

SimpleDialog subclass: #UIBTextListPrompter
	instanceVariableNames: 'choices choice '
	classVariableNames: 'Protocols '
	poolDictionaries: ''
	category: 'UIB-Development Extras'!


!UIBTextListPrompter methodsFor: 'initialize-release'!

initialize

	super initialize.
	choice := String new asValue.
	choices := List new asValue! !

!UIBTextListPrompter methodsFor: 'aspects'!

choice

	^choice!

choices

	^choices! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBTextListPrompter class
	instanceVariableNames: ''!


!UIBTextListPrompter class methodsFor: 'interface specs'!

protocolSpec
	"UIPainter new openOnClass: self andSelector: #protocolSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#bounds: #(#Rectangle 199 94 434 229 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 10 0 50 0 -10 1 70 0 ) 
					#name: #choices 
					#model: #choice 
					#isReadOnly: false 
					#comboList: #choices ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -90 1 -30 1 -40 1 -10 1 ) 
					#name: #cancel 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 40 0 -30 1 90 0 -10 1 ) 
					#name: #ok 
					#model: #accept 
					#label: 'OK' 
					#isDefault: true 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#LayoutFrame 10 0 10 0 -10 1 30 0 ) 
					#name: #prompt 
					#label: #prompt ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 80 ) 
					#name: #filter 
					#model: #filter 
					#label: 'Only show frequently used protocols' ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Enter/select string' 
			#bounds: #(#Rectangle 154 122 390 234 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 10 0 50 0 -10 1 70 0 ) 
					#name: #choices 
					#model: #choice 
					#isReadOnly: false 
					#comboList: #choices ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -90 1 -30 1 -40 1 -10 1 ) 
					#name: #cancel 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 40 0 -30 1 90 0 -10 1 ) 
					#name: #ok 
					#model: #accept 
					#label: 'OK' 
					#isDefault: true 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#LayoutFrame 10 0 10 0 -10 1 30 0 ) 
					#name: #prompt 
					#label: #prompt ) ) ) )! !

!UIBTextListPrompter class methodsFor: 'private'!

allProtocols
	"self allProtocols"

	Protocols isNil
		ifTrue: [Protocols :=
				(Smalltalk classNames
					inject: (Set new: 2000)
					into: [:theSet :aClassName|
							theSet addAll: (Smalltalk at: aClassName) organization categories; yourself])
				asSortedCollection].
	^Protocols!

frequentlyUsedProtocolsForClass
	"self frequentlyUsedProtocolsForClass"

	^(OrderedCollection new: 20)
		add: #accessing;
		add: #aspects;
		add: #changing;
		add: #comparing;
		add: #copying;
		add: #'initialize-release';
		add: #printing;
		add: #private;
		add: #testing;
		asSortedCollection!

frequentlyUsedProtocolsForClass: aClass
	"self frequentlyUsedProtocolsForClass: Collection"

	^(aClass isKindOf: Class)
		ifTrue: [self frequentlyUsedProtocolsForClass]
		ifFalse: [self frequentlyUsedProtocolsForMetaClass]!

frequentlyUsedProtocolsForMetaClass
	"self frequentlyUsedProtocolsForMetaClass"

	^(OrderedCollection new: 20)
		add: #accessing;
		add: #'class accessing';
		add: #'class initialization';
		add: #'examples';
		add: #'instance creation';
		add: #'interface opening';
		add: #'interface specs';
		add: #labels;
		add: #private;
		add: #'resource accessing';
		asSortedCollection! !

!UIBTextListPrompter class methodsFor: 'class initialization'!

initialize

	self allProtocols! !

!UIBTextListPrompter class methodsFor: 'interface opening'!

promptForProtocol: prompt for: aClass initially: protocolSymbol

	"self promptForProtocol: 'Enter/select a new protocol name' for: Collection initially: 'testing'"

	| dialog |
	dialog := self new.
	dialog choice value: protocolSymbol.
	(dialog builder aspectAt: #filter put: true asValue)
		compute: [:filtered|
					dialog choices
					value: (filtered
							ifTrue: [self frequentlyUsedProtocols]
							ifFalse: [self allProtocols])].
	dialog choices value: (self frequentlyUsedProtocolsForClass: aClass).
	dialog builder labelAt: #prompt put: prompt.
	self openOn: dialog withSpec: #protocolSpec. 
	^dialog accept value
		ifTrue: [dialog choice value]
		ifFalse: [String new]! !

!UIBTextListPrompter class methodsFor: 'labels'!

prompt

	^'Enter/select a new string'! !

UIBPalette subclass: #UIBSpecialPalette
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBSpecialPalette class
	instanceVariableNames: ''!


!UIBSpecialPalette class methodsFor: 'accessing-specs'!

activeSpecsList

	^#(#UIBAspectEditorSpec #UIBModelEditorSpec)! !

!UIBSpecialPalette class methodsFor: 'accessing'!

numberOfColumns

	^3!

paletteName

	^'Special'! !

UIBUserDefinedComponent subclass: #UIBCompositeComponent
	instanceVariableNames: 'lookAndFeels defaultLookAndFeel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components'!


!UIBCompositeComponent methodsFor: 'initialize-release'!

initialize

	self
		lookAndFeels: (List new add: (UIBComponentLookAndFeel new
									specHolderClass: #UntitledClass;
									specSelector: UIBCompositeComponentSpec defaultMinorKey);
						yourself);
		defaultLookAndFeel: (self lookAndFeels at: 1) "resourceLocation".
	super initialize!

initializeForClass: aSpecClass

	| lookAndFeel |
	super initializeForClass: aSpecClass.
	lookAndFeel := UIBComponentLookAndFeel new.
	(aSpecClass respondsTo: #defaultMajorKey)
		ifTrue:[lookAndFeel specHolderClass: aSpecClass defaultMajorKey].
	(aSpecClass respondsTo: #defaultMinorKey)
		ifTrue:[lookAndFeel specSelector: aSpecClass defaultMinorKey].
	(aSpecClass respondsTo: #placementExtent)
		ifTrue:[self placementExtent: aSpecClass placementExtent].
	(aSpecClass respondsTo: #lookAndFeels)
		ifTrue:[self lookAndFeels: (aSpecClass lookAndFeels collect:[:x| x decodeAsLiteralArray]) asList.
				lookAndFeel := self lookAndFeels detect:[:look| look sameLocationAs: lookAndFeel]
								ifNone:[self error: 'There is an inconsistency in this specification class.']]
		ifFalse:[self lookAndFeels: (List with: lookAndFeel)].
	self defaultLookAndFeel: lookAndFeel.
	(aSpecClass respondsTo: #placementExtent)
		ifTrue:[self placementExtent: aSpecClass placementExtent].! !

!UIBCompositeComponent methodsFor: 'testing'!

isCompositeComponent
	"Answer a Boolean whether this component is a composite component."

	^true! !

!UIBCompositeComponent methodsFor: 'accessing'!

componentName: aValue

	super componentName: aValue.
	self lookAndFeels do:[:look| look windowLabel: componentName]!

defaultLookAndFeel

	^defaultLookAndFeel!

defaultLookAndFeel: aUIBResourceLocation

	defaultLookAndFeel := aUIBResourceLocation!

lookAndFeels

	^lookAndFeels!

lookAndFeels: lookAndFeelsList
	"lookAndFeelsList <List>"

	lookAndFeels := lookAndFeelsList! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBCompositeComponent class
	instanceVariableNames: ''!


!UIBCompositeComponent class methodsFor: 'defaults'!

defaultWindowSpec
	"UIPainter new openOnClass: self andSelector: #defaultWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec
			#label: 'Unlabeled Component' 
			#bounds: #(#Rectangle 148 314 413 638 )) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )! !

!UIBCompositeComponent class methodsFor: 'factory'!

preferredComponentEditorClass
	"Answer a ComponentEditor class of which instances are able to edit the receiver."

	^UIBCompositeComponentEditor!

preferredComponentGeneratorClass
	"Answer a ComponentGenerator class of which instances are able to generate code for the receiver."

	^UIBCompositeComponentGenerator! !

UIBPalette subclass: #UIBConfiguredWidgetsPalette
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Preconfigured'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBConfiguredWidgetsPalette class
	instanceVariableNames: ''!


!UIBConfiguredWidgetsPalette class methodsFor: 'accessing-specs'!

activeSpecsList

	^#(#('Cancel Button' #UIBConfiguredWidgetsPalette #cancelButtonSpec) #('OK Button' #UIBConfiguredWidgetsPalette #oKButtonSpec))!

cancelButtonSpec

	^#(#ActionButtonSpec 
		#layout: #(#Rectangle 163 85 233 107 ) 
		#name: #cancelButton 
		#model: #doCancel 
		#label: #cancelButtonLabel 
		#hasCharacterOrientedLabel: false 
		#defaultable: true )!

oKButtonSpec

	^#(#ActionButtonSpec 
		#layout: #(#Rectangle 93 29 155 51 ) 
		#name: #okButton 
		#model: #doAccept 
		#label: #okButtonLabel 
		#hasCharacterOrientedLabel: false 
		#defaultable: true )! !

!UIBConfiguredWidgetsPalette class methodsFor: 'accessing'!

numberOfColumns

	^5!

paletteName

	^'Configured Widgets'! !

!UIBConfiguredWidgetsPalette class methodsFor: 'resources'!

cancelButtonPaletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #cancelButtonPaletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: ColorValue white; at: 3 put: ColorValue gray; at: 4 put: (ColorValue scaledRed: 6143 scaledGreen: 6143 scaledBlue: 6143); at: 5 put: (ColorValue scaledRed: 7085 scaledGreen: 280 scaledBlue: 212); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@DQDQDQDQDQDQDQDR@@@@@AL3L3L3L3L3L3L3L @@@@@SL3L3L3L3L3L3L3H@@@@@D1DQDQDQDQDQDQD2@@@@@ALSL3L3L3L3L3L0L @@@@@SD3QCL3L3L4P3LCH@@@@@D1L4QDL3L3QCL3@2@@@@@ALSL4QDL3MDL3L0L @@@@@SD3L3QDL4L3L3LCH@@@@@D1L3L3QDQCL3L3@2@@@@@ALSL3L3QDL3L3L0L @@@@@SD3L3MDQDL3L3LCH@@@@@D1L3L4QCMDL3L3@2@@@@@ALSL3QDL3MDL3L0L @@@@@SD3MDP3L3MCL3LCH@@@@@D1L3QDL3L3MCL3@2@@@@@ALSL3P3L3L3L3L0L @@@@@SD3L3L3L3L3P3LCH@@@@@D1L3L3L3L3L3L3@2@@@@@ALSL3L3L3L3L3L0L @@@@@S@@@@@@@@@@@@@CH@@@@@D3L3L3L3L3L3L3L2@@@@@AL3L3L3L3L3L3L3L @@@@@"H"H"H"H"H"H"H"H@@@@@@@@@@@@@@@@@@@@@@@@@@b'))!

oKButtonPaletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #oKButtonPaletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 6) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 6143 scaledGreen: 6143 scaledBlue: 6143); at: 3 put: (ColorValue scaledRed: 996 scaledGreen: 5874 scaledBlue: 646); at: 4 put: ColorValue white; at: 5 put: (ColorValue scaledRed: 0 scaledGreen: 3222 scaledBlue: 566); at: 6 put: ColorValue gray; yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L5@@@@@CDQDQDQDQDQDQDQEP@@@@@1DQDQDQDQDQDQDQT@@@@@LSL3L3L3L3L3L3LU@@@@@CD1DQDQDQDQDQDPEP@@@@@1LQDQDQDQDQDQDAT@@@@@LSDQDQDQDQDQEA@U@@@@@CD1DQDQDQDQD$DPEP@@@@@1LQDQDQDQDRPQDAT@@@@@LSDQDQDQDQIADQ@U@@@@@CD1DQDQDQD$DQDPEP@@@@@1LQD"DQDRPQDQDAT@@@@@LSDTH"DQD"DQDQ@U@@@@@CD1DTH"DRPQDQDPEP@@@@@1LQDTH"IADQDQDAT@@@@@LSDQDTH$DQDQDQ@U@@@@@CD1DQDTH!!DQDQDPEP@@@@@1LQDQDTDQDQDQDAT@@@@@LSDQDQDQDQDQDQ@U@@@@@CD1DQDQDQDQDQDPEP@@@@@1@@@@@@@@@@@@@AT@@@@@LQDQDQDQDQDQDQDU@@@@@CDQDQDQDQDQDQDQEP@@@@AUUUUUUUUUUUUUUUT@@@@@@@@@@@@@@@@@@@@@@@@@@b'))! !

UIBCompositeSpec subclass: #UIBComposingCompositeSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Composites'!
UIBComposingCompositeSpec comment:
'I am the abstract superclass of all specification classes related with UIBComposingComposites.

I do not introduce any behavior at this time, but that will probably change in the future.'!


UIBComposingCompositeSpec subclass: #UIBToolBarCompositeSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Composites'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBToolBarCompositeSpec class
	instanceVariableNames: ''!


!UIBToolBarCompositeSpec class methodsFor: 'private-interface building'!

componentName
	"Identification of component"

	^'Tool bar'! !

!UIBToolBarCompositeSpec class methodsFor: 'class accessing'!

preferredCompositeClass

	^UIBToolBarComposite! !

UIBProperty subclass: #UIBActionProperty
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Properties'!


!UIBActionProperty methodsFor: 'accessing'!

defaultGeneratedCode

	^'nil'!

defaultModelFromCustomCode: aString

	^aString isEmpty
		ifFalse:[self customDefaultModelFrom: aString]
		ifTrue:[super defaultModelFromCustomCode: aString]!

inBuilder: builder withCustomCode: aString

	^self inBuilder: builder withSelector: #actionAt: withCustomCode: aString! !

!UIBActionProperty methodsFor: 'private'!

customDefaultModelFrom: aString

	^(self name notNil and:[self name isKeyword])
		ifTrue:[[:args| super customDefaultModelFrom: aString]]
		ifFalse:[[super customDefaultModelFrom: aString]]!

defaultModel

	^(self name notNil and:[self name isKeyword])
		ifTrue:[[:args| "do nothing"]]
		ifFalse:[["do nothing"]]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBActionProperty class
	instanceVariableNames: ''!


!UIBActionProperty class methodsFor: 'accessing'!

propertyName

	^'Action'! !

UIBEncodableModel subclass: #UIBAdaptorSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBAdaptorSpec methodsFor: 'init string generation'!

initializationStringFor: anAspectValue on: aStream

	^self subclassResponsibility!

initializeStringFor: anObject
	"Code copied from UIDefiner>initializeStringFor: and edited (added size checks)."
	
	((anObject isKindOf: String) and:[anObject size = 0])
		ifTrue: [^'String new'].
	(anObject class == Text  and:[anObject size = 0])
		ifTrue: [^'Text new'].
	(anObject class == List and:[anObject size = 0])
		ifTrue: [^'List new'].
	^anObject storeString! !

!UIBAdaptorSpec methodsFor: 'converting'!

literalArrayEncodingOn: aStream
	"Put a literal encoding suitable for reconstituting the receiver on aStream.
	Use #nextPut: to store each value of the encoding.
	The class name is already on the stream."

	(self class allInstVarNames asSet remove: 'dependents'; yourself)
		do: [:iv |
			aStream nextPut: (iv , ':') asSymbol;
				nextPut: (self perform: iv asSymbol) literalArrayEncoding]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBAdaptorSpec class
	instanceVariableNames: ''!


!UIBAdaptorSpec class methodsFor: 'class accessing'!

adaptorClass

	^self subclassResponsibility!

editorClass

	^self subclassResponsibility! !

UIBAdaptorSpec subclass: #UIBValueHolderSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBValueHolderSpec methodsFor: 'init string generation'!

initializationStringFor: anAspectValue on: aStream

	"|s| s := String new writeStream.
	self new initializationStringFor: String new asValue on: s.
	s contents"

	aStream
		nextPutAll: (self initializeStringFor: anAspectValue value);
		nextPutAll: ' asValue'! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBValueHolderSpec class
	instanceVariableNames: ''!


!UIBValueHolderSpec class methodsFor: 'class accessing'!

adaptorClass

	^ValueHolder!

editorClass

	^UIBValueHolderEditor! !

UIBAdaptorSpec subclass: #UIBAspectAdaptorSpec
	instanceVariableNames: 'aspect subjectSelector subjectAccessor subjectSendsUpdates '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBAspectAdaptorSpec methodsFor: 'initialize-release'!

initialize

	super initialize.
	self subjectSelector: #subject.
	self subjectAccessor: #model.
	self subjectSendsUpdates: true! !

!UIBAspectAdaptorSpec methodsFor: 'accessing'!

aspect

	^aspect!

aspect: aValue

	aspect := aValue.
	self changed: #aspect!

subjectAccessor

	^subjectAccessor!

subjectAccessor: aValue

	subjectAccessor := aValue.
	self changed: #subjectAccessor!

subjectSelector

	^subjectSelector!

subjectSelector: aValue

	subjectSelector := aValue.
	self changed: #subjectSelector!

subjectSendsUpdates

	^subjectSendsUpdates!

subjectSendsUpdates: aValue

	subjectSendsUpdates := aValue.
	self changed: #subjectSendsUpdates! !

!UIBAspectAdaptorSpec methodsFor: 'init string generation'!

initializationStringFor: anAspectValue on: aStream
	"Koen: this method does not yet take the anAspectValue argument into account.
	When default values can be specified in the Painter, the following should be added:
		nextPut: $;;
		nextPutAll: ' value: ';
		nextPutAll: (self initializeStringFor: anAspectValue value)
	by removing the last comment in this method."

	"|s| s := String new writeStream.
	self new initializationStringFor: String new asValue on: s.
	s contents"

	aStream
		nextPut: $(;
		nextPutAll: 'AspectAdaptor forAspect: ';
		print: self aspect;
		nextPut: $); space;
		nextPutAll: (self subjectSelector , ':') asSymbol;
		nextPutAll: ' self ';
		nextPutAll: self subjectAccessor;
		nextPut: $;;
		nextPutAll: ' subjectSendsUpdates: ';
		print: self subjectSendsUpdates";
		nextPut: $;;
		nextPutAll: ' value: ';
		nextPutAll: (self initializeStringFor: anAspectValue value)"! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBAspectAdaptorSpec class
	instanceVariableNames: ''!


!UIBAspectAdaptorSpec class methodsFor: 'class accessing'!

adaptorClass

	^AspectAdaptor!

editorClass

	^UIBAspectAdaptorEditor! !

UIBResourceLocation subclass: #UIBCanvas
	instanceVariableNames: 'fullSpec inconsistent hasChanged '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources'!
UIBCanvas comment:
'I am an abstract superclass of the classes that represent a canvas. Instances of my subclasses act as model for UIBPluggablePainters.
My main functionality is the loading and installing of canvas specifications.

Subclasses have to override the #fetchFullSpec method in the ''private'' protocol.

Instance variables:
	fullSpec		<FullSpec>	The canvas'' specification.
	inconsistent	<Boolean>		True when fullSpec is inconsistent with the state of the instance variables defined in the superclass.
	hasChanged 	<Boolean>		True if fullSpec has changed since the last load/installation.'!


!UIBCanvas methodsFor: 'accessing'!

fullSpec

	| oldFullSpec |
	oldFullSpec := fullSpec.
	self makeConsistent.
	oldFullSpec isNil "Is it the first time that fullSpec is accessed ?"
		ifTrue:[self specHasChanged: false].
	^fullSpec!

fullSpec: aFullSpec

	fullSpec := aFullSpec.
	inconsistent := false.
	self specHasChanged: true!

windowLabel: aStringOrNIl

	self fullSpec window
		label: ((aStringOrNIl isNil or:[aStringOrNIl isEmpty])
				ifTrue:[''] ifFalse: [aStringOrNIl, '-'])
				, self windowLabelSuffix.
	self specHasChanged: true! !

!UIBCanvas methodsFor: 'testing'!

hasChanged

	^hasChanged!

isInconsistent
	"Answer a Boolean indicating whether the specSelector or the specHolderClass changed after the last update of fullSpec."

	^inconsistent!

specHasChanged

	^hasChanged!

targetTrouble

	^self specHolderClass isNil or:[(Smalltalk includesKey: self specHolderClass) not]! !

!UIBCanvas methodsFor: 'private'!

fetchFullSpec
	"Answer a FullSpec according to the state of the specHolder and specSelector IVs.
	Answer a valid FullSpec, even when these IVs contain a non-existant class and/or selector."

	^self subclassResponsibility!

isInconsistent: aBoolean

	inconsistent := aBoolean!

makeConsistent

	self isInconsistent ifTrue:[self updateFullSpec]!

setSpecHolderClass: aSymbol

	aSymbol = specHolderClass ifTrue:[^self].
	specHolderClass := aSymbol.
	inconsistent := true.
	self specHasChanged: true!

setSpecSelector: aSymbol

	aSymbol = specSelector ifTrue:[^self].
	specSelector := aSymbol.
	inconsistent := true.
	self specHasChanged: true!

specHasChanged: aBoolean

	hasChanged := aBoolean!

windowLabelSuffix

	^self specSelector printString! !

!UIBCanvas methodsFor: 'installation/loading'!

installInSystem

	| targetClass |
	self specHasChanged
		ifTrue:[	targetClass := Smalltalk at: self specHolderClass.
				UIBPainter
					store: self fullSpec
					toClass: targetClass class
					methodName: self specSelector.
				Transcript cr; show: targetClass class name, '>', self specSelector, ' defined'.
				UIBFinder installed: (Array with: targetClass name with: self specSelector).
				self specHasChanged: false]!

loadFromSystem

	self updateFullSpec! !

!UIBCanvas methodsFor: 'updating'!

updateFullSpec
	"Store a FullSpec according to the receiver's state."

	self fullSpec: self fetchFullSpec! !

!UIBCanvas methodsFor: 'initialize-release'!

initialize

	super initialize.
	self isInconsistent: true.
	self specHasChanged: false! !

UIBCanvas subclass: #UIBComponentLookAndFeel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources'!
UIBComponentLookAndFeel comment:
'I represent the canvas of an application or a user-defined component. I act as model for UIBPluggablePainters.

My main extension with respect to my superclass is the ability to convert me to literal arrays, so that I can be stored in component specifications.

Instance variables:
	none'!


!UIBComponentLookAndFeel methodsFor: 'initialize-release'!

fromLiteralArrayEncoding: anArray

	2 to: anArray size by: 2 do: [:i | self perform: (anArray at: i) with: (anArray at: i + 1)].
	self isInconsistent: true.! !

!UIBComponentLookAndFeel methodsFor: 'converting'!

literalArrayEncoding
	"Return a literal suitable for reconstituting the receiver."

	"UIBComponentLookAndFeel new literalArrayEncoding"

	| encoding |
	encoding := Array new: 5.
	encoding
		at: 1 put: self class name;
		at: 2 put: #specHolderClass:;
		at: 3 put: self specHolderClass;
		at: 4 put: #specSelector:;
		at: 5 put: self specSelector.
	^encoding! !

!UIBComponentLookAndFeel methodsFor: 'printing'!

displayString

	|aStream|
	aStream := WriteStream on: String new.
	self exists
		ifTrue:[aStream
				"nextPutAll: self specHolderClass;"
				nextPutAll: self specSelector printString]
		ifFalse:[aStream nextPutAll: 'New/Uninstalled'].
	^aStream contents!

fullDisplayString

	|aStream|
	aStream := WriteStream on: String new.
	self exists
		ifTrue:[aStream
				nextPutAll: self specHolderClass;
				space;
				nextPutAll: self specSelector printString]
		ifFalse:[aStream nextPutAll: 'New/Uninstalled'].
	^aStream contents!

printOn: aStream 

	"UIBComponentLookAndFeel new printString"

	aStream
		store: self class; crtab;
		store: self specHolderClass; nextPutAll: ', '; store: self specSelector! !

!UIBComponentLookAndFeel methodsFor: 'private'!

fetchFullSpec

	^FullSpec decodeFromLiteralArray:
		(specSelector isNil
			ifTrue:[UIBCompositeComponent defaultWindowSpec]
			ifFalse:[|holderClass|
					((holderClass := Smalltalk at: specHolderClass ifAbsent:[nil]) notNil and:[holderClass class canUnderstand: specSelector])
						ifTrue: [holderClass perform: specSelector]
						ifFalse:[UIBCompositeComponent defaultWindowSpec]])! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBComponentLookAndFeel class
	instanceVariableNames: ''!


!UIBComponentLookAndFeel class methodsFor: 'instance creation'!

decodeFromLiteralArray: anArray

	^self new fromLiteralArrayEncoding: anArray! !

UIBApplicationModel subclass: #FileSelector
	instanceVariableNames: 'directoryIndex selectedDirectory directoryContents filename currentSelection currentDirectory directoryMenu openButtonLabel forPut filter enablePutBlock '
	classVariableNames: 'FileIcon FolderIcon VolumeIcon '
	poolDictionaries: ''
	category: 'UIB-Demo-File selection (New)'!
FileSelector comment:
'I am a user interface component to get or to put a file.
I am part of ApplFLab''s documentation. I am an example of a user defined component.

Last revision: November 23, 1995.

Instance Variables:
	selectedDirectory	<ValueHolder on: Filename>	The directory of which the contents is currently displayed.
	directoryContents	<SelectionInList>			Aspect of the File Selector for the list view.
	filename			<ValueHolder on: Filename>	Aspect property of the File Selector. Its value is changed when the get/put button is pressed. In case of getting a file, the file''s Filename is stored. In case of putting, the currently opened directory''s Filename is stored.
	currentSelection	<ValueHolder on: Filename>	Aspect property of the File Selector. At any given time, it holds the current selection (a Filename of a file, directory or volume), or nil when no selection is made.
	currentDirectory	<ValueHolder on: Filename>	At any given time, it holds the currently opened directory''s Filename, or nil when the volumes are listed.
	directoryMenu	<ValueHolder on: Menu>		The menu for the directory pop-up menu.
	openButtonLabel	<String>					Property of the File Selector. The label of the get/put button.
	forPut			<Boolean>					Property of the File Selector. Indicates the get or put behaviour of the component.
	filter			<Block|nil>				Action property of the File Selector. Boolean Block taking a Filename as argument, used to filter unwanted files. Nil can be used to disable filtering.

Remarks:
	Protocol ''private-filename'' contains some methods that should be part of the Filename class, but they are not at this time.'!


!FileSelector methodsFor: 'properties'!

enablePutBlock

	^enablePutBlock!

filter

	^filter!

forPut

	^forPut!

openButtonLabel

	^openButtonLabel! !

!FileSelector methodsFor: 'models'!

currentSelection
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^currentSelection isNil
		ifTrue:
			[currentSelection := ValueHolder new]
		ifFalse:
			[currentSelection]!

filename
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^filename isNil
		ifTrue:
			[filename := ValueHolder new]
		ifFalse:
			[filename]! !

!FileSelector methodsFor: 'actions'!

displayVolumes

	| volumeName |
	volumeName := self currentDirectory value.
	self currentDirectory value: nil.
	self selectFileOrDirectoryOrVolumeNamed: (self volumeNameOf: volumeName)!

newDirectory
	"Create a new subdirectory and enter it."

	| directoryName directory |
	(directoryName := Dialog request: 'Name of new folder ?') isEmpty ifTrue: [^self].
	directoryName := Filename suggest: directoryName.
	(directory := self currentDirectory value construct: directoryName) exists
		ifTrue:[Dialog warn: 'Sorry, that name is already taken.'. ^self].
	directory makeDirectory.
	self currentDirectory value: directory!

openDirectory

	self currentDirectory value: self currentSelection value.
	self selectFirstFileOrDirectoryOrVolume!

openFile

	self filename value: 
		(self forPut
			ifTrue:[self currentDirectory value]
			ifFalse:[self currentSelection value])!

openFileOrDirectory
	"This stub method was generated by UIBDefiner"

	self currentSelectionIsDirectory
		ifTrue: [self openDirectory]
		ifFalse: [self openFile]!

toParentDirectory
	"Move the focus of attention to the parent directory of the current one."
	"PRECONDITION: this method may only be invoked when the current directory is not the desktop
	(the desktop is not a real directory, but is treated as the root directory)."

	| directoryName |
	directoryName := self currentDirectory value tail.
	self currentDirectory value: 
		((self filenameIsVolume: self currentDirectory value)
			ifFalse: [self currentDirectory value directory]
			ifTrue: [nil]).
	self selectFileOrDirectoryOrVolumeNamed: directoryName! !

!FileSelector methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	"This message is sent by the builder when it has completed work on either a complete window or a SubCanvas."

	(aBuilder componentAt: #directoryContentsList) widget container container noMenuBar.
	(aBuilder componentAt: #directoryContentsList) widget
		visualBlock:
			[:v :i | BoundedWrapper on: (self iconInCurrentPathOf:(v sequence at: i))];
		selectedVisualBlock:
			[:v :i || rw |
			rw := ReversingWrapper on: (self iconInCurrentPathOf:(v sequence at: i)).
			rw reverse setValue: true.
			BoundedWrapper on: rw].
	self currentDirectory value: self currentSelection value.
	self selectFirstFileOrDirectoryOrVolume.
	self updateParentDirectoryButtonFor: self currentDirectory value forceUpdate: true.
	directoryContents selectionHolder compute: [:newSelection| self selectionChanged: newSelection].
	self currentDirectory compute:
		[:directory|
			self updateParentDirectoryButtonFor: directory forceUpdate: false.
			self directoryMenu value:
				(directory isNil
					ifTrue:[self desktopMenu]
					ifFalse:[Menu labelArray: ((Filename components: directory asString) addFirst: 'Desktop'; yourself) asArray]).
			directoryIndex value: self directoryMenu value menuItems size].
	self currentDirectory changed: #value! !

!FileSelector methodsFor: 'private'!

currentDirectory

	^currentDirectory!

currentDirectoryIsDesktop
	"Answer a Boolean indicating whether the current directory is the desktop,
	i.e. the list of volumes."

	^self currentDirectory value isNil!

currentSelectionIsDirectory

	^self noSelection not and:[self currentSelection value isDirectory]!

defaultOpenButtonLabel

	^'Open'!

filterDirectoryContents: contents

	^contents select:[:item| |aFilename|
					aFilename := self pathnameOf: item.
					(aFilename exists and:[aFilename isDirectory]) or:[self filter value: (Array with: aFilename)]]
					"^^^^^^^^^^^^^^^^ this part excludes Macintosh alias files.
					Hope this is solved in the next version of VW."!

openButtonLabelForDirectory

	^'Open'!

pathnameOf: fileDirectoryOrVolumeName
	"Return the Filename of fileDirectoryOrVolumeName in the current path."

	| directory |
	^(directory := self currentDirectory value) isNil
		ifTrue: [fileDirectoryOrVolumeName asFilename]
		ifFalse:[directory asFilename construct: fileDirectoryOrVolumeName]!

putButtonMayBeEnabled

	^self enablePutBlock isNil or: [self enablePutBlock value]!

selectionChanged: newSelection

	self currentSelection value: 
		(newSelection isNil
			ifTrue:[nil]
			ifFalse:[self currentDirectory value isNil
					ifTrue: [Filename named: newSelection]
					ifFalse: [self currentDirectory value construct: newSelection]]).
	self updateSelectionDependentButtons! !

!FileSelector methodsFor: 'initialize-release'!

currentSelection: aFilenameHolder

	currentSelection := aFilenameHolder!

enablePutBlock: enableBlock

	enablePutBlock := enableBlock!

filename: aFilenameHolder

	filename := aFilenameHolder!

filter: filterBlock

	filter := filterBlock.
	self currentDirectory changed: #value "this forces an update of the directory contents list"!

forPut: aBoolean

	forPut := aBoolean!

initialize

	super initialize.
	directoryMenu := self desktopMenu asValue.
	selectedDirectory := 1 asValue.
	self initializeProperties.
	self initializeModels.
	self initializeAspects!

initializeAspects

	directoryContents := SelectionInList new.
	directoryContents listHolder:
		((PluggableAdaptor on: self currentDirectory)
		getBlock: [:m| |items|
					items := m value isNil ifTrue:[self volumes] ifFalse:[m value directoryContents].
					self forPut ifTrue:[items := items select: [:item| |path| path := self pathnameOf: item. path exists and: [(self filenameIsVolume: path) or: [path isDirectory]]]]. "select volumes and directories only"
					self filter isNil ifFalse:[items := self filterDirectoryContents: items].
					items asSortedCollection asList]
		putBlock: [:m :v| self error: 'directory contents may not be changed.']
		updateBlock: [:m :a :p| true]).
	selectedDirectory :=
		((PluggableAdaptor on: (directoryIndex := 1 asValue))
		getBlock: [:m| m value]
		putBlock: [:m :index| |newDirectory oldDirectoryName|
			self currentDirectory value:
			(index = 1
				ifTrue: [oldDirectoryName := self volumeNameOf: self currentDirectory value asString.
						nil]
				ifFalse: [newDirectory := self currentDirectory value.
						index to: self directoryMenu value menuItems size - 1
							do: [:i|	oldDirectoryName := newDirectory tail.
									newDirectory := newDirectory directory].
						newDirectory]).
			self selectFileOrDirectoryOrVolumeNamed: oldDirectoryName.
			m value: index]
		updateBlock: [:m :a :p| true]).!

initializeModels

	currentDirectory := nil asValue.
	filename := nil asValue.
	currentSelection := nil asValue!

initializeProperties

	openButtonLabel := self defaultOpenButtonLabel.
	forPut := false.
	filter := nil. "this means [:aFilename|true]"
	enablePutBlock := nil. "this means [true]"!

openButtonLabel: aString

	openButtonLabel := aString! !

!FileSelector methodsFor: 'aspects'!

directoryContents
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^directoryContents isNil
		ifTrue:
			[directoryContents := SelectionInList new]
		ifFalse:
			[directoryContents]!

selectedDirectory
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^selectedDirectory isNil
		ifTrue:
			[selectedDirectory := nil asValue]
		ifFalse:
			[selectedDirectory]! !

!FileSelector methodsFor: 'private-filename'!

filenameIsVolume: aFilename
	"Answer a Boolean indicating whether aFilename refers to a volume."
	"Note that a return value true does not indicate existance of the volume!!"

	^(Filename components: aFilename asString) size = 1!

isDirectory: aFilename
	"Return whether aFilename points to a valid directory."

	^OSErrorHolder errorSignal
		handle: [:exception |exception returnWith: false ]
		do: [aFilename isDirectory]!

volumeNameOf: aFilename

	^aFilename asString copyFrom: 1 to: (aFilename asString indexOf: Filename separator)!

volumes

	^Filename volumes select: [:name| name asFilename exists]! !

!FileSelector methodsFor: 'selection'!

noSelection
	"Answer true if no selection in the directory contents list is made, false otherwise."

	^self currentSelection value isNil!

selectFileOrDirectoryOrVolumeNamed: aString
	"Select aString in the directory contents list."

	self directoryContents selection: aString!

selectFirstFileOrDirectoryOrVolume
	"Select the first item in the directory contents list, if any."

	self directoryContents list isEmpty
		ifFalse:[self directoryContents selectionIndex: 1]! !

!FileSelector methodsFor: 'button state'!

updateOpenButton
	"Put the open/save button in an opening state consistent with the current file/directory/volume selection."

	self forPut
		ifFalse:[self updateOpenButtonForGet]
		ifTrue:[self updateOpenButtonForPut]!

updateOpenButtonForGet
	"Put the open/save button in an opening state consistent with the current file/directory/volume selection."

	self noSelection
		ifTrue:[	self able: false component: #openButton]
		ifFalse:[	(self widget: #openButton) labelString:
					(self currentSelectionIsDirectory
						ifTrue:[self openButtonLabelForDirectory]
						ifFalse:[self openButtonLabel]).
				self able: true component: #openButton]!

updateOpenButtonForPut
	"Put the open/save button in an opening state consistent with the current file/directory/volume selection."

	self currentDirectoryIsDesktop
		ifTrue:[	self able: self noSelection not component: #openButton]
		ifFalse:[	(self widget: #openButton) labelString:
					(self noSelection
						ifFalse:[self openButtonLabelForDirectory]
						ifTrue:[self openButtonLabel]).
				self able: (self noSelection not or:[self putButtonMayBeEnabled]) component: #openButton]!

updateParentDirectoryButtonFor: directory forceUpdate: aBoolean
	"directory <Filename>"

	directory isNil
		ifTrue:[	(self widget: #toParentDirectoryButton) labelString: ''.
				(self disableComponent: #toParentDirectoryButton)]
		ifFalse:[	(aBoolean or: [self filenameIsVolume: directory])
					ifTrue:[	(self widget: #toParentDirectoryButton)
								labelString: (Filename components: directory asString) first.
							(self enableComponent: #toParentDirectoryButton).]].!

updateSelectionDependentButtons

	self updateOpenButton.
	(self component: #newDirectoryButton) isNil
		ifFalse:[self able: self currentDirectoryIsDesktop not component: #newDirectoryButton]! !

!FileSelector methodsFor: 'visuals'!

desktopMenu

	^Menu labelArray: #('Desktop')!

directoryMenu

	^directoryMenu!

iconInCurrentPathOf: fileDirectoryOrVolumeName

	| aFilename |
	aFilename := self pathnameOf: fileDirectoryOrVolumeName.
	(self filenameIsVolume: aFilename)
		ifTrue: [^(UIBLabelAndIcon
					with: (Filename components: fileDirectoryOrVolumeName) last offset: 4@0)
					icon: VolumeIcon].
	^(self isDirectory: aFilename) "isDirectory"
		ifTrue:[(UIBLabelAndIcon
					with: (Filename components: fileDirectoryOrVolumeName) last offset: 4@0)
					icon: FolderIcon]
		ifFalse:[((UIBLabelAndIcon
					with: fileDirectoryOrVolumeName offset: 4@0) icon: FileIcon)]
	"^aFilename isDirectory
		ifTrue:[((LabelAndIconForNoteBook
					with: (Filename components: fileDirectoryOrVolumeName) last offset: 4@0)
					icon: ((self filenameIsVolume: aFilename) ifTrue:[VolumeIcon] ifFalse:[FolderIcon]))]
		ifFalse:[((LabelAndIconForNoteBook
					with: fileDirectoryOrVolumeName offset: 4@0) icon: FileIcon)]"! !

!FileSelector methodsFor: 'accessing'!

currentDirectoryName

	^self currentDirectoryIsDesktop
		ifTrue:['']
		ifFalse:[(Filename components: self currentDirectory value asString) last]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FileSelector class
	instanceVariableNames: ''!


!FileSelector class methodsFor: 'interface specs'!

extendedSpec
	"UIBPainter new openOnClass: self andSelector: #extendedSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'File Selector-#extendedSpec' 
			#bounds: #(#Rectangle 306 235 571 559 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 5 0 5 0 -75 1 30 0 ) 
					#model: #selectedDirectory 
					#menu: #directoryMenu ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0 35 0 -75 1 -5 1 ) 
					#name: #directoryContentsList 
					#model: #directoryContents 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#doubleClickSelector: #openFileOrDirectory ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 40 0 -5 1 65 0 ) 
					#name: #volumesButton 
					#model: #displayVolumes 
					#tabable: false 
					#label: 'Volumes' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 75 0 -5 1 100 0 ) 
					#name: #newDirectoryButton 
					#flags: 40 
					#model: #newDirectory 
					#tabable: false 
					#label: #newDirectoryLabel 
					#hasCharacterOrientedLabel: false 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 5 0 -5 1 25 0 ) 
					#name: #toParentDirectoryButton 
					#flags: 32 
					#model: #toParentDirectory 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 110 0 -5 1 135 0 ) 
					#name: #openButton 
					#flags: 40 
					#model: #openFileOrDirectory 
					#tabable: false 
					#label: 'Open' 
					#defaultable: true ) ) ) )!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'File Selector-#windowSpec' 
			#bounds: #(#Rectangle 85 169 350 493 ) 
			#models: #(#UIBAspectDictionary #filename #ValueHolder #currentSelection #ValueHolder ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 5 0 5 0 -75 1 30 0 ) 
					#model: #selectedDirectory 
					#menu: #directoryMenu ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0 35 0 -75 1 -5 1 ) 
					#name: #directoryContentsList 
					#model: #directoryContents 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#doubleClickSelector: #openFileOrDirectory ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 40 0 -5 1 65 0 ) 
					#name: #volumesButton 
					#model: #displayVolumes 
					#tabable: false 
					#label: 'Volumes' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 75 0 -5 1 100 0 ) 
					#name: #openButton 
					#flags: 40 
					#model: #openFileOrDirectory 
					#tabable: false 
					#label: 'Open' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -70 1 5 0 -5 1 25 0 ) 
					#name: #toParentDirectoryButton 
					#flags: 32 
					#model: #toParentDirectory 
					#defaultable: true ) ) ) )! !

!FileSelector class methodsFor: 'class initialization'!

initialize
	"self initialize"

	FileIcon := self visualFor: #fileIcon.
	FolderIcon :=self visualFor: #folderIcon.
	VolumeIcon := self visualFor: #volumeIcon.! !

!FileSelector class methodsFor: 'resources'!

fileIcon
	"UIMaskEditor new openOnClass: self andSelector: #fileIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 12@10 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[63 0 0 0 33 128 0 0 33 192 0 0 32 64 0 0 32 64 0 0 32 64 0 0 32 64 0 0 32 64 0 0 32 64 0 0 63 192 0 0])!

folderIcon
	"UIMaskEditor new openOnClass: self andSelector: #folderIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 12@10 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[120 0 0 0 135 224 0 0 128 16 0 0 128 16 0 0 128 16 0 0 128 16 0 0 128 16 0 0 128 16 0 0 128 16 0 0 255 240 0 0])!

newDirectoryLabel

	^(UIBLabelAndIcon with: 'New') icon: FolderIcon; iconPosition: #right!

volumeIcon
	"UIMaskEditor new openOnClass: self andSelector: #volumeIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 12@7 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[127 224 0 0 128 16 0 0 128 16 0 0 128 16 0 0 160 16 0 0 128 16 0 0 127 224 0 0])! !

UIBComponentGenerator subclass: #UIBCompositeComponentGenerator
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Generation'!


!UIBCompositeComponentGenerator methodsFor: 'private-generating-class'!

defaultMajorKeyMethodOn: aStream
	"Generate the #defaultMajorKey method on aStream."

	aStream
		nextPutAll: 'defaultMajorKey'; cr; crtab;
		nextPut: $^; nextPutAll: self component defaultLookAndFeel specHolderClass storeString!

defaultMinorKeyMethodOn: aStream
	"Generate the #defaultMinorKey method on aStream."

	aStream
		nextPutAll: 'defaultMinorKey'; cr; crtab;
		nextPut: $^; nextPutAll: self component defaultLookAndFeel specSelector storeString!

lookAndFeelsMethodOn: aStream
	"Generate the #lookAndFeels method on aStream."

	aStream
		nextPutAll: 'lookAndFeels'; cr; crtab;
		nextPut: $^; 
		store: self component lookAndFeels asArray literalArrayEncoding!

placementExtentMethodOn: aStream
	"Generate the #placementExtent method on aStream."

	aStream
		nextPutAll: 'placementExtent'; cr; crtab;
		nextPut: $^;
		nextPutAll: self component placementExtent x storeString;
		nextPutAll: ' @ ';
		nextPutAll: self component placementExtent y storeString! !

!UIBCompositeComponentGenerator methodsFor: 'validation'!

allApplicationModelsExist
	"Check whether the component application models exist. Interact with the user and create them if not."
	"Answer a Boolean indicating existance on exit of this method."

	| newClasses installMode target |
	(newClasses := ((self component lookAndFeels select:[:look| look targetTrouble]) collect:[:look| look specHolderClass]) asSet) size > 0 ifFalse:[^true].
	installMode :=
		Dialog
			choose: (newClasses size = 1
					ifTrue:['1 application class does not exist. Create it?']
					ifFalse:[newClasses size printString , ' application classes do not exist. Create them ?'])
			labels: (Array with: 'OK' with: 'Cancel')
			values: #(true false)
			default: true.
	installMode ifFalse:[^false]. "UIBFinder openNewClassDialogForName: #XXX subClassing: nil inCategory: nil"
	target := Array new:3.
	newClasses
		do:[:lookClass|
			target := UIBFinder openNewClassDialogForName: lookClass subClassing: nil inCategory: (target at: 3).
			target isNil ifTrue: [^false].
			UIBFinder createNewClassUsing: target].
	^true!

isValidForInstall
	"Answer a Boolean indicating that all data are valid for installation of a component."

	self allApplicationModelsExist ifFalse:[^false].
	^super isValidForInstall! !

!UIBCompositeComponentGenerator methodsFor: 'generating-class'!

generateDefaultMajorKeyMethod

	self
		generateStreamWith: [:aStream| self defaultMajorKeyMethodOn: aStream]
		inClassProtocol: #'defaults'!

generateDefaultMinorKeyMethod

	self
		generateStreamWith: [:aStream| self defaultMinorKeyMethodOn: aStream]
		inClassProtocol: #'defaults'!

generateLookAndFeelsMethod

	self
		generateStreamWith: [:aStream| self lookAndFeelsMethodOn: aStream]
		inClassProtocol: #'private-interface building'!

generatePlacementExtentMethod

	self
		generateStreamWith: [:aStream| self placementExtentMethodOn: aStream]
		inClassProtocol: #'private-interface building'! !

!UIBCompositeComponentGenerator methodsFor: 'generating'!

generate

	self generateApplicationModels.
	super generate!

generateApplicationModels

	self component lookAndFeels do:[:look| look installInSystem]!

generateClassMethods

	super generateClassMethods.
	self
		generateDefaultMajorKeyMethod;
		generateDefaultMinorKeyMethod;
		generateLookAndFeelsMethod;
		generatePlacementExtentMethod.! !

UIBIntegratedSpecModel subclass: #UIBAspectEditor
	instanceVariableNames: 'selectedAspectName adaptorType adaptorSpecsHolder availableAspects modelSpecsHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBAspectEditor methodsFor: 'aspects'!

adaptorType
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^adaptorType isNil
		ifTrue:
			[adaptorType := nil asValue]
		ifFalse:
			[adaptorType]!

selectedAspectName
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^selectedAspectName isNil
		ifTrue:
			[selectedAspectName := nil asValue]
		ifFalse:
			[selectedAspectName]! !

!UIBAspectEditor methodsFor: 'private'!

adaptorSpecsHolder

	^adaptorSpecsHolder!

adaptorTypesMenu

	^Menu labelArray: (UIBAdaptorSpec allSubclasses collect: [:cl| cl adaptorClass name]) values: UIBAdaptorSpec allSubclasses!

aspectNames

	^self availableAspects value asArray!

aspectNamesMenu

	^Menu labelArray: self aspectNames values: self aspectNames!

availableAspects

	^availableAspects!

modelSpecsHolder

	^modelSpecsHolder!

selectedAdaptorSpec

	^self adaptorSpecsHolder value at: self selectedAspectName value
		ifAbsent:[|newAdaptorSpec|
				self adaptorSpecsHolder value at: self selectedAspectName value put: (newAdaptorSpec := UIBValueHolderSpec new).
				self adaptorSpecsHolder changed: #value.
				newAdaptorSpec]! !

!UIBAspectEditor methodsFor: 'initialize-release'!

adaptorSpecs: aUIBAspectDictionaryHolder

	adaptorSpecsHolder := aUIBAspectDictionaryHolder!

availableAspects: anSortedCollectionHolder

	availableAspects := anSortedCollectionHolder!

initialize

	super initialize.
	adaptorSpecsHolder := IdentityDictionary new asValue.
	availableAspects := SortedCollection new asList asValue.
	selectedAspectName := nil asValue.
	adaptorType := nil asValue!

modelSpecs: aUIBAspectDictionaryHolder

	 modelSpecsHolder := aUIBAspectDictionaryHolder! !

!UIBAspectEditor methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	"This message is sent by the builder when it has completed work on 
	either a complete window or a SubCanvas."

	| pendingAspectSelectionChange |
	self availableAspects value isEmpty
		ifTrue: [self vanishGroup: (aBuilder namedComponents keys remove: #noAspectsLabel; yourself).
				self reappearGroup: #(#noAspectsLabel)]
		ifFalse: [self selectedAspectName value: (self availableAspects value first).
				self adaptorType value: self selectedAdaptorSpec class.
				(self builder componentAt: #adaptorTypesMenu) enable.
					(self builder componentAt: #adaptorEditor) widget client: (self selectedAdaptorSpec class  editorClass new adaptorSpec: self selectedAdaptorSpec; modelSpecs: modelSpecsHolder value) spec: #windowSpec builder: aBuilder newSubBuilder].
	pendingAspectSelectionChange := false.
	self selectedAspectName
		compute: [:newAspectName|
					(self builder componentAt: #adaptorTypesMenu) enable.
					pendingAspectSelectionChange := true.
					self adaptorType value: self selectedAdaptorSpec class].
	self adaptorType
		compute: [:newType|
					pendingAspectSelectionChange
					 ifTrue:[pendingAspectSelectionChange := false.
							(self builder componentAt: #adaptorEditor) widget client: (newType  editorClass new adaptorSpec: self selectedAdaptorSpec; modelSpecs: modelSpecsHolder value)]
					ifFalse:[(self builder componentAt: #adaptorEditor) widget
								client: (newType  editorClass new adaptorSpec: (self adaptorSpecsHolder value at: self selectedAspectName value put: newType new); modelSpecs: modelSpecsHolder value).
							self adaptorSpecsHolder changed: #value]].! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBAspectEditor class
	instanceVariableNames: ''!


!UIBAspectEditor class methodsFor: 'interface specs'!

propSpec
	"UIBPainter new openOnClass: self andSelector: #propSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Aspect Editor-#propSpec' 
			#bounds: #(#Rectangle 83 153 349 468 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 5 5 ) 
					#name: #aspectLabel 
					#label: 'Aspect' ) 
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 60 0 5 0 -25 1 25 0 ) 
					#name: #aspectNamesMenu 
					#model: #selectedAspectName 
					#menu: #aspectNamesMenu ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin -20 1 5 0 ) 
					#name: #isLabel 
					#label: 'is' ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 5 0 45 0 -5 1 -5 1 ) 
					#name: #adaptorGroup ) 
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 15 0 35 0 -60 1 55 0 ) 
					#name: #adaptorTypesMenu 
					#flags: 40 
					#isOpaque: true 
					#model: #adaptorType 
					#menu: #adaptorTypesMenu ) 
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 5 0 60 0 -5 1 -5 1 ) 
					#name: #adaptorEditor 
					#flags: 0 ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 0 0.5 0.5 0.5 ) 
					#name: #noAspectsLabel 
					#flags: 16 
					#label: 'No aspects are available at this time.' ) ) ) )! !

!UIBAspectEditor class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	"UIBPropertyFieldSpec addBindingsTo: env for: inst channel: aChannel"! !

InputFieldSpec subclass: #UIBPropertyInputFieldSpec
	instanceVariableNames: 'property defaultValue '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBPropertyInputFieldSpec methodsFor: 'generation'!

defaultModelString

	^self defaultValue! !

!UIBPropertyInputFieldSpec methodsFor: 'accessing'!

defaultValue

	^defaultValue isNil
		ifTrue: ['']
		ifFalse: [defaultValue]!

defaultValue: aValue

	defaultValue := aValue!

property

	^property!

setProperty: aProperty

	property := aProperty! !

!UIBPropertyInputFieldSpec methodsFor: 'initialize-release'!

initialize

	super initialize.
	property := UIBPropertyInputFieldModel new! !

!UIBPropertyInputFieldSpec methodsFor: 'private'!

resetDefaultValue

	self defaultValue: nil! !

!UIBPropertyInputFieldSpec methodsFor: 'building'!

dispatchTo: policy with: builder

	policy inputBox: self into: builder.
	builder isEditing
		ifTrue: [builder component model value: (builder component converter readValueFrom: self defaultValue)]! !

!UIBPropertyInputFieldSpec methodsFor: 'decoding'!

property: aPropertyEncoding

	property := aPropertyEncoding decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertyInputFieldSpec class
	instanceVariableNames: ''!


!UIBPropertyInputFieldSpec class methodsFor: 'private-interface building'!

adapt: inst forAspect: aspect accessPath: aSequencableCollection channel: aChannel

	^aChannel == nil
		ifTrue: [(AspectAdaptor subject: inst) forAspect: aspect; accessPath: aSequencableCollection]
		ifFalse: [(AspectAdaptor subjectChannel: aChannel) forAspect: aspect; accessPath: aSequencableCollection]!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #nilAllowed put: (self adapt: inst forAspect: #nilAllowed accessPath: #(#property) channel: aChannel).
	env at: #initBeforeBuilding put: (self typeConvert: (self adapt: inst forAspect: #initBeforeBuilding accessPath: #(#property) channel: aChannel)).
	
	env at: #defaultValue put: (self adapt: inst forAspect: #defaultValue channel: aChannel).
	(env at: #type) compute: [ inst resetDefaultValue ].!

componentName
	"Identification of component"

	^'Property Input Field'!

slices
	"Some slices are disabled by commenting them out,
	because they are too rich for the current version of ApplFLab."

	^#(	(Basics basicsEditSpec)
		(Details detailsEditSpec)
		(Specials specialsEditSpec)
		"(Validation validationEditSpec nil callbacks)
		(Notification notificationEditSpec nil callbacks)" 
		(Color propSpec ColorToolModel) 
		(Position propSpec PositionToolModel)
		"(#'Drop Target'	dropTargetSpec)" )!

typeConvert: aValue

	^(PluggableAdaptor on: aValue)
					getBlock: [:m | m value ifTrue:[#before] ifFalse:[#after]]
					putBlock: [:m :v | m value: v == #before]
					updateBlock: [:b :a :p | false]! !

!UIBPropertyInputFieldSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 300 357 ) 
			#max: #(#Point 300 357 ) 
			#bounds: #(#Rectangle 337 181 637 538 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 4 0 114 0 0 1 ) 
					#label: 'ID:' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 4 0 54 0 0 1 ) 
					#label: 'Aspect:' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 4 0 140 0 0 1 ) 
					#label: 'Type:' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 4 0 0.5 0 ) 
					#label: #componentName )
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 86 0 118 0 -10 1 140 0 ) 
					#model: #type 
					#menu: #typeMenu ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 4 0 83 0 0 1 ) 
					#label: 'Menu:' ) 
				#(#InputFieldSpec 
					#properties: 
					#(#PropertyListDictionary #dragOverSelector 
						#dragOverSelectorAspect: #dropSelector 
						#dropInSelectorAspect: #dragExitSelector 
						#dragLeaveSelectorAspect: #dragEnterSelector 
						#dragEnterSelectorAspect: ) 
					#layout: #(#LayoutFrame 86 0 28 0 -10 1 53 0 ) 
					#name: #modelField 
					#model: #model 
					#menu: #fieldMenu ) 
				#(#InputFieldSpec 
					#properties: 
					#(#PropertyListDictionary #dragOverSelector 
						#dragOverSelectorAspect: #dropSelector 
						#dropInSelectorAspect: #dragEnterSelector 
						#dragEnterSelectorAspect: #dragExitSelector 
						#dragLeaveSelectorAspect: ) 
					#layout: #(#LayoutFrame 86 0 58 0 -10 1 83 0 ) 
					#name: #menuField 
					#model: #menu 
					#menu: #fieldMenu ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 86 0 88 0 -10 1 113 0 ) 
					#model: #name 
					#menu: #fieldMenu ) 
				#(#ComboBoxSpec 
					#layout: #(#LayoutFrame 86 0 148 0 -10 1 173 0 ) 
					#name: #formatEditor 
					#model: #formatString 
					#menu: #fieldMenu 
					#isReadOnly: false 
					#comboList: #defaultFormats ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 4 0 174 0 0 1 ) 
					#name: #formatLabel 
					#label: 'Format:' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 240 233 ) 
			#max: #(#Point 262 273 ) 
			#bounds: #(#Rectangle 65 204 327 477 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 86 0 35 0 -10 1 57 0 ) 
					#model: #style 
					#menu: #fontMenu ) 
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 86 0 65 0 -10 1 87 0 ) 
					#model: #alignment 
					#menu: #alignmentMenu ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 86 0 95 0 -10 1 118 0 ) 
					#model: #numChars 
					#menu: #fieldMenu 
					#type: #string ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 126 ) 
					#model: #hasBorder 
					#label: 'Bordered' ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 148 ) 
					#model: #isOpaque 
					#label: 'Opaque' ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 170 ) 
					#model: #tabable 
					#label: 'Can Tab' ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 192 ) 
					#model: #isReadOnly 
					#label: 'Read Only' ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 214 ) 
					#model: #initiallyDisabled 
					#label: 'Initially Disabled' ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 236 ) 
					#model: #initiallyInvisible 
					#label: 'Initially Invisible' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 10 0 88 0 0 1 ) 
					#label: 'Align:' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 10 0 58 0 0 1 ) 
					#label: 'Font:' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 10 0 119 0 0 1 ) 
					#label: 'Size:' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 4 0 0.5 0 ) 
					#label: #componentName ) ) ) )!

specialsEditSpec
	"UIBPainter new openOnClass: self andSelector: #specialsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 240 233 ) 
			#max: #(#Point 262 273 ) 
			#bounds: #(#Rectangle 36 138 298 411 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 4 0 0.5 0 ) 
					#label: #componentName ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 10 0 53 0 0 1 ) 
					#label: 'Default value:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 10 0 55 0 -10 1 78 0 ) 
					#name: #defaultValueField 
					#model: #defaultValue 
					#menu: #fieldMenu 
					#type: #string ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 106 ) 
					#name: #nilAllowed 
					#model: #nilAllowed 
					#label: 'Nil allowed' ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#LabelSpec 
							#layout: #(#Point 0 1 ) 
							#label: 'Initialize' ) 
						#(#RadioButtonSpec 
							#layout: #(#Point 63 0 ) 
							#name: #before 
							#model: #initBeforeBuilding 
							#label: 'before' 
							#select: #before ) 
						#(#RadioButtonSpec 
							#layout: #(#Point 123 0 ) 
							#name: #after 
							#model: #initBeforeBuilding 
							#label: 'after building' 
							#select: #after ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 10 131 236 151 ) ) ) ) ) )! !

!UIBPropertyInputFieldSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@K0@@@@@OP@@/J****(=@@B<*(***#4@@K2@ HJ*OP@@/H"H"((=@@B< HBB@#4@@K2*****OP@@/J****(=@@B<@@@@@C4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a'))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 255 255 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 143 255 252 192 136 0 4 192 136 32 4 192 139 187 4 192 138 170 36 192 139 187 116 192 136 0 4 192 136 0 4 192 143 255 252 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 255 255 255 192 255 255 255 192 ])! !

UIBApplicationModel subclass: #UIBLookAndFeelEditor
	instanceVariableNames: 'specSelector specHolderClass default defaultHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources-UI'!


!UIBLookAndFeelEditor methodsFor: 'model accessing'!

defaultHolder

	^defaultHolder!

defaultHolder: aValueHolder

	defaultHolder := aValueHolder!

lookAndFeelHolder

	^specSelector subjectChannel!

lookAndFeelHolder: aValueHolder

	specHolderClass subjectChannel: aValueHolder.
	specSelector subjectChannel: aValueHolder.
	default subjectChannel: aValueHolder! !

!UIBLookAndFeelEditor methodsFor: 'initialize-release'!

initialize

	| lookAndFeelHolder |
	super initialize.
	lookAndFeelHolder := UIBComponentLookAndFeel new asValue.
	(specHolderClass := (AspectAdaptor forAspect: #specHolderClass) subjectChannel: lookAndFeelHolder; subjectSendsUpdates: true)
		compute:[self default changed: #value].
	(specSelector := (AspectAdaptor forAspect: #specSelector) subjectChannel: lookAndFeelHolder; subjectSendsUpdates: true)
		compute:[self default changed: #value].
	default := ((PluggableAdaptor on: lookAndFeelHolder)
				getBlock: [:m| m value sameLocationAs: self defaultHolder]
				putBlock: [:m :v| self defaultHolder: m value resourceLocation]
				updateBlock: [:m :v :p| true]).
	self defaultHolder: lookAndFeelHolder value resourceLocation.! !

!UIBLookAndFeelEditor methodsFor: 'aspects'!

default
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^default!

specHolderClass
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^specHolderClass!

specSelector
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^specSelector! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBLookAndFeelEditor class
	instanceVariableNames: ''!


!UIBLookAndFeelEditor class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'LookAndFeel Row' 
			#bounds: #(#Rectangle 255 228 536 255 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 0 0 -15 0.5 0 1 ) 
					#model: #specHolderClass 
					#style: #default 
					#type: #symbol ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame -9 0.5 0 0 -30 1 0 1 ) 
					#model: #specSelector 
					#style: #default 
					#type: #symbol ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin -25 1 0 0.5 0 0.5 ) 
					#model: #default 
					#select: true ) ) ) )! !

Cursor subclass: #UIBCursor
	instanceVariableNames: ''
	classVariableNames: 'HorizontalResizeCursor VerticalResizeCursor '
	poolDictionaries: ''
	category: 'UIB-Support'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBCursor class
	instanceVariableNames: ''!


!UIBCursor class methodsFor: 'constants'!

horizontalResizer
	"Answer the instance of the receiver that is a horizontal resizer."

	^HorizontalResizeCursor!

verticalResizer
	"Answer the instance of the receiver that is a vertical resizer."

	^VerticalResizeCursor! !

!UIBCursor class methodsFor: 'class initialization'!

initialize
	"self initialize"

	self installCursors! !

!UIBCursor class methodsFor: 'private-constant initialization'!

initHorizontalResizer

	HorizontalResizeCursor
		:= (self
			imageArray: #(	
		2r0000000000000000
		2r0000001001000000
		2r0000001001000000
		2r0000001001000000
		2r0000001001000000
		2r0001001001001000
		2r0011001001001100
		2r0111111001111110
		2r0011001001001100
		2r0001001001001000
		2r0000001001000000
		2r0000001001000000
		2r0000001001000000
		2r0000001001000000
		2r0000001001000000
		2r0000000000000000)
			maskArray: #(	
		2r0000000000000000
		2r0000011111100000
		2r0000011111100000
		2r0000011111100000
		2r0001011111101000
		2r0011111111111100
		2r0111111111111110
		2r1111111111111111
		2r0111111111111110
		2r0011111111111100
		2r0001011111101000
		2r0000011111100000
		2r0000011111100000
		2r0000011111100000
		2r0000011111100000
		2r0000000000000000)
	hotSpot: 8@8 name: 'horizontal resizer')!

initVerticalResizer

	VerticalResizeCursor
		:= (self
			imageArray: #(
		2r0000000000000000
		2r0000000010000000
		2r0000000111000000
		2r0000001111100000
		2r0000000010000000
		2r0000000010000000
		2r0111111111111110
		2r0000000000000000
		2r0000000000000000
		2r0111111111111110
		2r0000000010000000
		2r0000000010000000
		2r0000001111100000
		2r0000000111000000
		2r0000000010000000
		2r0000000000000000)
			maskArray: #(	
		2r0000000010000000
		2r0000000111000000
		2r0000001111100000
		2r0000011111110000
		2r0000001111100000
		2r0111111111111110
		2r0111111111111110
		2r0111111111111110
		2r0111111111111110
		2r0111111111111110
		2r0111111111111110
		2r0000001111100000
		2r0000011111110000
		2r0000001111100000
		2r0000000111000000
		2r0000000010000000)
	hotSpot: 8@8 name: 'vertical resizer')!

installCursors

	self initHorizontalResizer.
	self initVerticalResizer! !

UICanvasTool subclass: #UIBCanvasTool
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter-Tools'!


!UIBCanvasTool methodsFor: 'actions'!

openPropertyTool
	"Overridden here in order to use our own properties tool."
	
	UIBPropertiesTool open! !

!UIBCanvasTool methodsFor: 'private'!

adjustSelectionInMenu: newMenu andController: ctrlr 

	((newMenu menuItemLabeled: 'Arrange')  submenu menuItemLabeled: 'Special Group') submenu: ctrlr applFLabGroupMenu.
	((newMenu menuItemLabeled: 'Tools') submenu menuItemLabeled: 'Palette') submenu: UIBPaletteEditor palettesMenuForOpening.
	super adjustSelectionInMenu: newMenu andController: ctrlr!

changedStatusBar
	
	| tx |
	self builder window label:
		(((tx := self statusBarText value) isNil or: [tx isEmpty])
			ifTrue: ['ApplFLab Canvas Tool']
			ifFalse: ['ApplFLab Canvas Tool on: ' , tx])!

reloadSelectionInformation
	| ctrlr |
	super reloadSelectionInformation.
	ctrlr := selectionHolder value.
	ctrlr == controller
		ifFalse: 
			[(controller notNil and: [self isLocal])
				ifTrue: [^self].
			controller == nil
				ifFalse: 
					[controller griddedHorizontally retractInterestsFor: self.
					controller griddedVertically retractInterestsFor: self.
					controller showGrid retractInterestsFor: self.
					controller gridStep retractInterestsFor: self.
					controller fenced retractInterestsFor: self].
			ctrlr == nil
				ifTrue:
					[builder window menuBar menuButtons do: [:btn | btn isEnabled: false]]
				ifFalse: 
					[ctrlr griddedHorizontally onChangeSend: #gridSettingsUpdate to: self.
					ctrlr griddedVertically onChangeSend: #gridSettingsUpdate to: self.
					ctrlr showGrid onChangeSend: #gridSettingsUpdate to: self.
					ctrlr gridStep onChangeSend: #gridSettingsUpdate to: self.
					ctrlr fenced onChangeSend: #gridSettingsUpdate to: self.
					builder window menuBar menuButtons do:
						[:btn | (btn menu menuItemWithValue: 'null' ifNone: []) isNil
							ifTrue: [btn isEnabled: true]]].
			(controller isNil or: [self isLocal not])
				ifTrue: [controller := ctrlr]].
	controller isNil
		ifTrue: 
			[builder window menuBar menuButtons do: [:btn | btn isEnabled: false].
			self disableArrangeButtons.
			#(#installID #defineID #browseID #openID ) do: [:n | (builder componentAt: n) disable].
			statusBarText value: '']
		ifFalse: 
			[((controller isKindOf: UIBPainterController) and:[controller isCanvasToolActionAware not])
				ifTrue:[#(#installID #defineID #browseID #openID ) do: [:n | (builder componentAt: n) disable]]
			ifFalse:[
			self adjustSelectionInMenu: menuBar andController: ctrlr.
			(builder componentAt: #installID) enable.
			(controller model targetClass isNil and: [(UISettings preferenceFor: #installForDefine) not and: [(UISettings preferenceFor: #installForOpen) not]])
				ifTrue: [#(#defineID #browseID #openID ) do: [:n | (builder componentAt: n) disable]]
				ifFalse: [#(#defineID #browseID #openID ) do: [:n | (builder componentAt: n) enable]]].
			statusBarText value: (ctrlr model dependents at: 1) label asString].
	self gridSettingsUpdate.
	self lookSettingUpdate! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBCanvasTool class
	instanceVariableNames: ''!


!UIBCanvasTool class methodsFor: 'interface specs'!

windowSpecTight
	"UIBPainter new openOnClass: self andSelector: #windowSpecTight"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'ApplFLab Canvas Tool' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 17 205 433 301 ) 
			#flags: 4 
			#menu: #newMenuBar ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -65 1 32 0 -33 1 ) 
					#name: #alignTopID 
					#flags: 40 
					#model: #alignTop 
					#tabable: false 
					#label: #alignTopImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 32 0 -65 1 64 0 -33 1 ) 
					#name: #alignVCenterID 
					#flags: 40 
					#model: #alignVCenter 
					#tabable: false 
					#label: #alignVCenterImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 64 0 -65 1 96 0 -33 1 ) 
					#name: #alignBottomID 
					#flags: 40 
					#model: #alignBottom 
					#tabable: false 
					#label: #alignBottomImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 96 0 -65 1 128 0 -33 1 ) 
					#name: #alignLeftID 
					#flags: 40 
					#model: #alignLeft 
					#tabable: false 
					#label: #alignLeftImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 128 0 -65 1 160 0 -33 1 ) 
					#name: #alignHCenterID 
					#flags: 40 
					#model: #alignHCenter 
					#tabable: false 
					#label: #alignHCenterImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 160 0 -65 1 192 0 -33 1 ) 
					#name: #alignRightID 
					#flags: 40 
					#model: #alignRight 
					#tabable: false 
					#label: #alignRightImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 208 0 -65 1 240 0 -33 1 ) 
					#name: #distributeTTBEdgesID 
					#flags: 40 
					#model: #distributeTTBEdges 
					#tabable: false 
					#label: #distributeTTBEdgesImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 240 0 -65 1 272 0 -33 1 ) 
					#name: #distributeTTBCentersID 
					#flags: 40 
					#model: #distributeTTBCenters 
					#tabable: false 
					#label: #distributeTTBCentersImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 272 0 -65 1 304 0 -33 1 ) 
					#name: #distributeLTREdgesID 
					#flags: 40 
					#model: #distributeLTREdges 
					#tabable: false 
					#label: #distributeLTREdgesImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 304 0 -65 1 336 0 -33 1 ) 
					#name: #distributeLTRCentersID 
					#flags: 40 
					#model: #distributeLTRCenters 
					#tabable: false 
					#label: #distributeLTRCentersImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 352 0 -65 1 384 0 -33 1 ) 
					#name: #equalizeHeightID 
					#flags: 40 
					#model: #equalizeHeight 
					#tabable: false 
					#label: #equalizeHeightImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 384 0 -65 1 416 0 -33 1 ) 
					#name: #equalizeWidthID 
					#flags: 40 
					#model: #equalizeWidth 
					#tabable: false 
					#label: #equalizeWidthImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 -32 1 0 0.199203 0 1 ) 
					#model: #openPropertyTool 
					#tabable: true 
					#label: 'Properties' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.199203 -32 1 0 0.400398 0 1 ) 
					#name: #installID 
					#model: #doInstall 
					#label: 'Install...' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.400398 -32 1 0 0.599602 0 1 ) 
					#name: #defineID 
					#flags: 40 
					#model: #doDefine 
					#label: 'Define...' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.599602 -32 1 0 0.800797 0 1 ) 
					#name: #browseID 
					#flags: 40 
					#model: #doBrowse 
					#label: 'Browse...' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0.800797 -32 1 0 1.0 0 1 ) 
					#name: #openID 
					#flags: 40 
					#model: #doOpen 
					#label: 'Open' ) ) ) )! !

!UIBCanvasTool class methodsFor: 'resources'!

arrangeMenu
	"UIMenuEditor new openOnClass: self andSelector: #arrangeMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#label: 'Snap To Grid' ) 
			#(#MenuItem 
				#label: 'Group' ) 
			#(#MenuItem 
				#label: 'Special Group' ) 
			#(#MenuItem 
				#label: 'Ungroup' ) 
			#(#MenuItem 
				#label: 'Bring To Front' ) 
			#(#MenuItem 
				#label: 'Bring Forward' ) 
			#(#MenuItem 
				#label: 'Send To Back' ) 
			#(#MenuItem 
				#label: 'Send Backward' ) 
			#(#MenuItem 
				#label: 'Align...' ) 
			#(#MenuItem 
				#label: 'Distribute...' ) 
			#(#MenuItem 
				#label: 'Equalize...' ) ) #(1 3 4 3 ) #(#snapToGrid #doGroup nil #doUngroup #toVisualFront #toVisualFrontOne #toVisualBack #toVisualBackOne #alignDialog #distributeDialog #equalizeDialog ) ) decodeAsLiteralArray!

toolsMenu
	"UIMenuEditor new openOnClass: self andSelector: #toolsMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#label: 'Palette' ) 
			#(#MenuItem 
				#label: 'Image Editor' ) 
			#(#MenuItem 
				#label: 'Menu Editor' ) 
			#(#MenuItem 
				#label: 'Reusable Data Form Components' ) ) #(1 2 1 ) #(#nil #maskEditor #menuEditor #openReusableComponents ) ) decodeAsLiteralArray! !

UIBSimpleDialog subclass: #UIBComponentEditorSelector
	instanceVariableNames: 'componentKind componentClassName componentClassMenu '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Editor'!


!UIBComponentEditorSelector methodsFor: 'menu'!

componentClassMenu

	^componentClassMenu!

updateMenu

	| classes theMenu |
	classes := 
	(self componentKind value = #UIBCompositeComponent
		ifTrue:[UIBCompositeComponentSpec allSubclasses collect: [:cl| cl name]]
		ifFalse:[self componentKind value = #UIBStandardComponent
				ifTrue:[UIPalette standardSpecsForPalette]
				ifFalse:[UIBFinder subclassesOfStandardSpecClasses collect: [:cl| cl name]]])
	asSortedCollection.
	theMenu := Menu new.
	self componentKind value = #UIBCompositeComponent
		ifTrue:[theMenu addItemLabel: 'New' value: 'new'. "this value should not be a valid class name Symbol!!"].
	theMenu addItemGroupLabels: classes values: classes.
	self componentClassMenu value: theMenu.
	componentClassName value: (theMenu values at: 1).! !

!UIBComponentEditorSelector methodsFor: 'initialize-release'!

initialize

	super initialize.
	componentKind := #UIBCompositeComponent asValue.
	componentClassName := nil asValue.
	componentKind compute: [self updateMenu].
	componentClassMenu := Menu new asValue.
	self updateMenu! !

!UIBComponentEditorSelector methodsFor: 'aspects'!

componentClassName

	^componentClassName!

componentKind

	^componentKind! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBComponentEditorSelector class
	instanceVariableNames: ''!


!UIBComponentEditorSelector class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: '' 
			#bounds: #(#Rectangle 131 253 430 422 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 5 5 ) 
					#name: #promptID 
					#label: 'What kind of component do you want to edit?' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 10 35 ) 
					#name: #standardID 
					#model: #componentKind 
					#tabable: false 
					#label: 'Standard Widget' 
					#select: #UIBStandardComponent ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 10 60 ) 
					#name: #extendedID 
					#model: #componentKind 
					#tabable: false 
					#label: 'Specialisation of standard widget' 
					#select: #UIBExtendedStandardComponent ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 10 85 ) 
					#name: #compositeID 
					#model: #componentKind 
					#tabable: false 
					#label: 'Composite component' 
					#select: #UIBCompositeComponent ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -60 1 -30 1 -5 1 -5 1 ) 
					#name: #cancelID 
					#model: #doCancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -120 1 -30 1 -65 1 -5 1 ) 
					#name: #acceptID 
					#model: #doAccept 
					#label: 'OK' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#Point 10 110 ) 
					#name: #whichID 
					#label: 'Which One?' ) 
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 100 0 110 0 -5 1 135 0 ) 
					#name: #componentClassMenuID 
					#model: #componentClassName 
					#menu: #componentClassMenu ) ) ) )! !

!UIBComponentEditorSelector class methodsFor: 'interface opening'!

selectComponentKind
	"Answer an Array with the component kind and a specification class (or nil)."

	"self selectComponentKind"

	| anInstance |
	^((anInstance := self new) openFor: anInstance interface: #windowSpec)
		ifTrue:[Array
				with: anInstance componentKind value
				with: (anInstance componentClassName value = 'new'
						ifTrue:[nil]
						ifFalse:[Smalltalk at: anInstance componentClassName value])]
		ifFalse:[nil]! !

UIBEncodableModel subclass: #UIBPropertyModel
	instanceVariableNames: 'name property '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBPropertyModel methodsFor: 'accessing'!

initBeforeBuilding

	^self subclassResponsibility!

name

	^name!

name: aValue

	name := aValue! !

!UIBPropertyModel methodsFor: 'building'!

setup: componentPropertyAccessor for: uibComponent from: componentSpec afterBuildingIn: builder

	"Default is to do nothing."!

setup: componentPropertyAccessor for: uibComponent from: componentSpec beforeBuildingIn: builder

	"Default is to do nothing."! !

!UIBPropertyModel methodsFor: 'initialize-release'!

initialize

	self name: nil! !

!UIBPropertyModel methodsFor: 'printing'!

storeOn: aStream 
	"Append to the argument aStream a sequence of characters that is an expression 
	whose evaluation creates an object similar to the receiver."

	^self subclassResponsibility! !

!UIBPropertyModel methodsFor: 'private'!

property

	^property!

property: aValue

	property := aValue! !

UIBPropertyModel subclass: #UIBSubPropertyFieldModel
	instanceVariableNames: 'customComponentClassName minorKey componentName propertyName componentNameMenu propertyNameMenu customComponentBuilder fromLiteralEncoding interestingPropertySpecs lookAndFeel lookAndFeelMenu targetComponent '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBSubPropertyFieldModel methodsFor: 'private'!

customComponentBuilder

	^customComponentBuilder!

interestingPropertySpecsOf: specClass

	| col | 
	col := OrderedCollection new:20.
	(self interestingSliceSpecsOf: specClass)
		do:[:fullSpec|
			col addAll:(fullSpec component collection
						select:[:spec| (spec class inheritsFrom: WidgetSpec)
								or: [(spec class inheritsFrom: UIBCompositeComponentSpec)
									and:[(spec class inheritsFrom: UIBPropertyComponentSpec) not]]])].
	^col!

interestingSliceSpecsOf: specClass

	^((UIBSlice slicesOf: specClass) select:[:slice| slice isSimple])
		collect:[:slice| slice fullSpec]!

postLiteralArrayDecoding

	fromLiteralEncoding := true!

preLiteralEncoding

	self initialize!

setupComponentMenu

	| mb |
	self updateCustomComponentBuilder isNil
		ifTrue:[	componentNameMenu value: Menu new.
				^componentName := nil].
	mb := MenuBuilder new.
	(self customComponentBuilder namedComponents values
		asSortedCollection:[:w1 :w2| w1 spec name <= w2 spec name])
		do:[:w| mb add: (w spec name , ' (', w spec class componentName , ')') -> w spec name].
	componentNameMenu value: mb menu!

setupPropertyMenu

	| mb excludeSet menu |
	(self customComponentBuilder isNil or:[self componentName isNil])
		ifTrue:[	interestingPropertySpecs := nil.
				propertyNameMenu value: Menu new.
				^propertyName := nil].
	mb := MenuBuilder new.
	((interestingPropertySpecs := self interestingPropertySpecsOf:(self customComponentBuilder componentAt: self componentName) spec class)
		asSortedCollection:[:spec1 :spec2| spec1 model <= spec2 model])
		do:[:spec| mb add: spec model -> spec model].
	excludeSet:= Set with: 'model' with: 'clientKey' with: 'name' with: 'menu'.
	(menu := mb menu) menuItems do:[:item| (excludeSet includes: item label) ifTrue:[item disable]].
	propertyNameMenu value: menu.!

subComponentName: aValue

	componentName := aValue!

subPropertyName: aValue

	propertyName := aValue!

updateComponentMenu

	self setupComponentMenu isNil ifTrue:[^self].
	componentName := nil "(self componentNameMenu value valueAt: 1)"!

updateCustomComponentBuilder

	^customComponentBuilder :=
		self customComponentClass isNil
			ifTrue:[nil]
			ifFalse:[self customComponentClass new allButOpenInterface: self minorKey]!

updatePropertyMenu

	self setupPropertyMenu isNil ifTrue:[^self].
	propertyName := (self propertyNameMenu value valueAt: 1).! !

!UIBSubPropertyFieldModel methodsFor: 'accessing'!

componentName

	^componentName!

componentName: aValue

	componentName := aValue.
	self updatePropertyMenu!

componentNameMenu

	^componentNameMenu!

componentSpecFromCollection: aSpecCollection

	^(aSpecCollection
		select:[:spec|(spec class inheritsFrom: NamedSpec) and:[spec name = self componentName]]) "Koen: is NamedSpec niet te veel ?"
		at: 1!

customComponentClass

	^Smalltalk at: self customComponentClassName value ifAbsent: [nil]!

customComponentClassName

	^customComponentClassName!

customComponentClassName: aClassName

	aClassName == customComponentClassName ifTrue:[^self].
	customComponentClassName := aClassName.
	self setupComponentMenu.
	fromLiteralEncoding ifFalse:[componentName := nil].
	self setupPropertyMenu.
	fromLiteralEncoding := false!

initBeforeBuilding

	^true!

lookAndFeel

	^lookAndFeel!

lookAndFeel: aUIBComponentLookAndFeel

	lookAndFeel := aUIBComponentLookAndFeel.
	self updateComponentMenu.
	"self componentName: nil."
	self updatePropertyMenu!

lookAndFeelMenu

	^lookAndFeelMenu!

lookAndFeels: lookAndFeels

	self lookAndFeelMenu value:
		(Menu
			labelArray: (lookAndFeels collect:[:look| look fullDisplayString])
			values: lookAndFeels asArray)!

minorKey

	^minorKey!

minorKey: aSpecSymbol

	minorKey := aSpecSymbol isNil ifTrue:[#windowSpec] ifFalse:[aSpecSymbol]!

property

	property == self
		ifTrue:[	property := self subPropertyComponentSpecCopy defaultModel value
				"Koen: can non-value models act as property model ? If yes, the above line is not correct."].
	^property!

propertyName

	^propertyName!

propertyName: aValue

	propertyName := aValue!

propertyNameMenu

	^propertyNameMenu!

propertyValueOrFromSpec: aSpec

	property == self
		ifTrue:[property := (self componentSpecFromCollection: aSpec collection)
								perform: self propertyName].
	^property!

subPropertyComponentSpecCopy

	(customComponentBuilder isNil or:[self componentName isNil]) ifTrue:[^nil].
	^(self subPropertyComponentSpecFromCollection: interestingPropertySpecs) copy!

subPropertyComponentSpecFromCollection: aSpecCollection

	^(aSpecCollection
		select:[:spec|((spec class inheritsFrom: WidgetSpec) or:[spec class inheritsFrom: UIBCompositeComponentSpec]) and:[spec model = self propertyName]])
		at: 1!

targetComponent: aUIBComponent

	targetComponent := aUIBComponent.
	self lookAndFeels: targetComponent lookAndFeels.
	self minorKey: targetComponent defaultLookAndFeel specSelector.
	self customComponentClassName: targetComponent defaultLookAndFeel specHolderClass! !

!UIBSubPropertyFieldModel methodsFor: 'initialize-release'!

initialize

	super initialize.
	fromLiteralEncoding := false.
	customComponentClassName := nil.
	minorKey := #windowSpec.
	componentNameMenu := Menu new asValue.
	propertyNameMenu := Menu new asValue.
	lookAndFeel := nil.
	lookAndFeelMenu := Menu new asValue.
	componentName := nil.
	propertyName := nil.
	property := self. "This indicates that propertyValue is not yet assigned a value from outside."
	self updateComponentMenu! !

!UIBSubPropertyFieldModel methodsFor: 'converting'!

literalArrayEncodingOn: aStream

	"UIBSubPropertyFieldModel new literalArrayEncoding"

	aStream
		nextPut: #name:; nextPut: self name literalArrayEncoding;
		nextPut: #subComponentName:; nextPut: self componentName literalArrayEncoding;
		nextPut: #subPropertyName:; nextPut: self propertyName literalArrayEncoding! !

!UIBSubPropertyFieldModel methodsFor: 'building'!

defaultModel

	^nil!

overridePropertyInSpec: aSpec

	| propName propertyValue component|
	propName := self propertyName.
	propertyValue := self propertyValueOrFromSpec: aSpec.
	component := self componentSpecFromCollection: aSpec collection.
	(component isKindOf: UIBCompositeComponentSpec) "Is 'component' a custom component ?"
		ifFalse:[component perform: (propName , ':') asSymbol with: propertyValue]
		ifTrue:[component perform: (component class putSelectorForGetSelector: propName) with: propertyValue]! !

!UIBSubPropertyFieldModel methodsFor: 'printing'!

storeOn: aStream 
	"Append to the argument aStream a sequence of characters that is an expression 
	whose evaluation creates an object similar to the receiver."

	aStream
		nextPut: $(; store: self class; nextPutAll: ' new';
		nextPutAll: ' name: '; store: self name; nextPut: $;;
		nextPutAll: ' minorKey: '; store: self minorKey; nextPut: $;;
		nextPutAll: ' customComponentClassName: '; store: self customComponentClassName; nextPut: $;;
		nextPutAll: ' componentName: '; store: self componentName; nextPut: $;;
		nextPutAll: ' propertyName: '; store: self propertyName; nextPut: $;;
		nextPutAll: ' yourself)'! !

UIBPropertyModel subclass: #UIBPropertyFieldModel
	instanceVariableNames: 'type nilAllowed initBeforeBuilding generationMode generatedCode '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBPropertyFieldModel methodsFor: 'initialize-release'!

initialize

	super initialize.
	property := nil.
	self
		type: #UIBAspectProperty;
		nilAllowed: false;
		initBeforeBuilding: true;
		customGeneratedCode: nil! !

!UIBPropertyFieldModel methodsFor: 'accessing'!

generatedCode

	^generatedCode!

generatedCode: aString

	generatedCode := aString!

generationMode

	^generationMode!

generationMode: aValue

	generationMode := aValue!

initBeforeBuilding

	^initBeforeBuilding!

initBeforeBuilding: aBoolean

	initBeforeBuilding := aBoolean!

nilAllowed

	^nilAllowed!

nilAllowed: aBoolean

	nilAllowed := aBoolean!

type

	^type!

type: aValue

	type := aValue.
	self setupProperty! !

!UIBPropertyFieldModel methodsFor: 'converting'!

customGeneratedCode: aStringOrNil
	"This method is only sent when a literal array is decoded, when a store string is evaluated, or when the receiver is initialized."

	aStringOrNil isNil
		ifFalse:[	self generationMode: #custom.
				self generatedCode: aStringOrNil]
		ifTrue:[	self generationMode: #default.
				self generatedCode: self property defaultGeneratedCode]!

literalArrayEncodingOn: aStream

	"UIBPropertyFieldModel new literalArrayEncoding"

	aStream
		nextPut: #name:; nextPut: self name literalArrayEncoding;
		nextPut: #type:; nextPut: self type literalArrayEncoding;
		nextPut: #nilAllowed:; nextPut: self nilAllowed;
		nextPut: #initBeforeBuilding:; nextPut: self initBeforeBuilding;
		nextPut: #customGeneratedCode:;
		nextPut: (self generationMode == #default
					ifTrue:[nil]
					ifFalse:[self generatedCode asString]) literalArrayEncoding! !

!UIBPropertyFieldModel methodsFor: 'printing'!

storeOn: aStream 
	"Append to the argument aStream a sequence of characters that is an expression 
	whose evaluation creates an object similar to the receiver."

	aStream
		nextPut: $(; store: self class; nextPutAll: ' basicNew';
		nextPutAll: ' name: '; store: self name; nextPut: $;;
		nextPutAll: ' type: '; store: self type; nextPut: $;;
		nextPutAll: ' nilAllowed: '; store: self nilAllowed; nextPut: $;;
		nextPutAll: ' initBeforeBuilding: '; store: self initBeforeBuilding; nextPut: $;;
		nextPutAll: ' customGeneratedCode: ';
		store: (self generationMode == #default
				ifTrue:[nil]
				ifFalse:[self generatedCode asString]);
		nextPut: $;;
		nextPutAll: ' yourself)'! !

!UIBPropertyFieldModel methodsFor: 'building'!

bindInAspectEnumerator: aUIBAspectEnumerator

	self property bindInAspectEnumerator: aUIBAspectEnumerator withCustomCode: self customCode!

defaultInitializationString

	^self property defaultGeneratedCode!

defaultModel

	^self property defaultModelFromCustomCode: self customCode!

initializationString

	^self generationMode == #custom
		ifTrue:[self generatedCode]
		ifFalse:[self property defaultGeneratedCode]!

isIncompleteForBinding

	^(self property name isNil and:[self nilAllowed not])!

propertyInBuilder: builder

	^self property inBuilder: builder withCustomCode:  self customCode!

setup: componentPropertyAccessor for: uibComponent from: componentSpec afterBuildingIn: builder

	(self property name isNil and:[self nilAllowed]) ifTrue:[^self].
	self initBeforeBuilding
		ifFalse:[uibComponent
				perform: (componentPropertyAccessor , ':') asSymbol
				with: (self propertyInBuilder: builder)]!

setup: componentPropertyAccessor for: uibComponent from: componentSpec beforeBuildingIn: builder

	(self property name isNil and:[self nilAllowed]) ifTrue:[^self].
	self initBeforeBuilding
		ifTrue:[uibComponent
				perform: (componentPropertyAccessor , ':') asSymbol
				with: (self propertyInBuilder: builder)]! !

!UIBPropertyFieldModel methodsFor: 'private'!

customCode

	^self generationMode == #custom ifTrue:[self generatedCode] ifFalse:['']!

defaultProperty

	^(Smalltalk at: self  type) new!

property

	^property" isNil
		ifTrue:[self defaultProperty]
		ifFalse:[property]"!

property: aUIBProperty

	property := aUIBProperty!

setupProperty

	property := self defaultProperty! !

!UIBPropertyFieldModel methodsFor: 'copying'!

postCopy

	super postCopy.
	property := property copy! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertyFieldModel class
	instanceVariableNames: ''!


!UIBPropertyFieldModel class methodsFor: 'accessing'!

propertyTypes
	"Answer an OrderedCollection that holds the various property types associated with their names."

	^(UIBProperty subclasses collect:[:propClass| propClass propertyName -> propClass name]) asSortedCollection:[:x : y| x key <= y key]! !

UIBPropertyModel subclass: #UIBPropertyInputFieldModel
	instanceVariableNames: 'nilAllowed initBeforeBuilding '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBPropertyInputFieldModel methodsFor: 'accessing'!

initBeforeBuilding

	^initBeforeBuilding!

initBeforeBuilding: aBoolean

	initBeforeBuilding := aBoolean!

nilAllowed

	^nilAllowed!

nilAllowed: aBoolean

	nilAllowed := aBoolean! !

!UIBPropertyInputFieldModel methodsFor: 'initialize-release'!

initialize

	super initialize.
	property := nil.
	self
		nilAllowed: false;
		initBeforeBuilding: true! !

!UIBPropertyInputFieldModel methodsFor: 'converting'!

literalArrayEncodingOn: aStream

	"UIBPropertyInputFieldModel new literalArrayEncoding"

	aStream
		nextPut: #name:; nextPut: self name literalArrayEncoding;
		nextPut: #nilAllowed:; nextPut: self nilAllowed;
		nextPut: #initBeforeBuilding:; nextPut: self initBeforeBuilding! !

UIBPalette subclass: #FilesPalette
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-File selection (New)'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FilesPalette class
	instanceVariableNames: ''!


!FilesPalette class methodsFor: 'accessing-specs'!

activeSpecsList

	^#(#FileSelectorSpec)! !

!FilesPalette class methodsFor: 'accessing'!

numberOfColumns

	^5!

paletteName

	^'Files'! !

PositionToolModel subclass: #UIBPositionToolModel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter-Support'!


!UIBPositionToolModel methodsFor: 'actions'!

fullBottom

	bottomOffset value: '0'.
	bottomFraction value: '1'!

fullLeft

	leftOffset value: '0'.
	leftFraction value: '0'!

fullRight

	rightOffset value: '0'.
	rightFraction value: '1'!

fullSize
	"Set a layout to fill the whole window."

	self fullLeft; fullTop; fullRight; fullBottom; noAlignmentX; noAlignmentY!

fullTop

	topOffset value: '0'.
	topFraction value: '0'!

noAlignmentX

	alignmentX value: '0'!

noAlignmentY

	alignmentY value: '0'! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPositionToolModel class
	instanceVariableNames: ''!


!UIBPositionToolModel class methodsFor: 'interface specs'!

propSpec
	"UIPainter new openOnClass: self andSelector: #propSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'UIB Position Tool' 
			#min: #(#Point 237 246 ) 
			#max: #(#Point 407 246 ) 
			#bounds: #(#Rectangle 236 192 473 438 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#CompositeSpecCollection 
					#collection: #(
						#(#LabelSpec 
							#layout: #(#Point 6 0 ) 
							#name: #labelX 
							#flags: 16 
							#label: 'X' ) 
						#(#LabelSpec 
							#layout: #(#Point 6 37 ) 
							#name: #labelY 
							#flags: 16 
							#label: 'Y' ) 
						#(#LabelSpec 
							#layout: #(#Point 0 74 ) 
							#name: #labelInsetX 
							#flags: 16 
							#label: #insetXIcon 
							#hasCharacterOrientedLabel: false ) 
						#(#LabelSpec 
							#layout: #(#Point 0 111 ) 
							#name: #labelInsetY 
							#flags: 16 
							#label: #insetYIcon 
							#hasCharacterOrientedLabel: false ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 7 29 31 160 ) 
						#name: #unboundedLabelGroup ) ) 
				#(#SliderSpec 
					#layout: #(#LayoutFrame 40 0 50 0 0 0.481013 59 0 ) 
					#name: #leftFractionSlider 
					#model: #leftSlide 
					#orientation: #horizontal 
					#start: 0 
					#stop: 1.0 
					#step: 0.0833333 ) 
				#(#SliderSpec 
					#layout: #(#LayoutFrame 40 0 87 0 0 0.481013 96 0 ) 
					#name: #topFractionSlider 
					#model: #topSlide 
					#orientation: #horizontal 
					#start: 0 
					#stop: 1.0 
					#step: 0.0833333 ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 40 0 25 0 0 0.481013 49 0 ) 
					#name: #leftFractionField 
					#model: #leftFraction 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0.531646 25 0 -37 1 49 0 ) 
					#name: #leftOffsetField 
					#model: #leftOffset 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -27 1 27 0 -10 1 47 0 ) 
					#name: #emptyLeftButton 
					#model: #emptyLeft 
					#tabable: true 
					#label: ' ' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 40 0 62 0 0 0.481013 86 0 ) 
					#name: #topFractionField 
					#model: #topFraction 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0.531646 62 0 -37 1 86 0 ) 
					#name: #topOffsetField 
					#model: #topOffset 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -27 1 64 0 -10 1 84 0 ) 
					#name: #emptyTopButton 
					#model: #emptyTop 
					#tabable: true 
					#label: ' ' ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#LabelSpec 
							#layout: #(#Point 0 0 ) 
							#name: #labelLeft 
							#label: 'L' ) 
						#(#LabelSpec 
							#layout: #(#Point 0 37 ) 
							#name: #labelTop 
							#label: 'T' ) 
						#(#LabelSpec 
							#layout: #(#Point 0 74 ) 
							#name: #labelRight 
							#label: 'R' ) 
						#(#LabelSpec 
							#layout: #(#Point 0 111 ) 
							#name: #labelBottom 
							#label: 'B' ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 13 29 25 161 ) 
						#name: #boundedLabelGroup ) ) 
				#(#SliderSpec 
					#layout: #(#LayoutFrame 40 0 124 0 0 0.481013 133 0 ) 
					#name: #rightFractionSlider 
					#model: #rightSlide 
					#orientation: #horizontal 
					#start: 0 
					#stop: 1.0 
					#step: 0.0833333 ) 
				#(#SliderSpec 
					#layout: #(#LayoutFrame 40 0 161 0 0 0.481013 170 0 ) 
					#name: #bottomFractionSlider 
					#model: #bottomSlide 
					#orientation: #horizontal 
					#start: 0 
					#stop: 1.0 
					#step: 0.0833333 ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 40 0 99 0 0 0.481013 123 0 ) 
					#name: #rightFractionField 
					#model: #rightFraction 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0.531646 99 0 -37 1 123 0 ) 
					#name: #rightOffsetField 
					#model: #rightOffset 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -26 1 101 0 -9 1 121 0 ) 
					#name: #emptyRightButton 
					#model: #emptyRight 
					#tabable: true 
					#label: ' ' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 40 0 136 0 0 0.481013 160 0 ) 
					#name: #bottomFractionField 
					#model: #bottomFraction 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0.531646 136 0 -37 1 160 0 ) 
					#name: #bottomOffsetField 
					#model: #bottomOffset 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -26 1 138 0 -9 1 158 0 ) 
					#name: #emptyBottomButton 
					#model: #emptyBottom 
					#tabable: true 
					#label: ' ' ) 
				#(#SliderSpec 
					#layout: #(#LayoutFrame 40 0 124 0 0 0.481013 133 0 ) 
					#name: #alignmentXSlider 
					#model: #alignmentXSlide 
					#orientation: #horizontal 
					#start: 0 
					#stop: 1.0 
					#step: 0.0833333 ) 
				#(#SliderSpec 
					#layout: #(#LayoutFrame 40 0 161 0 0 0.481013 170 0 ) 
					#name: #alignmentYSlider 
					#model: #alignmentYSlide 
					#orientation: #horizontal 
					#start: 0 
					#stop: 1.0 
					#step: 0.0833333 ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 40 0 99 0 0 0.481013 123 0 ) 
					#name: #alignmentXField 
					#model: #alignmentX 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -26 1 101 0 -9 1 121 0 ) 
					#name: #emptyAlignmentXButton 
					#model: #emptyAlignmentX 
					#tabable: true 
					#label: ' ' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 40 0 136 0 0 0.481013 160 0 ) 
					#name: #alignmentYField 
					#model: #alignmentY 
					#menu: #fieldMenu 
					#alignment: #center ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -26 1 138 0 -9 1 158 0 ) 
					#name: #emptyAlignmentYButton 
					#model: #emptyAlignmentY 
					#tabable: true 
					#label: ' ' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 8 0 -54 1 61 0 -30 1 ) 
					#name: #boundedButton 
					#flags: 40 
					#model: #makeBounded 
					#tabable: true 
					#label: #toBoundedIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 8 0 -27 1 61 0 -3 1 ) 
					#name: #unboundedButton 
					#model: #makeUnbounded 
					#tabable: true 
					#label: #toUnboundedIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -54 0.5 -54 1 40 0.5 -30 1 ) 
					#name: #clearOffsetsButton 
					#model: #emptyOffsets 
					#tabable: true 
					#label: 'Clr Offsets' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -54 0.5 -27 1 40 0.5 -3 1 ) 
					#name: #clearAllButton 
					#model: #emptyAllFields 
					#tabable: true 
					#label: 'Clear All' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -74 1 -54 1 -6 1 -30 1 ) 
					#name: #readButton 
					#model: #readMode 
					#tabable: true 
					#label: 'Read' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 0 0.531646 1 0 ) 
					#name: #labelOffset 
					#label: 'Offset' ) 
				#(#LabelSpec 
					#layout: #(#Point 39 1 ) 
					#name: #labelProportion 
					#label: 'Proportion' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -74 1 -27 1 -6 1 -3 1 ) 
					#name: #fullSizeButton 
					#model: #fullSize 
					#tabable: true 
					#label: 'Full Size' ) ) ) )! !

SubCanvasSpec subclass: #UIBCompositeComponentSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components'!
UIBCompositeComponentSpec comment:
'I am the superclass of all composite user-defined specification classes.
I extend the superclass to be able to associate aspects with subcanvasses, in the same way as standard user interface components.

Instance variables:
	none'!


!UIBCompositeComponentSpec methodsFor: 'copying'!

postCopy

	super postCopy.
	self propertiesDo:[:propName : propValue|
		self
			perform: ('set', (String with: propName first asUppercase), (propName copyFrom: 2 to: propName size), ':')  asSymbol
			with: propValue copy]! !

!UIBCompositeComponentSpec methodsFor: 'private'!

finalizeComponentIn: builder

	super finalizeComponentIn: builder.
	(name notNil and:[builder source notNil])
		ifTrue: [builder customComponentAt: name put: builder customComponent]!

model

	|m|
	^(m := self models) isEmpty ifTrue:[#nil] ifFalse:[(m asArray at: 1) property name]!

models

	^((self properties collect:[:propString| self perform: propString asSymbol])
		select:[:instVar|(instVar isKindOf: UIBPropertyFieldModel) "Koen??? and:[instVar isAspectProperty]"]) asSet!

properties
	"Answer a collection of the receiver's specific properties,
	including those in the superclasses under UIBCompositeComponentSpec."

	"By convention, a specification's instance variables are the specification's specific properties,
	thus:"

	^self class allInstVarNames asSet - UIBCompositeComponentSpec allInstVarNames asSet!

propertiesDo: aBlock
	"Evaluate aBlock for each property, passing the name <Symbol> and the value <Object>."

	self properties do:[:propName| aBlock value: propName asSymbol value: (self perform: propName asSymbol)]!

subProperties
	"Answer a collection of the receiver's specific subproperties,
	including those in the superclasses under UIBComponentSpec."

	^(self properties collect:[:propString| self perform: propString asSymbol])
		 select:[:prop| prop isKindOf: UIBSubPropertyFieldModel]! !

!UIBCompositeComponentSpec methodsFor: 'initialize-release'!

initialize

	self majorKey: self class defaultMajorKey.
	self minorKey: self class defaultMinorKey.
	self clientKey: nil.
	self hasBorder: false! !

!UIBCompositeComponentSpec methodsFor: 'building'!

dispatchTo: policy with: builder

	policy applflabCompositeComponent: self into: builder!

overridePropertiesInSpec: aSpec
	"Override properties in aSpec that were modified with UIBSubPropertyFields."

	self subProperties do:[:subProp| subProp overridePropertyInSpec: aSpec]!

setupPropertiesAfterBuildingFor: uibComponent spec: spec builder: builder

	self propertiesDo:
		[:propName : propValue|
		(propValue isKindOf: UIBPropertyModel)
			ifTrue:[propValue initBeforeBuilding
					ifFalse: [propValue setup: propName for: uibComponent from: spec afterBuildingIn: builder]]
			ifFalse:[	"Koen: this is already done in #setupPropertiesBeforeBuildingFor:spec:builder:"
					"uibComponent perform: (propName , ':') asSymbol with: propValue"]]!

setupPropertiesBeforeBuildingFor: uibComponent spec: spec builder: builder

	self minorKey == self class defaultMinorKey ifFalse:[uibComponent minorKey: self minorKey].
	self propertiesDo:
		[:propName : propValue|
		(propValue isKindOf: UIBPropertyModel)
			ifTrue:[propValue initBeforeBuilding
					ifTrue: [propValue setup: propName for: uibComponent from: spec beforeBuildingIn: builder]]
			ifFalse:[uibComponent perform: (propName , ':') asSymbol with: propValue]]! !

!UIBCompositeComponentSpec methodsFor: 'accessing'!

savableSpecFor: implementationComponent
	"This method is invoked when a component is copied with 'Edit>Copy' in a painter view."

	"Make sure that the properties of the result are copies of the original values,
	otherwise a UIBComponent and its copy share the same properties."

	| result |
	result := super savableSpecFor: implementationComponent.
	self propertiesDo:
		[:propName :propValue|
			result perform: ('set' , (String with: propName first asUppercase),
							(propName copyFrom: 2 to: propName size) , ':')  asSymbol
			with: propValue copy].
	^result! !

!UIBCompositeComponentSpec methodsFor: 'private-validation'!

isDataValidFor: aPropertiesTool

	^(self isPropertyFieldDataValidFor: aPropertiesTool)
	and: [self isSimplePropertyDataValidFor: aPropertiesTool]!

isPropertyFieldDataValidFor: aPropertiesTool
	"Koen: in fact not yet implemented."
	"TO DO: Enumerate all IVs and check validity of all UIBPropertyFieldModels."
	"Are checks for UIBSubPropertyFieldModels necessary?"

	^true!

isSimplePropertyDataValidFor: aPropertiesTool
	"Answer a Boolean indicating validity of all non-UIBPropertyFieldModels."
	"Rely on the standard VW message for validity checks."

	^self isDataValid! !

!UIBCompositeComponentSpec methodsFor: 'unused'!

decodeProperties
	"My properties contain literal array encodings. Convert them to values."

	self propertiesDo:
		[:propertyName :propertyValue|
			self
				perform: (propertyName , ':') asSymbol
				with: propertyValue decodeAsLiteralArray]!

myOwnProperties
	"Answer a collection of the receiver's specific properties."

	"By convention, a specification's instance variables are the specification's specific properties,
	thus:"

	^self class instVarNames! !

!UIBCompositeComponentSpec methodsFor: 'converting'!

literalArrayEncoding
	"Make sure that default values for majorKey and minorKey are NOT encoded.
	Encode the name of a property instead of the whole UIBPropertyFieldModel that contains the name, since the receiver knows what the property's settings are anyway."

	| ns inames count val cl a |
	majorKey = self class defaultMajorKey ifTrue:[majorKey := nil].
	minorKey = self class defaultMinorKey ifTrue:[minorKey := nil].
	self checkForNeededSymbolicLabel.
	ns := self numberOfNonNilSlots.
	a := Array new: ns * 2 + 1.
	cl := self class.
	inames := cl allInstVarNames.
	a at: 1 put: cl name.
	count := 2.
	1 to: cl instSize do: [:i | (val := self instVarAt: i) == nil
			ifFalse: 
				[a at: count put: ((inames at: i)
						, ':') asSymbol.
				a at: count + 1 put: (self literalEncodingFor: val).
				count := count + 2]].
	majorKey isNil ifTrue:[majorKey := self class defaultMajorKey].
	minorKey isNil ifTrue:[minorKey := self class defaultMinorKey].
	^a!

literalEncodingFor: aValue

	^((aValue class canUnderstand: #literalArrayEncoding)
		ifTrue: [((aValue isKindOf: UIBPropertyModel)
				ifTrue:[	aValue property] ifFalse:[aValue])]
		ifFalse: [UIBNonEncodableModel on: aValue]) literalArrayEncoding! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBCompositeComponentSpec class
	instanceVariableNames: ''!


!UIBCompositeComponentSpec class methodsFor: 'accessing'!

putSelectorForGetSelector: getSelector

	"self putSelectorForGetSelector: #aspectname"

	 ^(String new writeStream
		nextPutAll: 'set';
		nextPut: getSelector first asUppercase;
		nextPutAll: (getSelector copyFrom: 2 to: getSelector size);
		nextPut: $:;
		contents) asSymbol! !

!UIBCompositeComponentSpec class methodsFor: 'defaults'!

defaultMajorKey
	"Answer the default application class name for the receiver's instances."

	"For subclasses this method is generated by the application builder."

	^self subclassResponsibility!

defaultMinorKey
	"Answer the default spec selector in the application class for the receiver's instances."

	^#windowSpec! !

!UIBCompositeComponentSpec class methodsFor: 'private-interface building'!

adapt: inst forAspect: aspect accessPath: aSequencableCollection channel: aChannel

	^aChannel == nil
		ifTrue: [(AspectAdaptor subject: inst) forAspect: aspect; accessPath: aSequencableCollection]
		ifFalse: [(AspectAdaptor subjectChannel: aChannel) forAspect: aspect; accessPath: aSequencableCollection]!

addBindingsTo: env for: inst channel: aChannel
	"Put other bindings for #minorKey, #majorKey, and #clientKey in the environment env, because the superclass converts their values to Strings and that is certainly not what we want.
	We want to be able to use their values as Symbols in widgets on a properties slice (typically a Radio Button)."

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #minorKey put: (self adapt: inst forAspect: #minorKey channel: aChannel).
	env at: #majorKey put: (self adapt: inst forAspect: #majorKey channel: aChannel).
	env at: #clientKey put: (self adapt: inst forAspect: #clientKey channel: aChannel).!

componentName
	"Answer a String which identifies the component."

	"For subclasses this method is generated by the application builder."

	^self subclassResponsibility!

placementExtent
	"Answer a Point holding the initial extent for the component when dragged from a palette."

	"For subclasses this method is generated by the application builder."

	^self subclassResponsibility!

placementExtentBlock

	^[:bldr | self placementExtent]!

slices
	"Answer an Array that identifies the pages used in the properties tool."

	"For subclasses this method is generated by the application builder."

	^self subclassResponsibility! !

!UIBCompositeComponentSpec class methodsFor: 'resources'!

paletteIcon
	"Answer an Image that serves as palette icon on non-b/w screens."

	"For subclasses this method is generated by the application builder."

	^self subclassResponsibility!

paletteMonoIcon
	"Answer a b/w Image that serves as palette icon on b/w screens."

	"For subclasses this method is generated by the application builder."

	^self subclassResponsibility! !

!UIBCompositeComponentSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Basics' 
			#bounds: #(#Rectangle 24 122 289 446 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #string ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: #componentName ) ) ) )!

defaultComponentSpec
	"UIBPainter new openOnClass: self andSelector: #defaultComponentSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'No Interface' 
			#bounds: #(#Rectangle 148 314 413 638 )  
			#models: #(#UIBAspectDictionary) 
			#adaptors: #(#UIBAspectDictionary)) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )!

defaultPropertiesSpec
	"UIBPainter new openOnClass: self andSelector: #defaultPropertiesSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'No Properties' 
			#bounds: #(#Rectangle 148 314 413 638 ) 
			#models: #(#UIBAspectDictionary) 
			#adaptors: #(#UIBAspectDictionary) ) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )!

detailsEditSpecOLD
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpecOLD"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Details' 
			#bounds: #(#Rectangle 132 137 397 461 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#label: #componentName ) ) ) )! !

!UIBCompositeComponentSpec class methodsFor: 'testing'!

canBeEditedByComponentEditor
	"Answer a Boolean indicating whether UIBComponentEditor can edit the receiver."

	^true! !

UIBCompositeComponentSpec subclass: #UIBAspectEditorSpec
	instanceVariableNames: 'modelSpecs adaptorSpecs availableAspects '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Aspect Editors'!


!UIBAspectEditorSpec methodsFor: 'accessing'!

adaptorSpecs

	^adaptorSpecs == nil
		ifTrue:[adaptorSpecs := (UIBPropertyFieldModel basicNew name: #adaptorSpecs; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: '(IdentityDictionary new: 20) asValue'; yourself)]
		ifFalse:[adaptorSpecs]!

availableAspects

	^availableAspects == nil
		ifTrue:[availableAspects := (UIBPropertyFieldModel basicNew name: #availableAspects; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: '(SortedCollection new: 20) asValue'; yourself)]
		ifFalse:[availableAspects]!

modelSpecs

	^modelSpecs == nil
		ifTrue:[modelSpecs := (UIBPropertyFieldModel basicNew name: #modelSpecs; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: '(SortedCollection new: 20) asValue'; yourself)]
		ifFalse:[modelSpecs]!

setAdaptorSpecs: aValue

	adaptorSpecs := aValue!

setAvailableAspects: aValue

	availableAspects := aValue!

setModelSpecs: aValue

	modelSpecs := aValue! !

!UIBAspectEditorSpec methodsFor: 'decoding'!

adaptorSpecs: aValue

	self adaptorSpecs property: aValue decodeAsLiteralArray!

availableAspects: aValue

	self availableAspects property: aValue decodeAsLiteralArray!

modelSpecs: aValue

	self modelSpecs property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBAspectEditorSpec class
	instanceVariableNames: ''!


!UIBAspectEditorSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#UIBAspectEditor!

defaultMinorKey

	^#propSpec! !

!UIBAspectEditorSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #adaptorSpecs put: (self adapt: inst forAspect: #property accessPath: #(#adaptorSpecs) channel: aChannel).
	env at: #modelSpecs put: (self adapt: inst forAspect: #property accessPath: #(#modelSpecs) channel: aChannel).
	env at: #availableAspects put: (self adapt: inst forAspect: #property accessPath: #(#availableAspects) channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Aspect Editor'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #UIBAspectEditor #specSelector: #propSpec))!

placementExtent

	^150 @ 150!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!UIBAspectEditorSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Aspect Editor-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Aspect Editor' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 71 0 123 0 -13 1 145 0 ) 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #availableAspects 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: '(SortedCollection new: 20) asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 123 0 ) 
					#label: 'Aspects:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 71 0 155 0 -13 1 177 0 ) 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #adaptorSpecs 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: '(IdentityDictionary new: 20) asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 159 0 ) 
					#label: 'Adaptors:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 93 0 ) 
					#label: 'Models:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 71 0 93 0 -13 1 115 0 ) 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #modelSpecs 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: '(SortedCollection new: 20) asValue' ) ) ) ) )! !

!UIBAspectEditorSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K0@@@@@OP@@/J****(=@@B<*"J**#4@@K2 @J**OP@@/J"J*((=@@B< @J*@#4@@K2"J***OP@@/J****(=@@B<@@@@@C4@@K???????P@@/??????=@@B<@@@@@C4@@K2*****OP@@/J("**(=@@B<(@B**#4@@K2("**JOP@@/H@B* H=@@B<("***#4@@K2*****OP@@/@@@@@@=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

UIBCompositeComponentSpec subclass: #FileSelectorSpec
	instanceVariableNames: 'openButtonLabel volumesButtonLabel enablePutBlock filter filename forPut currentSelection '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-File selection (New)'!


!FileSelectorSpec methodsFor: 'accessing'!

currentSelection

	^currentSelection == nil
		ifTrue:[currentSelection := (UIBPropertyFieldModel basicNew name: #currentSelection; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'Filename defaultDirectory asValue'; yourself)]
		ifFalse:[currentSelection]!

enablePutBlock

	^enablePutBlock == nil
		ifTrue:[enablePutBlock := (UIBPropertyFieldModel basicNew name: #enablePutBlock; type: #UIBActionProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: 'true'; yourself)]
		ifFalse:[enablePutBlock]!

filename

	^filename == nil
		ifTrue:[filename := (UIBPropertyFieldModel basicNew name: #filename; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'nil asValue'; yourself)]
		ifFalse:[filename]!

filter

	^filter == nil
		ifTrue:[filter := (UIBPropertyFieldModel basicNew name: #filter; type: #UIBActionProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: 'true'; yourself)]
		ifFalse:[filter]!

forPut

	^forPut == nil ifTrue:[false] ifFalse:[forPut]!

openButtonLabel

	^openButtonLabel == nil ifTrue:[''] ifFalse:[openButtonLabel]!

setCurrentSelection: aValue

	currentSelection := aValue!

setEnablePutBlock: aValue

	enablePutBlock := aValue!

setFilename: aValue

	filename := aValue!

setFilter: aValue

	filter := aValue!

setForPut: aValue

	forPut := aValue!

setOpenButtonLabel: aValue

	openButtonLabel := aValue!

setVolumesButtonLabel: aValue

	volumesButtonLabel := aValue!

volumesButtonLabel

	^volumesButtonLabel == nil
		ifTrue:[volumesButtonLabel := (UIBSubPropertyFieldModel new name: #volumesButtonLabel; minorKey: #windowSpec; customComponentClassName: nil; componentName: #volumesButton; propertyName: #label; yourself)]
		ifFalse:[volumesButtonLabel]! !

!FileSelectorSpec methodsFor: 'decoding'!

currentSelection: aValue

	self currentSelection property: aValue decodeAsLiteralArray!

enablePutBlock: aValue

	self enablePutBlock property: aValue decodeAsLiteralArray!

filename: aValue

	self filename property: aValue decodeAsLiteralArray!

filter: aValue

	self filter property: aValue decodeAsLiteralArray!

forPut: aValue

	forPut := aValue decodeAsLiteralArray!

openButtonLabel: aValue

	openButtonLabel := aValue decodeAsLiteralArray!

volumesButtonLabel: aValue

	self volumesButtonLabel property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FileSelectorSpec class
	instanceVariableNames: ''!


!FileSelectorSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#FileSelector!

defaultMinorKey

	^#windowSpec! !

!FileSelectorSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #openButtonLabel put: (self adapt: inst forAspect: #openButtonLabel channel: aChannel).
	env at: #volumesButtonLabel put: (self adapt: inst forAspect: #property accessPath: #(#volumesButtonLabel) channel: aChannel).
	env at: #filter put: (self adapt: inst forAspect: #property accessPath: #(#filter) channel: aChannel).
	env at: #filename put: (self adapt: inst forAspect: #property accessPath: #(#filename) channel: aChannel).
	env at: #forPut put: (self adapt: inst forAspect: #forPut channel: aChannel).
	env at: #currentSelection put: (self adapt: inst forAspect: #property accessPath: #(#currentSelection) channel: aChannel).
	env at: #enablePutBlock put: (self adapt: inst forAspect: #property accessPath: #(#enablePutBlock) channel: aChannel).!

componentName

	^'File Selector'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #FileSelector #specSelector: #windowSpec) #(#UIBComponentLookAndFeel #specHolderClass: #FileSelector #specSelector: #extendedSpec))!

placementExtent

	^170 @ 100!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Details #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!FileSelectorSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'File Selector-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 10 55 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'File Selector' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 95 ) 
					#label: 'File:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 71 0 95 0 -13 1 117 0 ) 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #filename 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'nil asValue' ) ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 192 ) 
					#model: #forPut 
					#label: 'For Put' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 160 0 -13 1 182 0 ) 
					#model: #openButtonLabel ) 
				#(#LabelSpec 
					#layout: #(#Point 10 133 ) 
					#label: 'Open Button Label:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 71 0 236 0 -13 1 258 0 ) 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #currentSelection 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'Filename defaultDirectory asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 10 214 ) 
					#label: 'Selection:' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'File Selector-Details' 
			#bounds: #(#Rectangle 193 144 458 468 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#label: 'File Selector' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 29 67 ) 
					#model: #minorKey 
					#label: 'Default' 
					#select: #windowSpec ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 29 98 ) 
					#model: #minorKey 
					#label: 'With New Directory Button' 
					#select: #extendedSpec ) 
				#(#GroupBoxSpec 
					#layout: #(#Rectangle 14 38 231 147 ) 
					#label: 'Look' ) 
				#(#LabelSpec 
					#layout: #(#Point 8 155 ) 
					#label: 'Filter (1 argument):' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 69 0 177 0 -15 1 199 0 ) 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #filter 
						#type: #UIBActionProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'true' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 9 217 ) 
					#label: 'Enable Put Button (no argument):' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#LayoutFrame 70 0 239 0 -13 1 261 0 ) 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #enablePutBlock 
						#type: #UIBActionProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'true' ) ) ) ) )! !

!FileSelectorSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K@@@@@@CP@@,??????M@@B3@@@C?<4@@KL???L@3P@@,0@@@??M@@B3?????<4@@KL@@@O?3P@@,3??<<OM@@B3O??3OL4@@KL???OC3P@@,3??<??M@@B3O??30<4@@KL???L<3P@@,3??<<OM@@B3O??3?<4@@KL???OC3P@@,3??<33M@@B3@@@C0<4@@KO?????3P@@,@@@@@@M@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

UIBCompositeComponentSpec subclass: #UIBPropertyComponentSpec
	instanceVariableNames: 'property '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBPropertyComponentSpec methodsFor: 'accessing'!

property

	^property!

setProperty: aProperty

	property := aProperty! !

!UIBPropertyComponentSpec methodsFor: 'decoding'!

property: aPropertyEncoding

	property := aPropertyEncoding decodeAsLiteralArray! !

!UIBPropertyComponentSpec methodsFor: 'building'!

setupPropertiesAfterBuildingFor: propertyField spec: spec builder: builder

	"Do nothing."!

setupPropertiesBeforeBuildingFor: propertyField spec: spec builder: builder

	"Do nothing."! !

!UIBPropertyComponentSpec methodsFor: 'initialize-release'!

initialize

	super initialize.
	property := self propertyModelClass new! !

!UIBPropertyComponentSpec methodsFor: 'private'!

models

	^Set with: self property!

propertyModelClass
	"Return the class that implements the receiver property's model."

	^self subclassResponsibility! !

!UIBPropertyComponentSpec methodsFor: 'copying'!

postCopy

	super postCopy.
	property := property copy! !

!UIBPropertyComponentSpec methodsFor: 'converting'!

literalArrayEncoding
	"The implementation in the superclass is not appropriate since UIBPropertyFieldModels
	do have to be encoded completely in stead of just their names."

	| ns inames count val cl a |
	majorKey = self class defaultMajorKey ifTrue:[majorKey := nil].
	minorKey = self class defaultMinorKey ifTrue:[minorKey := nil].
	self checkForNeededSymbolicLabel.
	ns := self numberOfNonNilSlots.
	a := Array new: ns * 2 + 1.
	cl := self class.
	inames := cl allInstVarNames.
	a at: 1 put: cl name.
	count := 2.
	1 to: cl instSize do: [:i | (val := self instVarAt: i) == nil
			ifFalse: 
				[a at: count put: ((inames at: i)
						, ':') asSymbol.
				a at: count + 1 put: val literalArrayEncoding.
				count := count + 2]].
	majorKey isNil ifTrue:[majorKey := self class defaultMajorKey].
	minorKey isNil ifTrue:[minorKey := self class defaultMinorKey].
	^a! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertyComponentSpec class
	instanceVariableNames: ''!


!UIBPropertyComponentSpec class methodsFor: 'testing'!

canBeEditedByComponentEditor
	"Answer a Boolean indicating whether UIBComponentEditor can edit the receiver."

	^false! !

UIBPropertyComponentSpec subclass: #UIBPropertyFieldSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBPropertyFieldSpec methodsFor: 'private'!

propertyModelClass

	^UIBPropertyFieldModel! !

!UIBPropertyFieldSpec methodsFor: 'building'!

dispatchTo: policy with: builder
	
	| spec subBuilder subEnv state  | 
	spec := self getSubSpecIn: builder.
	self overridePropertiesInSpec: spec.
	subBuilder := builder newSubBuilder.
	builder isEditing "Koen: misschien later de lijst filteren, naargelang welke aspecten toegelaten zijn in de aspect field."
		ifFalse:[	"Koen: dit is nogal een zware operatie (lineair naar het aantal widgets in de UI).
				Misschien moeten we geen ValueHolder gebruiken, maar een ValueModel dat de lijst pas berekent wanneer hij gevraagd wordt
				(wanneer voor het eerst een aspect combo box open geklikt wordt)."
				subBuilder aspectAt: #availableAspects put: builder source availableAspectsHolder.
				subBuilder aspectAt: #availableApplicationModels put: builder source availableApplicationModelsHolder].
	subEnv := (Smalltalk at: majorKey ifAbsent: [self notify: 'component class does not exist.']) new.
	builder customComponent: subEnv.
	self setupPropertiesBeforeBuildingFor: subEnv spec: spec builder: builder.
	subEnv buildInSubCanvas: (UISpecification from: (subEnv property value class perform: minorKey)) withBuilder: subBuilder.
	self setupPropertiesAfterBuildingFor: subEnv spec: spec builder: builder.
	builder component: subBuilder composite.
	builder wrapWith: WidgetStateWrapper new.
	state := builder wrapper widgetState.
	policy manufactureGeneralWrapperFor: self into: builder.
	builder applyLayout: self layout.
	^builder wrapWith: (policy simpleWidgetWrapperOn: builder spec: self state: state)!

setupPropertiesBeforeBuildingFor: propertyField spec: spec builder: builder

	"The PropertiesTool binds the UIBProperty for 'propertyField' in 'builder'.
	So take it from there when not editing."

	propertyField property: 
		(builder isEditing
			ifTrue:[self property property asValue]
			ifFalse:[builder aspectAt: self property name])! !

!UIBPropertyFieldSpec methodsFor: 'private-validation'!

isDataValidFor: aPropertiesTool
	"Test if the data is valid and answer true if it is."

	"Only the generated code must be checked to return an object.
	Note that the property name may be nil in order to allow incremental definition of the property."

	|generatedCodeFieldWrapper|
	aPropertiesTool slice == #Basics ifFalse:[^true].
	self property generationMode == #custom ifFalse:[^true].
	generatedCodeFieldWrapper := aPropertiesTool specEditorComponentNamed:#generatedCodeField.
	self messageNotUnderstoodSignal
		handle:
			[:ex |generatedCodeFieldWrapper widget controller
					selectFrom: 1 to: generatedCodeFieldWrapper widget controller text size.
				generatedCodeFieldWrapper takeKeyboardFocus.
				Dialog warn: 'Apply cancelled due to the following error in the code:\' withCRs , ex errorString.
				 ^false]
		do: [	Compiler new
				evaluate: self property generatedCode in: nil receiver: nil
				notifying: generatedCodeFieldWrapper widget controller
				ifFail: [	generatedCodeFieldWrapper takeKeyboardFocus.
						^false]].
	^true! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertyFieldSpec class
	instanceVariableNames: ''!


!UIBPropertyFieldSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #propertyName put: (self adapt: inst forAspect: #name accessPath: #(#property) channel: aChannel).
	env at: #propertyType put: (self adapt: inst forAspect: #type accessPath: #(#property) channel: aChannel).
	env at: #nilAllowed put: (self adapt: inst forAspect: #nilAllowed accessPath: #(#property) channel: aChannel).
	env at: #initBeforeBuilding put: (self typeConvert: (self adapt: inst forAspect: #initBeforeBuilding accessPath: #(#property) channel: aChannel)).
	env at: #generationMode put: (self adapt: inst forAspect: #generationMode accessPath: #(#property) channel: aChannel).
	env at: #generatedCode put: (self adapt: inst forAspect: #generatedCode accessPath: #(#property) channel: aChannel).
	env at: #typeMenu put: self typeMenu.
	env at: #runtimeStyle put: ((PluggableAdaptor on: (env at: #minorKey))
							getBlock:[:m| m value ~= #editSpec]
							putBlock:[:m :v| m value: (v ifTrue:[#comboEditSpec] ifFalse:[#editSpec])]
							updateBlock:[:m :v :p| true])!

componentName
	"Identification of component"

	^'Property Field'!

placementExtent

	^100 @ 20!

slices
	^#(	(Basics propSpec UIBPropertyFieldSlice)
		(Color propSpec ColorToolModel) 
		(Position propSpec PositionToolModel) )!

typeConvert: aValue

	^(PluggableAdaptor on: aValue)
					getBlock: [:m | m value ifTrue:[#before] ifFalse:[#after]]
					putBlock: [:m :v | m value: v == #before]
					updateBlock: [:b :a :p | false]!

typeMenu
	"Answer a menu used to describe the various types supported by property fields.
	Selecting a menu item will answer a Symbol that indicates the type."

	| mb |
	mb := MenuBuilder new.
	UIBPropertyFieldModel propertyTypes do:[:typ|mb add: typ].
	^mb menuHolder! !

!UIBPropertyFieldSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@K0@@@@@OP@@/J****(=@@B<*"J**#4@@K2 @J**OP@@/J"J*((=@@B< @J*@#4@@K2"J***OP@@/J****(=@@B<@@@@@C4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a'))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 255 255 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 143 255 252 192 136 0 4 192 136 80 4 192 137 248 4 192 136 160 36 192 139 240 116 192 137 64 4 192 136 0 4 192 143 255 252 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 255 255 255 192 255 255 255 192])! !

!UIBPropertyFieldSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#UIBPropertyField!

defaultMinorKey

	^#editSpec! !

UIBPropertyComponentSpec subclass: #UIBSubPropertyFieldSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Property Fields'!


!UIBSubPropertyFieldSpec methodsFor: 'private'!

componentName

	^self property componentName!

componentName: aValue

	self property componentName: aValue.
	self changed: #componentName.
	self changed: #propertyName!

lookAndFeel

	^self property lookAndFeel!

lookAndFeel: aValue

	self property lookAndFeel: aValue.
	self changed: #lookAndFeel.
	self changed: #componentName.
	self changed: #propertyName!

propertyModelClass

	^UIBSubPropertyFieldModel!

propertyName

	^self property propertyName!

propertyName: aValue

	self property propertyName: aValue.
	self changed: #propertyName! !

!UIBSubPropertyFieldSpec methodsFor: 'building'!

dispatchTo: policy with: builder
	
	| spec subBuilder subEnv state |
	
	spec := self getSubSpecIn: builder.
	subBuilder := builder newSubBuilder.
	builder isEditing
		ifFalse:[	|subSpec currentSpecCopy|
				currentSpecCopy := (builder aspectAt: #parentModel) spec.
				self property minorKey: currentSpecCopy minorKey; customComponentClassName: currentSpecCopy majorKey.
				subEnv := (Smalltalk at: majorKey ifAbsent: [self notify: 'component class does not exist.']) new.
				subSpec:= self property subPropertyComponentSpecCopy.
				(spec collection at: 1) hasBorder: subSpec isNil.
				subSpec isNil
					ifFalse:[	((subSpec isKindOf: InputFieldSpec) and:[subSpec menu == #fieldMenu])
								 ifTrue:[subSpec menu: nil]. "PATCH !!!!!!"
							subSpec class addBindingsTo: subBuilder bindings for: subSpec channel: nil.
							subBuilder
								aspectAt: self property propertyName
								put: (builder aspectAt: self property name).
							subSpec layout: (LayoutFrame new rightFraction: 1; bottomFraction: 1).
							subBuilder add: subSpec].
				builder customComponent: subEnv.
				self setupPropertiesBeforeBuildingFor: subEnv spec: spec builder: builder.
				subEnv buildInSubCanvas: spec withBuilder: subBuilder.
				self setupPropertiesAfterBuildingFor: subEnv spec: spec builder: builder]
		ifTrue: [	|subSpec propPainter|
				propPainter := builder composite model.
				self property
					targetComponent: propPainter targetComponent.
					"lookAndFeels: propPainter targetComponent lookAndFeels;
					minorKey: propPainter targetComponent defaultLookAndFeel specSelector;
					customComponentClassName: propPainter targetComponent defaultLookAndFeel specHolderClass."
				subBuilder source: (Smalltalk at: majorKey ifAbsent: [nil]).
				subSpec:= self property subPropertyComponentSpecCopy.
				spec == nil ifFalse: [(spec collection at: 1) hasBorder: subSpec isNil.
								subBuilder add: spec.].
				subSpec isNil
					ifFalse:[	subSpec layout: (LayoutFrame new rightFraction: 1; bottomFraction: 1).
							subBuilder add: subSpec]].
	builder component: subBuilder composite.
	builder wrapWith: WidgetStateWrapper new.
	state := builder wrapper widgetState.
	policy manufactureGeneralWrapperFor: self into: builder.
	builder applyLayout: self layout.
	^builder wrapWith: (policy simpleWidgetWrapperOn: builder spec: self state: state)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBSubPropertyFieldSpec class
	instanceVariableNames: ''!


!UIBSubPropertyFieldSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#UIBSubPropertyField! !

!UIBSubPropertyFieldSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/??????=@@B???????4@@K@@@@@@CP@@,??????M@@B3?????<4@@KL@@@@@3P@@,2****#M@@B3J("**L4@@KL(@B*(3P@@,2("*"#M@@B3H@B(BL4@@KL("**(3P@@,2****#M@@B3@@@@@L4@@KO?????3P@@,??????M@@B0@@@@@@4@@K???????P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a'))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 255 255 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 159 255 254 192 144 0 2 192 144 0 2 192 151 255 250 192 148 0 10 192 148 40 10 192 148 252 10 192 148 80 74 192 149 248 234 192 148 160 10 192 148 0 10 192 151 255 250 192 144 0 2 192 144 0 2 192 159 255 254 192 128 0 0 192 128 0 0 192 128 0 0 192 255 255 255 192 255 255 255 192])! !

!UIBSubPropertyFieldSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #subPropertyName put: (self adapt: inst forAspect: #name accessPath: #(#property) channel: aChannel).
	env at: #componentName put: ((self adapt: inst forAspect: #componentName channel: aChannel) subjectSendsUpdates: true).
	env at: #propertyName put: ((self adapt: inst forAspect: #propertyName channel: aChannel) subjectSendsUpdates: true).
	env at: #lookAndFeel put: ((self adapt: inst forAspect: #lookAndFeel channel: aChannel) subjectSendsUpdates: true).
	env at: #componentNameMenu put: inst property componentNameMenu .
	env at: #propertyNameMenu put: inst property propertyNameMenu.
	env at: #lookAndFeelMenu put: inst property lookAndFeelMenu.!

componentName
	"Identification of component"

	^'Subproperty Field'!

placementExtent

	^100 @ 25!

slices
	^#(	(Basics basicsEditSpec)
		(Color propSpec ColorToolModel) 
		(Position propSpec PositionToolModel) )! !

!UIBSubPropertyFieldSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'SubProperty Field' 
			#bounds: #(#Rectangle 87 115 352 428 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 4 0 0.5 0 ) 
					#name: #componentNameField 
					#label: 'Subproperty Field' ) 
				#(#LabelSpec 
					#layout: #(#Point 12 183 ) 
					#name: #componentLabel 
					#label: 'Component:' ) 
				#(#LabelSpec 
					#layout: #(#Point 12 245 ) 
					#name: #componentPropertyLabel 
					#label: 'Component''s Property:' ) 
				#(#MenuButtonSpec 
					#layout: #(#Rectangle 12 202 236 228 ) 
					#name: #componentNameMenu 
					#model: #componentName 
					#menu: #componentNameMenu ) 
				#(#MenuButtonSpec 
					#layout: #(#Rectangle 12 267 236 291 ) 
					#name: #propertyNameMenu 
					#model: #propertyName 
					#menu: #propertyNameMenu ) 
				#(#LabelSpec 
					#layout: #(#Point 10 48 ) 
					#name: #propertyLabel 
					#label: 'Property:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 74 46 234 69 ) 
					#name: #propertyNameField 
					#model: #subPropertyName 
					#type: #symbol ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 74 82 234 105 ) 
					#name: #nameField 
					#model: #name 
					#type: #string ) 
				#(#LabelSpec 
					#layout: #(#Point 10 82 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#LabelSpec 
					#layout: #(#Point 11 130 ) 
					#name: #lookAndFeelLabel 
					#label: 'Look And Feel:' ) 
				#(#MenuButtonSpec 
					#layout: #(#Rectangle 12 149 236 175 ) 
					#name: #lookAndFeelMenu 
					#model: #lookAndFeel 
					#menu: #lookAndFeelMenu ) ) ) )! !

UIBProperty subclass: #UIBMenuProperty
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Properties'!


!UIBMenuProperty methodsFor: 'accessing'!

inBuilder: builder withCustomCode: aString
	"Code stolen from MenuComponentSpec."

	| m |
	name == nil ifTrue: [^nil].
	m := builder menuAt: name.
	m == nil ifFalse: [^m].
	builder isEditing ifFalse: [^builder raiseErrorMessage: 'menu binding: <1p> not found!!' with: name].
	^m! !

!UIBMenuProperty methodsFor: 'private'!

defaultModel

	| mb |
	mb := MenuBuilder new.
	mb add: 'Item 1' -> #item1; add: 'Item 2' -> #item2.
	^mb menuHolder! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBMenuProperty class
	instanceVariableNames: ''!


!UIBMenuProperty class methodsFor: 'accessing'!

propertyName

	^'Menu'! !

UIBCanvas subclass: #UIBSlice
	instanceVariableNames: 'sliceLabel subSpecID targetClass '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources'!
UIBSlice comment:
'I represent the canvas of a slice in a properties tool. I act as model for UIBPropertiesPainters.
I hold onto all information provided by one element of the result of a #slices message to a specification class (see there). This information lays down how and where the slice''s user interface must be fetched.

Instance variables:
	sliceLabel	<String>	The name of the slice (used in the tabs of a properties tool).
	subSpecID	<Symbol|nil>	
	targetClass	<Class|nil>	'!


!UIBSlice methodsFor: 'printing'!

displayString

	^self sliceLabel!

printOn: aStream

	aStream nextPutAll: self class name; crtab.
	self sliceLabel printOn: aStream.
	aStream crtab.
	self specSelector printOn: aStream.
	aStream crtab.
	self specHolderClass printOn: aStream.
	aStream crtab.
	self subSpecID printOn: aStream.
	aStream cr! !

!UIBSlice methodsFor: 'converting'!

literalSlice
	"Answer an Array describing the receiver that can be used by VisualWorks."

	"UIBSlice new literalSlice"

	|sliceArray|
	sliceArray := Array new:
				(self subSpecID isNil
					ifTrue:[self specHolderClass isNil ifTrue:[2] ifFalse:[3]]
					ifFalse:[4]).
	sliceArray
		at: 1 put: self sliceLabel asSymbol;
		at: 2 put: self specSelector.
	sliceArray size >= 3 ifTrue:[sliceArray at: 3 put: self specHolderClass].
	sliceArray size >= 4 ifTrue:[sliceArray at: 4 put: self subSpecID].
	^sliceArray! !

!UIBSlice methodsFor: 'testing'!

isSimple

	^self subSpecID isNil and:[self specHolderClass isNil]! !

!UIBSlice methodsFor: 'accessing'!

sliceLabel

	^sliceLabel!

sliceLabel: aString

	sliceLabel := aString!

subSpecID

	^subSpecID!

subSpecID: aSymbol

	aSymbol = subSpecID ifTrue:[^self].
	subSpecID := aSymbol.
	inconsistent :=true!

targetClass

	^targetClass!

targetClass: aSpecClass

	targetClass := aSpecClass.
	"inconsistent :=true"! !

!UIBSlice methodsFor: 'initialize-release'!

fromSliceArray: aSliceArray
	"Initialize the receiver with the values found in aSliceArray,
	an Array returned by the #slices method of a specification class."

	"No write accessor self sends here to avoid unneccessary updates!!"

	sliceLabel := (aSliceArray at: 1) asString.
	specSelector := aSliceArray at: 2.
	specHolderClass := (aSliceArray size >= 3 ifTrue:[aSliceArray at: 3] ifFalse:[nil]).
	subSpecID := (aSliceArray size >= 4 ifTrue:[aSliceArray at: 4] ifFalse:[nil])! !

!UIBSlice methodsFor: 'private'!

fetchFullSpec
	"Since the meaning of the contents of a slice array is not documented,
	the implementation below is based on information compiled while
	reading several methods in the Smalltalk system, and can be incomplete
	wrt. the use of subspec identifiers."

	| aFullSpec |
	aFullSpec := UISpecification from:
	(specSelector isNil
		ifTrue:[UIBCompositeComponentSpec defaultPropertiesSpec]
		ifFalse:[subSpecID isNil
				ifFalse: [self targetClass isNil
						ifTrue:[UIBCompositeComponentSpec defaultPropertiesSpec]
						ifFalse:[specHolderClass isNil
								ifTrue: [(targetClass new subSpecFor: subSpecID) class perform: specSelector]
								ifFalse:[(Smalltalk at: specHolderClass) perform: specSelector]]]
				ifTrue: [
					specHolderClass notNil
					ifTrue: [((Smalltalk at: specHolderClass) class canUnderstand: specSelector)
						ifTrue:[(Smalltalk at: specHolderClass) perform: specSelector]
						ifFalse:[UIBCompositeComponentSpec defaultPropertiesSpec]]
					ifFalse: [(self targetClass notNil and:[self targetClass class canUnderstand: specSelector])
						ifTrue:[self targetClass perform: specSelector]
						ifFalse:[(UIBCompositeComponentSpec class canUnderstand: specSelector)
								ifTrue:[UIBCompositeComponentSpec perform: specSelector]
								ifFalse:[UIBCompositeComponentSpec defaultPropertiesSpec]]]]]).
	specHolderClass notNil
		ifTrue:[aFullSpec window: (FullSpec decodeFromLiteralArray: UIBCompositeComponentSpec defaultPropertiesSpec) window].
	^aFullSpec!

oldFetchFullSpec

	| specLiteral aFullSpec |
	specSelector isNil
		ifTrue:[specLiteral := UIBCompositeComponentSpec defaultPropertiesSpec]
		ifFalse:[specHolderClass notNil
				ifTrue: [((Smalltalk at: specHolderClass) class canUnderstand: specSelector)
						ifTrue:[specLiteral := (Smalltalk at: specHolderClass) perform: specSelector]
						ifFalse:[specLiteral := UIBCompositeComponentSpec defaultPropertiesSpec]]
				ifFalse: [(self targetClass notNil and:[self targetClass class canUnderstand: specSelector])
						ifTrue:[specLiteral := self targetClass perform: specSelector]
						ifFalse:[(UIBCompositeComponentSpec class canUnderstand: specSelector)
								ifTrue:[specLiteral := UIBCompositeComponentSpec perform: specSelector]
								ifFalse:[specLiteral := UIBCompositeComponentSpec defaultPropertiesSpec]]]].
	aFullSpec := (FullSpec decodeFromLiteralArray: specLiteral).
	specHolderClass notNil
		ifTrue:[aFullSpec window: (FullSpec decodeFromLiteralArray: UIBCompositeComponentSpec defaultPropertiesSpec) window].
	^aFullSpec!

specFromLiteral: specLiteral

	^FullSpec decodeFromLiteralArray: specLiteral!

windowLabelSuffix

	^self sliceLabel! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBSlice class
	instanceVariableNames: ''!


!UIBSlice class methodsFor: 'instance creation'!

fromSliceArray: aSliceArray forTargetClass: targetClass

	^self new
		fromSliceArray: aSliceArray;
		targetClass: targetClass!

fromSliceArray: aSliceArray forTargetClass: targetClass forComponentName: componentName

	^self new
		fromSliceArray: aSliceArray;
		targetClass: targetClass";
		componentName: componentName"! !

!UIBSlice class methodsFor: 'defaults'!

defaultPropertiesSpec
	"UIBPainter new openOnClass: self andSelector: #defaultPropertiesSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'No Properties' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #() ) )! !

!UIBSlice class methodsFor: 'accessing'!

slicesOf: specClass
	"Answer an OrderedCollection of UIBSlices fetched from specClass."

	"self slicesOf: ActionButtonSpec"

	^(specClass slices
		collect:[:sliceDef |
				UIBSlice
					fromSliceArray: sliceDef
					forTargetClass: specClass
					"forComponentName: specClass componentName"])
		asOrderedCollection! !

SimpleDialog subclass: #UIBResourceSelectorDialog
	instanceVariableNames: 'resourceSelector '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources-UI'!


!UIBResourceSelectorDialog methodsFor: 'accessing'!

resourceSelector
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^resourceSelector isNil
		ifTrue:
			[resourceSelector := UIBResourceSelectorWithButtons new]
		ifFalse:
			[resourceSelector]! !

!UIBResourceSelectorDialog methodsFor: 'initialize-release'!

initialize

	super initialize.
	resourceSelector := UIBResourceSelectorWithButtons new.
	resourceSelector acceptChannel: [:bool| bool ifTrue:[self accept value: true] ifFalse:[self cancel value: true]]!

release

	resourceSelector release.
	super release.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBResourceSelectorDialog class
	instanceVariableNames: ''!


!UIBResourceSelectorDialog class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'Resource Selector Dialog' 
			#bounds: #(#Rectangle 202 160 467 341 ) 
			#models: #(#UIBAspectDictionary ) 
			#adaptors: #(#UIBAspectDictionary ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#flags: 0 
					#majorKey: #UIBResourceSelectorWithButtons 
					#minorKey: #windowSpec 
					#clientKey: #resourceSelector ) ) ) )! !

!UIBResourceSelectorDialog class methodsFor: 'interface opening'!

openOnResource: aUIBResourceLocation
	"Open a dialog on aUIBResourceLocation.
	Only change aUIBResourceLocation when the dialog is accepted.
	Answer a boolean indicating acceptance."

	"|resource| self openOnResource: (resource := UIBResourceLocation new). resource inspect"

	| anInstance result |
	(anInstance := self new) resourceSelector resourceLocation: aUIBResourceLocation copy.
	(result := self openOn: anInstance withSpec: #windowSpec)
		ifTrue:[aUIBResourceLocation specHolderClass: anInstance resourceSelector resourceLocation specHolderClass.
				aUIBResourceLocation specSelector: anInstance resourceSelector resourceLocation specSelector].
	anInstance release. "Koen: waarom moet dit hier gebeuren ? Waarom worden ApplicationModels niet onmiddelijk gereleased?"
	^result!

openOnResource: aUIBResourceLocation desiredResourceTypes: desiredResourceTypesSet
	"Open a dialog on aUIBResourceLocation.
	Only change aUIBResourceLocation when the dialog is accepted.
	Answer a boolean indicating acceptance."

	"|resource| self openOnResource: (resource := UIBResourceLocation new) desiredResourceTypes: (Set with: #image). resource inspect"

	| anInstance result |
	(anInstance := self new) resourceSelector resourceLocation: aUIBResourceLocation copy.
	anInstance resourceSelector desiredResourceTypes: desiredResourceTypesSet.
	(result := self openOn: anInstance withSpec: #windowSpec)
		ifTrue:[aUIBResourceLocation specHolderClass: anInstance resourceSelector resourceLocation specHolderClass.
				aUIBResourceLocation specSelector: anInstance resourceSelector resourceLocation specSelector].
	anInstance release. "Koen: waarom moet dit hier gebeuren ? Waarom worden ApplicationModels niet onmiddelijk gereleased?"
	^result!

openOnResourceHolder: aUIBResourceLocationHolder

	| anInstance |
	(anInstance := self new) resourceSelector resourceLocation: aUIBResourceLocationHolder value copy.
	(self openOn: anInstance withSpec: #windowSpec)
		ifTrue:[aUIBResourceLocationHolder value: anInstance resourceSelector resourceLocation]! !

TabBarViewOOP subclass: #VerticalTabBarViewOOP
	instanceVariableNames: ''
	classVariableNames: 'DownScrollButtonImage TopMask UpScrollButtonImage '
	poolDictionaries: ''
	category: 'UIB-Support'!


!VerticalTabBarViewOOP methodsFor: 'displaying'!

displayInteriorRectangularBorderOn: aGC in: rt selected: aBoolean
	"Display a rectangular border such that it is contained by aRectangle." 
	| left bottom  right top corner   leftAdjust |
	left := rt left   .
	bottom := rt bottom .
	right := rt right .
	top := rt top .
	aBoolean 
		ifTrue: [leftAdjust := 1]
		ifFalse: [leftAdjust := 0].
	corner := 2.
	aGC paint: self borderColor.
		aGC displayLineFrom: (left@(top )  ) to: ((right - corner)@(top)) .
		aGC displayLineFrom: ((right - corner)@(top )) to: ((right)@(top+ corner )) .
		aGC displayLineFrom:  ((right)@(top+ corner  )) to:  ((right  )@(bottom - corner )) .
		aGC displayLineFrom: ((right )@(bottom - corner  )) to:  ((right - corner) @ (bottom)) .
		aGC displayLineFrom: (((right - corner)@(bottom   ))) to: (left @ (bottom )) .
	aGC paint: ColorValue white.
		aGC displayLineFrom: ((left)@(top + 1)) to: ((right - corner)@(top +1)) . 
	aGC paint: ColorValue lightGray.
		aGC displayLineFrom:  ((right - corner  )@(top + 1 )) to:  ((right - 1)@(top + corner + 1)).
		aGC displayLineFrom: (((right-1)@(top + corner))) to: ((right-1) @ (bottom - corner)) .
 		aGC displayLineFrom: (((right-1)@(bottom - corner))) to: ((right-corner) @ (bottom - 1)) . 
		aGC displayLineFrom: (((right-corner)@(bottom -1))) to: ((left) @ (bottom - 1)) . 
	"<<BIKI at the bottom of a mountain: 6 January 1996,11:21:10 pm, version: 26>>"!

displayOn2: aGraphicsContext
	"Display self on the GraphicsContext."

	| bounds box left clippingBox dt db visibleIndexInterval hasBackgroundColor |
	hasBackgroundColor := state isOpaque or: [state hasBackgroundColor].
	self validateScrollPosition.
	bounds := self bounds.
	hasBackgroundColor
		ifTrue: [aGraphicsContext paint: self backgroundColor.
				TopMask displayOn: aGraphicsContext.
				aGraphicsContext displayRectangle: (0@18 corner: 18@(bounds bottom -2))].
	box := bounds copy.
	box bottom: box bottom - 20.
	left := nil.
	clippingBox := aGraphicsContext clippingBounds.
	dt := clippingBox top <= (bounds top + 18).
	db := clippingBox bottom >= (bounds bottom - 19).
	aGraphicsContext paint: self borderColor.
	14 to: 1 by: -2 do: [:i | 
		"Displaying the page edges."
		| bt bb |
		bt := box top.
		bb := box bottom.
		i = 1 ifTrue: [box bottom: box bottom + 1].
		box left: i - 1.
		box right: i.
		aGraphicsContext displayRectangle: box.
		(leftSpine and: [i ~= 16 and: [dt]]) ifTrue: [
			aGraphicsContext displayRectangle: (0 @ bt corner: box left @ (bt + 1))].
		(i ~= 14 and: [db]) ifTrue: [
			aGraphicsContext displayRectangle: (left @ bb corner: box left @ bb + 1)].
		left := box left.
		box top: bt + 2.
		box bottom: bb + 2].
	leftSpine ifFalse: [
		aGraphicsContext displayLineFrom: 0 @ 0 to: 18 @ 18].
	self numberOfElements = 0 ifTrue: [^self].
	visibleIndexInterval := self visibleIntervalForBounds: clippingBox inBounds: bounds.
	visibleIndexInterval first to: visibleIndexInterval last do: [:i | 
		box := self boundsOfElementIndex: i inBounds: bounds.
		box bottom: box bottom - 3.
		aGraphicsContext paint: self borderColor.
		aGraphicsContext displayInteriorRectangularBorder: box.
		box := box insetBy: (Rectangle left: 0 right: 2 top: 1 bottom: 1).
		aGraphicsContext paint: self tabColor.
		aGraphicsContext displayRectangle: box.
		aGraphicsContext paint: self foregroundColor.
		(self visualComponentForElementIndex: i inBounds: box) displayOn: aGraphicsContext copy].
	self isScrollingTabs ifTrue: [
		hasBackgroundColor
			ifTrue: [aGraphicsContext paint: self backgroundColor.
					aGraphicsContext
						displayRectangle: (self decrementTabButtonBox origin extent: UpScrollButtonImage extent).
					aGraphicsContext
						displayRectangle: (self incrementTabButtonBox origin extent: DownScrollButtonImage extent)].
		aGraphicsContext paint: self scrollButtonColor.
		UpScrollButtonImage displayOn: aGraphicsContext at: self decrementTabButtonBox origin.
		DownScrollButtonImage displayOn: aGraphicsContext at: self incrementTabButtonBox origin]

	"<<BIKI at the bottom of a mountain: 2 January 1996,10:52:37 am, version: 7>>"!

displayOn: aGraphicsContext
	"Display self on the GraphicsContext."

	| bounds box  clippingBox   visibleIndexInterval hasBackgroundColor |
	hasBackgroundColor := state isOpaque or: [state hasBackgroundColor].
	self validateScrollPosition.
	bounds := self bounds.
	hasBackgroundColor
		ifTrue: [aGraphicsContext paint: self backgroundColor.
				TopMask displayOn: aGraphicsContext.
				aGraphicsContext displayRectangle: (0@18 corner: 18@(bounds bottom -2))].
	box := bounds copy.
	box bottom: box bottom - 13.
	clippingBox := aGraphicsContext clippingBounds.
	clippingBox top <= (bounds top + 18).
	clippingBox bottom >= (bounds bottom - 19).
	aGraphicsContext paint: self borderColor.
 		aGraphicsContext displayLineFrom: bounds left @ (bounds top+ 13) to: bounds left @ bounds bottom . 

	self numberOfElements = 0 ifTrue: [^self].
	visibleIndexInterval := self visibleIntervalForBounds: clippingBox inBounds: bounds.
	visibleIndexInterval first to: visibleIndexInterval last do: [:i | 
		box := self boundsOfElementIndex: i inBounds: bounds.
		box bottom: box bottom - 2.
		aGraphicsContext paint: self borderColor.
		self displayInteriorRectangularBorderOn: aGraphicsContext in: box selected: i = selectionIndex.
		box := box insetBy: (Rectangle left: 0 right: 2 top: 2 bottom: 1).
		aGraphicsContext paint: self tabColor.
		aGraphicsContext displayRectangle: box.
		aGraphicsContext paint: self foregroundColor.
		(self visualComponentForElementIndex: i inBounds: box) displayOn: aGraphicsContext copy].
	self isScrollingTabs ifTrue: [
		hasBackgroundColor
			ifTrue: [aGraphicsContext paint: self backgroundColor.
					aGraphicsContext
						displayRectangle: (self decrementTabButtonBox origin extent: UpScrollButtonImage extent).
					aGraphicsContext
						displayRectangle: (self incrementTabButtonBox origin extent: DownScrollButtonImage extent)].
		aGraphicsContext paint: self scrollButtonColor.
		UpScrollButtonImage displayOn: aGraphicsContext at: self decrementTabButtonBox origin.
		DownScrollButtonImage displayOn: aGraphicsContext at: self incrementTabButtonBox origin].
	 
	"<<BIKI at the bottom of a mountain: 6 January 1996,11:22:44 pm, version: 17>>"! !

!VerticalTabBarViewOOP methodsFor: 'private'!

boundsOfElementIndex: anElementIndex inBounds: aRectangle
	"Answer the bounding box of line anElementIndex."

	| lineGrid tabWidth scrollButtonMargin level tabScrollPositionOffset |
	level := self levelOfElement: anElementIndex.
	lineGrid := self lineGrid.
	tabWidth := aRectangle width - 18.
	self isScrollingTabs
		ifTrue: [
			scrollButtonMargin := self tabScrollButtonMargin.
			tabScrollPositionOffset := tabScrollPosition - 1]
		ifFalse: [
			scrollButtonMargin := 0.
			tabScrollPositionOffset := 0].
	^Rectangle
		origin: (level*2)@((anElementIndex - tabScrollPositionOffset - 1 * lineGrid) + self topOffsetForDisplay + scrollButtonMargin)
		extent: tabWidth@lineGrid

	"<<BIKI at the bottom of a mountain: 6 January 1996,11:21:59 pm, version: 2>>"!

levelOfElement: index 
	^index == selectionIndex
		ifTrue: [0]
		ifFalse: [1]  

	"<<BIKI at the bottom of a mountain: 6 January 1996,11:26:38 pm, version: 2>>"!

visibleIntervalForBounds: aRectangle inBounds: bounds
	"Answer the Interval of indexes in the receiver that are visible in the bounds of the given rectangle."

	| first lineGrid last scrollButtonMargin tabScrollPositionOffset  rt rb usableHeight |
	lineGrid := self lineGrid.
	self isScrollingTabs
		ifTrue: [
			scrollButtonMargin := self tabScrollButtonMargin.
			tabScrollPositionOffset := tabScrollPosition - 1]
		ifFalse: [
			scrollButtonMargin := 0.
			tabScrollPositionOffset := 0].
	rt :=  bounds top.
	rb :=  bounds bottom - self bottomOffsetForDisplay - scrollButtonMargin.
	first := (((rt - self topOffsetForDisplay - scrollButtonMargin) max: 0) // lineGrid +1)  + tabScrollPositionOffset.
	last := (((rb - self topOffsetForDisplay - scrollButtonMargin) max: 0) // lineGrid+1) + tabScrollPositionOffset.
	usableHeight := bounds height - self topOffsetForDisplay - self bottomOffsetForDisplay - scrollButtonMargin.
	last := last min: (tabScrollPositionOffset+ (usableHeight // lineGrid)).
	last := last min: self numberOfElements.
	^first to: last! !

!VerticalTabBarViewOOP methodsFor: 'private-tab scrolling'!

computeTabScrollPositionFor: anIndex
	"Compute the proper value for the tab scroll position."
	"The current tabScrollPosition may indicate the last valid tab scroll position."

	| boundsHeight usableHeight possibleTabs totalTabs |
	boundsHeight := self bounds height.
	usableHeight := boundsHeight - self topOffsetForDisplay - self bottomOffsetForDisplay.
	possibleTabs := usableHeight // self lineGrid.
	totalTabs := self numberOfElements.
	totalTabs > possibleTabs
		ifFalse: [tabScrollPosition := 0]
		ifTrue: [
			| end |
			tabScrollPosition = 0 ifTrue: [tabScrollPosition := 1].
			usableHeight := usableHeight - self tabScrollButtonMargin.
			possibleTabs := usableHeight // self lineGrid.
			end := (tabScrollPosition + possibleTabs - 1) min: totalTabs.
			tabScrollPosition :=
				(anIndex between: tabScrollPosition and: end )
					ifTrue: [tabScrollPosition]
					ifFalse: [(anIndex > end
								ifTrue: [tabScrollPosition + (anIndex - end)]
								ifFalse: [anIndex]) max: 1]].
	tabScrollPositionKnown := true

	"<<BIKI at the bottom of a mountain: 5 January 1996,2:41:28 pm, version: 1>>"!

decrementTabButtonBox
	"Answer the rectangle bounds of the tab scrolling button that decrements the tabScrollingPosition."

	^Rectangle origin: self bounds topLeft + (20@18) extent: UpScrollButtonImage extent!

incrementTabButtonBox
	"Answer the rectangle bounds of the tab scrolling button that increments the tabScrollingPosition."

	^Rectangle origin: self bounds bottomLeft + (20@-14) extent: DownScrollButtonImage extent!

invalidateTabsForScrolling
	"Invalidate the area where the tabs are displayed because they are being scrolled."

	self invalidateRectangle: (self bounds insetBy: (
		Rectangle left: 0 right: 0
			top: self topOffsetForDisplay + self tabScrollButtonMargin
			bottom: 0))!

tabScrollPositionIncrement
	"The tab scroll button to increment the tabScrollButton has been pressed.  Take the appropriate action."

	| usableHeight possibleTabs maxTabScrollPosition |
	usableHeight :=self bounds height - self topOffsetForDisplay - (self tabScrollButtonMargin * 2).
	possibleTabs := usableHeight // self lineGrid.
	maxTabScrollPosition := self numberOfElements - (possibleTabs - 1) min: self numberOfElements.
	tabScrollPosition >= maxTabScrollPosition ifTrue: [^self].
	tabScrollPosition := tabScrollPosition + 1.
	self invalidateTabsForScrolling! !

!VerticalTabBarViewOOP methodsFor: 'accessing'!

selectionIndex: elementIndex
	"Set the index of the selected item.
	If elementIndex is not zeroIndex then move the target index to
	correspond to the new selection index.  If the elementIndex is
	the zeroIndex then leave the target index where it was."

	| tb bb top bottom box old gc|
	((selectionIndex = elementIndex) or: [sequence == nil]) ifTrue: [^self].
	box := self bounds.
	old := selectionIndex max: 1.
	selectionIndex := elementIndex max: 1.
	self numberOfElements = 0 ifTrue: [^self invalidate].
	old < selectionIndex
		ifTrue: [top := old.
				bottom := selectionIndex + 6 min: self numberOfElements]
		ifFalse: [top := selectionIndex.
				bottom := old + 6 min: self numberOfElements].
	tb := self boundsOfElementIndex: top inBounds: box.
	bb := self boundsOfElementIndex: bottom inBounds: box.
	box := box left@tb top corner: box right@(bb bottom).
	(state isOpaque or: [state hasBackgroundColor]) 
		ifTrue: [^self invalidateRectangle: box repairNow: true].
	gc := self graphicsContext.
	gc paint: self backgroundColor.
	gc displayRectangle: box.
	gc paint: self foregroundColor.
	self displayOn: gc.! !

!VerticalTabBarViewOOP methodsFor: 'constants'!

bottomOffsetForDisplay
	"Answer the offset in pixels to begin displaying the tabs from the bottom of the component."

	^18!

topOffsetForDisplay
	"Answer the offset in pixels to begin displaying the tabs from the top of the component."

	^22! !

!VerticalTabBarViewOOP methodsFor: 'element accessing'!

elementIndexFor: aPoint
	"Answer the index of the element positioned relative to aPoint, counting from zero."

	| scrollButtonMargin tabScrollPositionOffset |
	self isScrollingTabs
		ifTrue: [
			scrollButtonMargin := self tabScrollButtonMargin.
			tabScrollPositionOffset := tabScrollPosition - 1]
		ifFalse: [
			scrollButtonMargin := 0.
			tabScrollPositionOffset := 0].
	^(aPoint y - self topOffsetForDisplay - scrollButtonMargin) // self lineGrid + 1 + tabScrollPositionOffset! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VerticalTabBarViewOOP class
	instanceVariableNames: ''!


!VerticalTabBarViewOOP class methodsFor: 'resources'!

downArrowSmallImage
	"UIMaskEditor new openOnClass: self andSelector: #downArrowSmallImage"

	<resource: #image>
	^CachedImage on: (Image extent: 11@6 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 2 put: ColorValue black; at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); yourself)) usingBits: #[170 170 168 0 192 0 4 0 240 0 28 0 252 0 124 0 255 1 252 0 255 199 252 0])

	"<<BIKI lost in space: 27 February 1996,11:37:03 am, version: 1>>"!

upArrowSmallImage
	"UIMaskEditor new openOnClass: self andSelector: #upArrowSmallImage"

	<resource: #image>
	^CachedImage on: (Image extent: 11@6 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 2 put: ColorValue black; at: 3 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); at: 4 put: ColorValue white; yourself)) usingBits: #[170 202 168 0 171 2 168 0 172 0 168 0 176 0 40 0 192 0 8 0 85 85 84 0])

	"<<BIKI lost in space: 27 February 1996,11:35:41 am, version: 1>>"! !

!VerticalTabBarViewOOP class methodsFor: 'initialization'!

initialize
	"Initialize the receiver."
	"VerticalTabBarView initialize."

	UpScrollButtonImage := self upArrowSmallImage.
	DownScrollButtonImage :=self downArrowSmallImage.
	TopMask := CachedImage on: ((Image extent: 18@18 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 224 0 0 0 224 0 0 0 224 0 0 0 252 0 0 0 252 0 0 0 252 0 0 0 255 128 0 0 255 128 0 0 255 128 0 0 255 240 0 0 255 240 0 0 255 240 0 0 255 254 0 0 255 254 0 0 255 254 0 0 ]))! !

!VerticalTabBarViewOOP class methodsFor: 'private'!

upScrollButtonImage

	"Answer the Image used for the up scrolling button.
	This is a privileged message used only by HorizontalTabBarView."

	UpScrollButtonImage == nil ifTrue: [self initialize].
	^UpScrollButtonImage image! !

UIBApplicationModel subclass: #UIBResourceSelector
	instanceVariableNames: 'resourceList classNameList resourceLocation desiredResources '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources-UI'!


!UIBResourceSelector methodsFor: 'initialize-release'!

desiredResourceTypes: aResourceTypeSetOrNil
	"aResourceTypeSet <Set of: <#image |  #menu | #dataModel | #canvas | #query> | nil>
	nil means all resources are allowed."

	desiredResources := aResourceTypeSetOrNil!

initialize

	| classNameIndex resourceIndex |
	super initialize.
	desiredResources := nil. "All resources are fine."
	resourceLocation := UIBResourceLocation new.
	classNameList := SelectionInList with: UIBFinder specBearingClasses asSortedCollection asList.
	resourceList := SelectionInList new.
	classNameIndex := classNameList selectionIndex.
	classNameList selectionIndexHolder:
		((PluggableAdaptor on: resourceLocation)
			getBlock:[:m| classNameIndex]
			putBlock:[:m :v| |selector|
						selector :=  m specSelector.
						classNameIndex := v.
						m specHolderClass: classNameList selection.
						self resourceList list: self computeSelectorList.
						self resourceList selection: (self resourceList list detect:[:res| res key == selector] ifNone:[nil])]
			updateBlock:[:m :a :p| true]).
	resourceIndex := classNameList selectionIndex.
	resourceList selectionIndexHolder:
		((PluggableAdaptor on: resourceLocation)
			getBlock:[:m| resourceIndex]
			putBlock:[:m :v| resourceIndex := v.
							m specSelector: 
								(resourceList selection isNil
									ifTrue:[nil]
									ifFalse:[resourceList selection key])]
			updateBlock:[:m :a :p| true]).!

releaseDependencyRelationShips

	self resourceLocation removeDependent: self classNameList selectionIndexHolder.
	self resourceLocation removeDependent: self resourceList selectionIndexHolder!

resourceLocation: aUIBResourceLocation

	| selector |
	resourceLocation := aUIBResourceLocation.
	selector :=  aUIBResourceLocation specSelector.
	self classNameList selectionIndexHolder model: aUIBResourceLocation.
	self resourceList selectionIndexHolder subjectChannel: aUIBResourceLocation.
	self classNameList selection: aUIBResourceLocation specHolderClass.
	self resourceList selection: (self resourceList list detect:[:res| res key == selector] ifNone:[nil])! !

!UIBResourceSelector methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	| val |
	(aBuilder componentAt: #resourceList) widget
		selectedVisualBlock: 
			[:v :index | 
			| rw |
			val := (v sequence at: index) value.
			rw :=ReversingWrapper on: ((LabelAndIcon with: (v displayStringAt: index)
					attributes: v textStyle)
					icon: (UIBFinder perform: val)).
			rw reverse setValue: true.
			BoundedWrapper on: rw];
		visualBlock: 
			[:v :i | 
			val := (v sequence at: i) value.
			BoundedWrapper on: ((LabelAndIcon with: (v displayStringAt: i)
					attributes: v textStyle)
					icon: (UIBFinder perform: val))].
	builder window icon: (Icon constantNamed: #finder)! !

!UIBResourceSelector methodsFor: 'private'!

computeSelectorList
	| clName class classInstance list types |
	(clName := self selectedClassName) isNil ifTrue: [^List new].
	classInstance := Smalltalk at: clName ifAbsent: ["self classGone. "^List new].
	class := classInstance class.
	list := List new.
	types := Dictionary new.
	types at: #image put: #iconIcon;
		at: #menu put: #menuIcon;
		at: #dataModel put: #modelIcon;
		at: #canvas put: #canvasIcon;
		at: #query put: #queryIcon.
	classInstance selectorsAndMethodsDo:
		[:sel :meth |
		(self isDesiredResourceType: meth resourceType)
			ifTrue: [list add: sel -> (types at: meth resourceType ifAbsent: [#beOther])]].
	class selectorsAndMethodsDo:
		[:sel :meth |
		(self isDesiredResourceType: meth resourceType)
			ifTrue: [list add: sel -> (types at: meth resourceType ifAbsent: [#beOther])]].
	"partSortType value = #byName
		ifTrue: 
			[list := list asSortedCollection]
		ifFalse: 
			[list := list asSortedCollection:
					[:first :second |
					first value = second value
						ifTrue: [first key <= second key]
						ifFalse: [first value <= second value]]]."
	^list asSortedCollection asList!

desiredResourceTypes

	^desiredResources!

isDesiredResourceType: resourceTypeOrNil

	| types |
	types := self desiredResourceTypes.
	^resourceTypeOrNil notNil
	and: [types isNil or: [types includes: resourceTypeOrNil]]!

resourceLocation

	^resourceLocation!

selectedClassName

	^self classNameList selection! !

!UIBResourceSelector methodsFor: 'actions'!

resourceDoubleClicked

	"Do nothing."! !

!UIBResourceSelector methodsFor: 'aspects'!

classNameList
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^classNameList!

resourceList
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined."

	^resourceList! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBResourceSelector class
	instanceVariableNames: ''!


!UIBResourceSelector class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'Resource Selector' 
			#bounds: #(#Rectangle 127 266 404 458 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 0 0 ) 
					#name: #classLabel 
					#label: 'Class' ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 25 0 0 0.5 0 1 ) 
					#name: #classNameList 
					#model: #classNameList ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 0 0.5 0 0 ) 
					#name: #resourcesLabel 
					#label: 'Resources' ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0.5 25 0 0 1 0 1 ) 
					#name: #resourceList 
					#model: #resourceList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#doubleClickSelector: #resourceDoubleClicked ) ) ) ) )! !

UIBResourceSelector subclass: #UIBResourceSelectorWithButtons
	instanceVariableNames: 'acceptChannel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Resources-UI'!


!UIBResourceSelectorWithButtons methodsFor: 'private'!

acceptChannel

	^acceptChannel! !

!UIBResourceSelectorWithButtons methodsFor: 'actions'!

doCancel

	self acceptChannel value: false!

doOk

	self acceptChannel value: true!

resourceDoubleClicked

	self doOk! !

!UIBResourceSelectorWithButtons methodsFor: 'initialize-release'!

acceptChannel: aValueModel

	acceptChannel := aValueModel!

initialize

	super initialize.
	acceptChannel := nil asValue! !

!UIBResourceSelectorWithButtons methodsFor: 'interface opening'!

postBuildWith: aBuilder

	super postBuildWith: aBuilder.
	resourceList selectionHolder compute:[:selection| self able: selection notNil component: #okButton].
	self able: resourceList selection notNil component: #okButton! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBResourceSelectorWithButtons class
	instanceVariableNames: ''!


!UIBResourceSelectorWithButtons class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBWindowSpec 
			#label: 'Resource Selector Dialog' 
			#bounds: #(#Rectangle 141 286 398 452 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 0 5 ) 
					#name: #selectResourceLabel 
					#label: 'Select a resource:' ) 
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 30 0 0 1 0 1 ) 
					#name: #selector 
					#flags: 0 
					#majorKey: #UIBResourceSelector 
					#minorKey: #windowSpec ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -120 1 5 0 -65 1 30 0 ) 
					#name: #okButton 
					#model: #doOk 
					#label: 'OK' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -60 1 5 0 -5 1 30 0 ) 
					#name: #cancelButton 
					#model: #doCancel 
					#label: 'Cancel' 
					#defaultable: true ) ) ) )! !

!UIBResourceSelectorWithButtons class methodsFor: 'interface opening'!

openOnResource: aUIBResourceLocation
	"self openOnResource: (UIBResourceLocation new specHolderClass: #CheckBoxSpec; specSelector: #basicsEditSpec)"

	| anInstance |
	(anInstance := self new) resourceLocation: aUIBResourceLocation.
	^self openOn: anInstance withSpec: #windowSpec!

openOnResource: aUIBResourceLocation desiredResourceTypes: desiredResourceTypesSet
	"self openOnResource: (UIBResourceLocation new specHolderClass: #CheckBoxSpec; specSelector: #basicsEditSpec)"

	| anInstance |
	(anInstance := self new) resourceLocation: aUIBResourceLocation.
	anInstance resourceSelector desiredResourceTypes: desiredResourceTypesSet.
	^self openOn: anInstance withSpec: #windowSpec! !

UIBWindowSpec subclass: #UIBPropertiesSliceSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Painter'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBPropertiesSliceSpec class
	instanceVariableNames: ''!


!UIBPropertiesSliceSpec class methodsFor: 'private-interface building'!

componentName
	"Identification of component"

	^'Properties Slice'!

slices

	^#(	(Details detailsEditSpec)
		(Models modelsEditSpec)
		(Aspects aspectsEditSpec) 
		(#'Drop Target'	dropTargetSpec))! !

!UIBPropertiesSliceSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 300 222 ) 
			#max: #(#Point 300 222 ) 
			#bounds: #(#Rectangle 126 310 426 532 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 4 0 0.5 0 ) 
					#label: 'Properties Slice' ) ) ) )! !

!UIBPropertiesSliceSpec class methodsFor: 'private'!

initialLabel

	^'Unlabeled Properties Slice'! !

UIBComponentEditor subclass: #UIBExtendedStandardComponentEditor
	instanceVariableNames: 'componentComment '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Components-Editor'!


!UIBExtendedStandardComponentEditor methodsFor: 'component class accessing'!

preferredComponentClass

	^UIBExtendedStandardComponent! !

!UIBExtendedStandardComponentEditor methodsFor: 'initialize-release'!

majorTabsList

	^(List new:10)
		add: (Association key: (self visualFor: #generalIcon) value: #(#generalSettings #acceptGeneral nil nil));
		add: (Association key: (self visualFor: #slicesIcon) value: #(#sliceSettings #acceptSlices nil nil));
		add: (Association key: (self visualFor: #propertiesIcon) value: #(#propertiesSettings #acceptProperties #slices #propertiesSpec));
		add: (Association key: (self visualFor: #paintingIcon) value: #(#paintingSettings #acceptPainting nil nil));
		add: (Association key: (self visualFor: #installIcon) value: #(#installSettings #acceptInstall nil nil));
		add: (Association key: (self visualFor: #paletteIcon) value: #(#paletteSettings #acceptPalette nil nil));
		yourself! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

UIBExtendedStandardComponentEditor class
	instanceVariableNames: ''!


!UIBExtendedStandardComponentEditor class methodsFor: 'interface specs'!

generalSettingsSpec
	"UIBPainter new openOnClass: self andSelector: #generalSettingsSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'General Settings' 
			#bounds: #(#Rectangle 551 245 816 569 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 5 0 0.5 0 ) 
					#name: #componentKindLabel 
					#label: 'Specialisation of Standard Component' 
					#style: #default ) 
				#(#LabelSpec 
					#layout: #(#Point 5 44 ) 
					#label: 'Component Name:' 
					#style: #default ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 69 0 -5 1 94 0 ) 
					#name: #componentName 
					#model: #componentName 
					#style: #default ) ) ) )! !

UIBComposingComposite subclass: #UIBToolBarComposite
	instanceVariableNames: 'layoutBlock '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Composites'!
UIBToolBarComposite comment:
'I am a composite for tool bars. I place my components either horizontally or vertically.

Instance variables:
	layoutBlock	<BlockClosure>	Block that takes 2 arguments, one of my components and its top left corner, and returning the top left corner for the next component to be placed.'!


!UIBToolBarComposite methodsFor: 'initialize-release'!

initialize

	super initialize.
	self beVertical! !

!UIBToolBarComposite methodsFor: 'accessing'!

beHorizontal

	self layoutBlock: [:comp :compTopLeft | compTopLeft + ((comp preferredBounds width + self spaceBetweenItems) @ 0)]!

beVertical

	self layoutBlock: [:comp :compTopLeft | compTopLeft + (0 @ (comp preferredBounds height + self spaceBetweenItems))]! !

!UIBToolBarComposite methodsFor: 'private'!

layoutBlock

	^layoutBlock!

layoutBlock: aBlock

	layoutBlock := aBlock!

layoutComponentsForBounds: newBounds
	"The receiver has been sized to the given parameters.  
	Re-layout all of the receiver's components."

	| currentTopLeft comp |
	currentTopLeft := self leftSpace @ self topSpace.
	comp := self components at: 1.
	comp bounds: (currentTopLeft extent: comp bounds extent).
	2 to: self components size
		do: [:index|
			comp := self components at: index.
			currentTopLeft := self layoutBlock value: comp value: currentTopLeft.
			comp bounds: (currentTopLeft extent: comp bounds extent)]! !

UIBPalette subclass: #OOPPalette
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Support'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

OOPPalette class
	instanceVariableNames: ''!


!OOPPalette class methodsFor: 'accessing-specs'!

activeSpecsList

	^#(#OOPNoteBookSpec)! !

!OOPPalette class methodsFor: 'accessing'!

numberOfColumns

	^5!

paletteName

	^'OO Partners'! !




HorizontalTabBarViewOOP initialize!

UIBFileOut initialize!

UIBPainterController initialize!

UIBPluggablePainterController initialize!

UIBPropertiesPainterController initialize!

UIBTextListPrompter initialize!

FileSelector initialize!

UIBCursor initialize!

VerticalTabBarViewOOP initialize!


!UILookPolicy methodsFor: 'building'!

applflabCompositeComponent: compositeComponentSpec into: builder

	"ApplFLab system addition"
 
	| spec subBuilder subEnv state |
	spec := compositeComponentSpec getSubSpecIn: builder.
	compositeComponentSpec overridePropertiesInSpec: spec.
	subBuilder := builder newSubBuilder.
	subEnv := (Smalltalk at: compositeComponentSpec majorKey ifAbsent: [compositeComponentSpec notify: 'component class does not exist.']) new.
	builder customComponent: subEnv.
	compositeComponentSpec setupPropertiesBeforeBuildingFor: subEnv spec: spec builder: builder.
	subEnv buildInSubCanvas: spec withBuilder: subBuilder.
	compositeComponentSpec setupPropertiesAfterBuildingFor: subEnv spec: spec builder: builder.
	builder component: subBuilder composite.
	builder wrapWith: WidgetStateWrapper new.
	state := builder wrapper widgetState.
	self manufactureGeneralWrapperFor: compositeComponentSpec into: builder.
	builder applyLayout: compositeComponentSpec layout.
	^builder wrapWith: (self simpleWidgetWrapperOn: builder spec: compositeComponentSpec state: state)! !

!UILookPolicy methodsFor: 'building'!

oopNoteBook: spec into: builder

	"ApplFLab system addition."

	| lv  b mod  mod2 nbc  lv2 bs insets bw|
	mod := spec modelInBuilder: builder.
	mod2 := spec secondModelInBuilder: builder.
	spec majorTabsOnRight
		ifFalse: [| tmp |
				tmp := mod.
				mod := mod2.
				mod2 := tmp].
	(spec labels notNil and: [mod list isEmpty])
		ifTrue: [mod list addAll: spec labels.
				mod selectionIndex: 1].
	lv := VerticalTabBarViewOOP new.
	lv model: mod listHolder.
	lv selectionChannel: mod selectionIndexHolder.
	self setStyleOf: lv to: spec style.
	self setDispatcherOf: lv fromSpec: spec builder: builder.
	spec tabable
		ifTrue: [lv widgetState isTabStop: true.
				builder sendKeyboardTo: lv]
		ifFalse: [lv widgetState canTakeFocus: true.
				lv controller keyboardProcessor: builder keyboardProcessor].

	lv2 := HorizontalTabBarViewOOP new.
	lv2 widgetState: lv widgetState.
	lv2 model: mod2 listHolder.
	lv2 selectionChannel: mod2 selectionIndexHolder.
	self setStyleOf: lv2 to: spec style.
	spec tabable
		ifTrue: [lv2 widgetState isTabStop: true.
				builder sendKeyboardTo: lv2]
		ifFalse: [lv2 widgetState canTakeFocus: true.
				lv2 controller keyboardProcessor: builder keyboardProcessor].
	bs := spec binderSide.
	bw := spec binderWidth.
	b := VisualBinderComponentOOP new.
	b widgetState: lv widgetState.
	nbc := NoteBookCompositeOOP new.
	b binderPosition: bs.
	lv leftSpine: bs == #left.
	lv2 leftSpine: bs == #left.
	b binderThickness: bw.
	insets := (bs == #left
		ifTrue: [(bw+1)@1 corner: 0@0]
		ifFalse: [1@(bw+1) corner: 0@0]).
	nbc binder: b
		tabBar: lv
		rightInset: spec rightInset
		bottomInset: spec bottomInset
		bottomTabBar: lv2
		subcanvas: SubCanvas new
		insets: insets.
	lv widgetState isEnabled: spec initiallyEnabled.
	builder isEditing ifFalse: [lv widgetState isVisible: spec initiallyVisible].
	builder component: nbc.
	self manufactureGeneralWrapperFor: spec  into: builder.
	builder applyLayout: spec layout.
	builder wrapWith: (self simpleWidgetWrapperOn: builder spec: spec state: lv widgetState)! !

!ComponentSpec methodsFor: 'private-interface building'!

dragHandlesFor: specWrapper subject: someWidget view: painterView isPrimary: isPrimary

	"ApplFLab system addition."

	| handleCollection |
	handleCollection := OrderedCollection new: 10.
	self handlesFor: specWrapper subject: someWidget view: painterView isPrimary: isPrimary in: handleCollection.
	self attachControlModesForWrapper: specWrapper toHandles: handleCollection.
	^handleCollection asArray! !

!ComponentSpec methodsFor: 'private-interface building'!

handlesFor: specWrapper subject: someWidget view: painterView isPrimary: isPrimary in: aCollection

	"ApplFLab system addition."

	^aCollection 
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asOrigin;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asTopRight;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asCorner;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asBottomLeft;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asTopCenter;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asBottomCenter;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asLeftCenter;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asRightCenter;
		yourself! !

!ComponentSpec methodsFor: 'private-interface building'!

attachControlModesForWrapper: specWrapper toHandles: handleCollection

	"ApplFLab system addition."

	| mode |
	mode:= (specWrapper component class == LayoutWrapper
		ifTrue: [[:h | NullDragMode new]]
		ifFalse: [[:h | CornerDragMode new]]).
	1 to: 4 do: [:index | (handleCollection at: index) dragModeBlock: mode].
	mode:= (specWrapper component class == LayoutWrapper
		ifTrue: [[:h | NullDragMode new]]
		ifFalse: [[:h | UIBSideDragMode new]]).
	5 to: 8 do: [:index | (handleCollection at: index) dragModeBlock: mode].
	^handleCollection! !

!SpecWrapper methodsFor: 'private-interface building'!

painterDragHandles: isPrimary inView: painterView
	"Answer an array of DragHandles for the receiver, suitable for use by 
	UIBPainterController. isPrimary indicates whether or not the receiver 
	is the primary selection in the controller where the handles are 
	wanted."

	"ApplFLab system addition."

	^spec
		dragHandlesFor: self
		subject: self widget
		view: painterView
		isPrimary: isPrimary! !

!DividerSpec methodsFor: 'private-interface building'!

handlesFor: specWrapper subject: someWidget view: painterView isPrimary: isPrimary in: aCollection

	"ApplFLab system addition."

	^aCollection
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asOrigin;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asDividerCorner;
		yourself! !

!DividerSpec methodsFor: 'private-interface building'!

attachControlModesForWrapper: specWrapper toHandles: handleCollection

	"ApplFLab system addition."

	| mode |
	mode := (specWrapper component class == LayoutWrapper
		ifTrue: [[:h | NullDragMode new]]
		ifFalse: [[:h | DividerResizingDragMode new]]).
	handleCollection do: [:dh | dh dragModeBlock: mode].
	^handleCollection! !

!SliderSpec methodsFor: 'private-interface building'!

handlesFor: specWrapper subject: someWidget view: painterView isPrimary: isPrimary in: aCollection

	"ApplFLab system addition."

	^aCollection 
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asOrigin;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asTopRight;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asCorner;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asBottomLeft;
		"Koen: the following is not working correctly. See OrientationResizeMode>>#stretchRectangle:from:to:
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asTopCenter;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asBottomCenter;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asLeftCenter;
		add: (UIBDragHandle wrapper: specWrapper subject: someWidget view: painterView isPrimary: isPrimary) asRightCenter;"
		yourself! !

!SliderSpec methodsFor: 'private-interface building'!

attachControlModesForWrapper: specWrapper toHandles: handleCollection

	"ApplFLab system addition."

	| mode |
	mode:= (specWrapper component class == LayoutWrapper
		ifTrue: [[:h | NullDragMode new]]
		ifFalse: [[:h | OrientationResizeMode new]]).
	1 to: 4 do: [:index | (handleCollection at: index) dragModeBlock: mode].
	"Koen: the following is not working correctly. See OrientationResizeMode>>#stretchRectangle:from:to:
	mode:= (specWrapper component class == LayoutWrapper
		ifTrue: [[:h | NullDragMode new]]
		ifFalse: [[:h | OrientationResizeMode new]]).
	5 to: 8 do: [:index | (handleCollection at: index) dragModeBlock: mode]."
	^handleCollection! !

!Parser methodsFor: 'initialize-release'!

initScanner

	"ApplFLab system change"

	super initScanner.
	typeTable := TypeTable.
	"Default language choice:"
	oldLanguage := true.
	newLanguage := true.
	extendedLanguage := true "ApplFLab: false in the standard image"! !

!Object methodsFor: 'user interface'!

basicInspect
	"Create and schedule an Inspector in which the user can examine the
	receiver's variables.  This method should not be overwritten."

	"ApplFLab system change"

	UIBInspector openOn: self! !

!Browser methodsFor: 'private-protocol functions'!

addProtocol

	"ApplFLab system change"

	| aString newProtocol |
	self changeRequest ifFalse: [^self].
	"ORGINAL:
	aString := self
			prompt: 'Enter new category name'
			initially: (LastProtocol == nil ifTrue: ['protocol name'] ifFalse: [LastProtocol]).
	PATCH: "
	aString := UIBTextListPrompter
				promptForProtocol: 'Enter/select a new protocol name'
				for: self selectedClass
				initially: (LastProtocol == nil ifTrue: ['protocol name'] ifFalse: [LastProtocol]).
	aString isEmpty ifTrue: [^ self].
	newProtocol := aString asSymbol.
	self classForSelectedProtocol organization addCategory: newProtocol before: protocol.
	self logProtocolChange: ('<1p> organization addCategory: <2p> before: <3p>'
					expandMacrosWith: self classForSelectedProtocol
					with: newProtocol
					with: protocol).
	self classForSelectedProtocol reorganize.
	self newProtocolList: newProtocol! !

UIFinderVW2 computeSpecBearingClasses!

UIBVisualLauncher open!

UIBApplFLabInstaller open!
