'From VisualWorks(R), Release 2.5 of September 26, 1995 on March 26, 1997 at 3:42:24 pm'!

UIBApplicationModel subclass: #MetroClockDependentUIC
	instanceVariableNames: 'clock '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroClockDependentUIC methodsFor: 'clock dependency'!

breakClockDependencyFor: anObject

	(clock notNil and:[anObject notNil])
		ifTrue:[clock value retractInterestIn: #clockTick for: anObject]!

setupClockDependencyFor: anObject

	(clock notNil and:[anObject notNil])
		ifTrue:[clock value expressInterestIn: #clockTick for: anObject sendBack: #clockTick:]! !

!MetroClockDependentUIC methodsFor: 'initialize-release'!

clock: aMetroClockHolder

	clock := aMetroClockHolder.
	self changeModelFrom: self model to: self model value!

release

	self breakClockDependencyFor: self model.
	^super release! !

!MetroClockDependentUIC methodsFor: 'model accessing'!

changeModelFrom: oldModel to: newModel

	self breakClockDependencyFor: oldModel.
	self setupClockDependencyFor: newModel!

model

	^self subclassResponsibility! !

UIBApplicationModel subclass: #MetroRunButtonUIC
	instanceVariableNames: 'count action '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroRunButtonUIC methodsFor: 'actions'!

run
	"This stub method was generated by UIBDefiner"

	action value: (Array with: count)! !

!MetroRunButtonUIC methodsFor: 'model accessing'!

action: aBlock

	action := aBlock!

count: anInteger

	count := anInteger! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroRunButtonUIC class
	instanceVariableNames: ''!


!MetroRunButtonUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Run Button' 
			#bounds: #(#Rectangle 389 151 550 233 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #theButton 
					#model: #run 
					#label: 'Run' 
					#defaultable: true ) ) ) )! !

UIBCompositeComponentSpec subclass: #MetroStationUICSpec
	instanceVariableNames: 'initialTrain2 track initialTrain1 rail2OutTrack clock duration stationName rail1OutTrack '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroStationUICSpec methodsFor: 'accessing'!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

duration

	^duration == nil ifTrue:[2] ifFalse:[duration]!

initialTrain1

	^initialTrain1 == nil
		ifTrue:[initialTrain1 := (UIBPropertyFieldModel basicNew name: #initialTrain1; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain1]!

initialTrain2

	^initialTrain2 == nil
		ifTrue:[initialTrain2 := (UIBPropertyFieldModel basicNew name: #initialTrain2; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain2]!

rail1OutTrack

	^rail1OutTrack == nil
		ifTrue:[rail1OutTrack := (UIBPropertyFieldModel basicNew name: #rail1OutTrack; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[rail1OutTrack]!

rail2OutTrack

	^rail2OutTrack == nil
		ifTrue:[rail2OutTrack := (UIBPropertyFieldModel basicNew name: #rail2OutTrack; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[rail2OutTrack]!

setClock: aValue

	clock := aValue!

setDuration: aValue

	duration := aValue!

setInitialTrain1: aValue

	initialTrain1 := aValue!

setInitialTrain2: aValue

	initialTrain2 := aValue!

setRail1OutTrack: aValue

	rail1OutTrack := aValue!

setRail2OutTrack: aValue

	rail2OutTrack := aValue!

setStationName: aValue

	stationName := aValue!

setTrack: aValue

	track := aValue!

stationName

	^stationName == nil ifTrue:[''] ifFalse:[stationName]!

track

	^track == nil
		ifTrue:[track := (UIBPropertyFieldModel basicNew name: #track; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: 'MetroStation new asValue'; yourself)]
		ifFalse:[track]! !

!MetroStationUICSpec methodsFor: 'decoding'!

clock: aValue

	self clock property: aValue decodeAsLiteralArray!

duration: aValue

	duration := aValue decodeAsLiteralArray!

initialTrain1: aValue

	self initialTrain1 property: aValue decodeAsLiteralArray!

initialTrain2: aValue

	self initialTrain2 property: aValue decodeAsLiteralArray!

rail1OutTrack: aValue

	self rail1OutTrack property: aValue decodeAsLiteralArray!

rail2OutTrack: aValue

	self rail2OutTrack property: aValue decodeAsLiteralArray!

stationName: aValue

	stationName := aValue decodeAsLiteralArray!

track: aValue

	self track property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroStationUICSpec class
	instanceVariableNames: ''!


!MetroStationUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroStationUIC!

defaultMinorKey

	^#windowSpec! !

!MetroStationUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #rail1OutTrack put: (self adapt: inst forAspect: #property accessPath: #(#rail1OutTrack) channel: aChannel).
	env at: #initialTrain1 put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain1) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #initialTrain2 put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain2) channel: aChannel).
	env at: #track put: (self adapt: inst forAspect: #property accessPath: #(#track) channel: aChannel).
	env at: #stationName put: (self adapt: inst forAspect: #stationName channel: aChannel).
	env at: #rail2OutTrack put: (self adapt: inst forAspect: #property accessPath: #(#rail2OutTrack) channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Station'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroStationUIC #specSelector: #windowSpec))!

placementExtent

	^70 @ 75!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Trains #trainsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroStationUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue blue; at: 4 put: ColorValue white; at: 5 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L1@@@@@CQBH"H"H"H"H"H$PP@@@@@4P"H"H"H"H"H"IDD@@@@@MDH"H"H"H"H"H"QA@@@@@CQDQDQDQDQDQDQDPP@@@@@4Q@Q@Q@Q@Q@Q@QDD@@@@@MD@@@@@@@@@@@@QA@@@@@CQDADADADADADADPP@@@@@4Q@Q@Q@Q@Q@Q@QDD@@@@@MD@@@@@@@@@@@@QA@@@@@CQDADADADADADADPP@@@@@4QDQDQDQDQDQDQDD@@@@@MDPDPDPDPDPDPDQA@@@@@CQ@@@@@@@@@@@@DPP@@@@@4Q@Q@Q@Q@Q@Q@QDD@@@@@MDPDPDPDPDPDPDQA@@@@@CQ@@@@@@@@@@@@DPP@@@@@4Q@Q@Q@Q@Q@Q@QDD@@@@@MDQDQDQDQDQDQDQA@@@@@CQBH"H"H"H"H"H$PP@@@@@4P"H"H"H"H"H"IDD@@@@@MDH"H"H"H"H"H"QA@@@@@CQDQDQDQDQDQDQDPP@@@@@QDQDQDQDQDQDQDQD@@@@@@@@@@@@@@@@@@@@@@@@@@b')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

!MetroStationUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Station-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 41 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 72 0 40 0 -12 1 62 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 8 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Station' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 156 253 178 ) 
					#name: #rail1OutTrack 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail1OutTrack 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 133 ) 
					#name: #rail1OutRailLabel 
					#label: 'Rail 1 outgoing track:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 209 253 231 ) 
					#name: #rail2OutTrack 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail2OutTrack 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 186 ) 
					#name: #rail2OutRailLabel 
					#label: 'Rail 2 outgoing track:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 280 253 302 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 9 283 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#LabelSpec 
					#layout: #(#Point 9 253 ) 
					#name: #durationLabel 
					#label: 'Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 94 252 253 274 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 97 253 119 ) 
					#name: #track 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #track 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroStation new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 98 0 ) 
					#name: #idLabel 
					#label: 'Station:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 72 0 ) 
					#name: #nameLabel 
					#label: 'Name:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 94 0 71 0 -12 1 93 0 ) 
					#name: #stationNameField 
					#model: #stationName 
					#type: #string ) ) ) )!

trainsEditSpec
	"UIBPainter new openOnClass: self andSelector: #trainsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Station-Trains' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 96 74 255 96 ) 
					#name: #initialTrain1 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain1 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 9 51 ) 
					#name: #initialTrain1Label 
					#label: 'Initial Train on Platform 1:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 97 131 256 153 ) 
					#name: #initialTrain2 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain2 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 10 108 ) 
					#name: #initialTrain2Label 
					#label: 'Initial Train on Platform 2:' ) ) ) )! !

UIBApplicationModel subclass: #MetroClockUIC
	instanceVariableNames: 'time '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroClockUIC methodsFor: 'initialize-release'!

initialize

	time := ((AspectAdaptor forAspect: #clockTick) subjectSendsUpdates: true) subjectChannel: MetroClock new asValue! !

!MetroClockUIC methodsFor: 'aspects'!

time

	^time! !

!MetroClockUIC methodsFor: 'model accessing'!

clock: aMetroClockHolder

	self time subjectChannel: aMetroClockHolder! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroClockUIC class
	instanceVariableNames: ''!


!MetroClockUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Clock' 
			#bounds: #(#Rectangle 426 172 577 241 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #timeField 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #yellow ) ) 
					#model: #time 
					#alignment: #right 
					#isReadOnly: true 
					#type: #number 
					#formatString: '0' ) ) ) )! !

UIBCompositeComponentSpec subclass: #MetroCornerUICSpec
	instanceVariableNames: 'track durationV rail2OutTrack rail1OutTrack clock duration trackV inset '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroCornerUICSpec methodsFor: 'accessing'!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

duration

	^duration == nil ifTrue:[2] ifFalse:[duration]!

durationV

	^durationV == nil ifTrue:[2] ifFalse:[durationV]!

inset

	^inset == nil ifTrue:[8] ifFalse:[inset]!

rail1OutTrack

	^rail1OutTrack == nil
		ifTrue:[rail1OutTrack := (UIBPropertyFieldModel basicNew name: #rail1OutTrack; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[rail1OutTrack]!

rail2OutTrack

	^rail2OutTrack == nil
		ifTrue:[rail2OutTrack := (UIBPropertyFieldModel basicNew name: #rail2OutTrack; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[rail2OutTrack]!

setClock: aValue

	clock := aValue!

setDuration: aValue

	duration := aValue!

setDurationV: aValue

	durationV := aValue!

setInset: aValue

	inset := aValue!

setRail1OutTrack: aValue

	rail1OutTrack := aValue!

setRail2OutTrack: aValue

	rail2OutTrack := aValue!

setTrack: aValue

	track := aValue!

setTrackV: aValue

	trackV := aValue!

track

	^track == nil
		ifTrue:[track := (UIBPropertyFieldModel basicNew name: #track; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[track]!

trackV

	^trackV == nil
		ifTrue:[trackV := (UIBPropertyFieldModel basicNew name: #trackV; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[trackV]! !

!MetroCornerUICSpec methodsFor: 'decoding'!

clock: aValue

	self clock property: aValue decodeAsLiteralArray!

duration: aValue

	duration := aValue decodeAsLiteralArray!

durationV: aValue

	durationV := aValue decodeAsLiteralArray!

inset: aValue

	inset := aValue decodeAsLiteralArray!

rail1OutTrack: aValue

	self rail1OutTrack property: aValue decodeAsLiteralArray!

rail2OutTrack: aValue

	self rail2OutTrack property: aValue decodeAsLiteralArray!

track: aValue

	self track property: aValue decodeAsLiteralArray!

trackV: aValue

	self trackV property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroCornerUICSpec class
	instanceVariableNames: ''!


!MetroCornerUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroBLCornerUIC!

defaultMinorKey

	^#windowSpec! !

!MetroCornerUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #rail1OutTrack put: (self adapt: inst forAspect: #property accessPath: #(#rail1OutTrack) channel: aChannel).
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #trackV put: (self adapt: inst forAspect: #property accessPath: #(#trackV) channel: aChannel).
	env at: #inset put: (self adapt: inst forAspect: #inset channel: aChannel).
	env at: #track put: (self adapt: inst forAspect: #property accessPath: #(#track) channel: aChannel).
	env at: #durationV put: (self adapt: inst forAspect: #durationV channel: aChannel).
	env at: #majorKey put: (self adapt: inst forAspect: #majorKey channel: aChannel).
	env at: #rail2OutTrack put: (self adapt: inst forAspect: #property accessPath: #(#rail2OutTrack) channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Corner'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroBLCornerUIC #specSelector: #windowSpec) #(#UIBComponentLookAndFeel #specHolderClass: #MetroBRCornerUIC #specSelector: #windowSpec) #(#UIBComponentLookAndFeel #specHolderClass: #MetroTLCornerUIC #specSelector: #windowSpec) #(#UIBComponentLookAndFeel #specHolderClass: #MetroTRCornerUIC #specSelector: #windowSpec))!

placementExtent

	^50 @ 50!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Layout #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroCornerUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Corner-Basics' 
			#bounds: #(#Rectangle 283 323 548 647 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 10 0 37 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 74 0 36 0 -10 1 58 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.516981 5 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Corner' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 98 157 257 179 ) 
					#name: #rail1OutTrack 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail1OutTrack 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 11 134 ) 
					#name: #rail1OutRailLabel 
					#label: 'Vertical outgoing track/station:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 98 204 257 226 ) 
					#name: #rail2OutTrack 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail2OutTrack 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 11 181 ) 
					#name: #rail2OutRailLabel 
					#label: 'Horizontal outgoing track/station:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 98 286 257 308 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 13 289 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#LabelSpec 
					#layout: #(#Point 14 233 ) 
					#name: #durationLabel 
					#label: 'Vertical Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 149 232 258 254 ) 
					#name: #durationVField 
					#model: #durationV 
					#type: #number 
					#formatString: '0' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 124 76 256 98 ) 
					#name: #track 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #trackV 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 11 0 77 0 ) 
					#name: #vTrackLabel 
					#label: 'Vertical Track:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 124 104 256 126 ) 
					#name: #track 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #track 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 11 0 105 0 ) 
					#name: #vTrackLabel 
					#label: 'Horizontal Track:' ) 
				#(#LabelSpec 
					#layout: #(#Point 14 260 ) 
					#name: #durationLabel 
					#label: 'Horizontal Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 149 259 258 281 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Corner-Layout' 
			#bounds: #(#Rectangle 320 380 585 704 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#RadioButtonSpec 
					#layout: #(#Point 72 44 ) 
					#model: #majorKey 
					#select: #MetroTLCornerUIC ) 
				#(#LabelSpec 
					#layout: #(#Point 26 235 ) 
					#label: 'Inset:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 75 234 125 254 ) 
					#model: #inset 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#CompositeSpecCollection 
							#collection: #(
								#(#RegionSpec 
									#layout: #(#Rectangle 7 0 15 55 ) 
									#lineWidth: 1 ) 
								#(#RegionSpec 
									#layout: #(#Rectangle 0 0 8 48 ) 
									#lineWidth: 1 ) ) 
							#compositeSpec: 
							#(#CompositeSpec 
								#layout: #(#Rectangle 41 0 56 55 ) ) ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 0 47 49 55 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 0 54 56 62 ) 
							#lineWidth: 1 ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 62 35 118 97 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#CompositeSpecCollection 
							#collection: #(
								#(#RegionSpec 
									#layout: #(#Rectangle 0 0 8 55 ) 
									#lineWidth: 1 ) 
								#(#RegionSpec 
									#layout: #(#Rectangle 7 0 15 48 ) 
									#lineWidth: 1 ) ) 
							#compositeSpec: 
							#(#CompositeSpec 
								#layout: #(#Rectangle 0 0 15 55 ) ) ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 7 47 55 55 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 0 54 55 62 ) 
							#lineWidth: 1 ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 142 35 197 97 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#RegionSpec 
							#layout: #(#Rectangle 7 0 54 9 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 14 8 54 16 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 0 0 8 57 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 7 8 15 57 ) 
							#lineWidth: 1 ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 141 119 195 176 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#RegionSpec 
							#layout: #(#Rectangle 46 0 56 57 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 37 8 47 57 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 0 0 47 9 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 0 8 38 16 ) 
							#lineWidth: 1 ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 61 119 117 176 ) ) ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 170 43 ) 
					#model: #majorKey 
					#select: #MetroTRCornerUIC ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 69 145 ) 
					#model: #majorKey 
					#select: #MetroBLCornerUIC ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 169 144 ) 
					#model: #majorKey 
					#select: #MetroBRCornerUIC ) ) ) )! !

!MetroCornerUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/333333=@@B<@@@@@C4@@K<<<<?0?P@@/3333<3=@@B?OOOOOC4@@K0@@@C<?P@@/3333O3=@@B????0@C4@@K????3<?P@@/????O3=@@B????0@C4@@K????3<?P@@/????O3=@@B????0@C4@@K????3<?P@@/????O3=@@B????0@C4@@K????3<?P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

UIBApplicationModel subclass: #MetroSimulation
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroSimulation methodsFor: 'actions'!

inspectComponent
	"This stub method was generated by UIBDefiner"

	| choice |
	choice := Dialog 
		choose: 'Which component do you want to inspect?' 
		fromList: self builder namedComponents keys asArray
		values:self builder namedComponents keys asArray 
		lines: 10 
		cancel: [nil].
	choice isNil ifFalse:[(self widget: choice) inspect]!

run
	"This stub method was generated by UIBDefiner"

	self clock value runFor: 50!

runFor: aValue
	"This stub method was generated by UIBDefiner"

	^self clock value runFor: aValue! !

!MetroSimulation methodsFor: 'binding'!

aspectFor: aKey 

	(aKey size > 10 and:[(aKey copyFrom: aKey size - 9 to: aKey size) = 'Occupation'])
		ifTrue:[^(AspectAdaptor forAspect: #occupation)
				subjectSendsUpdates: true;
				subjectChannel: (self perform: (aKey copyFrom: 1 to: aKey size -10) asSymbol)]
		ifFalse:[^super aspectFor: aKey]! !

MetroSimulation subclass: #MetroSimulationLine2
	instanceVariableNames: 'hallepoort2zuidstation ijzer2rogier simonis train2 naamsepoort luxemburg2naamsepoort3 rogier rogier2kruidtuin2 clock luxemburg kunstwet2luxemburg train1 zuidstation kruidtuin2madou madou hallepoort ribaucourt2ijzer kruidtuin rogier2kruidtuin3 ribaucourt louiza2munthof rogier2kruidtuin luxemburg2naamsepoort ijzer luxemburg2naamsepoort2 kunstwet simonis2ribaucourt hallepoort2zuidstation2 munthof louiza madou2kunstwet hallepoort2zuidstation3 munthof2hallepoort naamsepoort2louiza train3 rogier2kruidtuin4 hallepoort2zuidstation4 luxemburg2naamsepoort4 hallepoort2zuidstation1 rogier2kruidtuin1 luxemburg2naamsepoort1 train5 train4 madou2luxemburg train6 train7 train8 '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroSimulationLine2 methodsFor: 'aspects'!

clock
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^clock isNil
		ifTrue:
			[clock := MetroClock new asValue]
		ifFalse:
			[clock]!

hallepoort
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^hallepoort isNil
		ifTrue:
			[hallepoort := MetroStation new asValue]
		ifFalse:
			[hallepoort]!

hallepoort2zuidstation1
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^hallepoort2zuidstation1 isNil
		ifTrue:
			[hallepoort2zuidstation1 := MetroTrack new asValue]
		ifFalse:
			[hallepoort2zuidstation1]!

hallepoort2zuidstation2
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^hallepoort2zuidstation2 isNil
		ifTrue:
			[hallepoort2zuidstation2 := MetroTrack new asValue]
		ifFalse:
			[hallepoort2zuidstation2]!

hallepoort2zuidstation3
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^hallepoort2zuidstation3 isNil
		ifTrue:
			[hallepoort2zuidstation3 := MetroTrack new asValue]
		ifFalse:
			[hallepoort2zuidstation3]!

hallepoort2zuidstation4
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^hallepoort2zuidstation4 isNil
		ifTrue:
			[hallepoort2zuidstation4 := MetroTrack new asValue]
		ifFalse:
			[hallepoort2zuidstation4]!

ijzer
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^ijzer isNil
		ifTrue:
			[ijzer := MetroStation new asValue]
		ifFalse:
			[ijzer]!

ijzer2rogier
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^ijzer2rogier isNil
		ifTrue:
			[ijzer2rogier := MetroTrack new asValue]
		ifFalse:
			[ijzer2rogier]!

kruidtuin
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^kruidtuin isNil
		ifTrue:
			[kruidtuin := MetroStation new asValue]
		ifFalse:
			[kruidtuin]!

kruidtuin2madou
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^kruidtuin2madou isNil
		ifTrue:
			[kruidtuin2madou := MetroTrack new asValue]
		ifFalse:
			[kruidtuin2madou]!

kunstwet
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^kunstwet isNil
		ifTrue:
			[kunstwet := MetroStation new asValue]
		ifFalse:
			[kunstwet]!

kunstwet2luxemburg
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^kunstwet2luxemburg isNil
		ifTrue:
			[kunstwet2luxemburg := MetroTrack new asValue]
		ifFalse:
			[kunstwet2luxemburg]!

louiza
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^louiza isNil
		ifTrue:
			[louiza := MetroStation new asValue]
		ifFalse:
			[louiza]!

louiza2munthof
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^louiza2munthof isNil
		ifTrue:
			[louiza2munthof := MetroTrack new asValue]
		ifFalse:
			[louiza2munthof]!

luxemburg
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^luxemburg isNil
		ifTrue:
			[luxemburg := MetroStation new asValue]
		ifFalse:
			[luxemburg]!

luxemburg2naamsepoort1
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^luxemburg2naamsepoort1 isNil
		ifTrue:
			[luxemburg2naamsepoort1 := MetroTrack new asValue]
		ifFalse:
			[luxemburg2naamsepoort1]!

luxemburg2naamsepoort2
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^luxemburg2naamsepoort2 isNil
		ifTrue:
			[luxemburg2naamsepoort2 := MetroTrack new asValue]
		ifFalse:
			[luxemburg2naamsepoort2]!

luxemburg2naamsepoort3
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^luxemburg2naamsepoort3 isNil
		ifTrue:
			[luxemburg2naamsepoort3 := MetroTrack new asValue]
		ifFalse:
			[luxemburg2naamsepoort3]!

luxemburg2naamsepoort4
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^luxemburg2naamsepoort4 isNil
		ifTrue:
			[luxemburg2naamsepoort4 := MetroTrack new asValue]
		ifFalse:
			[luxemburg2naamsepoort4]!

madou
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^madou isNil
		ifTrue:
			[madou := MetroStation new asValue]
		ifFalse:
			[madou]!

madou2kunstwet
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^madou2kunstwet isNil
		ifTrue:
			[madou2kunstwet := MetroTrack new asValue]
		ifFalse:
			[madou2kunstwet]!

madou2luxemburg
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^madou2luxemburg isNil
		ifTrue:
			[madou2luxemburg := MetroTrack new asValue]
		ifFalse:
			[madou2luxemburg]!

munthof
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^munthof isNil
		ifTrue:
			[munthof := MetroStation new asValue]
		ifFalse:
			[munthof]!

munthof2hallepoort
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^munthof2hallepoort isNil
		ifTrue:
			[munthof2hallepoort := MetroTrack new asValue]
		ifFalse:
			[munthof2hallepoort]!

naamsepoort
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^naamsepoort isNil
		ifTrue:
			[naamsepoort := MetroStation new asValue]
		ifFalse:
			[naamsepoort]!

naamsepoort2louiza
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^naamsepoort2louiza isNil
		ifTrue:
			[naamsepoort2louiza := MetroTrack new asValue]
		ifFalse:
			[naamsepoort2louiza]!

ribaucourt
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^ribaucourt isNil
		ifTrue:
			[ribaucourt := MetroStation new asValue]
		ifFalse:
			[ribaucourt]!

ribaucourt2ijzer
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^ribaucourt2ijzer isNil
		ifTrue:
			[ribaucourt2ijzer := MetroTrack new asValue]
		ifFalse:
			[ribaucourt2ijzer]!

rogier
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^rogier isNil
		ifTrue:
			[rogier := MetroStation new asValue]
		ifFalse:
			[rogier]!

rogier2kruidtuin1
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^rogier2kruidtuin1 isNil
		ifTrue:
			[rogier2kruidtuin1 := MetroTrack new asValue]
		ifFalse:
			[rogier2kruidtuin1]!

rogier2kruidtuin2
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^rogier2kruidtuin2 isNil
		ifTrue:
			[rogier2kruidtuin2 := MetroTrack new asValue]
		ifFalse:
			[rogier2kruidtuin2]!

rogier2kruidtuin3
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^rogier2kruidtuin3 isNil
		ifTrue:
			[rogier2kruidtuin3 := MetroTrack new asValue]
		ifFalse:
			[rogier2kruidtuin3]!

rogier2kruidtuin4
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^rogier2kruidtuin4 isNil
		ifTrue:
			[rogier2kruidtuin4 := MetroTrack new asValue]
		ifFalse:
			[rogier2kruidtuin4]!

simonis
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^simonis isNil
		ifTrue:
			[simonis := MetroTerminusStation withRail1AsTerminusPlatform asValue]
		ifFalse:
			[simonis]!

simonis2ribaucourt
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^simonis2ribaucourt isNil
		ifTrue:
			[simonis2ribaucourt := MetroTrack new asValue]
		ifFalse:
			[simonis2ribaucourt]!

train1
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^train1 isNil
		ifTrue:
			[train1 := MetroTrain new asValue]
		ifFalse:
			[train1]!

train2
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^train2 isNil
		ifTrue:
			[train2 := MetroTrain new asValue]
		ifFalse:
			[train2]!

train3
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^train3 isNil
		ifTrue:
			[train3 := MetroTrain new asValue]
		ifFalse:
			[train3]!

train4
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^train4 isNil
		ifTrue:
			[train4 := MetroTrain new asValue]
		ifFalse:
			[train4]!

train5
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^train5 isNil
		ifTrue:
			[train5 := MetroTrain new asValue]
		ifFalse:
			[train5]!

train6
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^train6 isNil
		ifTrue:
			[train6 := MetroTrain new asValue]
		ifFalse:
			[train6]!

train7
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^train7 isNil
		ifTrue:
			[train7 := MetroTrain new asValue]
		ifFalse:
			[train7]!

train8
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^train8 isNil
		ifTrue:
			[train8 := MetroTrain new asValue]
		ifFalse:
			[train8]!

zuidstation
	"This method was generated by UIBDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^zuidstation isNil
		ifTrue:
			[zuidstation := MetroTerminusStation withRail1AsTerminusPlatform asValue]
		ifFalse:
			[zuidstation]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroSimulationLine2 class
	instanceVariableNames: ''!


!MetroSimulationLine2 class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Simulation : Line 2' 
			#bounds: #(#Rectangle 169 196 726 550 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroClockUICSpec 
					#layout: #(#Rectangle 13 89 61 111 ) 
					#name: #clock 
					#flags: 0 
					#bordered: true 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 11 322 59 342 ) 
					#name: #runButton 
					#model: #run 
					#label: 'Run' 
					#defaultable: true ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 168 304 216 328 ) 
					#model: #train1Occupation 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 224 304 272 328 ) 
					#model: #train2Occupation 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 121 4 200 76 ) 
					#name: #ribaucourt 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train2 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train1 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 
					#stationName: 'Ribaucourt' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 200 40 280 56 ) 
					#name: #ribaucourt2ijzer 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 10 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 280 4 328 76 ) 
					#name: #ijzer 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'IJzer' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 320 320 368 340 ) 
					#model: #inspectComponent 
					#label: 'Inspect' 
					#defaultable: true ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 328 40 448 56 ) 
					#name: #ijzer2rogier 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 8 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 448 4 504 76 ) 
					#name: #rogier 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 
					#stationName: 'Rogier' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) ) 
				#(#MetroLeftTerminusStationUICSpec 
					#layout: #(#Rectangle 5 4 72 76 ) 
					#name: #simonis 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #simonis ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Simonis' ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 448 92 520 164 ) 
					#name: #kruidtuin 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train5 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin4 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Kruidtuin' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 352 92 408 164 ) 
					#name: #madou 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'Madou' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 408 128 448 144 ) 
					#name: #kruidtuin2madou 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 240 92 320 164 ) 
					#name: #kunstwet 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 5 
					#stationName: 'Kunst-Wet' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 320 128 352 144 ) 
					#name: #madou2kunstwet 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 128 92 208 164 ) 
					#name: #luxemburg 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'Luxemburg' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort1 ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 208 128 240 144 ) 
					#name: #kunstwet2luxemburg 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 48 180 144 252 ) 
					#name: #naamsepoort 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train4 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Naamse Poort' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort4 ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 144 216 192 232 ) 
					#name: #naamsepoort2louiza 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 5 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 192 180 256 252 ) 
					#name: #louiza 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Louiza' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 256 216 288 232 ) 
					#name: #louiza2munthof 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 288 180 352 252 ) 
					#name: #munthof 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Munthof' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 352 216 416 232 ) 
					#name: #munthof2hallepoort 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 416 180 504 252 ) 
					#name: #hallepoort 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Halle Poort' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) ) 
				#(#MetroLeftTerminusStationUICSpec 
					#layout: #(#Rectangle 416 268 520 340 ) 
					#name: #zuidstation 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train3 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #zuidstation ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation4 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Zuidstation' ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 504 40 552 96 ) 
					#name: #rogier2kruidtuinCorner1 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 520 96 552 144 ) 
					#name: #rogier2kruidtuinCorner2 
					#flags: 0 
					#majorKey: #MetroTLCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin3 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 8 128 128 168 ) 
					#name: #luxemburg2naamsepoortCorner1 
					#flags: 0 
					#majorKey: #MetroBRCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 8 168 48 232 ) 
					#name: #luxemburg2naamsepoortCorner2 
					#flags: 0 
					#majorKey: #MetroTRCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort3 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 504 216 552 272 ) 
					#name: #hallepoort2zuidstationCorner1 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 520 272 552 320 ) 
					#name: #hallepoort2zuidstationCorner2 
					#flags: 0 
					#majorKey: #MetroTLCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #zuidstation ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation3 ) 
					#inset: 8 ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 72 40 120 56 ) 
					#name: #simonis2ribaucourt 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 7 ) ) ) )!

windowSpec0
	"UIBPainter new openOnClass: self andSelector: #windowSpec0"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Simulation : Line 2' 
			#bounds: #(#Rectangle 128 364 685 718 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroClockUICSpec 
					#layout: #(#Rectangle 13 89 61 111 ) 
					#name: #clock 
					#flags: 0 
					#bordered: true 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 168 304 216 328 ) 
					#model: #train1Occupation 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 224 304 272 328 ) 
					#model: #train2Occupation 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 121 4 200 76 ) 
					#name: #ribaucourt 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train2 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train1 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 
					#stationName: 'Ribaucourt' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 200 40 280 56 ) 
					#name: #ribaucourt2ijzer 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 10 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 280 4 328 76 ) 
					#name: #ijzer 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'IJzer' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 328 40 448 56 ) 
					#name: #ijzer2rogier 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 8 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 448 4 504 76 ) 
					#name: #rogier 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 
					#stationName: 'Rogier' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) ) 
				#(#MetroLeftTerminusStationUICSpec 
					#layout: #(#Rectangle 5 4 72 76 ) 
					#name: #simonis 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #simonis ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Simonis' ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 448 92 520 164 ) 
					#name: #kruidtuin 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train5 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin4 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Kruidtuin' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 352 92 408 164 ) 
					#name: #madou 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'Madou' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou2luxemburg ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 408 128 448 144 ) 
					#name: #kruidtuin2madou 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 208 128 352 144 ) 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #madou2luxemburg ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 128 92 208 164 ) 
					#name: #luxemburg 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou2luxemburg ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'Luxemburg' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort1 ) ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 48 180 144 252 ) 
					#name: #naamsepoort 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train4 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Naamse Poort' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort4 ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 144 216 192 232 ) 
					#name: #naamsepoort2louiza 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 5 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 192 180 256 252 ) 
					#name: #louiza 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Louiza' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 256 216 288 232 ) 
					#name: #louiza2munthof 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 288 180 352 252 ) 
					#name: #munthof 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train6 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Munthof' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 352 216 416 232 ) 
					#name: #munthof2hallepoort 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 416 180 504 252 ) 
					#name: #hallepoort 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Halle Poort' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) ) 
				#(#MetroLeftTerminusStationUICSpec 
					#layout: #(#Rectangle 416 268 520 340 ) 
					#name: #zuidstation 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train3 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #zuidstation ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation4 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Zuidstation' ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 504 40 552 96 ) 
					#name: #rogier2kruidtuinCorner1 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 520 96 552 144 ) 
					#name: #rogier2kruidtuinCorner2 
					#flags: 0 
					#majorKey: #MetroTLCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin3 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 8 128 128 168 ) 
					#name: #luxemburg2naamsepoortCorner1 
					#flags: 0 
					#majorKey: #MetroBRCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 8 168 48 232 ) 
					#name: #luxemburg2naamsepoortCorner2 
					#flags: 0 
					#majorKey: #MetroTRCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort3 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 504 216 552 272 ) 
					#name: #hallepoort2zuidstationCorner1 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 520 272 552 320 ) 
					#name: #hallepoort2zuidstationCorner2 
					#flags: 0 
					#majorKey: #MetroTLCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #zuidstation ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation3 ) 
					#inset: 8 ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 72 40 120 56 ) 
					#name: #simonis2ribaucourt 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 7 ) 
				#(#MetroRunButtonUICSpec 
					#layout: #(#Rectangle 12 309 62 329 ) 
					#flags: 0 
					#action: 
					#(#UIBActionProperty 
						#name: 
						#runFor: ) 
					#count: 50 ) ) ) )!

windowSpec1
	"UIBPainter new openOnClass: self andSelector: #windowSpec1"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Simulation : Line 2' 
			#bounds: #(#Rectangle 178 229 735 583 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroClockUICSpec 
					#layout: #(#Rectangle 13 89 61 111 ) 
					#name: #clock 
					#flags: 0 
					#bordered: true 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 168 304 216 328 ) 
					#model: #train1Occupation 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 224 304 272 328 ) 
					#model: #train2Occupation 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 121 4 200 76 ) 
					#name: #ribaucourt 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train2 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train1 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 
					#stationName: 'Ribaucourt' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 200 40 280 56 ) 
					#name: #ribaucourt2ijzer 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 10 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 280 4 328 76 ) 
					#name: #ijzer 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'IJzer' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 328 40 448 56 ) 
					#name: #ijzer2rogier 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 8 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 448 4 504 76 ) 
					#name: #rogier 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 
					#stationName: 'Rogier' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) ) 
				#(#MetroLeftTerminusStationUICSpec 
					#layout: #(#Rectangle 5 4 72 76 ) 
					#name: #simonis 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #simonis ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Simonis' ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 448 92 520 164 ) 
					#name: #kruidtuin 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train5 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin4 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Kruidtuin' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 352 92 408 164 ) 
					#name: #madou 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'Madou' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 408 128 448 144 ) 
					#name: #kruidtuin2madou 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 312 128 352 144 ) 
					#name: #madou2kunstwet 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 128 92 208 164 ) 
					#name: #luxemburg 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'Luxemburg' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort1 ) ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 48 180 144 252 ) 
					#name: #naamsepoort 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train4 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Naamse Poort' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort4 ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 144 216 192 232 ) 
					#name: #naamsepoort2louiza 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 5 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 192 180 256 252 ) 
					#name: #louiza 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Louiza' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 256 216 288 232 ) 
					#name: #louiza2munthof 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 288 180 352 252 ) 
					#name: #munthof 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train6 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Munthof' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 352 216 416 232 ) 
					#name: #munthof2hallepoort 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 416 180 504 252 ) 
					#name: #hallepoort 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Halle Poort' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) ) 
				#(#MetroLeftTerminusStationUICSpec 
					#layout: #(#Rectangle 416 268 520 340 ) 
					#name: #zuidstation 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train3 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #zuidstation ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation4 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Zuidstation' ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 504 40 552 96 ) 
					#name: #rogier2kruidtuinCorner1 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 520 96 552 144 ) 
					#name: #rogier2kruidtuinCorner2 
					#flags: 0 
					#majorKey: #MetroTLCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin3 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 8 128 128 168 ) 
					#name: #luxemburg2naamsepoortCorner1 
					#flags: 0 
					#majorKey: #MetroBRCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 8 168 48 232 ) 
					#name: #luxemburg2naamsepoortCorner2 
					#flags: 0 
					#majorKey: #MetroTRCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort3 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 504 216 552 272 ) 
					#name: #hallepoort2zuidstationCorner1 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 520 272 552 320 ) 
					#name: #hallepoort2zuidstationCorner2 
					#flags: 0 
					#majorKey: #MetroTLCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #zuidstation ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation3 ) 
					#inset: 8 ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 72 40 120 56 ) 
					#name: #simonis2ribaucourt 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 7 ) 
				#(#MetroRunButtonUICSpec 
					#layout: #(#Rectangle 12 309 62 329 ) 
					#flags: 0 
					#action: 
					#(#UIBActionProperty 
						#name: 
						#runFor: ) 
					#count: 50 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 232 92 312 164 ) 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train8 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train7 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Kunst-Wet' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 208 128 232 144 ) 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 ) ) ) )!

windowSpec2
	"UIBPainter new openOnClass: self andSelector: #windowSpec2"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Simulation : Line 2' 
			#bounds: #(#Rectangle 13 324 570 678 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroClockUICSpec 
					#layout: #(#Rectangle 13 89 61 111 ) 
					#name: #clock 
					#flags: 0 
					#bordered: true 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 11 322 59 342 ) 
					#name: #runButton 
					#model: #run 
					#label: 'Run' 
					#defaultable: true ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 168 304 216 328 ) 
					#model: #train1Occupation 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 224 304 272 328 ) 
					#model: #train2Occupation 
					#alignment: #right 
					#type: #number 
					#formatString: '0' ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 121 4 200 76 ) 
					#name: #ribaucourt 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train2 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train1 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 
					#stationName: 'Ribaucourt' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 200 40 280 56 ) 
					#name: #ribaucourt2ijzer 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 10 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 280 4 328 76 ) 
					#name: #ijzer 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'IJzer' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt2ijzer ) ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 320 320 368 340 ) 
					#model: #inspectComponent 
					#label: 'Inspect' 
					#defaultable: true ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 328 40 448 56 ) 
					#name: #ijzer2rogier 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 8 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 448 4 504 76 ) 
					#name: #rogier 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 
					#stationName: 'Rogier' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #ijzer2rogier ) ) 
				#(#MetroLeftTerminusStationUICSpec 
					#layout: #(#Rectangle 5 4 72 76 ) 
					#name: #simonis 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #simonis ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Simonis' ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 448 92 520 164 ) 
					#name: #kruidtuin 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train5 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin4 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Kruidtuin' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 352 92 408 164 ) 
					#name: #madou 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'Madou' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 408 128 448 144 ) 
					#name: #kruidtuin2madou 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #kruidtuin2madou ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 240 92 320 164 ) 
					#name: #kunstwet 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 5 
					#stationName: 'Kunst-Wet' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 320 128 352 144 ) 
					#name: #madou2kunstwet 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #madou2kunstwet ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #madou ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 128 92 208 164 ) 
					#name: #luxemburg 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 
					#stationName: 'Luxemburg' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort1 ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 208 128 240 144 ) 
					#name: #kunstwet2luxemburg 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #kunstwet2luxemburg ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kunstwet ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 48 180 144 252 ) 
					#name: #naamsepoort 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: #train4 ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Naamse Poort' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort4 ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 144 216 192 232 ) 
					#name: #naamsepoort2louiza 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 5 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 192 180 256 252 ) 
					#name: #louiza 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Louiza' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort2louiza ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 256 216 288 232 ) 
					#name: #louiza2munthof 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 4 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 288 180 352 252 ) 
					#name: #munthof 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Munthof' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #louiza2munthof ) ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 352 216 416 232 ) 
					#name: #munthof2hallepoort 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 3 ) 
				#(#MetroStationUICSpec 
					#layout: #(#Rectangle 416 180 504 252 ) 
					#name: #hallepoort 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Halle Poort' 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #munthof2hallepoort ) ) 
				#(#MetroLeftTerminusStationUICSpec 
					#layout: #(#Rectangle 416 268 520 340 ) 
					#name: #zuidstation 
					#flags: 0 
					#initialTrain2: 
					#(#UIBAspectProperty 
						#name: #train3 ) 
					#track: 
					#(#UIBAspectProperty 
						#name: #zuidstation ) 
					#initialTrain1: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation4 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#stationName: 'Zuidstation' ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 504 40 552 96 ) 
					#name: #rogier2kruidtuinCorner1 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 520 96 552 144 ) 
					#name: #rogier2kruidtuinCorner2 
					#flags: 0 
					#majorKey: #MetroTLCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #kruidtuin ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #rogier2kruidtuin3 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 8 128 128 168 ) 
					#name: #luxemburg2naamsepoortCorner1 
					#flags: 0 
					#majorKey: #MetroBRCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 8 168 48 232 ) 
					#name: #luxemburg2naamsepoortCorner2 
					#flags: 0 
					#majorKey: #MetroTRCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #naamsepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #luxemburg2naamsepoort3 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 504 216 552 272 ) 
					#name: #hallepoort2zuidstationCorner1 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation1 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation3 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation2 ) 
					#inset: 8 ) 
				#(#MetroCornerUICSpec 
					#layout: #(#Rectangle 520 272 552 320 ) 
					#name: #hallepoort2zuidstationCorner2 
					#flags: 0 
					#majorKey: #MetroTLCornerUIC 
					#track: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation4 ) 
					#durationV: 2 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #zuidstation ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 2 
					#trackV: 
					#(#UIBAspectProperty 
						#name: #hallepoort2zuidstation3 ) 
					#inset: 8 ) 
				#(#MetroTrackUICSpec 
					#layout: #(#Rectangle 72 40 120 56 ) 
					#name: #simonis2ribaucourt 
					#flags: 0 
					#track: 
					#(#UIBAspectProperty 
						#name: #simonis2ribaucourt ) 
					#rail1OutTrack: 
					#(#UIBAspectProperty 
						#name: #simonis ) 
					#rail2OutTrack: 
					#(#UIBAspectProperty 
						#name: #ribaucourt ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #clock ) 
					#duration: 7 ) ) ) )! !

UIBCompositeComponentSpec subclass: #MetroClockUICSpec
	instanceVariableNames: 'bordered clock '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroClockUICSpec methodsFor: 'accessing'!

bordered

	^bordered == nil
		ifTrue:[bordered := (UIBSubPropertyFieldModel new name: #bordered; minorKey: #windowSpec; customComponentClassName: #MetroClockUIC; componentName: #timeField; propertyName: #hasBorder; yourself)]
		ifFalse:[bordered]!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

setBordered: aValue

	bordered := aValue!

setClock: aValue

	clock := aValue! !

!MetroClockUICSpec methodsFor: 'decoding'!

bordered: aValue

	self bordered property: aValue decodeAsLiteralArray!

clock: aValue

	self clock property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroClockUICSpec class
	instanceVariableNames: ''!


!MetroClockUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroClockUIC!

defaultMinorKey

	^#windowSpec! !

!MetroClockUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #bordered put: (self adapt: inst forAspect: #property accessPath: #(#bordered) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Clock'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroClockUIC #specSelector: #windowSpec))!

placementExtent

	^40 @ 20!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroClockUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Clock-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Metro Clock' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 71 100 253 122 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 103 ) 
					#name: #aspectLabel 
					#label: 'Aspect:' ) 
				#(#UIBSubPropertyFieldSpec 
					#layout: #(#Rectangle 6 154 106 179 ) 
					#name: #borderedCheck 
					#flags: 0 
					#property: 
					#(#UIBSubPropertyFieldModel 
						#name: #bordered 
						#subComponentName: #timeField 
						#subPropertyName: #hasBorder ) ) ) ) )! !

!MetroClockUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue yellow; at: 4 put: ColorValue white; at: 5 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L1@@@@@CQDQDQDQDQDQDQDPP@@@@@4QDQDQDQDQDQDQDD@@@@@MDQDQD@@@DQDQDQA@@@@@CQDQD@BH"H@QDQDPP@@@@@4QDP@H"@"H@QDQDD@@@@@MDQD@"H H"HDQDQA@@@@@CQDPBH"HBH"HDQDPP@@@@@4QD@"H"@"H"ADQDD@@@@@MDQ@H"H @@H QDQA@@@@@CQDPBH"H"H"HDQDPP@@@@@4QDPBH"H"H QDQDD@@@@@MDQD@BH"H"@DQDQA@@@@@CQDQD@BH"H@QDQDPP@@@@@4QDQDP@@@QDQDQDD@@@@@MDQDQDQDQDQDQDQA@@@@@CQDQDQDQDQDQDQDPP@@@@@4Q@Q@@DQD@DQ@ADD@@@@@MD@DPDQ@PDPDADAA@@@@@CQDAD@@QDADA@Q@PP@@@@@4Q@QDPDA@Q@PDPDD@@@@@MD@@P@ADQ@ADP@QA@@@@@CQDQDQDQDQDQDQDPP@@@@@QDQDQDQDQDQDQDQD@@@@@@@@@@@@@@@@@@@@@@@@@@b')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 131 255 0 126 124 255 0 124 238 127 0 125 239 127 0 123 239 191 0 123 239 191 0 123 225 191 0 123 255 191 0 125 255 127 0 124 254 127 0 126 124 255 0 127 131 255 0 127 255 255 0 127 255 255 0 118 60 231 0 102 235 91 0 118 59 91 0 119 171 91 0 98 60 231 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

UIBCompositeComponentSpec subclass: #MetroLeftTerminusStationUICSpec
	instanceVariableNames: 'initialTrain2 track initialTrain1 rail2OutTrack clock duration stationName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroLeftTerminusStationUICSpec methodsFor: 'accessing'!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

duration

	^duration == nil ifTrue:[2] ifFalse:[duration]!

initialTrain1

	^initialTrain1 == nil
		ifTrue:[initialTrain1 := (UIBPropertyFieldModel basicNew name: #initialTrain1; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain1]!

initialTrain2

	^initialTrain2 == nil
		ifTrue:[initialTrain2 := (UIBPropertyFieldModel basicNew name: #initialTrain2; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain2]!

rail2OutTrack

	^rail2OutTrack == nil
		ifTrue:[rail2OutTrack := (UIBPropertyFieldModel basicNew name: #rail2OutTrack; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[rail2OutTrack]!

setClock: aValue

	clock := aValue!

setDuration: aValue

	duration := aValue!

setInitialTrain1: aValue

	initialTrain1 := aValue!

setInitialTrain2: aValue

	initialTrain2 := aValue!

setRail2OutTrack: aValue

	rail2OutTrack := aValue!

setStationName: aValue

	stationName := aValue!

setTrack: aValue

	track := aValue!

stationName

	^stationName == nil ifTrue:[''] ifFalse:[stationName]!

track

	^track == nil
		ifTrue:[track := (UIBPropertyFieldModel basicNew name: #track; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: 'MetroTerminusStation new asValue'; yourself)]
		ifFalse:[track]! !

!MetroLeftTerminusStationUICSpec methodsFor: 'decoding'!

clock: aValue

	self clock property: aValue decodeAsLiteralArray!

duration: aValue

	duration := aValue decodeAsLiteralArray!

initialTrain1: aValue

	self initialTrain1 property: aValue decodeAsLiteralArray!

initialTrain2: aValue

	self initialTrain2 property: aValue decodeAsLiteralArray!

rail2OutTrack: aValue

	self rail2OutTrack property: aValue decodeAsLiteralArray!

stationName: aValue

	stationName := aValue decodeAsLiteralArray!

track: aValue

	self track property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroLeftTerminusStationUICSpec class
	instanceVariableNames: ''!


!MetroLeftTerminusStationUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroTerminusStationUIC!

defaultMinorKey

	^#leftTerminusSpec! !

!MetroLeftTerminusStationUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #initialTrain1 put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain1) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #initialTrain2 put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain2) channel: aChannel).
	env at: #track put: (self adapt: inst forAspect: #property accessPath: #(#track) channel: aChannel).
	env at: #stationName put: (self adapt: inst forAspect: #stationName channel: aChannel).
	env at: #rail2OutTrack put: (self adapt: inst forAspect: #property accessPath: #(#rail2OutTrack) channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Left Terminus Station'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroTerminusStationUIC #specSelector: #leftTerminusSpec))!

placementExtent

	^90 @ 71!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Trains #trainsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroLeftTerminusStationUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Left Terminus Station-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 41 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 72 0 40 0 -12 1 62 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 8 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Left Terminus Station' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 96 160 255 182 ) 
					#name: #rail2OutTrack 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail2OutTrack 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 9 137 ) 
					#name: #rail2OutRailLabel 
					#label: 'Outgoing track:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 96 231 255 253 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 11 234 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#LabelSpec 
					#layout: #(#Point 11 204 ) 
					#name: #durationLabel 
					#label: 'Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 96 203 255 225 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 97 253 119 ) 
					#name: #track 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #track 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroTerminusStation new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 98 0 ) 
					#name: #idLabel 
					#label: 'Station:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 72 0 ) 
					#name: #nameLabel 
					#label: 'Name:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 94 0 71 0 -12 1 93 0 ) 
					#name: #stationNameField 
					#model: #stationName 
					#type: #string ) ) ) )!

trainsEditSpec
	"UIBPainter new openOnClass: self andSelector: #trainsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Left Terminus Station-Trains' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 96 74 255 96 ) 
					#name: #initialTrain1 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain1 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 9 51 ) 
					#name: #initialTrain1Label 
					#label: 'Initial Train on Platform 1:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 97 131 256 153 ) 
					#name: #initialTrain2 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain2 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 10 108 ) 
					#name: #initialTrain2Label 
					#label: 'Initial Train on Platform 2:' ) ) ) )! !

!MetroLeftTerminusStationUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 6) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); at: 3 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 4 put: ColorValue white; at: 5 put: ColorValue blue; at: 6 put: ColorValue red; yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L2@@@@@CDQDTQDQDQDQDQAD @@@@@1DQEDQDQDQDQDPQH@@@@@LQUUQDQDQDQDQDDR@@@@@CDUUQDQDQDQDQDQD @@@@@1EUTPDPDPDPDPDQH@@@@@LQUU@@@@@@@@@@DR@@@@@CDUUQ@Q@Q@Q@Q@QD @@@@@1EUTPDPDPDPDPDQH@@@@@LQUU@@@@@@@@@@DR@@@@@CDUUQ@Q@Q@Q@Q@QD @@@@@1EUTQDQDQDQDQDQH@@@@@LQUUDADADADADADR@@@@@CDUUP@@@@@@@@@AD @@@@@1EUTPDPDPDPDPDQH@@@@@LQUUDADADADADADR@@@@@CDUUP@@@@@@@@@AD @@@@@1EUTPDPDPDPDPDQH@@@@@LQUUDQDQDQDQDQDR@@@@@CDUUTQDQDQDQDQAD @@@@@1DQEDQDQDQDQDPQH@@@@@LQDQQDQDQDQDQDDR@@@@@CDQDQDQDQDQDQDQD @@@@@"H"H"H"H"H"H"H"H@@@@@@@@@@@@@@@@@@@@@@@@@@b')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

UIBCompositeComponentSpec subclass: #MetroTrackUICSpec
	instanceVariableNames: 'track rail1OutTrack rail2OutTrack clock duration '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroTrackUICSpec methodsFor: 'accessing'!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

duration

	^duration == nil ifTrue:[2] ifFalse:[duration]!

rail1OutTrack

	^rail1OutTrack == nil
		ifTrue:[rail1OutTrack := (UIBPropertyFieldModel basicNew name: #rail1OutTrack; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[rail1OutTrack]!

rail2OutTrack

	^rail2OutTrack == nil
		ifTrue:[rail2OutTrack := (UIBPropertyFieldModel basicNew name: #rail2OutTrack; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[rail2OutTrack]!

setClock: aValue

	clock := aValue!

setDuration: aValue

	duration := aValue!

setRail1OutTrack: aValue

	rail1OutTrack := aValue!

setRail2OutTrack: aValue

	rail2OutTrack := aValue!

setTrack: aValue

	track := aValue!

track

	^track == nil
		ifTrue:[track := (UIBPropertyFieldModel basicNew name: #track; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[track]! !

!MetroTrackUICSpec methodsFor: 'decoding'!

clock: aValue

	self clock property: aValue decodeAsLiteralArray!

duration: aValue

	duration := aValue decodeAsLiteralArray!

rail1OutTrack: aValue

	self rail1OutTrack property: aValue decodeAsLiteralArray!

rail2OutTrack: aValue

	self rail2OutTrack property: aValue decodeAsLiteralArray!

track: aValue

	self track property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTrackUICSpec class
	instanceVariableNames: ''!


!MetroTrackUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroTrackUIC!

defaultMinorKey

	^#horizontal! !

!MetroTrackUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #rail1OutTrack put: (self adapt: inst forAspect: #property accessPath: #(#rail1OutTrack) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #minorKey put: (self adapt: inst forAspect: #minorKey channel: aChannel).
	env at: #track put: (self adapt: inst forAspect: #property accessPath: #(#track) channel: aChannel).
	env at: #rail2OutTrack put: (self adapt: inst forAspect: #property accessPath: #(#rail2OutTrack) channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Track'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroTrackUIC #specSelector: #horizontal) #(#UIBComponentLookAndFeel #specHolderClass: #MetroTrackUIC #specSelector: #vertical))!

placementExtent

	^50 @ 16!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Layout #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroTrackUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Track-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Track' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 156 253 178 ) 
					#name: #rail1OutTrack 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail1OutTrack 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 133 ) 
					#name: #rail1OutRailLabel 
					#label: 'Rail 1 outgoing track/station:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 209 253 231 ) 
					#name: #rail2OutTrack 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail2OutTrack 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 186 ) 
					#name: #rail2OutRailLabel 
					#label: 'Rail 2 outgoing track/station:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 280 253 302 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 9 283 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#LabelSpec 
					#layout: #(#Point 9 253 ) 
					#name: #durationLabel 
					#label: 'Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 94 252 253 274 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 97 253 119 ) 
					#name: #track 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #track 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 98 0 ) 
					#name: #idLabel 
					#label: 'Track:' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Track-Layout' 
			#bounds: #(#Rectangle 320 380 585 704 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#CompositeSpecCollection 
					#collection: #(
						#(#RegionSpec 
							#layout: #(#Rectangle 0 0 8 55 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 7 0 15 55 ) 
							#lineWidth: 1 ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 75 33 90 88 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#RegionSpec 
							#layout: #(#Rectangle 0 0 57 9 ) 
							#lineWidth: 1 ) 
						#(#RegionSpec 
							#layout: #(#Rectangle 0 8 57 17 ) 
							#lineWidth: 1 ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#Rectangle 185 52 242 69 ) ) ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 47 50 ) 
					#model: #minorKey 
					#select: #vertical ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 156 50 ) 
					#model: #minorKey 
					#select: #horizontal ) ) ) )! !

!MetroTrackUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/??????=@@B?OOOOOO4@@K0@@@@@OP@@/333333=@@B?OOOOOO4@@K<<<<<<?P@@/@@@@@@=@@B?OOOOOO4@@K???????P@@/??????=@@B?OOOOOO4@@K0@@@@@OP@@/333333=@@B?OOOOOO4@@K<<<<<<?P@@/@@@@@@=@@B?OOOOOO4@@K???????P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

Model subclass: #MetroObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroObject methodsFor: 'initialize-release'!

initialize

	"no-op"! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroObject class
	instanceVariableNames: ''!


!MetroObject class methodsFor: 'instance creation'!

new

	^super new initialize! !

MetroObject subclass: #MetroClockDependentObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroClockDependentObject methodsFor: 'updating'!

update: anAspectSymbol with: aParameter

	self perform: (anAspectSymbol , ':') asSymbol  with: aParameter! !

!MetroClockDependentObject methodsFor: 'clock'!

clockTick: ticks
	"Do whatever is needed when a clock unit of time has elapsed."

	self subclassResponsibility! !

MetroObject subclass: #MetroProfile
	instanceVariableNames: 'profileValues '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroProfile methodsFor: 'accessing'!

at: timeTicks

	^(profileValues at: (timeTicks // 60) + 1) // 60!

profileValues: anArrayedThing

	profileValues := anArrayedThing! !

!MetroProfile methodsFor: 'initialize-release'!

initialize

	super initialize.
	profileValues := #(	100 100 100 100 300 700 1200 1000 500 400 400 800
						800 1000 500 700 1200 1000 700 500 500 800 300 200)! !

MetroObject subclass: #MetroTrain
	instanceVariableNames: 'line direction capacity occupation place riding '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!
MetroTrain comment:
'

Instance variables:

	line			<MetroLine>
	direction		<Boolean>		true = going out, false = comming back
	capacity		<Integer>
	occupation	<Integer>'!


!MetroTrain methodsFor: 'initialize-release'!

capacity: numberOfPlaces

	capacity := numberOfPlaces!

initialize

	super initialize.
	capacity := self class defaultCapacity.
	occupation := 0.
	riding := false!

line: aMetroLine

	line := aMetroLine! !

!MetroTrain methodsFor: 'accessing'!

changeDirection

	direction := direction not!

direction

	^direction!

freePlaces

	^capacity - occupation!

getOff: numberOfPersons
	"Try to get the given number of persons from the receiver. Answer the number that actually got off."

	| freePlacesBefore |
	freePlacesBefore := self freePlaces.
	self occupation: (self occupation - numberOfPersons max: 0).
	^self freePlaces - freePlacesBefore!

getOn: numberOfPersons
	"Try to put the given number of persons into the receiver. Answer the number that actually got in."

	| freePlacesBefore |
	freePlacesBefore := self freePlaces.
	self occupation: (self occupation + numberOfPersons min: capacity).
	^ freePlacesBefore - self freePlaces!

go

	riding := true!

occupation

	^occupation!

occupation: anInteger

	occupation := anInteger.
	self changed: #occupation with: anInteger!

riding

	^riding!

stop

	riding := false! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTrain class
	instanceVariableNames: ''!


!MetroTrain class methodsFor: 'defaults'!

defaultCapacity

	^100! !

MetroClockDependentObject subclass: #MetroTrack
	instanceVariableNames: 'rails '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroTrack methodsFor: 'accessing'!

nextTrackForRail1: aTrack

	self rail1 next: aTrack rail1!

nextTrackForRail2: aTrack

	self rail2 next: aTrack rail2!

rail1

	^rails at: 1!

rail1: aTrack

	^rails at: 1 put: aTrack!

rail2

	^rails at: 2!

rail2: aTrack

	^rails at: 2 put: aTrack! !

!MetroTrack methodsFor: 'private'!

rail1Class

	^self railClass!

rail2Class

	^self railClass!

railClass

	^MetroRailSegment! !

!MetroTrack methodsFor: 'initialize-release'!

initialize

	super initialize.
	self initializeRails!

initializeRails

	rails := OrderedCollection with: self rail1Class new with: self rail2Class new! !

MetroTrack subclass: #MetroStation
	instanceVariableNames: 'name '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroStation methodsFor: 'accessing'!

name

	^name!

name: aString

	name := aString.
	self changed: #name with: aString! !

!MetroStation methodsFor: 'initialize-release'!

initialize

	super initialize.
	name := 'unnamed'! !

!MetroStation methodsFor: 'private'!

railClass

	^MetroPlatform! !

MetroStation subclass: #MetroTerminusStation
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroTerminusStation methodsFor: 'private'!

rail1Class

	^MetroTerminusPlatform!

swapRails
	"Invoke this method only at initialization time !!"

	|t|
	t := self rail1.
	self rail1: self rail2.
	self rail2: t! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTerminusStation class
	instanceVariableNames: ''!


!MetroTerminusStation class methodsFor: 'instance creation'!

withRail1AsTerminusPlatform

	^self new!

withRail2AsTerminusPlatform

	^self new swapRails! !

MetroStation subclass: #MetroCrossingStation
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


MetroClockDependentUIC subclass: #MetroRailUIC
	instanceVariableNames: 'distanceAdaptor orientation '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroRailUIC methodsFor: 'aspects'!

distance

	^(PluggableAdaptor on: distanceAdaptor)
		getBlock:[:m| self isReversed ifFalse: [m value] ifTrue:[m value negated]]
		 "This slider does not change its model, but anyway:"
		putBlock:[:m :newValue| self isReversed ifFalse: [m value: newValue] ifTrue:[m value: newValue negated]]
		updateBlock:[:m :aspect :parameter| true]! !

!MetroRailUIC methodsFor: 'initialize-release'!

initialize

	super initialize.
	orientation := #leftToRight.
	self initializeDistanceAdaptor!

initializeDistanceAdaptor

	distanceAdaptor :=(AspectAdaptor forAspect: #occupiedTime)
					subjectSendsUpdates: true;
					 subjectChannel: self railClass new asValue!

orientation: anOrientation

	orientation := anOrientation isNil ifTrue:[#leftToRight] ifFalse:[anOrientation]! !

!MetroRailUIC methodsFor: 'accessing'!

changeDuration: anInteger

	| sliderWidget |
	sliderWidget := self widget: #slider.
	self rail value duration: anInteger.
	self built ifTrue:[self isReversed
					ifTrue:[sliderWidget rangeMap rangeStart:anInteger negated]
					ifFalse:[sliderWidget rangeMap rangeStop:anInteger]]! !

!MetroRailUIC methodsFor: 'model accessing'!

duration: anInteger

	self rail value duration: anInteger!

initialTrain: aMetroTrainHolder

	self rail value train: aMetroTrainHolder value!

model

	^self rail!

nextRail: aMetroRailSegmentHolder

	self rail value next: aMetroRailSegmentHolder value!

rail

	^distanceAdaptor subjectChannel!

rail: aMetroRailSegmentHolder

	self changeModelFrom: self model value  to: aMetroRailSegmentHolder value.
	distanceAdaptor subjectChannel: aMetroRailSegmentHolder!

railClass

	^MetroRailSegment! !

!MetroRailUIC methodsFor: 'private'!

fixOrientation: maxValue

	| sliderWidget |
	sliderWidget := self widget: #slider.
	(orientation == #bottomToTop or:[orientation == #topToBottom])
		ifTrue:[	sliderWidget beVertical].
	self isReversed
		ifTrue:[	sliderWidget rangeMap rangeStop: sliderWidget rangeMap rangeStart negated.
				sliderWidget rangeMap rangeStart: maxValue negated]
		ifFalse:[	sliderWidget rangeMap rangeStop: maxValue]!

isReversed

	^orientation == #bottomToTop or:[orientation == #rightToLeft]! !

!MetroRailUIC methodsFor: 'interface opening'!

postBuildWith: aBuilder 

	self fixOrientation: self rail value duration.
	(aBuilder componentAt: #slider) widget setMarkerLength: 5.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroRailUIC class
	instanceVariableNames: ''!


!MetroRailUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Rail Segment' 
			#bounds: #(#Rectangle 435 80 673 100 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SliderSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #slider 
					#model: #distance 
					#orientation: #horizontal 
					#start: 0 
					#stop: 5 
					#step: 1 ) ) ) )! !

MetroRailUIC subclass: #MetroPlatformUIC
	instanceVariableNames: 'personCount '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroPlatformUIC methodsFor: 'initialize-release'!

initialize

	super initialize.
	personCount := (AspectAdaptor forAspect: #population) subjectSendsUpdates: true; subjectChannel: 0 asValue! !

!MetroPlatformUIC methodsFor: 'aspects'!

personCount

	^personCount! !

!MetroPlatformUIC methodsFor: 'model accessing'!

rail: aMetroRailSegmentHolder

	super rail: aMetroRailSegmentHolder.
	personCount subjectChannel: aMetroRailSegmentHolder!

railClass

	^MetroPlatform! !

!MetroPlatformUIC methodsFor: 'component setup'!

minorKey: aSpecSymbol
	"This method is sent when the minorKey for a custom component differs
	from the default minorKey, as laid down in the component's specification class."

	orientation := aSpecSymbol! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroPlatformUIC class
	instanceVariableNames: ''!


!MetroPlatformUIC class methodsFor: 'interface specs'!

leftToRight
	"UIBPainter new openOnClass: self andSelector: #leftToRight"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Platform' 
			#bounds: #(#Rectangle 414 193 652 213 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SliderSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -20 1 ) 
					#name: #slider 
					#model: #distance 
					#orientation: #horizontal 
					#start: 0 
					#stop: 5 
					#step: 1 ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 -20 1 0 1 0 1 ) 
					#name: #bottomPlatform 
					#flags: 0 
					#colors: 
					#(#LookPreferences 
						#setForegroundColor: #(#ColorValue #black ) 
						#setBackgroundColor: #(#ColorValue 3072 5631 8191 ) ) 
					#model: #personCount 
					#alignment: #center 
					#type: #number 
					#formatString: '0' ) ) ) )!

rightToLeft
	"UIBPainter new openOnClass: self andSelector: #rightToLeft"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Platform' 
			#bounds: #(#Rectangle 421 219 659 239 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SliderSpec 
					#layout: #(#LayoutFrame 0 0 20 0 0 1 0 1 ) 
					#name: #slider 
					#model: #distance 
					#orientation: #horizontal 
					#start: 0 
					#stop: 5 
					#step: 1 ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 20 0 ) 
					#name: #topPlatform 
					#flags: 0 
					#colors: 
					#(#LookPreferences 
						#setForegroundColor: #(#ColorValue #black ) 
						#setBackgroundColor: #(#ColorValue 3072 5631 8191 ) ) 
					#model: #personCount 
					#alignment: #center 
					#type: #number 
					#formatString: '0' ) ) ) )! !

MetroPlatformUIC subclass: #MetroPlatformUIC2
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroPlatformUIC2 methodsFor: 'model accessing'!

profile: aUIBOrderedCollection

	personCount subject profile profileValues: aUIBOrderedCollection! !

MetroRailUIC subclass: #MetroTerminusRailUIC
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroTerminusRailUIC methodsFor: 'private'!

fixOrientation: maxValue

	| offsetAssoc |
	super fixOrientation: maxValue.
	self hideComponents: (#(#bottomToTop #topToBottom #leftToRight #rightToLeft) asSet remove: orientation; yourself).
	offsetAssoc := (Dictionary
					with: #topToBottom -> (#bottomOffset: -> -5)
					with: #bottomToTop -> (#topOffset: -> 5)
					with: #leftToRight -> (#rightOffset: -> -5)
					with: #rightToLeft -> (#leftOffset: -> 5))
				at: orientation.
	(self component: #slider) layout perform: offsetAssoc key with: offsetAssoc value! !

!MetroTerminusRailUIC methodsFor: 'aspects'!

distance

	^(PluggableAdaptor on: distanceAdaptor)
		getBlock:[:m| m value > m subject duration
					ifFalse:[self isReversed ifFalse: [m value] ifTrue:[m value negated]]
					ifTrue:[(m subject duration * 2) - m value]]
		 "This slider does not change its model, but anyway:"
		putBlock:[:m :newValue| self isReversed ifFalse: [m value: newValue] ifTrue:[m value: newValue negated]]
		updateBlock:[:m :aspect :parameter| true]! !

!MetroTerminusRailUIC methodsFor: 'model accessing'!

railClass

	^MetroTerminusRail! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTerminusRailUIC class
	instanceVariableNames: ''!


!MetroTerminusRailUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Metro Terminus Rail' 
			#bounds: #(#Rectangle 354 289 592 309 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SliderSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #slider 
					#model: #distance 
					#orientation: #horizontal 
					#start: 0 
					#stop: 5 
					#step: 1 ) 
				#(#RegionSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 5 0 ) 
					#name: #bottomToTop 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue 8191 1024 1024 ) ) ) 
				#(#RegionSpec 
					#layout: #(#LayoutFrame 0 0 0 0 5 0 0 1 ) 
					#name: #rightToLeft 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue 8191 1024 1024 ) ) ) 
				#(#RegionSpec 
					#layout: #(#LayoutFrame -5 1 0 0 0 1 0 1 ) 
					#name: #leftToRight 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue 8191 1024 1024 ) ) ) 
				#(#RegionSpec 
					#layout: #(#LayoutFrame 0 0 -5 1 0 1 0 1 ) 
					#name: #topToBottom 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue 8191 1024 1024 ) ) ) ) ) )! !

UIBCompositeComponentSpec subclass: #MetroTerminusRailUICSpec
	instanceVariableNames: 'initialTrain rail clock orientation duration nextRail '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!
MetroTerminusRailUICSpec comment:
'This class was created by hand and not with the UIBSpecificationEditor because the changes with respect to the superclass are minimal (and the the time of creation, UIBSpecificationEditor generates all methods, even if they are the same as in the superclass).'!


!MetroTerminusRailUICSpec methodsFor: 'accessing'!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

duration

	^duration == nil ifTrue:[2] ifFalse:[duration]!

initialTrain

	^initialTrain == nil
		ifTrue:[initialTrain := (UIBPropertyFieldModel basicNew name: #initialTrain; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain]!

nextRail

	^nextRail == nil
		ifTrue:[nextRail := (UIBPropertyFieldModel basicNew name: #nextRail; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroRailSegment new asValue'; yourself)]
		ifFalse:[nextRail]!

orientation

	^orientation!

rail

	^rail == nil
		ifTrue:[rail := (UIBPropertyFieldModel basicNew name: #rail; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroTerminusRail new asValue'; yourself)]
		ifFalse:[rail]!

setClock: aValue

	clock := aValue!

setDuration: aValue

	duration := aValue!

setInitialTrain: aValue

	initialTrain := aValue!

setNextRail: aValue

	nextRail := aValue!

setOrientation: aValue

	orientation := aValue!

setRail: aValue

	rail := aValue! !

!MetroTerminusRailUICSpec methodsFor: 'decoding'!

clock: aValue

	self clock property: aValue decodeAsLiteralArray!

duration: aValue

	duration := aValue decodeAsLiteralArray!

initialTrain: aValue

	self initialTrain property: aValue decodeAsLiteralArray!

nextRail: aValue

	self nextRail property: aValue decodeAsLiteralArray!

orientation: aValue

	orientation := aValue decodeAsLiteralArray!

rail: aValue

	self rail property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTerminusRailUICSpec class
	instanceVariableNames: ''!


!MetroTerminusRailUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #initialTrain put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain) channel: aChannel).
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #nextRail put: (self adapt: inst forAspect: #property accessPath: #(#nextRail) channel: aChannel).
	env at: #rail put: (self adapt: inst forAspect: #property accessPath: #(#rail) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #orientation put: (self adapt: inst forAspect: #orientation channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Terminus Rail'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroTerminusRailUIC #specSelector: #windowSpec))!

placementExtent

	^75 @ 10!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Details #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroTerminusRailUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue red; at: 4 put: ColorValue white; at: 5 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L1@@@@@CQDQDQDQDQDQDQDPP@@@@@4QDQDQDQDQDQDQDD@@@@@MDQDH"H"H"H$QDQA@@@@@CQDQBH"H"H"IDQDPP@@@@@4QDQDPDQ@QDQDQDD@@@@@MDQDQDADPDQDQDQA@@@@@CQDQDP@@@@DQDQDPP@@@@@4QDQDPDQ@QDQDQDD@@@@@MDQDQDADPDQDQDQA@@@@@CQDQDP@@@@DQDQDPP@@@@@4QDQDPDQ@QDQDQDD@@@@@MDQDQDADPDQDQDQA@@@@@CQDQDP@@@@DQDQDPP@@@@@4QDQDPDQ@QDQDQDD@@@@@MDQDQDADPDQDQDQA@@@@@CQDQDP@@@@DQDQDPP@@@@@4QDQDPDQ@QDQDQDD@@@@@MDQDQDADPDQDQDQA@@@@@CQDQDP@@@@DQDQDPP@@@@@4QDQDPDQ@QDQDQDD@@@@@MDQDQDQDQDQDQDQA@@@@@CQDQDQDQDQDQDQDPP@@@@@QDQDQDQDQDQDQDQD@@@@@@@@@@@@@@@@@@@@@@@@@@b')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

!MetroTerminusRailUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroTerminusRailUIC!

defaultMinorKey

	^#windowSpec! !

!MetroTerminusRailUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Terminus Rail-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 94 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Terminus Rail' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 100 253 122 ) 
					#name: #railAspect 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroTerminusRail new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 103 ) 
					#name: #aspectLabel 
					#label: 'Rail:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 95 158 254 180 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 161 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 95 194 254 216 ) 
					#name: #nextAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #nextRail 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroRailSegment new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 197 ) 
					#name: #nextLabel 
					#label: 'Next Rail:' ) 
				#(#LabelSpec 
					#layout: #(#Point 7 131 ) 
					#name: #durationLabel 
					#label: 'Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 94 130 253 152 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Terminus Rail-Details' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 97 241 256 263 ) 
					#name: #initialTrain 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 10 244 ) 
					#name: #trainLabel 
					#label: 'Initial Train:' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 46 ) 
					#name: #leftToRightButton 
					#model: #orientation 
					#label: 'Left to Right' 
					#select: #leftToRight ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 123 ) 
					#name: #bottomToTopButton 
					#model: #orientation 
					#label: 'Bottom to Top' 
					#select: #bottomToTop ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 97 ) 
					#name: #toToBottomButton 
					#model: #orientation 
					#label: 'Top to Bottom' 
					#select: #topToBottom ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 72 ) 
					#name: #rightToLeftButton 
					#model: #orientation 
					#label: 'Right to Left' 
					#select: #rightToLeft ) 
				#(#GroupBoxSpec 
					#layout: #(#Rectangle 10 18 152 158 ) 
					#name: #orientationBox 
					#label: 'Orientation' ) ) ) )! !

MetroClockDependentObject subclass: #MetroLine
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


UIBPalette subclass: #MetroPalette
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroPalette class
	instanceVariableNames: ''!


!MetroPalette class methodsFor: 'accessing-specs'!

activeSpecsList

	^#(#MetroClockUICSpec #MetroRunButtonUICSpec #MetroRailUICSpec #MetroTerminusRailUICSpec #MetroPlatformUICSpec #MetroTerminusPlatformUICSpec #MetroStationUICSpec #MetroTrackUICSpec #MetroCornerUICSpec #MetroLeftTerminusStationUICSpec #MetroRightTerminusStationUICSpec)! !

!MetroPalette class methodsFor: 'accessing'!

numberOfColumns

	^5!

paletteName

	^'Metro'! !

MetroClockDependentUIC subclass: #MetroTrackUIC
	instanceVariableNames: 'rail2 rail1 trackClock duration '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroTrackUIC methodsFor: 'aspects'!

rail1

	^rail1!

rail2

	^rail2!

trackClock

	^trackClock! !

!MetroTrackUIC methodsFor: 'initialize-release'!

initialize

	|track|
	super initialize.
	duration := 2.
	track := self trackClass new asValue.
	rail1 := (AspectAdaptor forAspect: #rail1) subjectSendsUpdates: true; subjectChannel: track.
	rail2 := (AspectAdaptor forAspect: #rail2) subjectSendsUpdates: true; subjectChannel: track.
	trackClock := MetroClock new asValue! !

!MetroTrackUIC methodsFor: 'model accessing'!

clock: aClockHolder

	trackClock := aClockHolder!

duration: anInteger

	duration := anInteger!

initialTrain1: aTrainHolder

	(self widget: #rail1) initialTrain: aTrainHolder!

initialTrain2: aTrainHolder

	(self widget: #rail2) initialTrain: aTrainHolder!

rail1OutTrack: aTrackHolder

	self rail1 value next: aTrackHolder value rail1!

rail2OutTrack: aTrackHolder

	self rail2 value next: aTrackHolder value rail2!

track: aTrackHolder

	rail1 subjectChannel: aTrackHolder.
	rail2 subjectChannel: aTrackHolder! !

!MetroTrackUIC methodsFor: 'interface opening'!

postBuildWith: aBuilder

	(self widget: #rail1) changeDuration: duration.
	(self widget: #rail2) changeDuration: duration! !

!MetroTrackUIC methodsFor: 'private'!

trackClass

	^MetroTrack! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTrackUIC class
	instanceVariableNames: ''!


!MetroTrackUIC class methodsFor: 'interface specs'!

horizontal
	"UIBPainter new openOnClass: self andSelector: #horizontal"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Horizontal' 
			#bounds: #(#Rectangle 459 103 626 155 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0.5 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal1
	"UIBPainter new openOnClass: self andSelector: #horizontal1"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 1' 
			#bounds: #(#Rectangle 459 103 626 155 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0.5 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal2
	"UIBPainter new openOnClass: self andSelector: #horizontal2"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 2' 
			#bounds: #(#Rectangle 459 103 626 155 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 10 0 0 0.5 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal3
	"UIBPainter new openOnClass: self andSelector: #horizontal3"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 3' 
			#bounds: #(#Rectangle 459 103 626 155 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0.5 -10 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal4
	"UIBPainter new openOnClass: self andSelector: #horizontal4"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 4' 
			#bounds: #(#Rectangle 459 103 626 155 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 10 0 0 0.5 -10 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal5
	"UIBPainter new openOnClass: self andSelector: #horizontal5"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 5' 
			#bounds: #(#Rectangle 459 103 626 155 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 10 0 0 0 0 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0.5 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal6
	"UIBPainter new openOnClass: self andSelector: #horizontal6"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 6' 
			#bounds: #(#Rectangle 459 103 626 155 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 -10 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0.5 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal7
	"UIBPainter new openOnClass: self andSelector: #horizontal7"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 7' 
			#bounds: #(#Rectangle 459 103 626 155 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 10 0 0 0 -10 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0.5 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal8
	"UIBPainter new openOnClass: self andSelector: #horizontal8"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 8' 
			#bounds: #(#Rectangle 441 117 608 169 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 10 0 0 0 0 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0.5 -10 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

horizontal9
	"UIBPainter new openOnClass: self andSelector: #horizontal9"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Hor 9' 
			#bounds: #(#Rectangle 441 117 608 169 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 -10 1 0 0.5 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 10 0 0 0.5 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical
	"UIBPainter new openOnClass: self andSelector: #vertical"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Vertical' 
			#bounds: #(#Rectangle 468 95 610 202 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 0 0 0 1 0 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical1
	"UIBPainter new openOnClass: self andSelector: #vertical1"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 1' 
			#bounds: #(#Rectangle 468 95 610 202 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 0 0 0 1 0 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical2
	"UIBPainter new openOnClass: self andSelector: #vertical2"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 2' 
			#bounds: #(#Rectangle 468 95 610 202 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 0 0 0 1 -10 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical3
	"UIBPainter new openOnClass: self andSelector: #vertical3"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 3' 
			#bounds: #(#Rectangle 468 95 610 202 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 10 0 0 1 0 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical4
	"UIBPainter new openOnClass: self andSelector: #vertical4"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 4' 
			#bounds: #(#Rectangle 468 95 610 202 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 10 0 0 1 -10 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical5
	"UIBPainter new openOnClass: self andSelector: #vertical5"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 5' 
			#bounds: #(#Rectangle 468 95 610 202 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 0 0 0 1 0 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 -10 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical6
	"UIBPainter new openOnClass: self andSelector: #vertical6"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 6' 
			#bounds: #(#Rectangle 468 95 610 202 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 0 0 0 1 0 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 10 0 0 0.5 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical7
	"UIBPainter new openOnClass: self andSelector: #vertical7"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 7' 
			#bounds: #(#Rectangle 778 592 920 699 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 0 0 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 10 0 0 0.5 -10 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical8
	"UIBPainter new openOnClass: self andSelector: #vertical8"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 8' 
			#bounds: #(#Rectangle 452 86 594 193 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 0 0 0 1 -10 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 10 0 0 0.5 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )!

vertical9
	"UIBPainter new openOnClass: self andSelector: #vertical9"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Track-Ver 9' 
			#bounds: #(#Rectangle 452 86 594 193 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0.5 10 0 0 1 0 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 0.5 -10 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )! !

MetroTrackUIC subclass: #MetroCornerUIC
	instanceVariableNames: 'rail1V rail2V durationV inset '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroCornerUIC methodsFor: 'initialize-release'!

initialize

	|track |
	super initialize.
	durationV := 2.
	track := self trackClass new asValue.
	rail1V := (AspectAdaptor forAspect: #rail1) subjectSendsUpdates: true; subjectChannel: track.
	rail2V := (AspectAdaptor forAspect: #rail2) subjectSendsUpdates: true; subjectChannel: track! !

!MetroCornerUIC methodsFor: 'aspects'!

rail1V

	^rail1V!

rail2V

	^rail2V! !

!MetroCornerUIC methodsFor: 'model accessing'!

durationV: anInteger

	durationV := anInteger!

inset: anInteger

	inset := anInteger!

trackV: aTrackHolder

	rail1V subjectChannel: aTrackHolder.
	rail2V subjectChannel: aTrackHolder! !

!MetroCornerUIC methodsFor: 'interface opening'!

postBuildWith: aBuilder

	super postBuildWith: aBuilder.
	(self widget: #rail1V) changeDuration: durationV.
	(self widget: #rail2V) changeDuration: durationV.
	self setupRails!

setupRail: aRailID

	| layout |
	layout := (self component: aRailID) layout.
	layout topOffset = 0 ifFalse:[layout topOffset: inset * (layout topOffset / 8)].
	layout bottomOffset = 0 ifFalse:[layout bottomOffset: inset * (layout bottomOffset / 8)].
	layout leftOffset = 0 ifFalse:[layout leftOffset: inset * (layout leftOffset / 8)].
	layout rightOffset = 0 ifFalse:[layout rightOffset: inset * (layout rightOffset / 8)]!

setupRails

	inset = 8
		ifFalse:[self setupRail: #rail1; setupRail: #rail2; setupRail: #rail1V; setupRail: #rail2V]! !

MetroCornerUIC subclass: #MetroBRCornerUIC
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroBRCornerUIC methodsFor: 'model accessing'!

rail1OutTrack: aTrackHolder

	self rail1V value next: aTrackHolder value rail1!

rail2OutTrack: aTrackHolder

	self rail2 value next: aTrackHolder value rail2! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroBRCornerUIC class
	instanceVariableNames: ''!


!MetroBRCornerUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Corner-#windowSpec' 
			#bounds: #(#Rectangle 362 155 503 281 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 8 0 0 0 0 1 8 0 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: #rail1V ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 16 0 8 0 0 1 16 0 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 8 0 0 1 ) 
					#name: #rail1V 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1V ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 8 0 8 0 16 0 0 1 ) 
					#name: #rail2V 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2V ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) ) ) ) )! !

MetroTrackUIC subclass: #MetroStationUIC
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroStationUIC methodsFor: 'private'!

trackClass

	^MetroStation! !

!MetroStationUIC methodsFor: 'model accessing'!

stationName: aString

	self rail1 subject name: aString! !

!MetroStationUIC methodsFor: 'interface opening'!

postBuildWith: aBuilder

	super postBuildWith: aBuilder.
	(aBuilder componentAt: #stationNameLabel) widget labelString: self rail1 subject name! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroStationUIC class
	instanceVariableNames: ''!


!MetroStationUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Station' 
			#bounds: #(#Rectangle 502 104 635 164 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #stationNameLabel 
					#label: 'Station' 
					#style: #default ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#MetroPlatformUICSpec 
							#layout: #(#LayoutFrame 0 0 0 0 0 1.0 0 0.5 ) 
							#name: #rail1 
							#flags: 0 
							#initialTrain: 
							#(#UIBAspectProperty 
								#name: nil ) 
							#rail: 
							#(#UIBAspectProperty 
								#name: #rail1 ) 
							#clock: 
							#(#UIBAspectProperty 
								#name: #trackClock ) 
							#minorKey: #rightToLeft 
							#duration: 2 
							#nextRail: 
							#(#UIBAspectProperty 
								#name: nil ) ) 
						#(#MetroPlatformUICSpec 
							#layout: #(#LayoutFrame 0 0 0 0.5 0 1.0 0 1.0 ) 
							#minorKey: #leftToRight 
							#name: #rail2 
							#flags: 0 
							#initialTrain: 
							#(#UIBAspectProperty 
								#name: nil ) 
							#rail: 
							#(#UIBAspectProperty 
								#name: #rail2 ) 
							#clock: 
							#(#UIBAspectProperty 
								#name: #trackClock ) 
							#duration: 2 
							#nextRail: 
							#(#UIBAspectProperty 
								#name: nil ) ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame 0 0 16 0 0 1 0 1 ) ) ) ) ) )! !

MetroStationUIC subclass: #MetroStationUIC2
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroStationUIC2 class
	instanceVariableNames: ''!


!MetroStationUIC2 class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Station' 
			#bounds: #(#Rectangle 183 433 316 493 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #stationNameLabel 
					#label: 'Station' 
					#style: #default ) 
				#(#MetroPlatformUICSpec2 
					#layout: #(#LayoutFrame 0 0 0 0.266667 0 1.0 0 0.633333 ) 
					#name: #rail1 
					#flags: 0 
					#minorKey: #rightToLeft 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#profile: #(#UIBOrderedCollection 100 100 100 100 300 700 1200 1000 500 400 400 800 800 1000 500 700 1200 1000 700 500 500 800 300 200) ) 
				#(#MetroPlatformUICSpec2 
					#layout: #(#LayoutFrame 0 0 0 0.633333 0 1.0 0 1.0 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#profile: #(#UIBOrderedCollection 100 100 100 100 300 700 1200 1000 500 400 400 800 800 1000 500 700 1200 1000 700 500 500 800 300 200) ) ) ) )! !

MetroStationUIC subclass: #MetroTerminusStationUIC
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroTerminusStationUIC methodsFor: 'private'!

trackClass

	^MetroTerminusStation! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTerminusStationUIC class
	instanceVariableNames: ''!


!MetroTerminusStationUIC class methodsFor: 'interface specs'!

leftTerminusSpec
	"UIBPainter new openOnClass: self andSelector: #leftTerminusSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Terminus Station' 
			#bounds: #(#Rectangle 383 257 508 332 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 7 0 0 0 0 1 0 1 ) 
					#name: #stationNameLabel 
					#label: 'Station'  
					#style: #default) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#MetroPlatformUICSpec 
							#layout: #(#LayoutFrame 0 0 0 0 0 1.0 0 0.5 ) 
							#name: #rail1 
							#flags: 0 
							#initialTrain: 
							#(#UIBAspectProperty 
								#name: nil ) 
							#rail: 
							#(#UIBAspectProperty 
								#name: #rail1 ) 
							#clock: 
							#(#UIBAspectProperty 
								#name: #trackClock ) 
							#minorKey: #rightToLeft 
							#duration: 2 
							#nextRail: 
							#(#UIBAspectProperty 
								#name: #rail2 ) ) 
						#(#MetroPlatformUICSpec 
							#layout: #(#LayoutFrame 0 0 0 0.5 0 1.0 0 1.0 ) 
							#minorKey: #leftToRight
							#name: #rail2 
							#flags: 0 
							#initialTrain: 
							#(#UIBAspectProperty 
								#name: nil ) 
							#rail: 
							#(#UIBAspectProperty 
								#name: #rail2 ) 
							#clock: 
							#(#UIBAspectProperty 
								#name: #trackClock ) 
							#duration: 2 
							#nextRail: 
							#(#UIBAspectProperty 
								#name: nil ) ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame 7 0 16 0 0 1 0 1 ) ) ) 
				#(#RegionSpec 
					#layout: #(#LayoutFrame 0 0 21 0 7 0 -5 1 ) 
					#name: #terminusBlock 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #red ) ) 
					#lineWidth: 1 ) ) ) )!

rightTerminusSpec
	"UIBPainter new openOnClass: self andSelector: #rightTerminusSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Terminus Station' 
			#bounds: #(#Rectangle 274 164 399 239 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 0 0 0 0 -7 1 0 1 ) 
					#name: #stationNameLabel 
					#label: 'Station'  
					#style: #default) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#MetroPlatformUICSpec 
							#layout: #(#LayoutFrame 0 0 0 0 0 1.0 0 0.5 ) 
							#name: #rail1 
							#flags: 0 
							#initialTrain: 
							#(#UIBAspectProperty 
								#name: nil ) 
							#rail: 
							#(#UIBAspectProperty 
								#name: #rail1 ) 
							#clock: 
							#(#UIBAspectProperty 
								#name: #trackClock ) 
							#minorKey: #rightToLeft 
							#duration: 2 
							#nextRail: 
							#(#UIBAspectProperty 
								#name: nil ) ) 
						#(#MetroPlatformUICSpec 
							#layout: #(#LayoutFrame 0 0 0 0.5 0 1.0 0 1.0 ) 
							#minorKey: #leftToRight
							#name: #rail2 
							#flags: 0 
							#initialTrain: 
							#(#UIBAspectProperty 
								#name: nil ) 
							#rail: 
							#(#UIBAspectProperty 
								#name: #rail2 ) 
							#clock: 
							#(#UIBAspectProperty 
								#name: #trackClock ) 
							#duration: 2 
							#nextRail: 
							#(#UIBAspectProperty 
								#name: #rail1 ) ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame 0 0 16 0 -7 1 0 1 ) ) ) 
				#(#RegionSpec 
					#layout: #(#LayoutFrame -7 1 21 0 0 1 -5 1 ) 
					#name: #terminusBlock 
					#colors: 
					#(#LookPreferences 
						#setBackgroundColor: #(#ColorValue #red ) ) 
					#lineWidth: 1 ) ) ) )! !

MetroCornerUIC subclass: #MetroTLCornerUIC
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroTLCornerUIC methodsFor: 'model accessing'!

rail1OutTrack: aTrackHolder

	self rail2V value next: aTrackHolder value rail2!

rail2OutTrack: aTrackHolder

	self rail1 value next: aTrackHolder value rail1! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTLCornerUIC class
	instanceVariableNames: ''!


!MetroTLCornerUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Corner-#windowSpec' 
			#bounds: #(#Rectangle 362 155 503 281 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 -16 1 -16 1 -8 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 -8 1 -8 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: #rail2V ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame -16 1 0 0 -8 1 -8 1 ) 
					#name: #rail1V 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1V ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame -8 1 0 0 0 1 0 1 ) 
					#name: #rail2V 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2V ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )! !

MetroCornerUIC subclass: #MetroTRCornerUIC
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroTRCornerUIC methodsFor: 'model accessing'!

rail1OutTrack: aTrackHolder

	self rail2V value next: aTrackHolder value rail2!

rail2OutTrack: aTrackHolder

	self rail2 value next: aTrackHolder value rail2! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTRCornerUIC class
	instanceVariableNames: ''!


!MetroTRCornerUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Corner-#windowSpec' 
			#bounds: #(#Rectangle 515 210 656 336 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 16 0 -16 1 0 1 -8 1 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: #rail2V ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 8 0 -8 1 0 1 0 1 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 8 0 0 1 ) 
					#name: #rail1V 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1V ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 8 0 0 0 16 0 -8 1 ) 
					#name: #rail2V 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2V ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) ) ) )! !

UIBCompositeComponentSpec subclass: #MetroPlatformUICSpec
	instanceVariableNames: 'initialTrain rail clock duration nextRail '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroPlatformUICSpec methodsFor: 'accessing'!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

duration

	^duration == nil ifTrue:[2] ifFalse:[duration]!

initialTrain

	^initialTrain == nil
		ifTrue:[initialTrain := (UIBPropertyFieldModel basicNew name: #initialTrain; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain]!

nextRail

	^nextRail == nil
		ifTrue:[nextRail := (UIBPropertyFieldModel basicNew name: #nextRail; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroRailSegment new asValue'; yourself)]
		ifFalse:[nextRail]!

rail

	^rail == nil
		ifTrue:[rail := (UIBPropertyFieldModel basicNew name: #rail; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroPlatform new asValue'; yourself)]
		ifFalse:[rail]!

setClock: aValue

	clock := aValue!

setDuration: aValue

	duration := aValue!

setInitialTrain: aValue

	initialTrain := aValue!

setNextRail: aValue

	nextRail := aValue!

setRail: aValue

	rail := aValue! !

!MetroPlatformUICSpec methodsFor: 'decoding'!

clock: aValue

	self clock property: aValue decodeAsLiteralArray!

duration: aValue

	duration := aValue decodeAsLiteralArray!

initialTrain: aValue

	self initialTrain property: aValue decodeAsLiteralArray!

nextRail: aValue

	self nextRail property: aValue decodeAsLiteralArray!

rail: aValue

	self rail property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroPlatformUICSpec class
	instanceVariableNames: ''!


!MetroPlatformUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroPlatformUIC!

defaultMinorKey

	^#leftToRight! !

!MetroPlatformUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #initialTrain put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain) channel: aChannel).
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #nextRail put: (self adapt: inst forAspect: #property accessPath: #(#nextRail) channel: aChannel).
	env at: #rail put: (self adapt: inst forAspect: #property accessPath: #(#rail) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #minorKey put: (self adapt: inst forAspect: #minorKey channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Platform'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroPlatformUIC #specSelector: #leftToRight) #(#UIBComponentLookAndFeel #specHolderClass: #MetroPlatformUIC #specSelector: #rightToLeft))!

placementExtent

	^75 @ 30!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Details #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroPlatformUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Platform-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 94 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Platform' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 100 253 122 ) 
					#name: #railAspect 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroPlatform new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 103 ) 
					#name: #aspectLabel 
					#label: 'Platform:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 95 158 254 180 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 161 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 95 194 254 216 ) 
					#name: #nextAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #nextRail 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroRailSegment new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 197 ) 
					#name: #nextLabel 
					#label: 'Next Rail:' ) 
				#(#LabelSpec 
					#layout: #(#Point 7 131 ) 
					#name: #durationLabel 
					#label: 'Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 94 130 253 152 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Platform-Details' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 97 241 256 263 ) 
					#name: #initialTrain 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 10 244 ) 
					#name: #trainLabel 
					#label: 'Initial Train:' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 46 ) 
					#name: #leftToRightButton 
					#model: #minorKey 
					#label: 'Left to Right' 
					#select: #leftToRight ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 72 ) 
					#name: #rightToLeftButton 
					#model: #minorKey 
					#label: 'Right to Left' 
					#select: #rightToLeft ) 
				#(#GroupBoxSpec 
					#layout: #(#Rectangle 10 18 152 158 ) 
					#name: #orientationBox 
					#label: 'Orientation' ) ) ) )! !

!MetroPlatformUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue blue; at: 4 put: ColorValue white; at: 5 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L1@@@@@CQDQDQDQDQDQDQDPP@@@@@4QDQDQDQDQDQDQDD@@@@@MDQDQDQDQDQDQDQA@@@@@CQBH"H"H"H"H"H$PP@@@@@4P"H"H"H"H"H"IDD@@@@@MDH"H"H"H"H"H"QA@@@@@CQBH"H"H"H"H"H$PP@@@@@4P"H"H"H"H"H"IDD@@@@@MDQDQDQDQDQDQDQA@@@@@CQDADADADADADADPP@@@@@4P@@@@@@@@@@@ADD@@@@@MDPDPDPDPDPDPDQA@@@@@CQDADADADADADADPP@@@@@4Q@Q@Q@Q@Q@Q@QDD@@@@@MD@@@@@@@@@@@@QA@@@@@CQDADADADADADADPP@@@@@4QDQDQDQDQDQDQDD@@@@@MDQDQDQDQDQDQDQA@@@@@CQDQDQDQDQDQDQDPP@@@@@4QDQDQDQDQDQDQDD@@@@@MDQDQDQDQDQDQDQA@@@@@CQDQDQDQDQDQDQDPP@@@@@QDQDQDQDQDQDQDQD@@@@@@@@@@@@@@@@@@@@@@@@@@b')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

MetroPlatformUICSpec subclass: #MetroTerminusPlatformUICSpec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroTerminusPlatformUICSpec class
	instanceVariableNames: ''!


!MetroTerminusPlatformUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 6) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); at: 3 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 4 put: ColorValue white; at: 5 put: ColorValue blue; at: 6 put: ColorValue red; yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L2@@@@@CDQDQDQDQDQDQDQD @@@@@1DQDQDQDQDQDQDQH@@@@@LQDQDQDQDQDQDQDR@@@@@CEDQDQDQDQDQDPQD @@@@@1QDQDQDQDQDQDDQH@@@@@LTQDQDQDQDQDQADR@@@@@CEDQDQDQDQDQDQUD @@@@@1QDQDQDQDQDQDUQH@@@@@LQDQDQDQDQDQDUTR@@@@@CDPDPDPDPDPDPEUD @@@@@1@@@@@@@@@@@@UQH@@@@@LQ@Q@Q@Q@Q@Q@UTR@@@@@CDPDPDPDPDPDPEUD @@@@@1DADADADADADAUQH@@@@@LP@@@@@@@@@@@ETR@@@@@CDPDPDPDPDPDPEUD @@@@@1DQDQDQDQDQDQUQH@@@@@LQDQDQDQDQDQDUTR@@@@@CDQDQDQDQDQDQDQD @@@@@1DQDQDQDQDQDQDQH@@@@@LQDQDQDQDQDQDQDR@@@@@CDQDQDQDQDQDQDQD @@@@@"H"H"H"H"H"H"H"H@@@@@@@@@@@@@@@@@@@@@@@@@@b')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

!MetroTerminusPlatformUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #initialTrain put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain) channel: aChannel).
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #nextRail put: (self adapt: inst forAspect: #property accessPath: #(#nextRail) channel: aChannel).
	env at: #rail put: (self adapt: inst forAspect: #property accessPath: #(#rail) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #minorKey put: (self adapt: inst forAspect: #minorKey channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Terminus Platform'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroPlatformUIC #specSelector: #leftToRight) #(#UIBComponentLookAndFeel #specHolderClass: #MetroPlatformUIC #specSelector: #rightToLeft))!

placementExtent

	^75 @ 30!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Details #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroTerminusPlatformUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Terminus Platform-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 94 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Terminus Platform' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 100 253 122 ) 
					#name: #railAspect 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroPlatform new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 103 ) 
					#name: #aspectLabel 
					#label: 'Platform:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 95 158 254 180 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 161 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 95 194 254 216 ) 
					#name: #nextAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #nextRail 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroRailSegment new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 197 ) 
					#name: #nextLabel 
					#label: 'Next Rail:' ) 
				#(#LabelSpec 
					#layout: #(#Point 7 131 ) 
					#name: #durationLabel 
					#label: 'Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 94 130 253 152 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Terminus Platform-Details' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 97 241 256 263 ) 
					#name: #initialTrain 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 10 244 ) 
					#name: #trainLabel 
					#label: 'Initial Train:' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 46 ) 
					#name: #leftToRightButton 
					#model: #minorKey 
					#label: 'Left to Right' 
					#select: #leftToRight ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 72 ) 
					#name: #rightToLeftButton 
					#model: #minorKey 
					#label: 'Right to Left' 
					#select: #rightToLeft ) 
				#(#GroupBoxSpec 
					#layout: #(#Rectangle 10 18 152 158 ) 
					#name: #orientationBox 
					#label: 'Orientation' ) ) ) )! !

!MetroTerminusPlatformUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroPlatformUIC!

defaultMinorKey

	^#leftToRight! !

MetroObject subclass: #MetroClock
	instanceVariableNames: 'clockTick '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroClock methodsFor: 'private'!

clockTick: anInteger

	clockTick := anInteger.
	self changed: #clockTick with: clockTick! !

!MetroClock methodsFor: 'accessing'!

clockTick

	^clockTick! !

!MetroClock methodsFor: 'running'!

reset

	self clockTick: 0!

runFor: numberOfTicks
	"Let the receiver run as for the given number of ticks"

	1 to: numberOfTicks do:[:ignore|self clockTick: clockTick + 1]!

runWhileTrue: booleanBlock
	"Let the receiver run as long as boolanBlock evaluates to true."
	"booleanBlock takes the current number of ticks as argument."

	"|cl| (cl := MetroClock new) runWhileTrue:[:ticks| ticks < 10].
	Transcript show: 'done '; show: cl clockTick printString; cr."

	[booleanBlock value: clockTick] whileTrue: [self clockTick: clockTick + 1]! !

!MetroClock methodsFor: 'initialize-release'!

initialize

	super initialize.
	clockTick := 0! !

UIBCompositeComponentSpec subclass: #MetroRightTerminusStationUICSpec
	instanceVariableNames: 'initialTrain2 track initialTrain1 rail1OutTrack clock duration stationName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroRightTerminusStationUICSpec methodsFor: 'accessing'!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

duration

	^duration == nil ifTrue:[2] ifFalse:[duration]!

initialTrain1

	^initialTrain1 == nil
		ifTrue:[initialTrain1 := (UIBPropertyFieldModel basicNew name: #initialTrain1; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain1]!

initialTrain2

	^initialTrain2 == nil
		ifTrue:[initialTrain2 := (UIBPropertyFieldModel basicNew name: #initialTrain2; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain2]!

rail1OutTrack

	^rail1OutTrack == nil
		ifTrue:[rail1OutTrack := (UIBPropertyFieldModel basicNew name: #rail1OutTrack; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrack new asValue'; yourself)]
		ifFalse:[rail1OutTrack]!

setClock: aValue

	clock := aValue!

setDuration: aValue

	duration := aValue!

setInitialTrain1: aValue

	initialTrain1 := aValue!

setInitialTrain2: aValue

	initialTrain2 := aValue!

setRail1OutTrack: aValue

	rail1OutTrack := aValue!

setStationName: aValue

	stationName := aValue!

setTrack: aValue

	track := aValue!

stationName

	^stationName == nil ifTrue:[''] ifFalse:[stationName]!

track

	^track == nil
		ifTrue:[track := (UIBPropertyFieldModel basicNew name: #track; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: true; customGeneratedCode: 'MetroTerminusStation withRail2AsTerminusPlatform asValue'; yourself)]
		ifFalse:[track]! !

!MetroRightTerminusStationUICSpec methodsFor: 'decoding'!

clock: aValue

	self clock property: aValue decodeAsLiteralArray!

duration: aValue

	duration := aValue decodeAsLiteralArray!

initialTrain1: aValue

	self initialTrain1 property: aValue decodeAsLiteralArray!

initialTrain2: aValue

	self initialTrain2 property: aValue decodeAsLiteralArray!

rail1OutTrack: aValue

	self rail1OutTrack property: aValue decodeAsLiteralArray!

stationName: aValue

	stationName := aValue decodeAsLiteralArray!

track: aValue

	self track property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroRightTerminusStationUICSpec class
	instanceVariableNames: ''!


!MetroRightTerminusStationUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroTerminusStationUIC!

defaultMinorKey

	^#rightTerminusSpec! !

!MetroRightTerminusStationUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #rail1OutTrack put: (self adapt: inst forAspect: #property accessPath: #(#rail1OutTrack) channel: aChannel).
	env at: #initialTrain1 put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain1) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #initialTrain2 put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain2) channel: aChannel).
	env at: #track put: (self adapt: inst forAspect: #property accessPath: #(#track) channel: aChannel).
	env at: #stationName put: (self adapt: inst forAspect: #stationName channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Right Terminus Station'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroTerminusStationUIC #specSelector: #rightTerminusSpec))!

placementExtent

	^90 @ 71!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Trains #trainsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroRightTerminusStationUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Right Terminus Station-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 41 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 72 0 40 0 -12 1 62 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 8 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Right Terminus Station' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 96 160 255 182 ) 
					#name: #rail1OutTrack 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail1OutTrack 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrack new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 9 137 ) 
					#name: #rail2OutRailLabel 
					#label: 'Outgoing track:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 96 231 255 253 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 11 234 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#LabelSpec 
					#layout: #(#Point 11 204 ) 
					#name: #durationLabel 
					#label: 'Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 96 203 255 225 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 97 253 119 ) 
					#name: #track 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #track 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroTerminusStation withRail2AsTerminusPlatform asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 98 0 ) 
					#name: #idLabel 
					#label: 'Station:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 8 0 72 0 ) 
					#name: #nameLabel 
					#label: 'Name:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 94 0 71 0 -12 1 93 0 ) 
					#name: #stationNameField 
					#model: #stationName 
					#type: #string ) ) ) )!

trainsEditSpec
	"UIBPainter new openOnClass: self andSelector: #trainsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Right Terminus Station-Trains' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 96 74 255 96 ) 
					#name: #initialTrain1 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain1 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 9 51 ) 
					#name: #initialTrain1Label 
					#label: 'Initial Train on Platform 1:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 97 131 256 153 ) 
					#name: #initialTrain2 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain2 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 10 108 ) 
					#name: #initialTrain2Label 
					#label: 'Initial Train on Platform 2:' ) ) ) )! !

!MetroRightTerminusStationUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 6) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); at: 3 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 4 put: ColorValue white; at: 5 put: ColorValue blue; at: 6 put: ColorValue red; yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L2@@@@@CDTQDQDQDQDQADQD @@@@@1EDQDQDQDQDPQDQH@@@@@LQQDQDQDQDQDUUDR@@@@@CDQDQDQDQDQDUUQD @@@@@1DPDPDPDPDPEUTQH@@@@@LQ@@@@@@@@@@UUDR@@@@@CDQ@Q@Q@Q@Q@UUQD @@@@@1DPDPDPDPDPEUTQH@@@@@LQ@@@@@@@@@@UUDR@@@@@CDQ@Q@Q@Q@Q@UUQD @@@@@1DQDQDQDQDQEUTQH@@@@@LQDADADADADAUUDR@@@@@CDP@@@@@@@@@EUQD @@@@@1DPDPDPDPDPEUTQH@@@@@LQDADADADADAUUDR@@@@@CDP@@@@@@@@@EUQD @@@@@1DPDPDPDPDPEUTQH@@@@@LQDQDQDQDQDQUUDR@@@@@CDTQDQDQDQDQEUQD @@@@@1EDQDQDQDQDPQDQH@@@@@LQQDQDQDQDQDDQDR@@@@@CDQDQDQDQDQDQDQD @@@@@"H"H"H"H"H"H"H"H@@@@@@@@@@@@@@@@@@@@@@@@@@b')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

UIBCompositeComponentSpec subclass: #MetroRunButtonUICSpec
	instanceVariableNames: 'action count '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroRunButtonUICSpec methodsFor: 'accessing'!

action

	^action == nil
		ifTrue:[action := (UIBPropertyFieldModel basicNew name: #action; type: #UIBActionProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: nil; yourself)]
		ifFalse:[action]!

count

	^count == nil ifTrue:[2] ifFalse:[count]!

setAction: aValue

	action := aValue!

setCount: aValue

	count := aValue! !

!MetroRunButtonUICSpec methodsFor: 'decoding'!

action: aValue

	self action property: aValue decodeAsLiteralArray!

count: aValue

	count := aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroRunButtonUICSpec class
	instanceVariableNames: ''!


!MetroRunButtonUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroRunButtonUIC!

defaultMinorKey

	^#windowSpec! !

!MetroRunButtonUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #action put: (self adapt: inst forAspect: #property accessPath: #(#action) channel: aChannel).
	env at: #count put: (self adapt: inst forAspect: #count channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Run Button'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroRunButtonUIC #specSelector: #windowSpec))!

placementExtent

	^50 @ 20!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroRunButtonUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Run Button-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 71 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Run Button' ) 
				#(#LabelSpec 
					#layout: #(#Point 10 109 ) 
					#label: 'Action:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 72 108 255 130 ) 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #action 
						#type: #UIBActionProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: nil ) ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 74 155 257 177 ) 
					#model: #count 
					#type: #number ) 
				#(#LabelSpec 
					#layout: #(#Point 17 155 ) 
					#label: 'Count:' ) ) ) )! !

!MetroRunButtonUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/??????=@@B???????4@@K???????P@@.******M@@B;?????<4@@K,@<<3<3P@@.3<33O3M@@B;O3OLOL4@@K,@<<3L3P@@.3O33OCM@@B;OOOL?L4@@K,?OC3<3P@@.??????M@@B0@@@@@@4@@K???????P@@/??????=@@B???????4@@K???????P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

MetroClockDependentObject subclass: #MetroRailSegment
	instanceVariableNames: 'previous next train duration occupiedTime '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!
MetroRailSegment comment:
'A MetroRailSegment is a piece of track on which MetroTrains ride. There can only be one MetroTrain in a MetroRailSegment.

Instance variables:

	previous		<MetroRailSegment>	The track from which MetroTrains enter the receiver.
	next			<MetroRailSegment>	The track on which MetroTrains leave the receiver.
	train		<MetroTrain | nil>		The MetroTrain that occupies the receiver.
	duration		<Integer>				The time (in MetroClock units) taken by a MetroTrain to traverse the receiver.
	occupiedTime	<Integer>				The time (in MetroClock units) that a MetroTrain is occupying the receiver.'!


!MetroRailSegment methodsFor: 'initialize-release'!

initialize

	super initialize.
	train := nil.
	occupiedTime := -1.
	duration := self class defaultDuration! !

!MetroRailSegment methodsFor: 'privileged-accessing'!

duration: anInteger

	duration := anInteger!

next: aMetroRailSegment

	next := aMetroRailSegment!

train

	^train!

train: aMetroTrain

	train := aMetroTrain.
	self occupiedTime: 0! !

!MetroRailSegment methodsFor: 'accessing'!

duration

	^duration!

enteredBy: aMetroTrain

	self train: aMetroTrain!

isFree

	^train isNil!

isOccupied

	^self isFree not!

leftBy: aMetroTrain

	train := nil!

occupiedTime

	^occupiedTime! !

!MetroRailSegment methodsFor: 'private'!

occupiedTime: time

	occupiedTime := time.
	self changed: #occupiedTime with: occupiedTime! !

!MetroRailSegment methodsFor: 'clock'!

clockTick: ticks

	self necessaryAction: ticks.
	self isFree
		ifTrue:[self freeAction: ticks]
		ifFalse:[self occupiedAction: ticks]!

freeAction: ticks

	"no-op"!

necessaryAction: ticks

	"no-op"!

occupiedAction: ticks

	self trainAtEnd
		ifTrue:[|leavingTrain|
				(next isNil or:[next isFree])
					ifTrue:[	self leftBy: (leavingTrain := self train go).
							next isNil ifFalse: [next enteredBy: leavingTrain]]
					ifFalse:[	^self train stop]]
		ifFalse:[self train go].
	self occupiedTime: occupiedTime + 1!

trainAtEnd

	^self occupiedTime >= self duration! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroRailSegment class
	instanceVariableNames: ''!


!MetroRailSegment class methodsFor: 'defaults'!

defaultDuration

	^5! !

MetroRailSegment subclass: #MetroRailFork
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


MetroRailSegment subclass: #MetroTerminusRail
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroTerminusRail methodsFor: 'clock'!

trainAtEnd
	"Since it takes 2 times the duration of a terminus rail for a train:"

	^self occupiedTime = (self duration * 2)! !

MetroCornerUIC subclass: #MetroBLCornerUIC
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroBLCornerUIC methodsFor: 'model accessing'!

rail1OutTrack: aTrackHolder

	self rail1V value next: aTrackHolder value rail1!

rail2OutTrack: aTrackHolder

	self rail1 value next: aTrackHolder value rail1! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroBLCornerUIC class
	instanceVariableNames: ''!


!MetroBLCornerUIC class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Corner-#windowSpec' 
			#bounds: #(#Rectangle 362 155 503 281 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 8 0 ) 
					#name: #rail1 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #rightToLeft 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame 0 0 8 0 -8 1 16 0 ) 
					#name: #rail2 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2 ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #leftToRight 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: #rail1V ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame -16 1 16 0 -8 1 0 1 ) 
					#name: #rail1V 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail1V ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #topToBottom 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: nil ) ) 
				#(#MetroRailUICSpec 
					#layout: #(#LayoutFrame -8 1 8 0 0 1 0 1 ) 
					#name: #rail2V 
					#flags: 0 
					#initialTrain: 
					#(#UIBAspectProperty 
						#name: nil ) 
					#rail: 
					#(#UIBAspectProperty 
						#name: #rail2V ) 
					#clock: 
					#(#UIBAspectProperty 
						#name: #trackClock ) 
					#orientation: #bottomToTop 
					#duration: 2 
					#nextRail: 
					#(#UIBAspectProperty 
						#name: #rail1 ) ) ) ) )! !

MetroRailSegment subclass: #MetroPlatform
	instanceVariableNames: 'population profile randomGenerator '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroPlatform methodsFor: 'accessing'!

population

	^population!

population: anInteger

	population := anInteger.
	self changed: #population with: anInteger!

profile

	^profile!

profile: aProfile

	profile := aProfile! !

!MetroPlatform methodsFor: 'private'!

getPeopleOff: aMetroTrain at: ticks

	^aMetroTrain getOff: (self random: self train occupation)!

getPeopleOn: aMetroTrain at: ticks

	| peopleOn |
	self population: self population - (peopleOn := aMetroTrain getOn: (self random: population)).
	^peopleOn!

random: anInteger

	^(randomGenerator next * anInteger) truncated + 1! !

!MetroPlatform methodsFor: 'clock'!

necessaryAction: ticks

	super necessaryAction: ticks.
	self population: self population + (profile at: ticks)!

occupiedAction: ticks

	(self trainAtEnd and:[self train riding])
		ifTrue:[	self train stop.
				self getPeopleOff: self train at: ticks; getPeopleOn: self train at: ticks.
				]
		ifFalse:[	super occupiedAction: ticks]! !

!MetroPlatform methodsFor: 'initialize-release'!

initialize

	super initialize.
	population := 0.
	profile := MetroProfile new.
	randomGenerator := Random new! !

UIBCompositeComponentSpec subclass: #MetroRailUICSpec
	instanceVariableNames: 'initialTrain rail clock orientation duration nextRail '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro UICs'!


!MetroRailUICSpec methodsFor: 'accessing'!

clock

	^clock == nil
		ifTrue:[clock := (UIBPropertyFieldModel basicNew name: #clock; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroClock new asValue'; yourself)]
		ifFalse:[clock]!

duration

	^duration == nil ifTrue:[2] ifFalse:[duration]!

initialTrain

	^initialTrain == nil
		ifTrue:[initialTrain := (UIBPropertyFieldModel basicNew name: #initialTrain; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroTrain new asValue'; yourself)]
		ifFalse:[initialTrain]!

nextRail

	^nextRail == nil
		ifTrue:[nextRail := (UIBPropertyFieldModel basicNew name: #nextRail; type: #UIBAspectProperty; nilAllowed: true; initBeforeBuilding: false; customGeneratedCode: 'MetroRailSegment new asValue'; yourself)]
		ifFalse:[nextRail]!

orientation

	^orientation!

rail

	^rail == nil
		ifTrue:[rail := (UIBPropertyFieldModel basicNew name: #rail; type: #UIBAspectProperty; nilAllowed: false; initBeforeBuilding: true; customGeneratedCode: 'MetroRailSegment new asValue'; yourself)]
		ifFalse:[rail]!

setClock: aValue

	clock := aValue!

setDuration: aValue

	duration := aValue!

setInitialTrain: aValue

	initialTrain := aValue!

setNextRail: aValue

	nextRail := aValue!

setOrientation: aValue

	orientation := aValue!

setRail: aValue

	rail := aValue! !

!MetroRailUICSpec methodsFor: 'decoding'!

clock: aValue

	self clock property: aValue decodeAsLiteralArray!

duration: aValue

	duration := aValue decodeAsLiteralArray!

initialTrain: aValue

	self initialTrain property: aValue decodeAsLiteralArray!

nextRail: aValue

	self nextRail property: aValue decodeAsLiteralArray!

orientation: aValue

	orientation := aValue decodeAsLiteralArray!

rail: aValue

	self rail property: aValue decodeAsLiteralArray! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MetroRailUICSpec class
	instanceVariableNames: ''!


!MetroRailUICSpec class methodsFor: 'defaults'!

defaultMajorKey

	^#MetroRailUIC!

defaultMinorKey

	^#windowSpec! !

!MetroRailUICSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel

	super addBindingsTo: env for: inst channel: aChannel.
	env at: #initialTrain put: (self adapt: inst forAspect: #property accessPath: #(#initialTrain) channel: aChannel).
	env at: #duration put: (self adapt: inst forAspect: #duration channel: aChannel).
	env at: #nextRail put: (self adapt: inst forAspect: #property accessPath: #(#nextRail) channel: aChannel).
	env at: #rail put: (self adapt: inst forAspect: #property accessPath: #(#rail) channel: aChannel).
	env at: #clock put: (self adapt: inst forAspect: #property accessPath: #(#clock) channel: aChannel).
	env at: #orientation put: (self adapt: inst forAspect: #orientation channel: aChannel).
	env at: #name put: (self adapt: inst forAspect: #name channel: aChannel).!

componentName

	^'Rail Segment'!

lookAndFeels

	^#(#(#UIBComponentLookAndFeel #specHolderClass: #MetroRailUIC #specSelector: #windowSpec))!

placementExtent

	^75 @ 10!

slices

	^#( #(#Basics #basicsEditSpec)
		#(#Details #detailsEditSpec)
		#(#Color #propSpec #ColorToolModel)
		#(#Position #propSpec #PositionToolModel) )! !

!MetroRailUICSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIBPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Rail Segment-Basics' 
			#bounds: #(#Rectangle 317 424 582 748 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 7 0 53 0 ) 
					#name: #idLabel 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 94 0 52 0 -13 1 74 0 ) 
					#name: #nameField 
					#model: #name 
					#type: #symbol ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 10 0 0.5 0 ) 
					#name: #componentNameLabel 
					#label: 'Rail Segment' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 94 100 253 122 ) 
					#name: #railAspect 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #rail 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroRailSegment new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 7 103 ) 
					#name: #aspectLabel 
					#label: 'Rail:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 95 158 254 180 ) 
					#name: #clockAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #clock 
						#type: #UIBAspectProperty 
						#nilAllowed: false 
						#initBeforeBuilding: true 
						#customGeneratedCode: 'MetroClock new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 161 ) 
					#name: #clockLabel 
					#label: 'Clock:' ) 
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 95 194 254 216 ) 
					#name: #nextAspect 
					#flags: 0 
					#minorKey: #comboEditSpec 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #nextRail 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroRailSegment new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 8 197 ) 
					#name: #nextLabel 
					#label: 'Next Rail:' ) 
				#(#LabelSpec 
					#layout: #(#Point 7 131 ) 
					#name: #durationLabel 
					#label: 'Duration:' ) 
				#(#InputFieldSpec 
					#layout: #(#Rectangle 94 130 253 152 ) 
					#name: #durationField 
					#model: #duration 
					#type: #number 
					#formatString: '0' ) ) ) )!

detailsEditSpec
	"UIBPainter new openOnClass: self andSelector: #detailsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#UIBPropertiesSliceSpec 
			#label: 'Rail Segment-Details' 
			#bounds: #(#Rectangle 148 314 413 638 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#UIBPropertyFieldSpec 
					#layout: #(#Rectangle 97 241 256 263 ) 
					#name: #initialTrain 
					#flags: 0 
					#property: 
					#(#UIBPropertyFieldModel 
						#name: #initialTrain 
						#type: #UIBAspectProperty 
						#nilAllowed: true 
						#initBeforeBuilding: false 
						#customGeneratedCode: 'MetroTrain new asValue' ) ) 
				#(#LabelSpec 
					#layout: #(#Point 10 244 ) 
					#name: #trainLabel 
					#label: 'Initial Train:' ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 46 ) 
					#name: #leftToRightButton 
					#model: #orientation 
					#label: 'Left to Right' 
					#select: #leftToRight ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 123 ) 
					#name: #bottomToTopButton 
					#model: #orientation 
					#label: 'Bottom to Top' 
					#select: #bottomToTop ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 97 ) 
					#name: #toToBottomButton 
					#model: #orientation 
					#label: 'Top to Bottom' 
					#select: #topToBottom ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 30 72 ) 
					#name: #rightToLeftButton 
					#model: #orientation 
					#label: 'Right to Left' 
					#select: #rightToLeft ) 
				#(#GroupBoxSpec 
					#layout: #(#Rectangle 10 18 152 158 ) 
					#name: #orientationBox 
					#label: 'Orientation' ) ) ) )! !

!MetroRailUICSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); at: 3 put: ColorValue white; at: 4 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@*******)@@B???????4@@K???????P@@/3<????=@@B<@@????4@@K<?O<<<?P@@/3<?@@@=@@B<@@?OOO4@@K<?O<<<?P@@/3<?333=@@B<@@<@@C4@@K<?O<<<?P@@/3<????=@@B<@@????4@@K<?O????P@@/3<????=@@B<@@????4@@K<?O????P@@/3<????=@@B<@@????4@@K<?O????P@@/??????=@@B???????4@@EUUUUUUUP@@@@@@@@@@@@@@a')))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: ((Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 127 255 255 0 0 0 0 0 0 0 0 0]))! !

MetroPlatform subclass: #MetroTerminusPlatform
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Demo-Metro'!


!MetroTerminusPlatform methodsFor: 'private'!

getPeopleOff: aMetroTrain at: ticks
	"When a train reaches a terminus platform, all people must get off:"

	^aMetroTrain getOff: self train occupation!

getPeopleOn: aMetroTrain at: ticks
	"On a terminus platform, noone may get on:"

	"no-op"
	^0! !

!MetroTerminusPlatform methodsFor: 'clock'!

necessaryAction: ticks

	"no-op"! !





UIFinderVW2 computeSpecBearingClasses!
