'From VisualWorks(R), Release 2.5 of September 26, 1995 on March 26, 1997 at 3:42:22 pm'!

UIBApplicationModel subclass: #TutorialIconEditor
	instanceVariableNames: 'magnifiedBitView icon doTheCurrentColor colorHolder '
	classVariableNames: 'PasteBuffer '
	poolDictionaries: ''
	category: 'UIB-Tutorial-ESUG96'!


!TutorialIconEditor methodsFor: 'change messsages'!

colorHolderChanged

	self colorHolder value ifTrue: [self enableColor] ifFalse: [self disableColor]!

iconHolderChanged

	self setupBitView! !

!TutorialIconEditor methodsFor: 'initialize-release'!

initialize

	magnifiedBitView := ColorBitView new.
	magnifiedBitView changedPreferredBounds: nil.
	self magnifiedBitView scale: 6@6; gridding: 13@13.
	colorHolder := true asValue.
	icon := ValueHolder with: (self class emptyIcon image convertToPalette: self preferredPalette).
	icon onChangeSend: #iconHolderChanged to: self!

releaseDependencyRelationShips

	self colorHolder retractInterestsFor: self.
	icon retractInterestsFor: self! !

!TutorialIconEditor methodsFor: 'actions'!

doAccept

	self magnifiedBitView controller imageHasChanged
		ifTrue:[	self magnifiedBitView controller imageHasChanged: false.
				self
					retractInterest: #iconHolderChanged
					from: self iconHolder
					while: [icon value: self magnifiedBitView model copy]]!

doCancel

	self magnifiedBitView controller imageHasChanged
		ifTrue:[	magnifiedBitView model: icon value copy; changedPreferredBounds: nil;invalidate.
				self magnifiedBitView controller imageHasChanged: false]!

doCapture

	| rect image |
	"self changeRequest ifFalse: [^self]."
	rect := self getIconScreenRectangle.
	(rect height == 0 or: [rect width == 0 or: [rect extent = (1@1)]])
		ifTrue: [^self].
	image := Screen default completeContentsOfArea: rect.
	image extent = (1@1) ifTrue: [^self].
	magnifiedBitView model: image; changedPreferredBounds: nil; invalidate.
	self magnifiedBitView controller imageHasChanged: true!

doCopy

	| image r newMap |
	r := Rectangle
			fromUser: magnifiedBitView scale
			phase: magnifiedBitView controller sensor globalOrigin.
	r extent = magnifiedBitView scale ifTrue: [^self].
	(self apertureIntersectsWithScreenRectangle: r) ifFalse: [^self].
	r := self modelRegionFromScreenRegion: r.
	image := magnifiedBitView model.
	newMap :=
		Image
			extent: r extent
			depth: image depth
			bitsPerPixel: image bitsPerPixel
			palette: image palette.
	newMap
		copy: (Rectangle origin: 0 @ 0 corner: r extent)
		from: r origin
		in: image
		rule: RasterOp paint.
	self pasteBuffer: newMap!

doCut

	| image r newMap worker |
	r := Rectangle
			fromUser: magnifiedBitView scale
			phase: magnifiedBitView controller sensor globalOrigin.
	r extent = magnifiedBitView scale ifTrue: [^self].
	(self apertureIntersectsWithScreenRectangle: r) ifFalse: [^self].
	r := self modelRegionFromScreenRegion: r.
	image := magnifiedBitView model.
	newMap :=
		Image
			extent: r extent
			depth: image depth
			bitsPerPixel: image bitsPerPixel
			palette: image palette.
	newMap
		copy: (Rectangle origin: 0 @ 0 corner: r extent)
		from: r origin
		in: image
		rule: RasterOp paint.
	self pasteBuffer: newMap.
	worker := 
		Image
			extent: 1@1
			depth: image depth
			bitsPerPixel: image bitsPerPixel
			palette: image palette.
	worker atPoint: 0@0 put: (image palette indexOf: ColorValue white).
	image tile: r from: 0@0 in: worker rule: RasterOp over.
	magnifiedBitView model: image; invalidate.
	self magnifiedBitView controller imageHasChanged: true!

doFillCurrentColor

	self fillWith: magnifiedBitView controller currentColor.
	self magnifiedBitView controller imageHasChanged: true!

doPaste

	| bufferBounds buffer ctrlr origin bltOrigin r model |
	(buffer := self pasteBuffer) isNil ifTrue: [^self].
	(bufferBounds := buffer bounds scaledBy: magnifiedBitView scale) isNil
		ifTrue: [^self].
	ctrlr := magnifiedBitView controller.
	origin := self getScreenRectangleOfWidth: bufferBounds width andHeight: bufferBounds height.
	(self apertureIntersectsWithScreenRectangle:
			(Rectangle origin: origin extent: bufferBounds extent))
		ifFalse: [^self].
	bltOrigin := (origin - ctrlr sensor globalOrigin) scaledBy: 1 /magnifiedBitView scale.
	r := Rectangle origin: bltOrigin extent: bufferBounds width @ bufferBounds height.
	r extent = (1@1) ifTrue: [^self].
	model := magnifiedBitView model.
	model copy: r from: 0@0 in: buffer rule: RasterOp over.
	magnifiedBitView model: model; invalidate.
	self magnifiedBitView controller imageHasChanged: true!

doToCurrentColor

	self toColor: magnifiedBitView controller currentColor.
	self magnifiedBitView controller imageHasChanged: true!

maskify

	| newImage oldImage colorWhite colorBlack takeBuffer putBuffer |
	oldImage := self magnifiedBitView model copy.
	newImage := oldImage copy.
	Cursor execute showWhile:
		[colorWhite := oldImage palette indexOf: ColorValue white.
		colorBlack := oldImage palette indexOf: ColorValue black.
		takeBuffer := Array new: oldImage width.
		putBuffer := Array new: oldImage width.
		0 to: newImage height -1 do:
			[:rowIndex |
			oldImage rowAt: rowIndex into: takeBuffer.
			1 to: takeBuffer size do:
				[:colIndex |
				(takeBuffer at: colIndex) = colorWhite
					ifTrue: [putBuffer at: colIndex put: colorWhite]
					ifFalse: [putBuffer at: colIndex put: colorBlack]].
		newImage rowAt: rowIndex putAll: putBuffer].
		self magnifiedBitView model: newImage; changedPreferredBounds:nil; invalidate.
		"directBitView model: newImage; changedPreferredBounds:nil; invalidate"].
	self modified: true! !

!TutorialIconEditor methodsFor: 'accessing'!

magnifiedBitView

	^magnifiedBitView! !

!TutorialIconEditor methodsFor: 'aspects'!

doTheCurrentColor
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^doTheCurrentColor isNil
		ifTrue:
			[doTheCurrentColor := String new asValue]
		ifFalse:
			[doTheCurrentColor]! !

!TutorialIconEditor methodsFor: 'components'!

colorButtons
	
	^#(#grey #red #yellow #green #cyan #blue #magenta #darkGrey #darkRed #darkYellow #darkGreen #darkCyan #darkBlue #darkMagenta)!

disableColor
	
	self setColorFor: #black.
	self colorButtons
		do: 
			[:n | 
			(builder componentAt: n) beInvisible.
			(builder componentAt: n) disable]!

enableColor
	
	self colorButtons
		do: 
			[:n | 
			(builder componentAt: n) enable.
			(builder componentAt: n) beVisible]! !

!TutorialIconEditor methodsFor: 'private'!

apertureIntersectsWithScreenRectangle: aRectangle

	| viewOrigin|
	viewOrigin :=
		aRectangle origin -
			((builder componentAt: #magnifiedBitView)  component bounds origin +
				magnifiedBitView topComponent globalOrigin + (4@3)).
	^((Rectangle
		origin: (magnifiedBitView localPointToGlobal: 0@0)"origin of bitView in window coordinates"
		extent: magnifiedBitView bounds extent)
	intersects:
		(Rectangle origin: viewOrigin extent: aRectangle extent))!

colorHolder

	^colorHolder!

fillWith: aColorIndex

	| r image worker |
	r := Rectangle
			fromUser: magnifiedBitView scale
			phase: magnifiedBitView controller sensor globalOrigin.
	r extent = magnifiedBitView scale ifTrue: [^self].
	(self apertureIntersectsWithScreenRectangle: r) ifFalse: [^self].
	r := self modelRegionFromScreenRegion: r.
	image := magnifiedBitView model.
	worker := 
		Image
			extent: 1@1
			depth: image depth
			bitsPerPixel: image bitsPerPixel
			palette: image palette.
	worker atPoint: 0@0 put: aColorIndex.
	image tile: r from: 0@0 in: worker rule: RasterOp over.
	magnifiedBitView model: image; invalidate!

getIconScreenRectangle

	^Rectangle origin:(
	Cursor crossHair showWhile: [
	Screen default
		dragShape: (Rectangle origin: 0@0 extent: 26@26) asPointArray
		offset: 0@0
		gridPhase:
			0@0
		gridSpacing: 1@1
		boundedBy: nil
		whileButton: 0
		isDown: false])
	extent: 26@26!

getScreenRectangleOfWidth: width andHeight: height

	^Screen default
		dragShape: (Rectangle origin: 0@0 extent: width@height) asPointArray
		offset: 0@0
		gridPhase:
			(magnifiedBitView localPointToGlobal: 0@0) +
				magnifiedBitView topComponent globalOrigin
		gridSpacing: magnifiedBitView scale
		boundedBy: nil
		whileButton: 0
		isDown: false.!

iconHolder

	^icon!

modelRegionFromScreenRegion: aRectangle

	| r |
	r := aRectangle translatedBy:
			magnifiedBitView controller sensor globalOrigin negated.
	r := r scaledBy: 1 / magnifiedBitView scale.
	^r!

pasteBuffer

	^PasteBuffer!

pasteBuffer: anImage

	PasteBuffer := anImage!

preferredPalette

	^MappedPalette withColors: ((Array new: 16)
						at: 1 put: ColorValue black;
						at: 2 put: ColorValue darkGray;
						at: 3 put: ColorValue white;
						at: 4 put: ColorValue red;
						at: 5 put: ColorValue olive;
						at: 6 put: ColorValue green;
						at: 7 put: ColorValue blue;
						at: 8 put: ColorValue darkCyan;
						at: 9 put: ColorValue darkMagenta;
						at: 10 put: ColorValue darkRed;
						at: 11 put: ColorValue darkGreen;
						at: 12 put: ColorValue magenta;
						at: 13 put: ColorValue yellow;
						at: 14 put: ColorValue lightGray;
						at: 15 put: ColorValue cyan;
						at: 16 put: ColorValue navy; yourself)!

rectangleFromUserLimitedTo: extentPoint 
	"It is lamentably necessary to duplicate the code from Rectangle class 
	here, so that limitations can be imposed on the size of the rectangle 
	specified by the user."

	| originPoint |
	^Cursor crossHair
		showWhile: 
			[originPoint := Screen default
						dragShape: (0 @ 0 extent: 1@1) asPointArray
						offset: 0 @ 0
						gridPhase: 0@0
						gridSpacing: 1@1
						boundedBy: nil
						whileButton: 0
						isDown: false.
			Screen default
				resizeRectangle: (Rectangle origin: originPoint extent: 1@1)
				minimumExtent: 0@0
				resizeIncrement: 1@1
				boundedBy: (Rectangle origin: originPoint extent: extentPoint)
				whileButton: 0
				isDown: true]!

setColorFor: aButtonId

	| currentLookPreferences color colorNumber |
	self builder isNil ifFalse:[
	color := (self builder componentAt: aButtonId) lookPreferences backgroundColor.
	currentLookPreferences := (self builder componentAt: #currentColor) lookPreferences copy.
	currentLookPreferences setBackgroundColor: color.
	colorNumber := magnifiedBitView model palette
					indexOf: color
					ifAbsent: [magnifiedBitView model palette indexOfPaintNearest: color].
	magnifiedBitView controller currentColor: colorNumber.
	(builder componentAt: #currentColor) lookPreferences: currentLookPreferences]!

setupBitView

	magnifiedBitView model: (icon value copy convertToPalette: self preferredPalette).
	self setColorFor: #black.
	magnifiedBitView changedPreferredBounds: nil.
	magnifiedBitView invalidate!

toColor: aColorIndex

	| controller point oldImage zeroColor newImage takeBuffer putBuffer |
	controller := builder window controller.
	oldImage := magnifiedBitView model copy.
	Cursor crossHair showWhile:
		[[controller poll. controller sensor anyButtonPressed not] whileTrue: [].
		[controller sensor anyButtonPressed] whileTrue: []].
	point := magnifiedBitView controller sensor cursorPoint.
	(magnifiedBitView bounds containsPoint: point) ifFalse: [^self].
	point := (point scaledBy: 1 / magnifiedBitView scale) truncated.
	(oldImage bounds containsPoint: point)
		ifFalse: [^self].
	zeroColor := oldImage atPoint: point.
	newImage := oldImage copy.
	takeBuffer := Array new: oldImage width.
	putBuffer := Array new: oldImage width.
	0 to: newImage height -1 do:
		[:rowIndex |
		oldImage rowAt: rowIndex into: takeBuffer.
		1 to: takeBuffer size do:
			[:colIndex |
			(takeBuffer at: colIndex) = zeroColor
				ifTrue: [putBuffer at: colIndex put: aColorIndex]
				ifFalse: [putBuffer at: colIndex put: (takeBuffer at: colIndex)]].
		newImage rowAt: rowIndex putAll: putBuffer].
	magnifiedBitView model: newImage; changedPreferredBounds:nil; invalidate! !

!TutorialIconEditor methodsFor: 'binding'!

actionFor: aKey 
	"Return a block that will be sent the message value when the 
	button is pressed."

	(aKey copyFrom: 1 to: 2) = 'do'
		ifTrue:[^super actionFor: aKey]
		ifFalse:[^[self setColorFor: aKey]]! !

!TutorialIconEditor methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	"This message is sent by the builder when it has completed work on 
	either a complete window or a SubCanvas."

	self setupBitView! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

TutorialIconEditor class
	instanceVariableNames: ''!


!TutorialIconEditor class methodsFor: 'interface specs'!

windowSpec
	"UIBPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Icon Editor-#windowSpec' 
			#bounds: #(#Rectangle 229 168 478 405 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 5 0 -79 1 -62 1 ) 
					#name: #magnifiedBitView 
					#flags: 11 
					#component: #magnifiedBitView ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#InputFieldSpec 
							#layout: #(#Rectangle 0 0 70 18 ) 
							#name: #currentColor 
							#flags: 0 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #black ) ) 
							#model: #doTheCurrentColor 
							#tabable: false 
							#isReadOnly: true ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 54 35 72 ) 
							#name: #red 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #red ) 
								#setSelectionBackgroundColor: #(#ColorValue #red ) ) 
							#model: #red 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 72 35 90 ) 
							#name: #yellow 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #yellow ) 
								#setSelectionBackgroundColor: #(#ColorValue #yellow ) ) 
							#model: #yellow 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 36 35 54 ) 
							#name: #grey 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #lightGray ) 
								#setSelectionBackgroundColor: #(#ColorValue #lightGray ) ) 
							#model: #grey 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 54 70 72 ) 
							#name: #darkRed 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkRed ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkRed ) ) 
							#model: #darkRed 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 72 70 90 ) 
							#name: #darkYellow 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #olive ) 
								#setSelectionBackgroundColor: #(#ColorValue #olive ) ) 
							#model: #darkYellow 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 36 70 54 ) 
							#name: #darkGrey 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #gray ) 
								#setSelectionBackgroundColor: #(#ColorValue #gray ) ) 
							#model: #darkGrey 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 18 35 36 ) 
							#name: #white 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #white ) 
								#setSelectionBackgroundColor: #(#ColorValue #white ) ) 
							#model: #white 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 18 70 36 ) 
							#name: #black 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #black ) 
								#setSelectionBackgroundColor: #(#ColorValue #black ) ) 
							#model: #black 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 90 35 108 ) 
							#name: #green 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #green ) 
								#setSelectionBackgroundColor: #(#ColorValue #green ) ) 
							#model: #green 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 108 35 126 ) 
							#name: #cyan 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #cyan ) 
								#setSelectionBackgroundColor: #(#ColorValue #cyan ) ) 
							#model: #cyan 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 126 35 144 ) 
							#name: #blue 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #blue ) 
								#setSelectionBackgroundColor: #(#ColorValue #blue ) ) 
							#model: #blue 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 144 35 162 ) 
							#name: #magenta 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #magenta ) 
								#setSelectionBackgroundColor: #(#ColorValue #magenta ) ) 
							#model: #magenta 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 144 70 162 ) 
							#name: #darkMagenta 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkMagenta ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkMagenta ) ) 
							#model: #darkMagenta 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 90 70 108 ) 
							#name: #darkGreen 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkGreen ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkGreen ) ) 
							#model: #darkGreen 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 108 70 126 ) 
							#name: #darkCyan 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #darkCyan ) 
								#setSelectionBackgroundColor: #(#ColorValue #darkCyan ) ) 
							#model: #darkCyan 
							#tabable: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 35 126 70 144 ) 
							#name: #darkBlue 
							#isOpaque: true 
							#colors: 
							#(#LookPreferences 
								#setBackgroundColor: #(#ColorValue #navy ) 
								#setSelectionBackgroundColor: #(#ColorValue #navy ) ) 
							#model: #darkBlue 
							#tabable: false ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame -73 1 6 0 -3 1 168 0 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 112 0 166 26 ) 
							#model: #doFillCurrentColor 
							#label: #fillRectangleImage 
							#hasCharacterOrientedLabel: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 112 28 166 54 ) 
							#model: #doToCurrentColor 
							#label: #changeColorImage 
							#hasCharacterOrientedLabel: false ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 0 54 26 ) 
							#model: #doCut 
							#label: 'Cut' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 55 0 109 26 ) 
							#model: #doCopy 
							#label: 'Copy' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 28 54 54 ) 
							#model: #doPaste 
							#label: 'Paste' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 56 28 110 54 ) 
							#model: #doCapture 
							#label: 'Capture' 
							#style: #default ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame 1 0 -59 1 167 0 -5 1 ) ) ) 
				#(#CompositeSpecCollection 
					#collection: #(
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 0 54 26 ) 
							#model: #doCancel 
							#label: 'Cancel' 
							#style: #default ) 
						#(#ActionButtonSpec 
							#layout: #(#Rectangle 0 28 54 54 ) 
							#model: #doAccept 
							#label: 'Accept' 
							#style: #default ) ) 
					#compositeSpec: 
					#(#CompositeSpec 
						#layout: #(#LayoutFrame -66 1 -59 1 -12 1 -5 1 ) ) ) ) ) )! !

!TutorialIconEditor class methodsFor: 'binding'!

visualFor: aKey 
	"Return an instance of any non-abstract subclass of 
	VisualComponent (in practice usually either ComposedText or 
	Image) for use as a label for a widget. Check the visual registry if no 
	implementation has been provided."

	^UIMaskEditor visualFor: aKey! !

!TutorialIconEditor class methodsFor: 'resources'!

emptyIcon
	"self emptyIcon image"

	^UIBImage bwEmptyIcon26! !

Model subclass: #Person
	instanceVariableNames: 'firstName lastName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Tutorial-ESUG96'!


!Person methodsFor: 'accessing'!

firstName

	^firstName!

firstName: aValue

	firstName := aValue.
	self changed: #firstName!

lastName

	^lastName!

lastName: aValue

	lastName := aValue.
	self changed: #lastName! !

!Person methodsFor: 'initialize-release'!

initialize

	firstName := 'John'.
	lastName := 'Doe'! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Person class
	instanceVariableNames: ''!


!Person class methodsFor: 'instance creation'!

new
	"self new"

	^self basicNew initialize! !

UIBApplicationModel subclass: #TutorialIconListEditor
	instanceVariableNames: 'inColor iconList selectedIcon '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'UIB-Tutorial-ESUG96'!


!TutorialIconListEditor methodsFor: 'initialize-release'!

initialize

	super initialize.
	iconList := SelectionInList with:
		((UIBImage class organization elements)
			select: [:selector| 'cg*' match: selector ignoreCase: false]) asList.
	inColor := true asValue.
	selectedIcon :=
		(PluggableAdaptor on: iconList selectionHolder)
		getBlock: [:m| m value isNil
						ifTrue: [UIBIconEditor emptyIcon image]
						ifFalse: [(UIBImage perform: m value) image]]
		putBlock: [:m :v| Dialog warn: 'Sorry, you are not allowed to install this icon.']
		updateBlock: [:m :a :p| true]! !





UIFinderVW2 computeSpecBearingClasses!
