;;;; LOADS THE EXPLICIT-CONTROL EVALUATOR FROM SECTION 5.4 OF
;;;; STRUCTURE AND INTERPRETATION OF COMPUTER PROGRAMS, WITH
;;;; ALL THE SUPPORTING CODE IT NEEDS IN ORDER TO RUN.

; Zorg dat alles werkt in DrRacket met R5RS taal geselecteerd
(#%require (only racket/base error))
(define true #t)
(define false #f)

;;;;This is like load-eceval.scm except that it loads the version
;;;; of eceval that interfaces with compiled code

(load "ch5-compiler.scm")

;;;; **NB** The actual "load" calls are implementation dependent.

(load "regmach.scm")			;reg machine simulator

;; **NB** next file contains another "load"
(load "ch5-eceval-support.scm")		;simulation of machine operations

;;**NB** eceval-compiler *must* be loaded after eceval-support,
;;  so that the version of user-print in eceval-compiler will override
;;  the version in eceval-support
(load "ch5-eceval-compiler.scm")		;eceval itself
                                    ;and interface to compiled code

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;Print a regmach controller program yielded by compiler
(define (pp progr)
  (let loop ((prog (statements progr)))
    (cond ((null? prog)
     (newline)
     (display "------------------------"))
    (else
     (let ((inst (car prog)))
       (newline)
       (if (not (symbol? inst))
         (display "    "))
       (display inst)
       (loop (cdr prog)))))))
